/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.oom.signature;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import net.sourceforge.pmd.lang.java.ast.ASTConstructorDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTFieldDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTFormalParameters;
import net.sourceforge.pmd.lang.java.ast.ASTIfStatement;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTMethodOrConstructorDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTName;
import net.sourceforge.pmd.lang.java.ast.ASTPrimaryExpression;
import net.sourceforge.pmd.lang.java.ast.ASTPrimaryPrefix;
import net.sourceforge.pmd.lang.java.ast.ASTPrimarySuffix;
import net.sourceforge.pmd.lang.java.ast.ASTReturnStatement;
import net.sourceforge.pmd.lang.java.ast.ASTStatementExpression;
import net.sourceforge.pmd.lang.java.ast.ASTType;
import net.sourceforge.pmd.lang.java.oom.signature.Signature;
import net.sourceforge.pmd.lang.java.symboltable.ClassScope;
import net.sourceforge.pmd.lang.java.symboltable.VariableNameDeclaration;
import net.sourceforge.pmd.lang.symboltable.NameOccurrence;

public final class OperationSignature
extends Signature {
    private static final Map<Integer, OperationSignature> POOL = new HashMap<Integer, OperationSignature>();
    public final Role role;
    public final boolean isAbstract;

    private OperationSignature(Signature.Visibility visibility, Role role, boolean isAbstract) {
        super(visibility);
        this.role = role;
        this.isAbstract = isAbstract;
    }

    public static OperationSignature buildFor(ASTMethodOrConstructorDeclaration node) {
        int code = OperationSignature.code(Signature.Visibility.get(node), Role.get(node), node.isAbstract());
        if (!POOL.containsKey(code)) {
            POOL.put(code, new OperationSignature(Signature.Visibility.get(node), Role.get(node), node.isAbstract()));
        }
        return POOL.get(code);
    }

    private static int code(Signature.Visibility visibility, Role role, boolean isAbstract) {
        return visibility.hashCode() * 31 + role.hashCode() * 2 + (isAbstract ? 1 : 0);
    }

    @Override
    public boolean equals(Object o) {
        return o instanceof OperationSignature && super.equals(o) && this.role == ((OperationSignature)o).role && this.isAbstract == ((OperationSignature)o).isAbstract;
    }

    @Override
    public int hashCode() {
        return super.hashCode() * 2 + this.role.hashCode() * 4 + (this.isAbstract ? 1 : 0);
    }

    public static enum Role {
        GETTER_OR_SETTER,
        CONSTRUCTOR,
        METHOD,
        STATIC;

        private static final Pattern NAME_PATTERN;

        public static Role get(ASTMethodOrConstructorDeclaration node) {
            return node instanceof ASTConstructorDeclaration ? CONSTRUCTOR : Role.get((ASTMethodDeclaration)node);
        }

        private static Role get(ASTMethodDeclaration node) {
            if (node.isStatic()) {
                return STATIC;
            }
            if (Role.isGetterOrSetter(node)) {
                return GETTER_OR_SETTER;
            }
            return METHOD;
        }

        private static boolean isGetterOrSetter(ASTMethodDeclaration node) {
            String name = node.getName();
            if (NAME_PATTERN.matcher(name).matches()) {
                return true;
            }
            if (node.isAbstract()) {
                return false;
            }
            int length = node.getEndLine() - node.getBeginLine();
            if (length > 6) {
                return false;
            }
            if (length > 4 && node.getFirstDescendantOfType(ASTIfStatement.class) == null) {
                return false;
            }
            ClassScope scope = (ClassScope)node.getScope().getEnclosingScope(ClassScope.class);
            HashMap<String, String> fieldNames = new HashMap<String, String>();
            for (Map.Entry<VariableNameDeclaration, List<NameOccurrence>> decl : scope.getVariableDeclarations().entrySet()) {
                ASTFieldDeclaration field = (ASTFieldDeclaration)decl.getKey().getNode().getFirstParentOfType(ASTFieldDeclaration.class);
                fieldNames.put(field.getVariableName(), ((ASTType)field.getFirstChildOfType(ASTType.class)).getTypeImage());
            }
            return Role.isGetter(node, fieldNames) || Role.isSetter(node, fieldNames);
        }

        private static boolean isGetter(ASTMethodDeclaration node, Map<String, String> fieldNames) {
            List returnStatements = node.getBlock().findDescendantsOfType(ASTReturnStatement.class);
            for (ASTReturnStatement st : returnStatements) {
                ASTName name = (ASTName)st.getFirstDescendantOfType(ASTName.class);
                if (name == null || !fieldNames.containsKey(name.getImage().split("\\.")[0])) continue;
                return true;
            }
            return false;
        }

        private static boolean isSetter(ASTMethodDeclaration node, Map<String, String> fieldNames) {
            if (((ASTFormalParameters)node.getFirstDescendantOfType(ASTFormalParameters.class)).jjtGetNumChildren() != 1) {
                return false;
            }
            List statementExpressions = node.getBlock().findDescendantsOfType(ASTStatementExpression.class);
            HashSet<String> namesToCheck = new HashSet<String>();
            for (ASTStatementExpression st : statementExpressions) {
                ASTName name = (ASTName)st.getFirstDescendantOfType(ASTName.class);
                if (name == null) {
                    ASTPrimaryExpression prim = (ASTPrimaryExpression)st.getFirstChildOfType(ASTPrimaryExpression.class);
                    ASTPrimaryPrefix prefix = (ASTPrimaryPrefix)prim.getFirstChildOfType(ASTPrimaryPrefix.class);
                    if (prefix.usesThisModifier() || prefix.usesSuperModifier()) {
                        namesToCheck.add(((ASTPrimarySuffix)prim.getFirstChildOfType(ASTPrimarySuffix.class)).getImage());
                        continue;
                    }
                    namesToCheck.add(prefix.getImage().split("\\.")[0]);
                    continue;
                }
                namesToCheck.add(name.getImage().split("\\.")[0]);
            }
            for (String name : namesToCheck) {
                if (!fieldNames.containsKey(name)) continue;
                return true;
            }
            return false;
        }

        static {
            NAME_PATTERN = Pattern.compile("(?:get|set|is|increment|decrement)\\w*");
        }
    }
}

