/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.oom;

import java.util.HashMap;
import java.util.Map;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTMethodOrConstructorDeclaration;
import net.sourceforge.pmd.lang.java.ast.QualifiedName;
import net.sourceforge.pmd.lang.java.oom.ClassStats;
import net.sourceforge.pmd.lang.java.oom.api.ClassMetricKey;
import net.sourceforge.pmd.lang.java.oom.api.MetricVersion;
import net.sourceforge.pmd.lang.java.oom.api.OperationMetricKey;
import net.sourceforge.pmd.lang.java.oom.api.ResultOption;
import net.sourceforge.pmd.lang.java.oom.signature.FieldSigMask;
import net.sourceforge.pmd.lang.java.oom.signature.OperationSigMask;

public final class PackageStats {
    private Map<String, PackageStats> subPackages = new HashMap<String, PackageStats>();
    private Map<String, ClassStats> classes = new HashMap<String, ClassStats>();

    PackageStats() {
    }

    ClassStats getClassStats(QualifiedName qname, boolean createIfNotFound) {
        ClassStats next;
        PackageStats container = this.getSubPackage(qname, createIfNotFound);
        if (container == null) {
            return null;
        }
        String topClassName = qname.getClasses()[0];
        if (createIfNotFound && this.classes.get(topClassName) == null) {
            this.classes.put(topClassName, new ClassStats());
        }
        if ((next = this.classes.get(topClassName)) == null) {
            return null;
        }
        String[] nameClasses = qname.getClasses();
        for (int i = 1; i < nameClasses.length && next != null; next = next.getNestedClassStats(nameClasses[i], createIfNotFound), ++i) {
        }
        return next;
    }

    private PackageStats getSubPackage(QualifiedName qname, boolean createIfNotFound) {
        if (qname.getPackages() == null) {
            return this;
        }
        String[] packagePath = qname.getPackages();
        PackageStats next = this;
        for (int i = 0; i < packagePath.length && next != null; ++i) {
            if (createIfNotFound && next.subPackages.get(packagePath[i]) == null) {
                next.subPackages.put(packagePath[i], new PackageStats());
            }
            next = next.subPackages.get(packagePath[i]);
        }
        return next;
    }

    public boolean hasMatchingSig(QualifiedName qname, OperationSigMask sigMask) {
        ClassStats clazz = this.getClassStats(qname, false);
        return clazz != null && clazz.hasMatchingSig(qname.getOperation(), sigMask);
    }

    public boolean hasMatchingSig(QualifiedName qname, String fieldName, FieldSigMask sigMask) {
        ClassStats clazz = this.getClassStats(qname, false);
        return clazz != null && clazz.hasMatchingSig(fieldName, sigMask);
    }

    double compute(ClassMetricKey key, ASTClassOrInterfaceDeclaration node, boolean force, MetricVersion version) {
        ClassStats container = this.getClassStats(node.getQualifiedName(), false);
        return container == null ? Double.NaN : container.compute(key, node, force, version);
    }

    double compute(OperationMetricKey key, ASTMethodOrConstructorDeclaration node, boolean force, MetricVersion version) {
        QualifiedName qname = node.getQualifiedName();
        ClassStats container = this.getClassStats(qname, false);
        return container == null ? Double.NaN : container.compute(key, node, qname.getOperation(), force, version);
    }

    double computeWithResultOption(OperationMetricKey key, ASTClassOrInterfaceDeclaration node, boolean force, MetricVersion version, ResultOption option) {
        ClassStats container = this.getClassStats(node.getQualifiedName(), false);
        return container == null ? Double.NaN : container.computeWithResultOption(key, node, force, version, option);
    }
}

