/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.oom;

import java.util.Stack;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTConstructorDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTFieldDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.java.ast.JavaParserVisitorAdapter;
import net.sourceforge.pmd.lang.java.oom.ClassStats;
import net.sourceforge.pmd.lang.java.oom.PackageStats;
import net.sourceforge.pmd.lang.java.oom.signature.FieldSignature;
import net.sourceforge.pmd.lang.java.oom.signature.OperationSignature;

class MetricsVisitor
extends JavaParserVisitorAdapter {
    private Stack<ClassStats> stack = new Stack();

    MetricsVisitor() {
    }

    @Override
    public Object visit(ASTClassOrInterfaceDeclaration node, Object data) {
        this.stack.push(((PackageStats)data).getClassStats(node.getQualifiedName(), true));
        super.visit(node, data);
        this.stack.pop();
        return data;
    }

    @Override
    public Object visit(ASTConstructorDeclaration node, Object data) {
        this.stack.peek().addOperation(node.getQualifiedName().getOperation(), OperationSignature.buildFor(node));
        return super.visit(node, data);
    }

    @Override
    public Object visit(ASTMethodDeclaration node, Object data) {
        this.stack.peek().addOperation(node.getQualifiedName().getOperation(), OperationSignature.buildFor(node));
        return super.visit(node, data);
    }

    @Override
    public Object visit(ASTFieldDeclaration node, Object data) {
        this.stack.peek().addField(node.getVariableName(), FieldSignature.buildFor(node));
        return data;
    }
}

