/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.oom;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceBody;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceBodyDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTMethodOrConstructorDeclaration;
import net.sourceforge.pmd.lang.java.ast.AccessNode;
import net.sourceforge.pmd.lang.java.ast.QualifiedName;
import net.sourceforge.pmd.lang.java.oom.Metrics;
import net.sourceforge.pmd.lang.java.oom.PackageStats;
import net.sourceforge.pmd.lang.java.oom.api.Metric;
import net.sourceforge.pmd.lang.java.oom.api.MetricVersion;
import net.sourceforge.pmd.lang.java.oom.api.OperationMetricKey;

public abstract class AbstractMetric
implements Metric {
    protected static PackageStats getTopLevelPackageStats() {
        return Metrics.getTopLevelPackageStats();
    }

    protected static double sumMetricOverOperations(ASTClassOrInterfaceDeclaration node, OperationMetricKey key, MetricVersion version, boolean includeNested) {
        List<ASTMethodOrConstructorDeclaration> operations = AbstractMetric.findOperations(node, includeNested);
        double sum = 0.0;
        for (ASTMethodOrConstructorDeclaration op : operations) {
            double val = Metrics.get(key, op, version);
            sum += val == Double.NaN ? 0.0 : val;
        }
        return sum;
    }

    protected static double averageMetricOverOperations(ASTClassOrInterfaceDeclaration node, OperationMetricKey key, MetricVersion version, boolean includeNested) {
        List<ASTMethodOrConstructorDeclaration> operations = AbstractMetric.findOperations(node, includeNested);
        double total = 0.0;
        for (ASTMethodOrConstructorDeclaration op : operations) {
            double val = Metrics.get(key, op, version);
            total += val == Double.NaN ? 0.0 : val;
        }
        return total / (double)operations.size();
    }

    protected static double highestMetricOverOperations(ASTClassOrInterfaceDeclaration node, OperationMetricKey key, MetricVersion version, boolean includeNested) {
        List<ASTMethodOrConstructorDeclaration> operations = AbstractMetric.findOperations(node, includeNested);
        double highest = Double.NEGATIVE_INFINITY;
        for (ASTMethodOrConstructorDeclaration op : operations) {
            double val = Metrics.get(key, op, version);
            if (!(val > highest)) continue;
            highest = val;
        }
        return highest;
    }

    public static List<ASTMethodOrConstructorDeclaration> findOperations(ASTClassOrInterfaceDeclaration node, boolean includeNested) {
        if (includeNested) {
            return node.findDescendantsOfType(ASTMethodOrConstructorDeclaration.class);
        }
        ASTClassOrInterfaceBody body = (ASTClassOrInterfaceBody)node.jjtGetChild(0);
        List outerDecls = body.findChildrenOfType(ASTClassOrInterfaceBodyDeclaration.class);
        ArrayList<ASTMethodOrConstructorDeclaration> operations = new ArrayList<ASTMethodOrConstructorDeclaration>();
        for (ASTClassOrInterfaceBodyDeclaration decl : outerDecls) {
            if (!(decl.jjtGetChild(0) instanceof ASTMethodOrConstructorDeclaration)) continue;
            operations.add((ASTMethodOrConstructorDeclaration)decl.jjtGetChild(0));
        }
        return operations;
    }

    protected List<QualifiedName> findAllCalls(ASTMethodOrConstructorDeclaration node) {
        ArrayList<QualifiedName> result = new ArrayList<QualifiedName>();
        return result;
    }

    @Override
    public boolean supports(AccessNode node) {
        return !node.isAbstract();
    }
}

