/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.design;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import net.sourceforge.pmd.lang.java.ast.ASTAllocationExpression;
import net.sourceforge.pmd.lang.java.ast.ASTAnnotationTypeDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTArguments;
import net.sourceforge.pmd.lang.java.ast.ASTArrayDimsAndInits;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceType;
import net.sourceforge.pmd.lang.java.ast.ASTCompilationUnit;
import net.sourceforge.pmd.lang.java.ast.ASTConstructorDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTEnumDeclaration;
import net.sourceforge.pmd.lang.java.ast.AbstractJavaAccessTypeNode;
import net.sourceforge.pmd.lang.java.ast.JavaNode;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRule;
import net.sourceforge.pmd.lang.java.symboltable.SourceFileScope;

public class AccessorClassGenerationRule
extends AbstractJavaRule {
    private List<ClassData> classDataList = new ArrayList<ClassData>();
    private int classID = -1;
    private String packageName;

    @Override
    public Object visit(ASTEnumDeclaration node, Object data) {
        return data;
    }

    @Override
    public Object visit(ASTCompilationUnit node, Object data) {
        this.classDataList.clear();
        this.packageName = ((SourceFileScope)node.getScope().getEnclosingScope(SourceFileScope.class)).getPackageName();
        return super.visit(node, data);
    }

    private boolean isToplevelType(JavaNode node) {
        return node.jjtGetParent().jjtGetParent() instanceof ASTCompilationUnit;
    }

    @Override
    public Object visit(ASTClassOrInterfaceDeclaration node, Object data) {
        if (node.isInterface()) {
            return this.visitInterface(node, data);
        }
        if (!this.isToplevelType(node)) {
            return this.handleInnerType(node, data);
        }
        return this.handleToplevelType(node, data);
    }

    private Object visitInterface(ASTClassOrInterfaceDeclaration node, Object data) {
        if (!this.isToplevelType(node)) {
            return this.handleInnerType(node, data);
        }
        return this.handleToplevelType(node, data);
    }

    @Override
    public Object visit(ASTAnnotationTypeDeclaration node, Object data) {
        if (!this.isToplevelType(node)) {
            return this.handleInnerType(node, data);
        }
        return this.handleToplevelType(node, data);
    }

    private Object handleToplevelType(AbstractJavaAccessTypeNode node, Object data) {
        Object o;
        if (!node.isStatic()) {
            String typeName = node.getImage();
            this.classDataList.clear();
            this.setClassID(0);
            this.classDataList.add(this.getClassID(), new ClassData(typeName));
        }
        if ((o = super.visit(node, data)) != null && !node.isStatic()) {
            this.processRule(o);
        } else {
            this.processRule(data);
        }
        this.setClassID(-1);
        return o;
    }

    private Object handleInnerType(AbstractJavaAccessTypeNode node, Object data) {
        String typeName = node.getImage();
        int formerID = this.getClassID();
        this.setClassID(this.classDataList.size());
        ClassData newClassData = new ClassData(typeName);
        ClassData formerClassData = this.classDataList.get(formerID);
        newClassData.addClassQualifyingName(formerClassData.getClassName());
        this.classDataList.add(this.getClassID(), newClassData);
        Object o = super.visit(node, data);
        this.setClassID(formerID);
        return o;
    }

    @Override
    public Object visit(ASTConstructorDeclaration node, Object data) {
        if (node.isPrivate()) {
            this.getCurrentClassData().addConstructor(node);
        }
        return super.visit(node, data);
    }

    @Override
    public Object visit(ASTAllocationExpression node, Object data) {
        if (this.classID == -1 || this.getCurrentClassData() == null) {
            return data;
        }
        AllocData ad = new AllocData(node, this.packageName, this.getCurrentClassData().getClassQualifyingNamesList());
        if (!ad.isArray()) {
            this.getCurrentClassData().addInstantiation(ad);
        }
        return super.visit(node, data);
    }

    private void processRule(Object ctx) {
        for (ClassData outerDataSet : this.classDataList) {
            Iterator<ASTConstructorDeclaration> constructors = outerDataSet.getPrivateConstructorIterator();
            while (constructors.hasNext()) {
                ASTConstructorDeclaration cd = constructors.next();
                for (ClassData innerDataSet : this.classDataList) {
                    if (outerDataSet.equals(innerDataSet)) continue;
                    Iterator<AllocData> allocations = innerDataSet.getInstantiationIterator();
                    while (allocations.hasNext()) {
                        AllocData ad = allocations.next();
                        if (!outerDataSet.getClassName().equals(ad.getName()) || cd.getParameterCount() != ad.getArgumentCount()) continue;
                        this.addViolation(ctx, ad.getASTAllocationExpression());
                    }
                }
            }
        }
    }

    private ClassData getCurrentClassData() {
        if (this.classID >= this.classDataList.size()) {
            return null;
        }
        return this.classDataList.get(this.classID);
    }

    private void setClassID(int id) {
        this.classID = id;
    }

    private int getClassID() {
        return this.classID;
    }

    private static String stripString(String remove, String value) {
        int index = value.indexOf(remove);
        String returnValue = index != -1 ? value.substring(0, index) + value.substring(index + remove.length()) : value;
        return returnValue;
    }

    private static class AllocData {
        private String name;
        private int argumentCount;
        private ASTAllocationExpression allocationExpression;
        private boolean isArray;

        public AllocData(ASTAllocationExpression node, String aPackageName, List<String> classQualifyingNames) {
            if (node.jjtGetChild(1) instanceof ASTArguments) {
                ASTArguments aa = (ASTArguments)node.jjtGetChild(1);
                this.argumentCount = aa.getArgumentCount();
                if (!(node.jjtGetChild(0) instanceof ASTClassOrInterfaceType)) {
                    throw new RuntimeException("BUG: Expected a ASTClassOrInterfaceType, got a " + node.jjtGetChild(0).getClass());
                }
                ASTClassOrInterfaceType an = (ASTClassOrInterfaceType)node.jjtGetChild(0);
                this.name = AccessorClassGenerationRule.stripString(aPackageName + '.', an.getImage());
                String findName = "";
                ListIterator<String> li = classQualifyingNames.listIterator(classQualifyingNames.size());
                while (li.hasPrevious()) {
                    String aName = li.previous();
                    findName = aName + '.' + findName;
                    if (!this.name.startsWith(findName)) continue;
                    this.name = this.name.substring(findName.length());
                    break;
                }
            } else if (node.jjtGetChild(1) instanceof ASTArrayDimsAndInits) {
                this.isArray = true;
            }
            this.allocationExpression = node;
        }

        public String getName() {
            return this.name;
        }

        public int getArgumentCount() {
            return this.argumentCount;
        }

        public ASTAllocationExpression getASTAllocationExpression() {
            return this.allocationExpression;
        }

        public boolean isArray() {
            return this.isArray;
        }
    }

    private static class ClassData {
        private String className;
        private List<ASTConstructorDeclaration> privateConstructors;
        private List<AllocData> instantiations;
        private List<String> classQualifyingNames;

        public ClassData(String className) {
            this.className = className;
            this.privateConstructors = new ArrayList<ASTConstructorDeclaration>();
            this.instantiations = new ArrayList<AllocData>();
            this.classQualifyingNames = new ArrayList<String>();
        }

        public void addInstantiation(AllocData ad) {
            this.instantiations.add(ad);
        }

        public Iterator<AllocData> getInstantiationIterator() {
            return this.instantiations.iterator();
        }

        public void addConstructor(ASTConstructorDeclaration cd) {
            this.privateConstructors.add(cd);
        }

        public Iterator<ASTConstructorDeclaration> getPrivateConstructorIterator() {
            return this.privateConstructors.iterator();
        }

        public String getClassName() {
            return this.className;
        }

        public void addClassQualifyingName(String name) {
            this.classQualifyingNames.add(name);
        }

        public List<String> getClassQualifyingNamesList() {
            return this.classQualifyingNames;
        }
    }
}

