/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.imports;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceType;
import net.sourceforge.pmd.lang.java.ast.ASTCompilationUnit;
import net.sourceforge.pmd.lang.java.ast.ASTImportDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTName;
import net.sourceforge.pmd.lang.java.ast.ASTPackageDeclaration;
import net.sourceforge.pmd.lang.java.ast.JavaNode;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRule;

public class UnnecessaryFullyQualifiedNameRule
extends AbstractJavaRule {
    private List<ASTImportDeclaration> imports = new ArrayList<ASTImportDeclaration>();
    private List<ASTImportDeclaration> matches = new ArrayList<ASTImportDeclaration>();
    private List<PotentialViolation> violations = new ArrayList<PotentialViolation>();
    private List<PotentialViolation> enumViolations = new ArrayList<PotentialViolation>();

    public UnnecessaryFullyQualifiedNameRule() {
        super.addRuleChainVisit(ASTCompilationUnit.class);
        super.addRuleChainVisit(ASTImportDeclaration.class);
        super.addRuleChainVisit(ASTClassOrInterfaceType.class);
        super.addRuleChainVisit(ASTName.class);
    }

    @Override
    public Object visit(ASTCompilationUnit node, Object data) {
        this.imports.clear();
        this.violations.clear();
        this.enumViolations.clear();
        super.visit(node, data);
        this.filterPotentialViolations();
        this.reportViolations(data);
        return data;
    }

    @Override
    public Object visit(ASTImportDeclaration node, Object data) {
        this.imports.add(node);
        return data;
    }

    @Override
    public Object visit(ASTClassOrInterfaceType node, Object data) {
        this.checkImports(node);
        return data;
    }

    @Override
    public Object visit(ASTName node, Object data) {
        if (!(node.jjtGetParent() instanceof ASTImportDeclaration) && !(node.jjtGetParent() instanceof ASTPackageDeclaration)) {
            this.checkImports(node);
        }
        return data;
    }

    private void checkImports(JavaNode node) {
        String name = node.getImage();
        this.matches.clear();
        for (ASTImportDeclaration importDeclaration : this.imports) {
            if (importDeclaration.isImportOnDemand()) {
                if (!name.startsWith(importDeclaration.getImportedName()) || name.lastIndexOf(46) != importDeclaration.getImportedName().length()) continue;
                this.matches.add(importDeclaration);
                continue;
            }
            if (name.equals(importDeclaration.getImportedName())) {
                this.matches.add(importDeclaration);
                continue;
            }
            if (!name.startsWith(importDeclaration.getImportedName()) || name.lastIndexOf(46) != importDeclaration.getImportedName().length()) continue;
            this.matches.add(importDeclaration);
        }
        if (this.matches.isEmpty() && name.indexOf(46) >= 0) {
            for (ASTImportDeclaration importDeclaration : this.imports) {
                if (!importDeclaration.isStatic()) continue;
                String[] importParts = importDeclaration.getImportedName().split("\\.");
                String[] nameParts = name.split("\\.");
                if (importDeclaration.isImportOnDemand()) {
                    if (!nameParts[nameParts.length - 2].equals(importParts[importParts.length - 1])) continue;
                    this.matches.add(importDeclaration);
                    continue;
                }
                if (!nameParts[nameParts.length - 1].equals(importParts[importParts.length - 1]) || !nameParts[nameParts.length - 2].equals(importParts[importParts.length - 2])) continue;
                this.matches.add(importDeclaration);
            }
        }
        if (!this.matches.isEmpty()) {
            ASTImportDeclaration firstMatch = this.matches.get(0);
            String importStr = firstMatch.getImportedName() + (this.matches.get(0).isImportOnDemand() ? ".*" : "");
            String type = firstMatch.isStatic() ? "static " : "";
            PotentialViolation v = new PotentialViolation(node, importStr, type);
            this.violations.add(v);
            if (this.isEnum(firstMatch.getType())) {
                this.enumViolations.add(v);
            }
        }
        this.matches.clear();
    }

    private void filterPotentialViolations() {
        if (this.enumViolations.size() > 1) {
            this.violations.removeAll(this.enumViolations);
        }
    }

    private void reportViolations(Object data) {
        for (PotentialViolation v : this.violations) {
            v.addViolation(this, data);
        }
    }

    private boolean isEnum(Class<?> type) {
        return type != null && Enum.class.isAssignableFrom(type);
    }

    private static class PotentialViolation {
        private JavaNode node;
        private String importStr;
        private String importType;

        public PotentialViolation(JavaNode node, String importStr, String importType) {
            this.node = node;
            this.importStr = importStr;
            this.importType = importType;
        }

        public void addViolation(UnnecessaryFullyQualifiedNameRule rule, Object data) {
            rule.addViolation(data, (Node)this.node, new Object[]{this.node.getImage(), this.importStr, this.importType});
        }
    }
}

