/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.design;

import java.util.List;
import java.util.Map;
import net.sourceforge.pmd.RuleContext;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTAllocationExpression;
import net.sourceforge.pmd.lang.java.ast.ASTArgumentList;
import net.sourceforge.pmd.lang.java.ast.ASTCastExpression;
import net.sourceforge.pmd.lang.java.ast.ASTCatchStatement;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceType;
import net.sourceforge.pmd.lang.java.ast.ASTName;
import net.sourceforge.pmd.lang.java.ast.ASTPrimaryExpression;
import net.sourceforge.pmd.lang.java.ast.ASTPrimaryPrefix;
import net.sourceforge.pmd.lang.java.ast.ASTThrowStatement;
import net.sourceforge.pmd.lang.java.ast.ASTVariableDeclarator;
import net.sourceforge.pmd.lang.java.ast.ASTVariableDeclaratorId;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRule;
import net.sourceforge.pmd.lang.java.symboltable.VariableNameDeclaration;
import net.sourceforge.pmd.lang.symboltable.NameOccurrence;
import org.jaxen.JaxenException;

public class PreserveStackTraceRule
extends AbstractJavaRule {
    private static final String FIND_THROWABLE_INSTANCE = "./VariableInitializer/Expression/PrimaryExpression/PrimaryPrefix/AllocationExpression[ClassOrInterfaceType[contains(@Image,'Exception')] and Arguments[count(*)=0]]";
    private static final String FILL_IN_STACKTRACE = ".fillInStackTrace";

    @Override
    public Object visit(ASTCatchStatement catchStmt, Object data) {
        String target = ((ASTVariableDeclaratorId)catchStmt.jjtGetChild(0).findChildrenOfType(ASTVariableDeclaratorId.class).get(0)).getImage();
        List lstThrowStatements = catchStmt.findDescendantsOfType(ASTThrowStatement.class);
        for (ASTThrowStatement throwStatement : lstThrowStatements) {
            Node child;
            Node n = throwStatement.jjtGetChild(0).jjtGetChild(0);
            if (n instanceof ASTCastExpression) {
                ASTPrimaryExpression expr = (ASTPrimaryExpression)n.jjtGetChild(1);
                if (expr.jjtGetNumChildren() <= 1 || !(expr.jjtGetChild(1) instanceof ASTPrimaryPrefix)) continue;
                RuleContext ctx = (RuleContext)data;
                this.addViolation(ctx, (Node)throwStatement);
                continue;
            }
            ASTArgumentList args = (ASTArgumentList)throwStatement.getFirstDescendantOfType(ASTArgumentList.class);
            if (args != null) {
                Node parent = args.jjtGetParent().jjtGetParent();
                if (parent instanceof ASTAllocationExpression) {
                    this.ck(data, target, throwStatement, parent);
                    continue;
                }
                this.ck(data, target, throwStatement, (Node)args);
                continue;
            }
            for (child = throwStatement.jjtGetChild(0); child != null && child.jjtGetNumChildren() > 0 && !(child instanceof ASTName); child = child.jjtGetChild(0)) {
            }
            if (child == null) continue;
            if (child instanceof ASTName && !target.equals(child.getImage()) && !child.hasImageEqualTo(target + FILL_IN_STACKTRACE)) {
                Map vars = ((ASTName)child).getScope().getDeclarations(VariableNameDeclaration.class);
                for (Map.Entry entry : vars.entrySet()) {
                    VariableNameDeclaration decl = (VariableNameDeclaration)entry.getKey();
                    List occurrences = (List)entry.getValue();
                    if (!decl.getImage().equals(child.getImage()) || this.isInitCauseCalled(target, occurrences) || (args = (ASTArgumentList)decl.getNode().jjtGetParent().getFirstDescendantOfType(ASTArgumentList.class)) == null) continue;
                    this.ck(data, target, throwStatement, (Node)args);
                }
                continue;
            }
            if (!(child instanceof ASTClassOrInterfaceType)) continue;
            this.addViolation(data, (Node)throwStatement);
        }
        return super.visit(catchStmt, data);
    }

    private boolean isInitCauseCalled(String target, List<NameOccurrence> occurrences) {
        boolean initCauseCalled = false;
        for (NameOccurrence occurrence : occurrences) {
            ASTArgumentList args2;
            ASTPrimaryExpression primaryExpression;
            String image = null;
            if (occurrence.getLocation() != null) {
                image = occurrence.getLocation().getImage();
            }
            if (image == null || !image.endsWith("initCause") || (primaryExpression = (ASTPrimaryExpression)occurrence.getLocation().getFirstParentOfType(ASTPrimaryExpression.class)) == null || !this.checkForTargetUsage(target, (Node)(args2 = (ASTArgumentList)primaryExpression.getFirstDescendantOfType(ASTArgumentList.class)))) continue;
            initCauseCalled = true;
            break;
        }
        return initCauseCalled;
    }

    @Override
    public Object visit(ASTVariableDeclarator node, Object data) {
        try {
            if (node.hasDescendantMatchingXPath(FIND_THROWABLE_INSTANCE)) {
                String variableName = node.jjtGetChild(0).getImage();
                for (ASTCatchStatement catchStmt = (ASTCatchStatement)node.getFirstParentOfType(ASTCatchStatement.class); catchStmt != null; catchStmt = (ASTCatchStatement)catchStmt.getFirstParentOfType(ASTCatchStatement.class)) {
                    List violations = catchStmt.findChildNodesWithXPath("//Expression/PrimaryExpression/PrimaryPrefix/Name[@Image = '" + variableName + "']");
                    if (violations.isEmpty() || this.useInitCause((Node)violations.get(0), catchStmt)) continue;
                    this.addViolation(data, node);
                }
            }
            return super.visit(node, data);
        }
        catch (JaxenException e) {
            throw new IllegalStateException(e);
        }
    }

    private boolean useInitCause(Node node, ASTCatchStatement catchStmt) {
        if (node != null && node.getImage() != null) {
            return catchStmt.hasDescendantMatchingXPath("./Block/BlockStatement/Statement/StatementExpression/PrimaryExpression/PrimaryPrefix/Name[@Image = '" + node.getImage() + ".initCause']");
        }
        return false;
    }

    private boolean checkForTargetUsage(String target, Node baseNode) {
        boolean match = false;
        if (target != null && baseNode != null) {
            List nameNodes = baseNode.findDescendantsOfType(ASTName.class);
            for (ASTName nameNode : nameNodes) {
                if (!target.equals(nameNode.getImage())) continue;
                match = true;
                break;
            }
        }
        return match;
    }

    private void ck(Object data, String target, ASTThrowStatement throwStatement, Node baseNode) {
        if (!this.checkForTargetUsage(target, baseNode)) {
            RuleContext ctx = (RuleContext)data;
            this.addViolation(ctx, (Node)throwStatement);
        }
    }
}

