/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.finalizers;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.sourceforge.pmd.lang.java.ast.ASTCompilationUnit;
import net.sourceforge.pmd.lang.java.ast.ASTName;
import net.sourceforge.pmd.lang.java.ast.ASTPrimaryPrefix;
import net.sourceforge.pmd.lang.java.ast.ASTPrimarySuffix;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRule;
import net.sourceforge.pmd.lang.java.symboltable.MethodScope;

public class AvoidCallingFinalizeRule
extends AbstractJavaRule {
    private Set<MethodScope> checked = new HashSet<MethodScope>();

    @Override
    public Object visit(ASTCompilationUnit acu, Object ctx) {
        this.checked.clear();
        return super.visit(acu, ctx);
    }

    @Override
    public Object visit(ASTName name, Object ctx) {
        if (name.getImage() == null || !name.getImage().endsWith("finalize")) {
            return ctx;
        }
        MethodScope meth = (MethodScope)name.getScope().getEnclosingScope(MethodScope.class);
        if (meth.getName().equals("finalize")) {
            return ctx;
        }
        if (this.checked.contains((Object)meth)) {
            return ctx;
        }
        this.checked.add(meth);
        this.addViolation(ctx, name);
        return ctx;
    }

    @Override
    public Object visit(ASTPrimaryPrefix pp, Object ctx) {
        List primarySuffixes = pp.jjtGetParent().findChildrenOfType(ASTPrimarySuffix.class);
        ASTPrimarySuffix firstSuffix = null;
        if (primarySuffixes.size() > 0) {
            firstSuffix = (ASTPrimarySuffix)primarySuffixes.get(0);
        }
        if (firstSuffix == null || firstSuffix.getImage() == null || !firstSuffix.getImage().endsWith("finalize")) {
            return super.visit(pp, ctx);
        }
        MethodScope meth = (MethodScope)pp.getScope().getEnclosingScope(MethodScope.class);
        if (meth.getName().equals("finalize")) {
            return super.visit(pp, ctx);
        }
        if (this.checked.contains((Object)meth)) {
            return super.visit(pp, ctx);
        }
        this.checked.add(meth);
        this.addViolation(ctx, pp);
        return super.visit(pp, ctx);
    }
}

