/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.owlapi;

import com.google.inject.assistedinject.Assisted;
import java.io.Serializable;
import java.util.List;
import javax.inject.Inject;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.AddImport;
import org.semanticweb.owlapi.model.AddOntologyAnnotation;
import org.semanticweb.owlapi.model.OWLMutableOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyChangeVisitorEx;
import org.semanticweb.owlapi.model.OWLOntologyID;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.RemoveAxiom;
import org.semanticweb.owlapi.model.RemoveImport;
import org.semanticweb.owlapi.model.RemoveOntologyAnnotation;
import org.semanticweb.owlapi.model.SetOntologyID;
import org.semanticweb.owlapi.model.parameters.ChangeApplied;
import uk.ac.manchester.cs.owl.owlapi.OWLImmutableOntologyImpl;

public class OWLOntologyImpl
extends OWLImmutableOntologyImpl
implements OWLMutableOntology,
Serializable {
    @Inject
    public OWLOntologyImpl(@Assisted OWLOntologyManager manager, @Assisted OWLOntologyID ontologyID) {
        super(manager, ontologyID);
    }

    @Override
    public ChangeApplied applyDirectChange(OWLOntologyChange change) {
        OWLOntologyChangeFilter changeFilter = new OWLOntologyChangeFilter();
        return change.accept(changeFilter);
    }

    @Override
    public ChangeApplied applyChanges(List<? extends OWLOntologyChange> changes) {
        ChangeApplied appliedChanges = ChangeApplied.SUCCESSFULLY;
        OWLOntologyChangeFilter changeFilter = new OWLOntologyChangeFilter();
        for (OWLOntologyChange oWLOntologyChange : changes) {
            ChangeApplied result = oWLOntologyChange.accept(changeFilter);
            if (appliedChanges != ChangeApplied.SUCCESSFULLY) continue;
            appliedChanges = result;
        }
        return appliedChanges;
    }

    protected class OWLOntologyChangeFilter
    implements OWLOntologyChangeVisitorEx<ChangeApplied>,
    Serializable {
        protected OWLOntologyChangeFilter() {
        }

        @Override
        public ChangeApplied visit(RemoveAxiom change) {
            if (OWLOntologyImpl.this.ints.removeAxiom(change.getAxiom())) {
                return ChangeApplied.SUCCESSFULLY;
            }
            return ChangeApplied.NO_OPERATION;
        }

        @Override
        public ChangeApplied visit(SetOntologyID change) {
            OWLOntologyID id = change.getNewOntologyID();
            if (!id.equals(OWLOntologyImpl.this.ontologyID)) {
                OWLOntologyImpl.this.ontologyID = id;
                return ChangeApplied.SUCCESSFULLY;
            }
            return ChangeApplied.NO_OPERATION;
        }

        @Override
        public ChangeApplied visit(AddAxiom change) {
            if (OWLOntologyImpl.this.ints.addAxiom(change.getAxiom())) {
                return ChangeApplied.SUCCESSFULLY;
            }
            return ChangeApplied.NO_OPERATION;
        }

        @Override
        public ChangeApplied visit(AddImport change) {
            if (OWLOntologyImpl.this.ints.addImportsDeclaration(change.getImportDeclaration())) {
                return ChangeApplied.SUCCESSFULLY;
            }
            return ChangeApplied.NO_OPERATION;
        }

        @Override
        public ChangeApplied visit(RemoveImport change) {
            if (OWLOntologyImpl.this.ints.removeImportsDeclaration(change.getImportDeclaration())) {
                return ChangeApplied.SUCCESSFULLY;
            }
            return ChangeApplied.NO_OPERATION;
        }

        @Override
        public ChangeApplied visit(AddOntologyAnnotation change) {
            if (OWLOntologyImpl.this.ints.addOntologyAnnotation(change.getAnnotation())) {
                return ChangeApplied.SUCCESSFULLY;
            }
            return ChangeApplied.NO_OPERATION;
        }

        @Override
        public ChangeApplied visit(RemoveOntologyAnnotation change) {
            if (OWLOntologyImpl.this.ints.removeOntologyAnnotation(change.getAnnotation())) {
                return ChangeApplied.SUCCESSFULLY;
            }
            return ChangeApplied.NO_OPERATION;
        }
    }
}

