/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapitools.builders;

import javax.annotation.Nullable;
import javax.inject.Inject;
import org.semanticweb.owlapi.model.EntityType;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapitools.builders.BaseEntityBuilder;

public class BuilderEntity
extends BaseEntityBuilder<OWLEntity, BuilderEntity> {
    @Nullable
    private EntityType<?> entityType = null;

    @Inject
    public BuilderEntity(OWLDataFactory df) {
        super(df);
    }

    public BuilderEntity(OWLEntity expected, OWLDataFactory df) {
        this(df);
        this.withType(expected.getEntityType()).withIRI(expected.getIRI());
    }

    public BuilderEntity withType(EntityType<?> arg) {
        this.entityType = arg;
        return this;
    }

    public EntityType<?> getEntityType() {
        return OWLAPIPreconditions.verifyNotNull(this.entityType);
    }

    @Override
    public OWLEntity buildObject() {
        if (this.pm != null && this.string != null) {
            return this.df.getOWLEntity(this.getEntityType(), this.getPM().getIRI(this.getString()));
        }
        return this.df.getOWLEntity(this.getEntityType(), this.getIRI());
    }
}

