/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.util;

import java.util.HashMap;
import java.util.Map;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.util.NamespaceUtil;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.util.ShortFormProvider;

public class QNameShortFormProvider
implements ShortFormProvider {
    private final NamespaceUtil namespaceUtil = new NamespaceUtil();

    public QNameShortFormProvider() {
        this(new HashMap<String, String>());
    }

    public QNameShortFormProvider(Map<String, String> prefix2Ns) {
        OWLAPIPreconditions.checkNotNull(prefix2Ns, "prefix2NamespaceMap cannot be null");
        prefix2Ns.forEach((key, v) -> this.namespaceUtil.setPrefix((String)v, this.removeColon((String)key)));
    }

    protected String removeColon(String key) {
        int lastChar = key.length() - 1;
        if (key.charAt(lastChar) == ':') {
            return key.substring(0, lastChar);
        }
        return key;
    }

    @Override
    public String getShortForm(OWLEntity entity) {
        OWLAPIPreconditions.checkNotNull(entity, "entity cannot be null");
        String namespace = entity.getIRI().getNamespace();
        String prefix = this.namespaceUtil.getPrefix(namespace);
        return entity.getIRI().prefixedBy(prefix + ':');
    }
}

