/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.rio;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import javax.annotation.Nullable;
import org.openrdf.rio.RDFFormat;
import org.semanticweb.owlapi.formats.FunctionalSyntaxDocumentFormat;
import org.semanticweb.owlapi.formats.ManchesterSyntaxDocumentFormat;
import org.semanticweb.owlapi.formats.OWLXMLDocumentFormat;
import org.semanticweb.owlapi.model.OWLDocumentFormat;
import org.semanticweb.owlapi.model.OWLDocumentFormatFactory;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;

public class OWLAPIRDFFormat
extends RDFFormat {
    public static final OWLAPIRDFFormat MANCHESTER_OWL = new OWLAPIRDFFormat("Manchester OWL Syntax", Arrays.asList("text/owl-manchester"), StandardCharsets.UTF_8, Arrays.asList("omn"), true, false, (OWLDocumentFormat)new ManchesterSyntaxDocumentFormat());
    public static final OWLAPIRDFFormat OWL_XML = new OWLAPIRDFFormat("OWL/XML Syntax", Arrays.asList("application/owl+xml"), StandardCharsets.UTF_8, Arrays.asList("owx"), true, false, (OWLDocumentFormat)new OWLXMLDocumentFormat());
    public static final OWLAPIRDFFormat OWL_FUNCTIONAL = new OWLAPIRDFFormat("OWL Functional Syntax", Arrays.asList("text/owl-functional"), StandardCharsets.UTF_8, Arrays.asList("ofn"), true, false, (OWLDocumentFormat)new FunctionalSyntaxDocumentFormat());
    @Nullable
    private OWLDocumentFormat owlFormat;
    @Nullable
    private OWLDocumentFormatFactory owlFormatFactory;

    public OWLAPIRDFFormat(String name, String mimeType, Charset charset, String fileExtension, boolean supportsNamespaces, boolean supportsContexts, OWLDocumentFormatFactory owlFormat) {
        super(name, mimeType, charset, fileExtension, supportsNamespaces, supportsContexts);
        this.owlFormatFactory = owlFormat;
    }

    public OWLAPIRDFFormat(String name, String mimeType, Charset charset, Collection<String> fileExtensions, boolean supportsNamespaces, boolean supportsContexts, OWLDocumentFormatFactory owlFormat) {
        super(name, mimeType, charset, fileExtensions, supportsNamespaces, supportsContexts);
        this.owlFormatFactory = owlFormat;
    }

    public OWLAPIRDFFormat(String name, Collection<String> mimeTypes, Charset charset, Collection<String> fileExtensions, boolean supportsNamespaces, boolean supportsContexts, OWLDocumentFormatFactory owlFormat) {
        super(name, mimeTypes, charset, fileExtensions, supportsNamespaces, supportsContexts);
        this.owlFormatFactory = owlFormat;
    }

    public OWLAPIRDFFormat(String name, String mimeType, Charset charset, String fileExtension, boolean supportsNamespaces, boolean supportsContexts, OWLDocumentFormat owlFormat) {
        super(name, mimeType, charset, fileExtension, supportsNamespaces, supportsContexts);
        this.owlFormat = owlFormat;
    }

    public OWLAPIRDFFormat(String name, String mimeType, Charset charset, Collection<String> fileExtensions, boolean supportsNamespaces, boolean supportsContexts, OWLDocumentFormat owlFormat) {
        super(name, mimeType, charset, fileExtensions, supportsNamespaces, supportsContexts);
        this.owlFormat = owlFormat;
    }

    public OWLAPIRDFFormat(String name, Collection<String> mimeTypes, Charset charset, Collection<String> fileExtensions, boolean supportsNamespaces, boolean supportsContexts, OWLDocumentFormat owlFormat) {
        super(name, mimeTypes, charset, fileExtensions, supportsNamespaces, supportsContexts);
        this.owlFormat = owlFormat;
    }

    public OWLDocumentFormat getOWLFormat() {
        if (this.owlFormatFactory != null) {
            return this.owlFormatFactory.createFormat();
        }
        try {
            return (OWLDocumentFormat)OWLAPIPreconditions.verifyNotNull(this.owlFormat).getClass().newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new OWLRuntimeException("Format did not have a factory or a public default constructor", e);
        }
    }
}

