/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.rdf.rdfxml.parser;

import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.io.XMLUtils;
import org.semanticweb.owlapi.rdf.rdfxml.parser.AbstractState;
import org.semanticweb.owlapi.rdf.rdfxml.parser.NodeElement;
import org.semanticweb.owlapi.rdf.rdfxml.parser.RDFParser;
import org.semanticweb.owlapi.rdf.rdfxml.parser.State;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.xml.sax.Attributes;

class ParseTypeLiteralElement
extends AbstractState
implements State {
    protected final NodeElement nodeElement;
    @Nullable
    protected String pIRI;
    @Nullable
    protected String reificationID;
    protected int depth;
    protected final StringBuilder m_content = new StringBuilder();
    protected Set<String> declaredNamespaces = new HashSet<String>(2);

    ParseTypeLiteralElement(NodeElement nodeElement, RDFParser parser) {
        super(parser);
        this.nodeElement = nodeElement;
    }

    protected String propertyIRI() {
        return OWLAPIPreconditions.verifyNotNull(this.pIRI);
    }

    @Override
    public void startElement(String namespaceIRI, String localName, String qName, Attributes atts) {
        if (this.depth == 0) {
            this.pIRI = this.nodeElement.getPropertyIRI(namespaceIRI + localName);
            this.reificationID = this.nodeElement.getReificationID(atts);
            this.m_content.delete(0, this.m_content.length());
        } else {
            this.m_content.append('<');
            this.m_content.append(qName);
            if (!localName.equals(qName) && this.declaredNamespaces.add(namespaceIRI)) {
                this.m_content.append(" xmlns:").append(qName.substring(0, qName.indexOf(58))).append("=\"").append(namespaceIRI).append('\"');
            }
            int length = atts.getLength();
            for (int i = 0; i < length; ++i) {
                this.m_content.append(' ');
                this.m_content.append(atts.getQName(i));
                this.m_content.append("=\"");
                this.m_content.append(atts.getValue(i));
                this.m_content.append('\"');
            }
            this.m_content.append('>');
        }
        ++this.depth;
    }

    @Override
    public void endElement(String namespaceIRI, String localName, String qName) {
        if (this.depth == 1) {
            String content = OWLAPIPreconditions.verifyNotNull(this.m_content.toString());
            this.parser.statementWithLiteralValue(this.nodeElement.subjectIRI(), this.propertyIRI(), content, "http://www.w3.org/1999/02/22-rdf-syntax-ns#XMLLiteral", this.reificationID);
            this.parser.popState();
        } else {
            this.m_content.append("</");
            this.m_content.append(qName);
            this.m_content.append('>');
        }
        --this.depth;
    }

    @Override
    public void characters(char[] data, int start, int length) {
        XMLUtils.escapeXML(data, start, length, this.m_content);
    }
}

