/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.model;

import java.util.Optional;
import org.semanticweb.owlapi.model.EntityType;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;

public interface EntityTypeVisitorEx<T> {
    default public Optional<T> visit(EntityType<?> entity) {
        if (entity.equals(EntityType.CLASS)) {
            return this.visitCLASS();
        }
        if (entity.equals(EntityType.OBJECT_PROPERTY)) {
            return this.visitOBJECT_PROPERTY();
        }
        if (entity.equals(EntityType.DATA_PROPERTY)) {
            return this.visitDATA_PROPERTY();
        }
        if (entity.equals(EntityType.ANNOTATION_PROPERTY)) {
            return this.visitANNOTATION_PROPERTY();
        }
        if (entity.equals(EntityType.NAMED_INDIVIDUAL)) {
            return this.visitNAMED_INDIVIDUAL();
        }
        if (entity.equals(EntityType.DATATYPE)) {
            return this.visitDATATYPE();
        }
        return this.doDefault();
    }

    default public Optional<T> doDefault() {
        return OWLAPIPreconditions.emptyOptional();
    }

    public Optional<T> visitCLASS();

    public Optional<T> visitOBJECT_PROPERTY();

    public Optional<T> visitDATA_PROPERTY();

    public Optional<T> visitANNOTATION_PROPERTY();

    public Optional<T> visitNAMED_INDIVIDUAL();

    public Optional<T> visitDATATYPE();
}

