/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.owlapi.explanation.io;

import com.clarkparsia.owlapi.explanation.io.ExplanationRenderer;
import java.io.IOException;
import java.io.Writer;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.util.SimpleRenderer;

public class ConciseExplanationRenderer
implements ExplanationRenderer {
    private static final String INDENT = "   ";
    private final SimpleRenderer renderer = new SimpleRenderer();
    @Nullable
    private Writer printWriter;

    @Override
    public void startRendering(Writer writer) {
        this.printWriter = OWLAPIPreconditions.checkNotNull(writer, "w cannot be null");
    }

    @Override
    public void render(OWLAxiom axiom, @Nonnull Set<Set<OWLAxiom>> explanations) {
        OWLAPIPreconditions.checkNotNull(axiom, "axiom cannot be null");
        try {
            this.getWriter().write("Axiom: " + this.renderer.render(axiom) + "\n");
            int expSize = explanations.size();
            if (expSize == 0) {
                this.getWriter().write("Explanation: AXIOM IS NOT ENTAILED!\n");
                return;
            }
            if (expSize == 1) {
                this.getWriter().write("Explanation: ");
                Set<OWLAxiom> explanation = explanations.iterator().next();
                this.renderSingleExplanation(INDENT, explanation);
            } else {
                this.getWriter().write("Explanations (" + expSize + "): \n");
                this.renderMultipleExplanations(explanations);
            }
            this.getWriter().write("\n");
        }
        catch (IOException e) {
            throw new OWLRuntimeException(e);
        }
    }

    protected Writer getWriter() {
        return OWLAPIPreconditions.verifyNotNull(this.printWriter, "printWriter not set yet");
    }

    private void renderMultipleExplanations(Set<Set<OWLAxiom>> explanations) {
        int count = 1;
        for (Set<OWLAxiom> exp : explanations) {
            String header = count++ + ") ";
            this.renderSingleExplanation(header, exp);
        }
    }

    private void renderSingleExplanation(String inputHeader, Set<OWLAxiom> axioms) {
        String header = inputHeader;
        boolean first = true;
        for (OWLAxiom axiom : axioms) {
            if (first) {
                first = false;
            } else {
                header = INDENT;
            }
            try {
                this.getWriter().write(header + this.renderer.render(axiom) + "\n");
            }
            catch (IOException e) {
                throw new OWLRuntimeException(e);
            }
        }
    }

    @Override
    public void endRendering() {
        try {
            this.getWriter().flush();
        }
        catch (IOException e) {
            throw new OWLRuntimeException(e);
        }
    }
}

