/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.search;

import java.util.Collection;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.HasProperty;
import org.semanticweb.owlapi.model.HasSubject;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLDatatypeDefinitionAxiom;
import org.semanticweb.owlapi.model.OWLSubAnnotationPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.OWLSubDataPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubObjectPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubPropertyAxiom;
import org.semanticweb.owlapi.util.CollectionFactory;
import org.semanticweb.owlapi.util.OWLAxiomSearchFilter;

public class Filters {
    public static final OWLAxiomSearchFilter subAnnotationWithSuper = new AxiomFilter<OWLSubAnnotationPropertyOfAxiom>(AxiomType.SUB_ANNOTATION_PROPERTY_OF, OWLSubAnnotationPropertyOfAxiom::getSuperProperty);
    public static final OWLAxiomSearchFilter subAnnotationWithSub = new AxiomFilter<OWLSubAnnotationPropertyOfAxiom>(AxiomType.SUB_ANNOTATION_PROPERTY_OF, OWLSubAnnotationPropertyOfAxiom::getSubProperty);
    public static final OWLAxiomSearchFilter subClassWithSuper = new AxiomFilter<OWLSubClassOfAxiom>(AxiomType.SUBCLASS_OF, OWLSubClassOfAxiom::getSuperClass);
    public static final OWLAxiomSearchFilter subClassWithSub = new AxiomFilter<OWLSubClassOfAxiom>(AxiomType.SUBCLASS_OF, OWLSubClassOfAxiom::getSubClass);
    public static final OWLAxiomSearchFilter subObjectPropertyWithSuper = new AxiomFilter<OWLSubObjectPropertyOfAxiom>(AxiomType.SUB_OBJECT_PROPERTY, OWLSubPropertyAxiom::getSuperProperty);
    public static final OWLAxiomSearchFilter subObjectPropertyWithSub = new AxiomFilter<OWLSubObjectPropertyOfAxiom>(AxiomType.SUB_OBJECT_PROPERTY, OWLSubPropertyAxiom::getSubProperty);
    public static final OWLAxiomSearchFilter subDataPropertyWithSuper = new AxiomFilter<OWLSubDataPropertyOfAxiom>(AxiomType.SUB_DATA_PROPERTY, OWLSubPropertyAxiom::getSuperProperty);
    public static final OWLAxiomSearchFilter subDataPropertyWithSub = new AxiomFilter<OWLSubDataPropertyOfAxiom>(AxiomType.SUB_DATA_PROPERTY, OWLSubPropertyAxiom::getSubProperty);
    public static final OWLAxiomSearchFilter datatypeDefFilter = new AxiomFilter<OWLDatatypeDefinitionAxiom>(AxiomType.DATATYPE_DEFINITION, OWLDatatypeDefinitionAxiom::getDatatype);
    public static final OWLAxiomSearchFilter apRangeFilter = new AxiomFilter<OWLAnnotationPropertyRangeAxiom>(AxiomType.ANNOTATION_PROPERTY_RANGE, HasProperty::getProperty);
    public static final OWLAxiomSearchFilter apDomainFilter = new AxiomFilter<OWLAnnotationPropertyDomainAxiom>(AxiomType.ANNOTATION_PROPERTY_DOMAIN, HasProperty::getProperty);
    @Deprecated
    public static final OWLAxiomSearchFilter annotations = new AxiomFilter<OWLAnnotationAssertionAxiom>(AxiomType.ANNOTATION_ASSERTION, HasSubject::getSubject);
    public static final OWLAxiomSearchFilter axiomsFromTBoxAndRBox = new AxiomFilter<OWLAxiom>(AxiomType.TBoxAndRBoxAxiomTypes, a -> a){

        @Override
        public boolean pass(OWLAxiom axiom, Object key) {
            return true;
        }
    };
    public static final OWLAxiomSearchFilter axiomsNotInTBoxOrRBox = new AxiomFilter<OWLAxiom>(AxiomType.AXIOM_TYPES, a -> a){

        @Override
        public boolean pass(@Nonnull OWLAxiom axiom, Object key) {
            return !AxiomType.TBoxAndRBoxAxiomTypes.contains(axiom.getAxiomType());
        }
    };

    private Filters() {
    }

    public static class AxiomFilter<A extends OWLAxiom>
    implements OWLAxiomSearchFilter {
        private final Collection<AxiomType<?>> types;
        private final Filter<A> filter;

        public AxiomFilter(AxiomType<?> type, Filter<A> f) {
            this.types = CollectionFactory.list(type);
            this.filter = f;
        }

        public AxiomFilter(Collection<AxiomType<?>> types, Filter<A> f) {
            this.types = types;
            this.filter = f;
        }

        public AxiomFilter(Filter<A> f, AxiomType<?> ... types) {
            this.types = CollectionFactory.list(types);
            this.filter = f;
        }

        @Override
        public Iterable<AxiomType<?>> getAxiomTypes() {
            return this.types;
        }

        @Override
        public boolean pass(OWLAxiom axiom, Object key) {
            return this.axiomValue(axiom).equals(key);
        }

        protected Object axiomValue(A axiom) {
            return this.filter.filter(axiom);
        }
    }

    @FunctionalInterface
    private static interface Filter<A extends OWLAxiom> {
        public Object filter(A var1);
    }
}

