/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.model;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.IsAnonymous;
import org.semanticweb.owlapi.model.NodeID;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OWLOntologyID
implements Comparable<OWLOntologyID>,
Serializable,
IsAnonymous {
    private static final Logger LOGGER = LoggerFactory.getLogger(OWLOntologyID.class);
    private static final AtomicInteger COUNTER = new AtomicInteger();
    private static final String ANON_PREFIX = "Anonymous-";
    private transient Optional<String> internalID = OWLAPIPreconditions.emptyOptional();
    private transient Optional<IRI> ontologyIRI;
    private transient Optional<IRI> versionIRI;
    private int hashCode;

    public OWLOntologyID(@Nullable IRI iri) {
        this(OWLOntologyID.opt(iri), OWLAPIPreconditions.emptyOptional(IRI.class));
    }

    public OWLOntologyID(@Nullable IRI iri, @Nullable IRI versionIRI) {
        this(OWLOntologyID.opt(iri), OWLOntologyID.opt(versionIRI));
    }

    public OWLOntologyID(Optional<IRI> iri, Optional<IRI> version) {
        this.ontologyIRI = OWLOntologyID.opt(iri);
        this.hashCode = 17;
        if (this.ontologyIRI.isPresent()) {
            this.hashCode += 37 * this.ontologyIRI.hashCode();
        } else {
            this.internalID = OWLAPIPreconditions.optional(ANON_PREFIX + COUNTER.getAndIncrement());
            this.hashCode += 37 * this.internalID.hashCode();
        }
        this.versionIRI = OWLOntologyID.opt(version);
        if (this.versionIRI.isPresent()) {
            if (!this.ontologyIRI.isPresent()) {
                throw new IllegalArgumentException("If the ontology IRI is null then it is not possible to specify a version IRI");
            }
            this.hashCode += 37 * this.versionIRI.hashCode();
        }
    }

    public OWLOntologyID() {
        this(OWLAPIPreconditions.emptyOptional(IRI.class), OWLAPIPreconditions.emptyOptional(IRI.class));
    }

    private void readObject(ObjectInputStream stream) throws ClassNotFoundException, IOException {
        stream.defaultReadObject();
        this.ontologyIRI = OWLAPIPreconditions.optional((IRI)stream.readObject());
        this.versionIRI = OWLAPIPreconditions.optional((IRI)stream.readObject());
        this.internalID = OWLAPIPreconditions.optional((String)stream.readObject());
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        stream.writeObject(this.ontologyIRI.orElse(null));
        stream.writeObject(this.versionIRI.orElse(null));
        stream.writeObject(this.internalID.orElse(null));
    }

    private static Optional<IRI> opt(@Nullable IRI i) {
        if (i == null || NodeID.isAnonymousNodeIRI(i)) {
            return OWLAPIPreconditions.emptyOptional();
        }
        if (!i.isAbsolute()) {
            LOGGER.error("Ontology IRIs must be absolute; IRI {} is relative and will be made absolute by prefixing urn:absolute: to it", (Object)i);
            return OWLAPIPreconditions.optional(IRI.create("urn:absolute:" + i));
        }
        return OWLAPIPreconditions.optional(i);
    }

    private static Optional<IRI> opt(Optional<IRI> i) {
        if (NodeID.isAnonymousNodeIRI(i.orElse(null))) {
            return OWLAPIPreconditions.emptyOptional();
        }
        return i;
    }

    public boolean match(IRI iri) {
        return this.matchOntology(iri) || this.matchVersion(iri);
    }

    public boolean matchVersion(IRI iri) {
        return iri.equals(this.versionIRI.orElse(null));
    }

    public boolean matchDocument(IRI iri) {
        return iri.equals(this.getDefaultDocumentIRI().orElse(null));
    }

    public boolean matchOntology(IRI iri) {
        return iri.equals(this.ontologyIRI.orElse(null));
    }

    public boolean match(OWLOntologyID id) {
        return this.ontologyIRI.equals(id.getOntologyIRI());
    }

    public boolean isOWL2DLOntologyID() {
        return !this.ontologyIRI.isPresent() || !this.ontologyIRI.get().isReservedVocabulary() && (!this.versionIRI.isPresent() || !this.versionIRI.get().isReservedVocabulary());
    }

    @Override
    public int compareTo(@Nullable OWLOntologyID o) {
        OWLAPIPreconditions.checkNotNull(o);
        assert (o != null);
        return this.toString().compareTo(o.toString());
    }

    public Optional<IRI> getOntologyIRI() {
        return this.ontologyIRI;
    }

    public Optional<IRI> getVersionIRI() {
        return this.versionIRI;
    }

    public Optional<IRI> getDefaultDocumentIRI() {
        if (this.ontologyIRI.isPresent()) {
            if (this.versionIRI.isPresent()) {
                return this.versionIRI;
            }
            return this.ontologyIRI;
        }
        return OWLAPIPreconditions.emptyOptional();
    }

    @Override
    public boolean isAnonymous() {
        return !this.ontologyIRI.isPresent();
    }

    public String toString() {
        if (this.ontologyIRI.isPresent()) {
            String template = "OntologyID(OntologyIRI(<%s>) VersionIRI(<%s>))";
            return String.format(template, this.ontologyIRI.get(), this.versionIRI.orElse(null));
        }
        return "OntologyID(" + (String)this.internalID.orElse(null) + ')';
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(@Nullable Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof OWLOntologyID)) {
            return false;
        }
        OWLOntologyID other = (OWLOntologyID)obj;
        if (this.isAnonymous() && other.isAnonymous()) {
            return this.internalID.equals(other.internalID);
        }
        if (this.isAnonymous() != other.isAnonymous()) {
            return false;
        }
        if (!this.isAnonymous()) {
            boolean toReturn = this.ontologyIRI.equals(other.ontologyIRI);
            if (!toReturn) {
                return toReturn;
            }
            toReturn = this.versionIRI.equals(other.versionIRI);
            return toReturn;
        }
        return false;
    }
}

