/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.profiles;

import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.HasIRI;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import org.semanticweb.owlapi.profiles.KnownFactories;
import org.semanticweb.owlapi.profiles.OWL2DLProfile;
import org.semanticweb.owlapi.profiles.OWL2ELProfile;
import org.semanticweb.owlapi.profiles.OWL2Profile;
import org.semanticweb.owlapi.profiles.OWL2QLProfile;
import org.semanticweb.owlapi.profiles.OWL2RLProfile;
import org.semanticweb.owlapi.profiles.OWLProfile;
import org.semanticweb.owlapi.profiles.OWLProfileReport;
import org.semanticweb.owlapi.reasoner.OWLReasonerFactory;
import org.semanticweb.owlapi.util.CollectionFactory;

public enum Profiles implements HasIRI,
KnownFactories,
OWLProfile
{
    OWL2_DL("DL", new String[]{"uk.ac.manchester.cs.factplusplus.owlapiv3.FaCTPlusPlusReasonerFactory", "org.semanticweb.HermiT.Reasoner.ReasonerFactory", "uk.ac.manchester.cs.jfact.JFactFactory", "eu.trowl.owlapi3.rel.reasoner.dl.RELReasonerFactory", "com.clarkparsia.pellet.owlapiv3.PelletReasonerFactory", "org.semanticweb.more.MOReRLrewReasonerFactory"}){

        @Override
        public OWLProfile getOWLProfile() {
            return new OWL2DLProfile();
        }
    }
    ,
    OWL2_QL("QL", new String[]{"uk.ac.manchester.cs.factplusplus.owlapiv3.FaCTPlusPlusReasonerFactory", "org.semanticweb.HermiT.Reasoner.ReasonerFactory", "uk.ac.manchester.cs.jfact.JFactFactory", "eu.trowl.owlapi3.rel.reasoner.dl.RELReasonerFactory", "com.clarkparsia.pellet.owlapiv3.PelletReasonerFactory", "org.semanticweb.more.MOReRLrewReasonerFactory"}){

        @Override
        public OWLProfile getOWLProfile() {
            return new OWL2QLProfile();
        }
    }
    ,
    OWL2_EL("EL", new String[]{"org.semanticweb.elk.owlapi.ElkReasonerFactory", "au.csiro.snorocket.owlapi.SnorocketReasonerFactory", "uk.ac.manchester.cs.factplusplus.owlapiv3.FaCTPlusPlusReasonerFactory", "org.semanticweb.HermiT.Reasoner.ReasonerFactory", "uk.ac.manchester.cs.jfact.JFactFactory", "eu.trowl.owlapi3.rel.reasoner.dl.RELReasonerFactory", "com.clarkparsia.pellet.owlapiv3.PelletReasonerFactory", "org.semanticweb.more.MOReRLrewReasonerFactory"}){

        @Override
        public OWLProfile getOWLProfile() {
            return new OWL2ELProfile();
        }
    }
    ,
    OWL2_RL("RL", new String[]{"uk.ac.manchester.cs.factplusplus.owlapiv3.FaCTPlusPlusReasonerFactory", "org.semanticweb.HermiT.Reasoner.ReasonerFactory", "uk.ac.manchester.cs.jfact.JFactFactory", "eu.trowl.owlapi3.rel.reasoner.dl.RELReasonerFactory", "com.clarkparsia.pellet.owlapiv3.PelletReasonerFactory", "org.semanticweb.more.MOReRLrewReasonerFactory"}){

        @Override
        public OWLProfile getOWLProfile() {
            return new OWL2RLProfile();
        }
    }
    ,
    OWL2_FULL("Full", new String[]{"uk.ac.manchester.cs.factplusplus.owlapiv3.FaCTPlusPlusReasonerFactory", "org.semanticweb.HermiT.Reasoner.ReasonerFactory", "uk.ac.manchester.cs.jfact.JFactFactory", "eu.trowl.owlapi3.rel.reasoner.dl.RELReasonerFactory", "com.clarkparsia.pellet.owlapiv3.PelletReasonerFactory", "org.semanticweb.more.MOReRLrewReasonerFactory"}){

        @Override
        public OWLProfile getOWLProfile() {
            return new OWL2Profile();
        }
    };

    @Nonnull
    private final IRI iri;
    @Nonnull
    private final List<String> supportingFactories;

    private Profiles(String name, String ... supportingFactories) {
        this.iri = IRI.create("http://www.w3.org/ns/owl-profile/", name);
        this.supportingFactories = CollectionFactory.list(supportingFactories);
    }

    @Override
    public String getName() {
        return this.getOWLProfile().getName();
    }

    @Override
    public OWLProfileReport checkOntology(OWLOntology ontology) {
        return this.getOWLProfile().checkOntology(ontology);
    }

    @Override
    public IRI getIRI() {
        return this.iri;
    }

    public abstract OWLProfile getOWLProfile();

    public Collection<String> supportingReasoners() {
        return this.supportingFactories;
    }

    public static OWLReasonerFactory instantiateFactory(String factoryClassName) {
        try {
            Class<?> c = Class.forName(factoryClassName);
            if (OWLReasonerFactory.class.isAssignableFrom(c)) {
                return (OWLReasonerFactory)c.newInstance();
            }
            throw new OWLRuntimeException("Reasoner factory cannot be instantiated: " + factoryClassName);
        }
        catch (ClassNotFoundException e) {
            throw new OWLRuntimeException("Reasoner factory cannot be instantiated: " + factoryClassName, e);
        }
        catch (InstantiationException e) {
            throw new OWLRuntimeException("Reasoner factory cannot be instantiated: " + factoryClassName, e);
        }
        catch (IllegalAccessException e) {
            throw new OWLRuntimeException("Reasoner factory cannot be instantiated: " + factoryClassName, e);
        }
    }

    public static Profiles valueForIRI(IRI i) {
        for (Profiles p : Profiles.values()) {
            if (!p.iri.equals(i)) continue;
            return p;
        }
        return null;
    }
}

