/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.binaryowl.owlobject.serializer;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.semanticweb.binaryowl.BinaryOWLParseException;
import org.semanticweb.binaryowl.owlobject.serializer.AbstractAxiomSerializer;
import org.semanticweb.binaryowl.stream.BinaryOWLInputStream;
import org.semanticweb.binaryowl.stream.BinaryOWLOutputStream;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLHasKeyAxiom;
import org.semanticweb.owlapi.model.OWLObject;

public class OWLHasKeyAxiomSerializer
extends AbstractAxiomSerializer<OWLHasKeyAxiom> {
    @Override
    protected void writeAxiom(OWLHasKeyAxiom axiom, BinaryOWLOutputStream outputStream) throws IOException {
        outputStream.writeOWLObject((OWLObject)axiom.getClassExpression());
        outputStream.writeOWLObjects(axiom.getObjectPropertyExpressions());
        outputStream.writeOWLObjects(axiom.getDataPropertyExpressions());
    }

    @Override
    protected OWLHasKeyAxiom readAxiom(BinaryOWLInputStream inputStream, Set<OWLAnnotation> annotations) throws IOException, BinaryOWLParseException {
        OWLClassExpression classExpression = (OWLClassExpression)inputStream.readOWLObject();
        Set objectPropertyExpressions = inputStream.readOWLObjects();
        Set dataPropertyExpressions = inputStream.readOWLObjects();
        HashSet expressions = new HashSet();
        expressions.addAll(objectPropertyExpressions);
        expressions.addAll(dataPropertyExpressions);
        return inputStream.getDataFactory().getOWLHasKeyAxiom(classExpression, expressions, annotations);
    }
}

