/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.binaryowl.change;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.semanticweb.binaryowl.BinaryOWLMetadata;
import org.semanticweb.binaryowl.BinaryOWLParseException;
import org.semanticweb.binaryowl.change.OntologyChangeDataType;
import org.semanticweb.binaryowl.chunk.ChunkUtil;
import org.semanticweb.binaryowl.chunk.TimeStampedMetadataChunk;
import org.semanticweb.binaryowl.stream.BinaryOWLInputStream;
import org.semanticweb.binaryowl.stream.BinaryOWLOutputStream;
import org.semanticweb.owlapi.change.OWLOntologyChangeData;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyID;

public class OntologyChangeDataList
implements TimeStampedMetadataChunk,
Iterable<OWLOntologyChangeData> {
    public static final int CHUNK_TYPE = ChunkUtil.toInt("ochi");
    private long timestamp;
    private List<OWLOntologyChangeData> list;
    private BinaryOWLMetadata metadata;

    public OntologyChangeDataList(List<OWLOntologyChange> ontologyChanges, OWLOntologyID targetOntology, long timeStamp, BinaryOWLMetadata metadata) {
        ArrayList<OWLOntologyChangeData> infoList = new ArrayList<OWLOntologyChangeData>();
        for (OWLOntologyChange change : ontologyChanges) {
            if (!change.getOntology().getOntologyID().equals((Object)targetOntology)) continue;
            infoList.add(change.getChangeData());
        }
        this.timestamp = timeStamp;
        this.metadata = metadata;
        this.list = Collections.unmodifiableList(infoList);
    }

    public OntologyChangeDataList(List<OWLOntologyChangeData> list, long timestamp, BinaryOWLMetadata metadata) {
        this.timestamp = timestamp;
        this.list = Collections.unmodifiableList(new ArrayList<OWLOntologyChangeData>(list));
        this.metadata = metadata;
    }

    public OntologyChangeDataList(List<OWLOntologyChangeData> list, long timestamp) {
        this(list, timestamp, BinaryOWLMetadata.emptyMetadata());
    }

    public OntologyChangeDataList(BinaryOWLInputStream inputStream) throws IOException, BinaryOWLParseException {
        this.read(inputStream);
    }

    @Override
    public long getTimestamp() {
        return this.timestamp;
    }

    @Override
    public BinaryOWLMetadata getMetadata() {
        return this.metadata;
    }

    @Override
    public int getChunkType() {
        return CHUNK_TYPE;
    }

    public int size() {
        return this.list.size();
    }

    @Override
    public Iterator<OWLOntologyChangeData> iterator() {
        return this.list.iterator();
    }

    public List<OWLOntologyChange> getOntologyChanges(OWLOntology ontology) {
        ArrayList<OWLOntologyChange> result = new ArrayList<OWLOntologyChange>();
        for (OWLOntologyChangeData info : this.list) {
            OWLOntologyChange change = info.createOntologyChange(ontology);
            result.add(change);
        }
        return result;
    }

    public void write(BinaryOWLOutputStream dos) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        BinaryOWLOutputStream buffer = new BinaryOWLOutputStream(bos, dos.getVersion());
        buffer.writeLong(this.timestamp);
        this.writeMetadata(buffer);
        this.writeChangeRecordData(buffer);
        dos.writeInt(bos.size());
        dos.writeInt(CHUNK_TYPE);
        bos.writeTo(dos);
    }

    private void read(BinaryOWLInputStream inputStream) throws IOException, BinaryOWLParseException {
        int dataSize = inputStream.readInt();
        int chunkType = inputStream.readInt();
        if (chunkType != CHUNK_TYPE) {
            throw new BinaryOWLParseException("Expected change record chunk marker (0x" + Integer.toHexString(CHUNK_TYPE) + ") but found 0x" + Integer.toHexString(chunkType));
        }
        this.timestamp = inputStream.readLong();
        this.metadata = this.readMetadata(inputStream);
        this.list = Collections.unmodifiableList(this.readChangeRecordData(inputStream));
    }

    private List<OWLOntologyChangeData> readChangeRecordData(BinaryOWLInputStream inputStream) throws IOException, BinaryOWLParseException {
        int recordSizeInBytes = inputStream.readInt();
        int listSize = inputStream.readInt();
        ArrayList<OWLOntologyChangeData> list = new ArrayList<OWLOntologyChangeData>(listSize + 2);
        for (int i = 0; i < listSize; ++i) {
            OWLOntologyChangeData representative = OntologyChangeDataType.read(inputStream);
            list.add(representative);
        }
        return list;
    }

    private BinaryOWLMetadata readMetadata(BinaryOWLInputStream inputStream) throws IOException, BinaryOWLParseException {
        int recordSize = inputStream.readInt();
        return new BinaryOWLMetadata(inputStream);
    }

    private void writeMetadata(BinaryOWLOutputStream mainOutputStream) throws IOException {
        ByteArrayOutputStream metadataByteOutputStream = new ByteArrayOutputStream();
        DataOutputStream metaDataOutputStream = new DataOutputStream(metadataByteOutputStream);
        BinaryOWLOutputStream metadataOWLOutputStream = new BinaryOWLOutputStream(metaDataOutputStream, mainOutputStream.getVersion());
        this.metadata.write(metadataOWLOutputStream);
        int recordSize = metaDataOutputStream.size();
        mainOutputStream.writeInt(recordSize);
        metadataByteOutputStream.writeTo(mainOutputStream);
    }

    private void writeChangeRecordData(BinaryOWLOutputStream mainOutputStream) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream changeRecordDataOutputStream = new DataOutputStream(byteArrayOutputStream);
        BinaryOWLOutputStream dataOWLOutputStream = new BinaryOWLOutputStream(changeRecordDataOutputStream, mainOutputStream.getVersion());
        changeRecordDataOutputStream.writeInt(this.list.size());
        for (OWLOntologyChangeData Data : this.list) {
            OntologyChangeDataType.write(Data, dataOWLOutputStream);
        }
        int size = changeRecordDataOutputStream.size();
        mainOutputStream.writeInt(size);
        byteArrayOutputStream.writeTo(mainOutputStream);
    }
}

