/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.binaryowl;

public final class BinaryOWLVersion {
    private final int version;
    private static BinaryOWLVersion VERSION_1 = new BinaryOWLVersion(1);
    private static BinaryOWLVersion VERSION_2 = new BinaryOWLVersion(2);

    private BinaryOWLVersion(int version) {
        this.version = version;
    }

    public static BinaryOWLVersion getVersion(int version) {
        if (version == 1) {
            return VERSION_1;
        }
        if (version == 2) {
            return VERSION_2;
        }
        return new BinaryOWLVersion(version);
    }

    public int getVersion() {
        return this.version;
    }

    public int hashCode() {
        return "BinaryOWLVersion".hashCode() + this.version;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof BinaryOWLVersion)) {
            return false;
        }
        BinaryOWLVersion other = (BinaryOWLVersion)obj;
        return this.version == other.version;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("BinaryOWLVersion");
        sb.append("(");
        sb.append(this.version);
        sb.append(")");
        return sb.toString();
    }

    public String toHexString() {
        return Integer.toHexString(this.version);
    }
}

