/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.binaryowl;

import com.google.common.base.Preconditions;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.semanticweb.binaryowl.BinaryOWLMetadata;
import org.semanticweb.binaryowl.BinaryOWLOntologyDocumentHandler;
import org.semanticweb.binaryowl.BinaryOWLOntologyDocumentPreamble;
import org.semanticweb.binaryowl.BinaryOWLParseException;
import org.semanticweb.binaryowl.BinaryOWLVersion;
import org.semanticweb.binaryowl.change.OntologyChangeDataList;
import org.semanticweb.binaryowl.doc.OWLOntologyDocument;
import org.semanticweb.binaryowl.owlobject.serializer.SerializerBase;
import org.semanticweb.binaryowl.serializer.BinaryOWLDocumentBodySerializer;
import org.semanticweb.binaryowl.serializer.BinaryOWLDocumentBodySerializerSelector;
import org.semanticweb.binaryowl.stream.BinaryOWLOutputStream;
import org.semanticweb.binaryowl.stream.BinaryOWLStreamUtil;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.UnloadableImportException;

public class BinaryOWLOntologyDocumentSerializer
extends SerializerBase {
    public static final byte CHUNK_FOLLOWS_MARKER = 33;

    public <E extends Throwable> void read(InputStream inputStream, BinaryOWLOntologyDocumentHandler<E> handler, OWLDataFactory df) throws IOException, BinaryOWLParseException, UnloadableImportException, E {
        Preconditions.checkNotNull((Object)inputStream);
        Preconditions.checkNotNull(handler);
        Preconditions.checkNotNull((Object)df);
        DataInputStream dis = BinaryOWLStreamUtil.getDataInputStream(inputStream);
        BinaryOWLOntologyDocumentPreamble preamble = new BinaryOWLOntologyDocumentPreamble(dis);
        BinaryOWLVersion fileFormatVersion = preamble.getFileFormatVersion();
        handler.handleBeginDocument();
        handler.handlePreamble(preamble);
        BinaryOWLDocumentBodySerializerSelector selector = new BinaryOWLDocumentBodySerializerSelector();
        BinaryOWLDocumentBodySerializer serializer = selector.getSerializerForVersion(fileFormatVersion);
        serializer.read(dis, handler, df);
    }

    public void write(OWLOntologyDocument document, OutputStream dos) throws IOException {
        this.write(document, dos, new BinaryOWLMetadata());
    }

    public void write(OWLOntologyDocument document, OutputStream os, BinaryOWLMetadata documentMetadata) throws IOException {
        Preconditions.checkNotNull((Object)document);
        Preconditions.checkNotNull((Object)os);
        Preconditions.checkNotNull((Object)documentMetadata);
        DataOutputStream dos = new DataOutputStream(os);
        BinaryOWLOntologyDocumentPreamble preamble = new BinaryOWLOntologyDocumentPreamble();
        preamble.write(dos);
        BinaryOWLDocumentBodySerializerSelector selector = new BinaryOWLDocumentBodySerializerSelector();
        BinaryOWLVersion fileFormatVersion = preamble.getFileFormatVersion();
        BinaryOWLDocumentBodySerializer serializer = selector.getSerializerForVersion(fileFormatVersion);
        serializer.write(document, dos, documentMetadata);
    }

    public void appendOntologyChanges(BinaryOWLOutputStream dos, OntologyChangeDataList changeRecords) throws IOException {
        dos.writeByte(33);
        changeRecords.write(dos);
    }

    public void appendOntologyChanges(File file, OntologyChangeDataList changeRecords) throws IOException {
        FileOutputStream fos = new FileOutputStream(file, true);
        this.appendOntologyChanges(new BinaryOWLOutputStream(fos, BinaryOWLVersion.getVersion(1)), changeRecords);
        fos.close();
    }
}

