/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.binaryowl;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.semanticweb.binaryowl.BinaryOWLParseException;
import org.semanticweb.binaryowl.stream.BinaryOWLInputStream;
import org.semanticweb.binaryowl.stream.BinaryOWLOutputStream;
import org.semanticweb.owlapi.model.OWLObject;

public class BinaryOWLMetadata {
    private StringMap stringAttributes = new StringMap();
    private IntegerMap intAttributes = new IntegerMap();
    private LongMap longAttributes = new LongMap();
    private BooleanMap booleanAttributes = new BooleanMap();
    private DoubleMap doubleAttributes = new DoubleMap();
    private ByteArrayMap byteArrayAttributes = new ByteArrayMap();
    private OWLObjectListMap owlObjectAttributes = new OWLObjectListMap();
    private EnumMap<TypeMarker, AttributeMap<?>> attributeMaps = new EnumMap(TypeMarker.class);
    private static BinaryOWLMetadata EMPTY_METADATA = new BinaryOWLMetadata(){

        @Override
        public void setStringAttribute(String name, String value) {
            this.throwUnmodifiableException();
        }

        @Override
        public void setIntAttribute(String name, int value) {
            this.throwUnmodifiableException();
        }

        @Override
        public void setLongAttribute(String name, long value) {
            this.throwUnmodifiableException();
        }

        @Override
        public void setBooleanAttribute(String name, boolean value) {
            this.throwUnmodifiableException();
        }

        @Override
        public void setDoubleAttribute(String name, double value) {
            this.throwUnmodifiableException();
        }

        @Override
        public void setOWLObjectListAttribute(String name, List<OWLObject> value) {
            this.throwUnmodifiableException();
        }

        private void throwUnmodifiableException() {
            throw new RuntimeException("Immutable metadata");
        }
    };

    public BinaryOWLMetadata() {
        this.attributeMaps.put(TypeMarker.STRING, this.stringAttributes);
        this.attributeMaps.put(TypeMarker.INTEGER, this.intAttributes);
        this.attributeMaps.put(TypeMarker.LONG, this.longAttributes);
        this.attributeMaps.put(TypeMarker.BOOLEAN, this.booleanAttributes);
        this.attributeMaps.put(TypeMarker.DOUBLE, this.doubleAttributes);
        this.attributeMaps.put(TypeMarker.BYTE_ARRAY, this.byteArrayAttributes);
        this.attributeMaps.put(TypeMarker.OWL_OBJECT_LIST, this.owlObjectAttributes);
    }

    public BinaryOWLMetadata(BinaryOWLInputStream inputStream) throws IOException, BinaryOWLParseException {
        this();
        this.read(inputStream);
    }

    public boolean isEmpty() {
        for (AttributeMap<?> attributeValueMap : this.attributeMaps.values()) {
            if (attributeValueMap.isEmpty()) continue;
            return false;
        }
        return true;
    }

    private <O> void setValue(Map<String, O> nameValueMap, String name, O value) {
        this.checkForNull(name, value);
        nameValueMap.put(name, value);
    }

    private void checkForNull(String name, Object value) {
        if (name == null) {
            throw new NullPointerException("name must not be null");
        }
        if (value == null) {
            throw new NullPointerException("value must not be null");
        }
    }

    private <O> O getValue(Map<String, O> nameValueMap, String attributeName, O defaultValue) {
        if (attributeName == null) {
            throw new NullPointerException("name must not be null");
        }
        if (nameValueMap == null) {
            return defaultValue;
        }
        O value = nameValueMap.get(attributeName);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    private <O> void clearAttribute(Map<String, O> attributeValueMap, String attributeName) {
        attributeValueMap.remove(attributeName);
    }

    public BinaryOWLMetadata createCopy() {
        BinaryOWLMetadata copy = new BinaryOWLMetadata();
        copy.stringAttributes.putAll(this.stringAttributes);
        copy.intAttributes.putAll(this.intAttributes);
        copy.longAttributes.putAll(this.longAttributes);
        copy.doubleAttributes.putAll(this.doubleAttributes);
        copy.booleanAttributes.putAll(this.booleanAttributes);
        copy.byteArrayAttributes.putAll(this.byteArrayAttributes);
        for (String key : this.owlObjectAttributes.keySet()) {
            ArrayList objectList = new ArrayList((Collection)this.owlObjectAttributes.get(key));
            copy.owlObjectAttributes.put(key, objectList);
        }
        return copy;
    }

    public void removeAll() {
        for (Map map : this.attributeMaps.values()) {
            map.clear();
        }
    }

    public void removeAttribute(String name) {
        for (Map map : this.attributeMaps.values()) {
            this.clearAttribute(map, name);
        }
    }

    public String getStringAttribute(String name, String defaultValue) {
        return this.getValue(this.stringAttributes, name, defaultValue);
    }

    public void setStringAttribute(String name, String value) {
        this.setValue(this.stringAttributes, name, value);
    }

    public void removeStringAttribute(String name) {
        this.clearAttribute(this.stringAttributes, name);
    }

    public void setIntAttribute(String name, int value) {
        this.setValue(this.intAttributes, name, value);
    }

    public Integer getIntAttribute(String name, Integer defaultValue) {
        return this.getValue(this.intAttributes, name, defaultValue);
    }

    public void removeIntAttribute(String name) {
        this.clearAttribute(this.intAttributes, name);
    }

    public void setLongAttribute(String name, long value) {
        this.setValue(this.longAttributes, name, value);
    }

    public Long getLongAttribute(String name, Long defaultValue) {
        return this.getValue(this.longAttributes, name, defaultValue);
    }

    public void removeLongAttribute(String name) {
        this.clearAttribute(this.longAttributes, name);
    }

    public void setBooleanAttribute(String name, boolean value) {
        this.setValue(this.booleanAttributes, name, value);
    }

    public Boolean getBooleanAttribute(String name, Boolean defaultValue) {
        return this.getValue(this.booleanAttributes, name, defaultValue);
    }

    public void removeBooleanAttribute(String name) {
        this.clearAttribute(this.booleanAttributes, name);
    }

    public void setDoubleAttribute(String name, double value) {
        this.setValue(this.doubleAttributes, name, value);
    }

    public Double getDoubleAttribute(String name, Double defaultValue) {
        return this.getValue(this.doubleAttributes, name, defaultValue);
    }

    public void removeDoubleAttribute(String name) {
        this.clearAttribute(this.doubleAttributes, name);
    }

    public void setByteArrayAttribute(String name, byte[] value) {
        byte[] copy = new byte[value.length];
        System.arraycopy(value, 0, copy, 0, value.length);
        this.setValue(this.byteArrayAttributes, name, ByteBuffer.wrap(copy));
    }

    public byte[] getByteArrayAttribute(String name, byte[] defaultValue) {
        ByteBuffer buffer = this.getValue(this.byteArrayAttributes, name, null);
        if (buffer != null) {
            byte[] result = new byte[buffer.capacity()];
            System.arraycopy(buffer.array(), 0, result, 0, buffer.capacity());
            return result;
        }
        return defaultValue;
    }

    public void removeByteArrayAttribute(String name) {
        this.clearAttribute(this.byteArrayAttributes, name);
    }

    public List<OWLObject> getOWLObjectListAttribute(String name, List<OWLObject> defaultValue) {
        List<OWLObject> result = this.getValue(this.owlObjectAttributes, name, defaultValue);
        return new ArrayList<OWLObject>(result);
    }

    public void setOWLObjectListAttribute(String name, List<OWLObject> value) {
        if (value == null) {
            throw new NullPointerException("value must not be null");
        }
        ArrayList<OWLObject> valueCopy = new ArrayList<OWLObject>(value);
        this.setValue(this.owlObjectAttributes, name, valueCopy);
    }

    public void removeOWLObjectListAttribute(String name) {
        this.clearAttribute(this.owlObjectAttributes, name);
    }

    public void write(BinaryOWLOutputStream outputStream) throws IOException {
        int mapCount = 0;
        for (AttributeMap<?> map : this.attributeMaps.values()) {
            if (map.isEmpty()) continue;
            mapCount = (byte)(mapCount + 1);
        }
        outputStream.writeByte(mapCount);
        if (mapCount == 0) {
            return;
        }
        for (AttributeMap<?> map : this.attributeMaps.values()) {
            if (map.isEmpty()) continue;
            outputStream.writeByte(map.getTypeMarker().getMarker());
            map.write(outputStream);
        }
    }

    private void read(BinaryOWLInputStream inputStream) throws IOException, BinaryOWLParseException {
        int mapCount = inputStream.readByte();
        if (mapCount == 0) {
            return;
        }
        for (int i = 0; i < mapCount; ++i) {
            byte typeMarker = inputStream.readByte();
            AttributeMap<?> map = this.getMap(typeMarker);
            map.read(inputStream);
        }
    }

    private AttributeMap<?> getMap(byte typeMarker) {
        TypeMarker marker = TypeMarker.getTypeMarker(typeMarker);
        return this.attributeMaps.get((Object)marker);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Metadata(");
        for (AttributeMap<?> map : this.attributeMaps.values()) {
            for (String attributeName : map.keySet()) {
                sb.append(" Entry(");
                sb.append("Property(");
                sb.append(attributeName);
                sb.append(") Value(");
                sb.append(map.get(attributeName));
                sb.append("))");
            }
        }
        sb.append(")");
        return sb.toString();
    }

    public static BinaryOWLMetadata emptyMetadata() {
        return EMPTY_METADATA;
    }

    private class ByteArrayMap
    extends AttributeMap<ByteBuffer> {
        private ByteArrayMap() {
        }

        @Override
        public TypeMarker getTypeMarker() {
            return TypeMarker.BYTE_ARRAY;
        }

        @Override
        protected ByteBuffer readValue(BinaryOWLInputStream inputStream) throws IOException {
            int length = inputStream.readInt();
            ByteBuffer buffer = ByteBuffer.allocate(length);
            inputStream.readFully(buffer.array());
            return buffer;
        }

        @Override
        protected void writeValue(ByteBuffer value, BinaryOWLOutputStream outputStream) throws IOException {
            int length = value.capacity();
            outputStream.writeInt(length);
            outputStream.write(value.array());
        }
    }

    private class OWLObjectListMap
    extends AttributeMap<List<OWLObject>> {
        private OWLObjectListMap() {
        }

        @Override
        public TypeMarker getTypeMarker() {
            return TypeMarker.OWL_OBJECT_LIST;
        }

        @Override
        public List<OWLObject> readValue(BinaryOWLInputStream inputStream) throws IOException, BinaryOWLParseException {
            return new ArrayList<OWLObject>(inputStream.readOWLObjects());
        }

        @Override
        public void writeValue(List<OWLObject> value, BinaryOWLOutputStream outputStream) throws IOException {
            outputStream.writeOWLObjects(new HashSet<OWLObject>(value));
        }
    }

    private class DoubleMap
    extends AttributeMap<Double> {
        private DoubleMap() {
        }

        @Override
        public TypeMarker getTypeMarker() {
            return TypeMarker.DOUBLE;
        }

        @Override
        public Double readValue(BinaryOWLInputStream inputStream) throws IOException {
            return inputStream.readDouble();
        }

        @Override
        public void writeValue(Double value, BinaryOWLOutputStream outputStream) throws IOException {
            outputStream.writeDouble(value);
        }
    }

    private class BooleanMap
    extends AttributeMap<Boolean> {
        private BooleanMap() {
        }

        @Override
        public TypeMarker getTypeMarker() {
            return TypeMarker.BOOLEAN;
        }

        @Override
        public Boolean readValue(BinaryOWLInputStream inputStream) throws IOException {
            return inputStream.readBoolean();
        }

        @Override
        public void writeValue(Boolean value, BinaryOWLOutputStream outputStream) throws IOException {
            outputStream.writeBoolean(value);
        }
    }

    private class LongMap
    extends AttributeMap<Long> {
        private LongMap() {
        }

        @Override
        public TypeMarker getTypeMarker() {
            return TypeMarker.LONG;
        }

        @Override
        public Long readValue(BinaryOWLInputStream inputStream) throws IOException {
            return inputStream.readLong();
        }

        @Override
        public void writeValue(Long value, BinaryOWLOutputStream outputStream) throws IOException {
            outputStream.writeLong(value);
        }
    }

    private class IntegerMap
    extends AttributeMap<Integer> {
        private IntegerMap() {
        }

        @Override
        public TypeMarker getTypeMarker() {
            return TypeMarker.INTEGER;
        }

        @Override
        protected Integer readValue(BinaryOWLInputStream inputStream) throws IOException {
            return inputStream.readInt();
        }

        @Override
        public void writeValue(Integer value, BinaryOWLOutputStream outputStream) throws IOException {
            outputStream.writeInt(value);
        }
    }

    private class StringMap
    extends AttributeMap<String> {
        private StringMap() {
        }

        @Override
        public TypeMarker getTypeMarker() {
            return TypeMarker.STRING;
        }

        @Override
        protected String readValue(BinaryOWLInputStream inputStream) throws IOException {
            return inputStream.readUTF();
        }

        @Override
        protected void writeValue(String value, BinaryOWLOutputStream outputStream) throws IOException {
            outputStream.writeUTF(value);
        }
    }

    private abstract class AttributeMap<O>
    implements Map<String, O> {
        public static final int DEFAULT_INITIAL_SIZE = 2;
        private Map<String, O> delegate = null;

        protected AttributeMap() {
        }

        public abstract TypeMarker getTypeMarker();

        public void read(BinaryOWLInputStream inputStream) throws IOException, BinaryOWLParseException {
            int length = inputStream.readShort();
            for (int i = 0; i < length; ++i) {
                String name = inputStream.readUTF();
                O value = this.readValue(inputStream);
                this.put(name, value);
            }
        }

        public void write(BinaryOWLOutputStream outputStream) throws IOException {
            outputStream.writeShort(this.size());
            for (String attributeName : this.keySet()) {
                outputStream.writeUTF(attributeName);
                O value = this.get(attributeName);
                this.writeValue(value, outputStream);
            }
        }

        protected abstract O readValue(BinaryOWLInputStream var1) throws IOException, BinaryOWLParseException;

        protected abstract void writeValue(O var1, BinaryOWLOutputStream var2) throws IOException;

        @Override
        public int size() {
            return this.delegate == null ? 0 : this.delegate.size();
        }

        @Override
        public boolean isEmpty() {
            return this.delegate == null ? true : this.delegate.isEmpty();
        }

        @Override
        public boolean containsKey(Object key) {
            return this.delegate == null ? false : this.delegate.containsKey(key);
        }

        @Override
        public boolean containsValue(Object value) {
            return this.delegate == null ? false : this.delegate.containsValue(value);
        }

        @Override
        public O get(Object key) {
            return this.delegate == null ? null : (O)this.delegate.get(key);
        }

        @Override
        public O put(String key, O value) {
            this.getDelegate();
            return this.delegate.put(key, value);
        }

        private Map<String, O> getDelegate() {
            if (this.delegate == null) {
                this.delegate = this.createDelegate();
            }
            return this.delegate;
        }

        private LinkedHashMap<String, O> createDelegate() {
            return new LinkedHashMap();
        }

        @Override
        public O remove(Object key) {
            if (this.delegate == null) {
                return null;
            }
            return this.delegate.remove(key);
        }

        @Override
        public void putAll(Map<? extends String, ? extends O> m) {
            this.getDelegate().putAll(m);
        }

        @Override
        public void clear() {
            if (this.delegate != null) {
                this.delegate.clear();
            }
        }

        @Override
        public Set<String> keySet() {
            return this.delegate == null ? Collections.emptySet() : this.delegate.keySet();
        }

        @Override
        public Collection<O> values() {
            return this.delegate == null ? Collections.emptySet() : this.delegate.values();
        }

        @Override
        public Set<Map.Entry<String, O>> entrySet() {
            return this.delegate == null ? Collections.emptySet() : this.delegate.entrySet();
        }
    }

    private static enum TypeMarker {
        STRING(1),
        INTEGER(2),
        LONG(3),
        BOOLEAN(4),
        DOUBLE(5),
        BYTE_ARRAY(6),
        OWL_OBJECT_LIST(7);

        private byte marker;
        private static TypeMarker[] values;

        private TypeMarker(int marker) {
            this.marker = (byte)marker;
        }

        public byte getMarker() {
            return this.marker;
        }

        public static TypeMarker getTypeMarker(byte marker) {
            return values[marker - 1];
        }

        static {
            values = TypeMarker.values();
        }
    }
}

