/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.utility;

import java.io.IOException;

public abstract class Tokenizer {
    public static final int TT_EOL = 10;
    public static final int TT_EOF = -1;
    public static final int TT_WORD = -3;
    private char m_quote = (char)34;
    private char m_delimiter = (char)44;
    private int m_next;
    private int m_type;
    private StringBuffer m_buffer = new StringBuffer();

    protected abstract int read() throws IOException;

    public int nextToken() throws IOException {
        int nextc = -1;
        boolean quoted = false;
        int result = this.m_next;
        if (this.m_next != 0) {
            this.m_next = 0;
        }
        this.m_buffer.setLength(0);
        block4: while (result == 0) {
            int c;
            if (nextc != -1) {
                c = nextc;
                nextc = -1;
            } else {
                c = this.read();
            }
            switch (c) {
                case -1: {
                    if (this.m_buffer.length() != 0) {
                        result = -3;
                        this.m_next = -1;
                        continue block4;
                    }
                    result = -1;
                    continue block4;
                }
                case 10: {
                    int length = this.m_buffer.length();
                    if (length != 0 && this.m_buffer.charAt(length - 1) == '\r') {
                        this.m_buffer.setLength(--length);
                    }
                    if (length == 0) {
                        result = 10;
                        continue block4;
                    }
                    result = -3;
                    this.m_next = 10;
                    continue block4;
                }
            }
            if (c == this.m_quote) {
                if (!quoted && this.m_buffer.length() == 0) {
                    quoted = true;
                    continue;
                }
                if (!quoted) {
                    this.m_buffer.append((char)c);
                    continue;
                }
                nextc = this.read();
                if (nextc == this.m_quote) {
                    this.m_buffer.append((char)c);
                    nextc = -1;
                    continue;
                }
                quoted = false;
                continue;
            }
            if (c == this.m_delimiter && !quoted) {
                result = -3;
                continue;
            }
            this.m_buffer.append((char)c);
        }
        this.m_type = result;
        return result;
    }

    public String getToken() {
        return this.m_buffer.toString();
    }

    public int getType() {
        return this.m_type;
    }

    public void setDelimiter(char delimiter) {
        this.m_delimiter = delimiter;
    }
}

