/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.utility;

import net.sf.mpxj.AssignmentField;
import net.sf.mpxj.FieldType;
import net.sf.mpxj.MPPAssignmentField;
import net.sf.mpxj.MPPAssignmentField14;
import net.sf.mpxj.MPPResourceField;
import net.sf.mpxj.MPPResourceField14;
import net.sf.mpxj.MPPTaskField;
import net.sf.mpxj.MPPTaskField14;
import net.sf.mpxj.ResourceField;
import net.sf.mpxj.TaskField;

public final class FieldTypeUtility {
    public static final FieldType getInstanceUnmapped(int fieldID) {
        Enum result;
        int prefix = fieldID & 0xFFFF0000;
        int index = fieldID & 0xFFFF;
        switch (prefix) {
            case 0xB400000: {
                result = MPPTaskField.getInstance(index);
                break;
            }
            case 0xC400000: {
                result = MPPResourceField.getInstance(index);
                break;
            }
            case 0xF400000: {
                result = MPPAssignmentField.getInstance(index);
                break;
            }
            default: {
                result = null;
            }
        }
        return result;
    }

    public static final FieldType getInstance(int fieldID) {
        Enum result;
        int prefix = fieldID & 0xFFFF0000;
        int index = fieldID & 0xFFFF;
        switch (prefix) {
            case 0xB400000: {
                result = MPPTaskField.getInstance(index);
                if (result != null) break;
                result = TaskField.UNAVAILABLE;
                break;
            }
            case 0xC400000: {
                result = MPPResourceField.getInstance(index);
                if (result != null) break;
                result = ResourceField.UNAVAILABLE;
                break;
            }
            case 0xF400000: {
                result = MPPAssignmentField.getInstance(index);
                if (result != null) break;
                result = AssignmentField.UNAVAILABLE;
                break;
            }
            default: {
                result = null;
            }
        }
        return result;
    }

    public static final FieldType getInstance14Unmapped(int fieldID) {
        Enum result;
        int prefix = fieldID & 0xFFFF0000;
        int index = fieldID & 0xFFFF;
        switch (prefix) {
            case 0xB400000: {
                result = MPPTaskField14.getInstanceUnmapped(index);
                break;
            }
            case 0xC400000: {
                result = MPPResourceField14.getInstance(index);
                break;
            }
            case 0xF400000: {
                result = MPPAssignmentField14.getInstance(index);
                break;
            }
            default: {
                result = null;
            }
        }
        return result;
    }

    public static final FieldType getInstance14(int fieldID) {
        Enum result;
        int prefix = fieldID & 0xFFFF0000;
        int index = fieldID & 0xFFFF;
        switch (prefix) {
            case 0xB400000: {
                result = MPPTaskField14.getInstance(index);
                if (result != null) break;
                result = TaskField.UNAVAILABLE;
                break;
            }
            case 0xC400000: {
                result = MPPResourceField14.getInstance(index);
                if (result != null) break;
                result = ResourceField.UNAVAILABLE;
                break;
            }
            case 0xF400000: {
                result = MPPAssignmentField14.getInstance(index);
                if (result != null) break;
                result = AssignmentField.UNAVAILABLE;
                break;
            }
            default: {
                result = null;
            }
        }
        return result;
    }
}

