/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.junit;

import java.util.List;
import net.sf.mpxj.Filter;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.Task;
import net.sf.mpxj.junit.MPXJTestCase;
import net.sf.mpxj.mpp.MPPReader;

public class MppFilterLogicTest
extends MPXJTestCase {
    public void testMpp9FilterLogic() throws Exception {
        ProjectFile mpp = new MPPReader().read(this.m_basedir + "/mpp9filterlogic.mpp");
        this.testFilterLogic(mpp);
    }

    public void testMpp9FilterLogicFrom12() throws Exception {
    }

    public void testMpp9FilterLogicFrom14() throws Exception {
    }

    public void testMpp12FilterLogic() throws Exception {
        ProjectFile mpp = new MPPReader().read(this.m_basedir + "/mpp12filterlogic.mpp");
        this.testFilterLogic(mpp);
    }

    public void testMpp12FilterLogicFrom14() throws Exception {
        ProjectFile mpp = new MPPReader().read(this.m_basedir + "/mpp12filterlogic-from14.mpp");
        this.testFilterLogic(mpp);
    }

    public void testMpp14FilterLogic() throws Exception {
        ProjectFile mpp = new MPPReader().read(this.m_basedir + "/mpp14filterlogic.mpp");
        this.testFilterLogic(mpp);
    }

    private void testFilterLogic(ProjectFile mpp) {
        List<Task> listAllTasks = mpp.getAllTasks();
        Task ac1 = listAllTasks.get(1);
        MppFilterLogicTest.assertEquals((String)"ac1", (String)ac1.getName());
        Task ac2 = listAllTasks.get(2);
        MppFilterLogicTest.assertEquals((String)"ac2", (String)ac2.getName());
        Filter inBlockAndFilter = mpp.getFilterByName("InBlockAnd");
        MppFilterLogicTest.assertTrue((boolean)inBlockAndFilter.evaluate(ac1, null));
        MppFilterLogicTest.assertTrue((boolean)inBlockAndFilter.evaluate(ac2, null));
        Filter betweenBlockAndFilter = mpp.getFilterByName("BetweenBlockAnd");
        MppFilterLogicTest.assertTrue((boolean)betweenBlockAndFilter.evaluate(ac1, null));
        MppFilterLogicTest.assertFalse((boolean)betweenBlockAndFilter.evaluate(ac2, null));
    }
}

