/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.htmlunit.xerces.dom;

import net.sourceforge.htmlunit.xerces.dom.ChildNode;
import net.sourceforge.htmlunit.xerces.dom.CoreDocumentImpl;
import net.sourceforge.htmlunit.xerces.dom.EntityImpl;
import net.sourceforge.htmlunit.xerces.dom.ParentNode;
import net.sourceforge.htmlunit.xerces.util.URI;
import org.w3c.dom.DocumentType;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class EntityReferenceImpl
extends ParentNode
implements EntityReference {
    protected final String name;
    protected String baseURI;

    public EntityReferenceImpl(CoreDocumentImpl ownerDoc, String name) {
        super(ownerDoc);
        this.name = name;
        this.isReadOnly(true);
        this.needsSyncChildren(true);
    }

    @Override
    public short getNodeType() {
        return 5;
    }

    @Override
    public String getNodeName() {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        return this.name;
    }

    @Override
    public Node cloneNode(boolean deep) {
        EntityReferenceImpl er = (EntityReferenceImpl)super.cloneNode(deep);
        er.setReadOnly(true, deep);
        return er;
    }

    @Override
    public String getBaseURI() {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        if (this.baseURI == null) {
            EntityImpl entDef;
            NamedNodeMap entities;
            DocumentType doctype = this.getOwnerDocument().getDoctype();
            if (null != doctype && null != (entities = doctype.getEntities()) && (entDef = (EntityImpl)entities.getNamedItem(this.getNodeName())) != null) {
                return entDef.getBaseURI();
            }
        } else if (this.baseURI != null && this.baseURI.length() != 0) {
            try {
                return new URI(this.baseURI).toString();
            }
            catch (URI.MalformedURIException e) {
                return null;
            }
        }
        return this.baseURI;
    }

    public void setBaseURI(String uri) {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        this.baseURI = uri;
    }

    protected String getEntityRefValue() {
        if (this.needsSyncChildren()) {
            this.synchronizeChildren();
        }
        if (this.firstChild != null) {
            String value;
            if (this.firstChild.getNodeType() == 5) {
                value = ((EntityReferenceImpl)this.firstChild).getEntityRefValue();
            } else if (this.firstChild.getNodeType() == 3) {
                value = this.firstChild.getNodeValue();
            } else {
                return null;
            }
            if (this.firstChild.nextSibling == null) {
                return value;
            }
            StringBuilder buff = new StringBuilder(value);
            ChildNode next = this.firstChild.nextSibling;
            while (next != null) {
                if (next.getNodeType() == 5) {
                    value = ((EntityReferenceImpl)next).getEntityRefValue();
                } else if (next.getNodeType() == 3) {
                    value = next.getNodeValue();
                } else {
                    return null;
                }
                buff.append(value);
                next = next.nextSibling;
            }
            return buff.toString();
        }
        return "";
    }

    @Override
    protected void synchronizeChildren() {
        NamedNodeMap entities;
        this.needsSyncChildren(false);
        DocumentType doctype = this.getOwnerDocument().getDoctype();
        if (null != doctype && null != (entities = doctype.getEntities())) {
            EntityImpl entDef = (EntityImpl)entities.getNamedItem(this.getNodeName());
            if (entDef == null) {
                return;
            }
            this.isReadOnly(false);
            for (Node defkid = entDef.getFirstChild(); defkid != null; defkid = defkid.getNextSibling()) {
                Node newkid = defkid.cloneNode(true);
                this.insertBefore(newkid, null);
            }
            this.setReadOnly(true, true);
        }
    }

    @Override
    public void setReadOnly(boolean readOnly, boolean deep) {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        if (deep) {
            if (this.needsSyncChildren()) {
                this.synchronizeChildren();
            }
            ChildNode mykid = this.firstChild;
            while (mykid != null) {
                mykid.setReadOnly(readOnly, true);
                mykid = mykid.nextSibling;
            }
        }
        this.isReadOnly(readOnly);
    }
}

