/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.web.css;

import cz.vutbr.web.css.CSSException;
import cz.vutbr.web.css.NodeData;
import cz.vutbr.web.css.RuleFactory;
import cz.vutbr.web.css.StyleSheet;
import cz.vutbr.web.css.SupportedCSS;
import cz.vutbr.web.css.TermFactory;
import cz.vutbr.web.csskit.antlr.CSSParserFactory;
import cz.vutbr.web.domassign.Analyzer;
import cz.vutbr.web.domassign.DeclarationTransformer;
import cz.vutbr.web.domassign.StyleMap;
import cz.vutbr.web.domassign.Traversal;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import org.fit.net.DataURLHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CSSFactory {
    private static Logger log = LoggerFactory.getLogger(CSSFactory.class);
    private static final String DEFAULT_TERM_FACTORY = "cz.vutbr.web.csskit.TermFactoryImpl";
    private static final String DEFAULT_SUPPORTED_CSS = "cz.vutbr.web.domassign.SupportedCSS3";
    private static final String DEFAULT_RULE_FACTORY = "cz.vutbr.web.csskit.RuleFactoryImpl";
    private static final String DEFAULT_DECLARATION_TRANSFORMER = "cz.vutbr.web.domassign.DeclarationTransformer";
    private static final String DEFAULT_NODE_DATA_IMPL = "cz.vutbr.web.domassign.SingleMapNodeData";
    private static TermFactory tf;
    private static SupportedCSS css;
    private static RuleFactory rf;
    private static DeclarationTransformer dt;
    private static Class<? extends NodeData> ndImpl;
    private static boolean implyPixelLengths;

    public static final void setImplyPixelLength(boolean b) {
        implyPixelLengths = b;
    }

    public static final boolean getImplyPixelLength() {
        return implyPixelLengths;
    }

    public static final void registerTermFactory(TermFactory newFactory) {
        tf = newFactory;
    }

    public static final TermFactory getTermFactory() {
        if (tf == null) {
            try {
                Class<?> clazz = Class.forName(DEFAULT_TERM_FACTORY);
                Method m = clazz.getMethod("getInstance", new Class[0]);
                CSSFactory.registerTermFactory((TermFactory)m.invoke(null, new Object[0]));
                log.debug("Retrived {} as default TermFactory implementation.", (Object)DEFAULT_TERM_FACTORY);
            }
            catch (Exception e) {
                log.error("Unable to get TermFactory from default", (Throwable)e);
                throw new RuntimeException("No TermFactory implementation registered!");
            }
        }
        return tf;
    }

    public static final void registerSupportedCSS(SupportedCSS newCSS) {
        css = newCSS;
    }

    public static final SupportedCSS getSupportedCSS() {
        if (css == null) {
            try {
                Class<?> clazz = Class.forName(DEFAULT_SUPPORTED_CSS);
                Method m = clazz.getMethod("getInstance", new Class[0]);
                CSSFactory.registerSupportedCSS((SupportedCSS)m.invoke(null, new Object[0]));
                log.debug("Retrived {} as default SupportedCSS implementation.", (Object)DEFAULT_SUPPORTED_CSS);
            }
            catch (Exception e) {
                log.error("Unable to get SupportedCSS from default", (Throwable)e);
                throw new RuntimeException("No SupportedCSS implementation registered!");
            }
        }
        return css;
    }

    public static final void registerRuleFactory(RuleFactory newRuleFactory) {
        rf = newRuleFactory;
    }

    public static final RuleFactory getRuleFactory() {
        if (rf == null) {
            try {
                Class<?> clazz = Class.forName(DEFAULT_RULE_FACTORY);
                Method m = clazz.getMethod("getInstance", new Class[0]);
                CSSFactory.registerRuleFactory((RuleFactory)m.invoke(null, new Object[0]));
                log.debug("Retrived {} as default RuleFactory implementation.", (Object)DEFAULT_RULE_FACTORY);
            }
            catch (Exception e) {
                log.error("Unable to get RuleFactory from default", (Throwable)e);
                throw new RuntimeException("No RuleFactory implementation registered!");
            }
        }
        return rf;
    }

    public static final void registerDeclarationTransformer(DeclarationTransformer newDeclarationTransformer) {
        dt = newDeclarationTransformer;
    }

    public static final DeclarationTransformer getDeclarationTransformer() {
        if (dt == null) {
            try {
                Class<?> clazz = Class.forName(DEFAULT_DECLARATION_TRANSFORMER);
                Method m = clazz.getMethod("getInstance", new Class[0]);
                CSSFactory.registerDeclarationTransformer((DeclarationTransformer)m.invoke(null, new Object[0]));
                log.debug("Retrived {} as default DeclarationTransformer implementation.", (Object)DEFAULT_DECLARATION_TRANSFORMER);
            }
            catch (Exception e) {
                log.error("Unable to get DeclarationTransformer from default", (Throwable)e);
                throw new RuntimeException("No DeclarationTransformer implementation registered!");
            }
        }
        return dt;
    }

    public static final void registerNodeDataInstance(Class<? extends NodeData> clazz) {
        try {
            NodeData test = clazz.newInstance();
            ndImpl = clazz;
        }
        catch (InstantiationException e) {
            throw new RuntimeException("NodeData implemenation (" + clazz.getName() + ") doesn't provide sole constructor", e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("NodeData implementation (" + clazz.getName() + ") is not accesible", e);
        }
    }

    public static final NodeData createNodeData() {
        if (ndImpl == null) {
            try {
                Class<?> clazz = Class.forName(DEFAULT_NODE_DATA_IMPL);
                CSSFactory.registerNodeDataInstance(clazz);
                log.debug("Registered {} as default NodeData instance.", (Object)DEFAULT_NODE_DATA_IMPL);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        try {
            return ndImpl.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("No NodeData implementation registered");
        }
    }

    public static final StyleSheet parse(URL url, String encoding) throws CSSException, IOException {
        return CSSParserFactory.parse(url, encoding, CSSParserFactory.SourceType.URL, url);
    }

    public static final StyleSheet parse(String fileName, String encoding) throws CSSException, IOException {
        try {
            File f = new File(fileName);
            URL url = f.toURI().toURL();
            return CSSFactory.parse(url, encoding);
        }
        catch (MalformedURLException e) {
            String message = "Unable to construct URL from fileName: " + fileName;
            log.error(message);
            throw new FileNotFoundException(message);
        }
    }

    public static final StyleSheet parse(String css) throws IOException, CSSException {
        return CSSParserFactory.parse(css, null, CSSParserFactory.SourceType.EMBEDDED, null);
    }

    public static final StyleSheet getUsedStyles(Document doc, URL base, String media) {
        return CSSFactory.getUsedStyles(doc, null, base, media);
    }

    public static final StyleSheet getUsedStyles(Document doc, String encoding, URL base, String media) {
        Pair pair = new Pair(base, media);
        CSSAssignTraversal traversal = new CSSAssignTraversal(doc, encoding, pair, 1);
        StyleSheet style = (StyleSheet)CSSFactory.getRuleFactory().createStyleSheet().unlock();
        traversal.listTraversal(style);
        return style;
    }

    public static final StyleMap assignDOM(Document doc, URL base, String media, boolean useInheritance) {
        return CSSFactory.assignDOM(doc, null, base, media, useInheritance);
    }

    public static final StyleMap assignDOM(Document doc, String encoding, URL base, String media, boolean useInheritance) {
        Pair pair = new Pair(base, media);
        CSSAssignTraversal traversal = new CSSAssignTraversal(doc, encoding, pair, 1);
        StyleSheet style = (StyleSheet)CSSFactory.getRuleFactory().createStyleSheet().unlock();
        traversal.listTraversal(style);
        Analyzer analyzer = new Analyzer(style);
        return analyzer.evaluateDOM(doc, media, useInheritance);
    }

    static {
        implyPixelLengths = false;
    }

    private static final class Pair {
        public URL base;
        public String media;

        public Pair(URL base, String media) {
            this.base = base;
            this.media = media;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class CSSAssignTraversal
    extends Traversal<StyleSheet> {
        private String encoding;

        public CSSAssignTraversal(Document doc, String encoding, Object source, int whatToShow) {
            super(doc, source, whatToShow);
            this.encoding = encoding;
        }

        @Override
        protected void processNode(StyleSheet result, Node current, Object source) {
            URL base = ((Pair)source).base;
            String media = ((Pair)source).media;
            Element elem = (Element)current;
            try {
                if (CSSAssignTraversal.isEmbeddedStyleSheet(elem, media)) {
                    result = CSSParserFactory.append(CSSAssignTraversal.extractElementText(elem), null, CSSParserFactory.SourceType.EMBEDDED, result, base);
                    log.debug("Matched embedded CSS style");
                } else if (CSSAssignTraversal.isLinkedStyleSheet(elem, media)) {
                    URL uri = DataURLHandler.createURL(base, elem.getAttribute("href"));
                    result = CSSParserFactory.append(uri, this.encoding, CSSParserFactory.SourceType.URL, result, uri);
                    log.debug("Matched linked CSS style");
                } else {
                    if (elem.getAttribute("style") != null && elem.getAttribute("style").length() > 0) {
                        result = CSSParserFactory.append(elem.getAttribute("style"), null, CSSParserFactory.SourceType.INLINE, elem, true, result, base);
                        log.debug("Matched inline CSS style");
                    }
                    if (elem.getAttribute("XDefaultStyle") != null && elem.getAttribute("XDefaultStyle").length() > 0) {
                        result = CSSParserFactory.append(elem.getAttribute("XDefaultStyle"), null, CSSParserFactory.SourceType.INLINE, elem, false, result, base);
                        log.debug("Matched default CSS style");
                    }
                }
            }
            catch (CSSException ce) {
                log.error("THROWN:", (Throwable)ce);
            }
            catch (IOException ioe) {
                log.error("THROWN:", (Throwable)ioe);
            }
        }

        private static boolean isEmbeddedStyleSheet(Element e, String media) {
            return "style".equalsIgnoreCase(e.getNodeName()) && CSSAssignTraversal.isAllowedMedia(e, media);
        }

        private static boolean isLinkedStyleSheet(Element e, String media) {
            return e.getNodeName().equals("link") && e.getAttribute("rel").toLowerCase().contains("stylesheet") && (e.getAttribute("type").isEmpty() || "text/css".equalsIgnoreCase(e.getAttribute("type"))) && CSSAssignTraversal.isAllowedMedia(e, media);
        }

        private static String extractElementText(Element e) {
            Node text = e.getFirstChild();
            if (text != null && text.getNodeType() == 3) {
                return ((Text)text).getData();
            }
            return "";
        }

        private static boolean isAllowedMedia(Element e, String media) {
            String mediaList = e.getAttribute("media");
            return mediaList == null || mediaList.length() == 0 || mediaList.contains(media) || mediaList.contains("all");
        }
    }
}

