/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.spark.snowflake.io;

import java.io.InputStream;
import java.io.Serializable;
import java.net.URI;
import java.security.Key;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import net.snowflake.client.jdbc.ErrorCode;
import net.snowflake.client.jdbc.MatDesc;
import net.snowflake.client.jdbc.SnowflakeSQLException;
import net.snowflake.client.jdbc.cloud.storage.StageInfo;
import net.snowflake.client.jdbc.internal.amazonaws.ClientConfiguration;
import net.snowflake.client.jdbc.internal.amazonaws.auth.AWSCredentials;
import net.snowflake.client.jdbc.internal.amazonaws.auth.AWSCredentialsProvider;
import net.snowflake.client.jdbc.internal.amazonaws.auth.AWSStaticCredentialsProvider;
import net.snowflake.client.jdbc.internal.amazonaws.auth.BasicAWSCredentials;
import net.snowflake.client.jdbc.internal.amazonaws.auth.BasicSessionCredentials;
import net.snowflake.client.jdbc.internal.amazonaws.client.builder.AwsClientBuilder;
import net.snowflake.client.jdbc.internal.amazonaws.retry.PredefinedRetryPolicies;
import net.snowflake.client.jdbc.internal.amazonaws.retry.RetryPolicy;
import net.snowflake.client.jdbc.internal.amazonaws.services.s3.AmazonS3;
import net.snowflake.client.jdbc.internal.amazonaws.services.s3.AmazonS3Client;
import net.snowflake.client.jdbc.internal.amazonaws.services.s3.AmazonS3ClientBuilder;
import net.snowflake.client.jdbc.internal.amazonaws.services.s3.model.ObjectMetadata;
import net.snowflake.client.jdbc.internal.amazonaws.util.Base64;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.JsonNode;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.ObjectMapper;
import net.snowflake.client.jdbc.internal.microsoft.azure.storage.StorageCredentials;
import net.snowflake.client.jdbc.internal.microsoft.azure.storage.StorageCredentialsAnonymous;
import net.snowflake.client.jdbc.internal.microsoft.azure.storage.StorageCredentialsSharedAccessSignature;
import net.snowflake.client.jdbc.internal.microsoft.azure.storage.blob.CloudBlobClient;
import net.snowflake.spark.snowflake.DefaultJDBCWrapper;
import net.snowflake.spark.snowflake.DefaultJDBCWrapper$;
import net.snowflake.spark.snowflake.Parameters;
import net.snowflake.spark.snowflake.ProxyInfo;
import net.snowflake.spark.snowflake.ServerConnection;
import net.snowflake.spark.snowflake.SnowflakeConnectorFeatureNotSupportException;
import net.snowflake.spark.snowflake.io.CloudStorage;
import net.snowflake.spark.snowflake.io.ExternalAzureStorage;
import net.snowflake.spark.snowflake.io.ExternalS3Storage;
import net.snowflake.spark.snowflake.io.ExternalS3Storage$;
import net.snowflake.spark.snowflake.io.InternalAzureStorage;
import net.snowflake.spark.snowflake.io.InternalGcsStorage;
import net.snowflake.spark.snowflake.io.InternalS3Storage;
import net.snowflake.spark.snowflake.io.InternalS3Storage$;
import net.snowflake.spark.snowflake.io.SFInternalStage;
import net.snowflake.spark.snowflake.io.SFInternalStage$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.LinearSeqOptimized;
import scala.collection.immutable.List;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxedUnit;
import scala.util.Random$;
import scala.util.matching.Regex;

public final class CloudStorageOperations$ {
    public static CloudStorageOperations$ MODULE$;
    private final int DEFAULT_PARALLELISM;
    private final int S3_MAX_RETRIES;
    private final int S3_MAX_TIMEOUT_MS;
    private final String AES;
    private final String AMZ_KEY;
    private final String AMZ_IV;
    private final String DATA_CIPHER;
    private final String KEY_CIPHER;
    private final String AMZ_MATDESC;
    private final String AZ_ENCRYPTIONDATA;
    private final String AZ_IV;
    private final String AZ_KEY_WRAP;
    private final String AZ_KEY;
    private final String AZ_MATDESC;
    private final Logger log;

    static {
        new CloudStorageOperations$();
    }

    public int DEFAULT_PARALLELISM() {
        return this.DEFAULT_PARALLELISM;
    }

    public int S3_MAX_RETRIES() {
        return this.S3_MAX_RETRIES;
    }

    public int S3_MAX_TIMEOUT_MS() {
        return this.S3_MAX_TIMEOUT_MS;
    }

    public String AES() {
        return this.AES;
    }

    public String AMZ_KEY() {
        return this.AMZ_KEY;
    }

    public String AMZ_IV() {
        return this.AMZ_IV;
    }

    public String DATA_CIPHER() {
        return this.DATA_CIPHER;
    }

    public String KEY_CIPHER() {
        return this.KEY_CIPHER;
    }

    public String AMZ_MATDESC() {
        return this.AMZ_MATDESC;
    }

    public String AZ_ENCRYPTIONDATA() {
        return this.AZ_ENCRYPTIONDATA;
    }

    public String AZ_IV() {
        return this.AZ_IV;
    }

    public String AZ_KEY_WRAP() {
        return this.AZ_KEY_WRAP;
    }

    public String AZ_KEY() {
        return this.AZ_KEY;
    }

    public String AZ_MATDESC() {
        return this.AZ_MATDESC;
    }

    public Logger log() {
        return this.log;
    }

    public final InputStream getDecryptedStream(InputStream stream, String masterKey, Map<String, String> metaData, StageInfo.StageType stageType) {
        Tuple2<String, String> tuple2;
        byte[] decodedKey = Base64.decode((String)masterKey);
        StageInfo.StageType stageType2 = stageType;
        if (StageInfo.StageType.S3.equals(stageType2)) {
            tuple2 = new Tuple2<String, String>((Object)metaData.get(this.AMZ_KEY()), (Object)metaData.get(this.AMZ_IV()));
        } else if (StageInfo.StageType.AZURE.equals(stageType2)) {
            tuple2 = this.parseEncryptionData(metaData.get(this.AZ_ENCRYPTIONDATA()));
        } else {
            throw new UnsupportedOperationException(new StringBuilder(44).append("Only support s3 or azure stage. Stage Type: ").append(stageType).toString());
        }
        Tuple2<String, String> tuple22 = tuple2;
        if (tuple22 == null) {
            throw new MatchError(tuple22);
        }
        String key = (String)tuple22._1();
        String iv = (String)tuple22._2();
        Tuple2 tuple23 = new Tuple2((Object)key, (Object)iv);
        Tuple2 tuple24 = tuple23;
        String key2 = (String)tuple24._1();
        String iv2 = (String)tuple24._2();
        if (key2 == null || iv2 == null) {
            throw new SnowflakeSQLException("XX000", Predef$.MODULE$.Integer2int(ErrorCode.INTERNAL_ERROR.getMessageCode()), new Object[]{"File metadata incomplete"});
        }
        byte[] keyBytes = Base64.decode((String)key2);
        byte[] ivBytes = Base64.decode((String)iv2);
        SecretKeySpec queryStageMasterKey = new SecretKeySpec(decodedKey, 0, decodedKey.length, this.AES());
        Cipher keyCipher = Cipher.getInstance(this.KEY_CIPHER());
        keyCipher.init(2, queryStageMasterKey);
        byte[] fileKeyBytes = keyCipher.doFinal(keyBytes);
        SecretKeySpec fileKey = new SecretKeySpec(fileKeyBytes, 0, decodedKey.length, this.AES());
        Cipher dataCipher = Cipher.getInstance(this.DATA_CIPHER());
        IvParameterSpec ivy = new IvParameterSpec(ivBytes);
        dataCipher.init(2, (Key)fileKey, ivy);
        return new CipherInputStream(stream, dataCipher);
    }

    public final Tuple2<String, String> parseEncryptionData(String jsonEncryptionData) {
        ObjectMapper mapper = new ObjectMapper();
        JsonNode encryptionDataNode = mapper.readTree(jsonEncryptionData);
        String iv = encryptionDataNode.findValue(this.AZ_IV()).asText();
        String key = encryptionDataNode.findValue(this.AZ_KEY_WRAP()).findValue(this.AZ_KEY()).asText();
        return new Tuple2((Object)key, (Object)iv);
    }

    public final Tuple2<Cipher, ObjectMetadata> getCipherAndS3Metadata(String masterKey, String queryId, String smkId) {
        Tuple4<Cipher, String, String, String> tuple4 = this.getCipherAndMetadata(masterKey, queryId, smkId);
        if (tuple4 == null) {
            throw new MatchError(tuple4);
        }
        Cipher cipher = (Cipher)tuple4._1();
        String matDesc = (String)tuple4._2();
        String encKeK = (String)tuple4._3();
        String ivData = (String)tuple4._4();
        Tuple4 tuple42 = new Tuple4((Object)cipher, (Object)matDesc, (Object)encKeK, (Object)ivData);
        Tuple4 tuple43 = tuple42;
        Cipher cipher2 = (Cipher)tuple43._1();
        String matDesc2 = (String)tuple43._2();
        String encKeK2 = (String)tuple43._3();
        String ivData2 = (String)tuple43._4();
        ObjectMetadata meta = new ObjectMetadata();
        meta.addUserMetadata(this.AMZ_MATDESC(), matDesc2);
        meta.addUserMetadata(this.AMZ_KEY(), encKeK2);
        meta.addUserMetadata(this.AMZ_IV(), ivData2);
        return new Tuple2((Object)cipher2, (Object)meta);
    }

    public final Tuple2<Cipher, HashMap<String, String>> getCipherAndAZMetaData(String masterKey, String queryId, String smkId) {
        Tuple4<Cipher, String, String, String> tuple4 = this.getCipherAndMetadata(masterKey, queryId, smkId);
        if (tuple4 == null) {
            throw new MatchError(tuple4);
        }
        Cipher cipher = (Cipher)tuple4._1();
        String matDesc = (String)tuple4._2();
        String enKeK = (String)tuple4._3();
        String ivData = (String)tuple4._4();
        Tuple4 tuple42 = new Tuple4((Object)cipher, (Object)matDesc, (Object)enKeK, (Object)ivData);
        Tuple4 tuple43 = tuple42;
        Cipher cipher2 = (Cipher)tuple43._1();
        String matDesc2 = (String)tuple43._2();
        String enKeK2 = (String)tuple43._3();
        String ivData2 = (String)tuple43._4();
        HashMap<String, String> meta = new HashMap<String, String>();
        meta.put(this.AZ_MATDESC(), matDesc2);
        meta.put(this.AZ_ENCRYPTIONDATA(), CloudStorageOperations$.buildEncryptionMetadataJSON$1(ivData2, enKeK2));
        return new Tuple2((Object)cipher2, meta);
    }

    public final Tuple4<Cipher, String, String, String> getCipherAndMetadata(String masterKey, String queryId, String smkId) {
        byte[] decodedKey = Base64.decode((String)masterKey);
        int keySize = decodedKey.length;
        byte[] fileKeyBytes = new byte[keySize];
        Cipher fileCipher = Cipher.getInstance(this.DATA_CIPHER());
        int blockSz = fileCipher.getBlockSize();
        byte[] ivData = new byte[blockSz];
        SecureRandom secRnd = SecureRandom.getInstance("SHA1PRNG", "SUN");
        secRnd.nextBytes(new byte[10]);
        secRnd.nextBytes(ivData);
        IvParameterSpec iv = new IvParameterSpec(ivData);
        secRnd.nextBytes(fileKeyBytes);
        SecretKeySpec fileKey = new SecretKeySpec(fileKeyBytes, 0, keySize, this.AES());
        fileCipher.init(1, (Key)fileKey, iv);
        Cipher keyCipher = Cipher.getInstance(this.KEY_CIPHER());
        SecretKeySpec queryStageMasterKey = new SecretKeySpec(decodedKey, 0, keySize, this.AES());
        keyCipher.init(1, queryStageMasterKey);
        byte[] encKeK = keyCipher.doFinal(fileKeyBytes);
        MatDesc matDesc = new MatDesc(new StringOps(Predef$.MODULE$.augmentString(smkId)).toLong(), queryId, keySize * 8);
        return new Tuple4((Object)fileCipher, (Object)matDesc.toString(), (Object)Base64.encodeAsString((byte[])encKeK), (Object)Base64.encodeAsString((byte[])ivData));
    }

    public CloudStorage createStorageClientFromStage(Parameters.MergedParameters param, ServerConnection conn, String stageName, Option<String> dir, boolean temporary) {
        CloudStorage cloudStorage;
        DefaultJDBCWrapper.DataBaseOperations qual$1 = DefaultJDBCWrapper$.MODULE$.DataBaseOperations(conn);
        String x$1 = stageName;
        boolean x$2 = temporary;
        Option<String> x$3 = qual$1.createStage$default$2();
        Option<String> x$4 = qual$1.createStage$default$3();
        Option<String> x$5 = qual$1.createStage$default$4();
        Option<String> x$6 = qual$1.createStage$default$5();
        boolean x$7 = qual$1.createStage$default$6();
        boolean x$8 = qual$1.createStage$default$8();
        qual$1.createStage(x$1, x$3, x$4, x$5, x$6, x$7, x$2, x$8);
        SFInternalStage stageManager = new SFInternalStage(false, param, stageName, conn, SFInternalStage$.MODULE$.$lessinit$greater$default$5());
        StageInfo.StageType stageType = stageManager.stageType();
        if (StageInfo.StageType.S3.equals(stageType)) {
            cloudStorage = new InternalS3Storage(param, stageName, conn, InternalS3Storage$.MODULE$.apply$default$4());
        } else if (StageInfo.StageType.AZURE.equals(stageType)) {
            cloudStorage = new InternalAzureStorage(param, stageName, conn);
        } else if (StageInfo.StageType.GCS.equals(stageType)) {
            cloudStorage = new InternalGcsStorage(param, stageName, conn, stageManager);
        } else {
            throw new UnsupportedOperationException(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(80).append("Only support s3, Azure or Gcs stage,\n             | stage types: ").append(stageManager.stageType()).append("\n             |").toString())).stripMargin());
        }
        return cloudStorage;
    }

    public Tuple2<CloudStorage, String> createStorageClient(Parameters.MergedParameters param, ServerConnection conn, boolean tempStage, Option<String> stage, String operation) {
        Tuple2 tuple2;
        Regex azure_url = new StringOps(Predef$.MODULE$.augmentString("wasbs?://([^@]+)@([^.]+)\\.([^/]+)/(.*)")).r();
        Regex s3_url = new StringOps(Predef$.MODULE$.augmentString("s3[an]://([^/]+)/(.*)")).r();
        Regex gcs_url = new StringOps(Predef$.MODULE$.augmentString("gcs://([^/]+)/(.*)")).r();
        String stageName = (String)stage.getOrElse((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(23).append("spark_connector_").append(operation).append("_stage_").append(Random$.MODULE$.alphanumeric().take(10).mkString("")).toString());
        String string = param.rootTempDir();
        Option option = azure_url.unapplySeq((CharSequence)string);
        if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(4) == 0) {
            String container = (String)((LinearSeqOptimized)option.get()).apply(0);
            String account = (String)((LinearSeqOptimized)option.get()).apply(1);
            String endpoint = (String)((LinearSeqOptimized)option.get()).apply(2);
            String path = (String)((LinearSeqOptimized)option.get()).apply(3);
            Predef$.MODULE$.require(param.azureSAS().isDefined(), (Function0 & Serializable & scala.Serializable)() -> "missing Azure SAS");
            String azureSAS = (String)param.azureSAS().get();
            String sql = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(147).append("\n             |create or replace ").append((Object)(tempStage ? "temporary" : "")).append(" stage ").append(stageName).append("\n             |url = 'azure://").append(account).append(".").append(endpoint).append("/").append(container).append("/").append(path).append("'\n             |credentials =\n             |(azure_sas_token='").append(azureSAS).append("')\n         ").toString())).stripMargin();
            DefaultJDBCWrapper$.MODULE$.executeQueryInterruptibly(conn, sql);
            tuple2 = new Tuple2((Object)new ExternalAzureStorage(param, container, account, endpoint, azureSAS, param.expectedPartitionCount(), path, conn), (Object)stageName);
        } else {
            Option option2 = s3_url.unapplySeq((CharSequence)string);
            if (!option2.isEmpty() && option2.get() != null && ((LinearSeqOptimized)option2.get()).lengthCompare(2) == 0) {
                String bucket = (String)((LinearSeqOptimized)option2.get()).apply(0);
                String prefix = (String)((LinearSeqOptimized)option2.get()).apply(1);
                Predef$.MODULE$.require(param.awsAccessKey().isDefined(), (Function0 & Serializable & scala.Serializable)() -> "missing aws access key");
                Predef$.MODULE$.require(param.awsSecretKey().isDefined(), (Function0 & Serializable & scala.Serializable)() -> "missing aws secret key");
                String sql = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(155).append("\n             |create or replace ").append((Object)(tempStage ? "temporary" : "")).append(" stage ").append(stageName).append("\n             |url = 's3://").append(bucket).append("/").append(prefix).append("'\n             |credentials =\n             |(aws_key_id='").append(param.awsAccessKey().get()).append("' aws_secret_key='").append(param.awsSecretKey().get()).append("')\n         ").toString())).stripMargin();
                DefaultJDBCWrapper$.MODULE$.executeQueryInterruptibly(conn, sql);
                Parameters.MergedParameters x$1 = param;
                String x$2 = bucket;
                String x$3 = (String)param.awsAccessKey().get();
                String x$4 = (String)param.awsSecretKey().get();
                int x$5 = param.expectedPartitionCount();
                String x$6 = prefix;
                ServerConnection x$7 = conn;
                None$ x$8 = None$.MODULE$;
                None$ x$9 = None$.MODULE$;
                None$ x$10 = None$.MODULE$;
                Option<String> x$11 = ExternalS3Storage$.MODULE$.apply$default$6();
                int x$12 = ExternalS3Storage$.MODULE$.apply$default$9();
                tuple2 = new Tuple2((Object)new ExternalS3Storage(x$1, x$2, x$3, x$4, x$5, x$11, x$6, x$7, x$12, (Option<String>)x$8, (Option<String>)x$9, (Option<String>)x$10), (Object)stageName);
            } else {
                Option option3 = gcs_url.unapplySeq((CharSequence)string);
                if (!option3.isEmpty() && option3.get() != null && ((LinearSeqOptimized)option3.get()).lengthCompare(2) == 0) {
                    throw new SnowflakeConnectorFeatureNotSupportException(new StringBuilder(41).append("Doesn't support GCS external stage. url: ").append(param.rootTempDir()).toString());
                }
                tuple2 = new Tuple2((Object)this.createStorageClientFromStage(param, conn, stageName, (Option<String>)None$.MODULE$, tempStage), (Object)stageName);
            }
        }
        return tuple2;
    }

    public Option<String> createStorageClientFromStage$default$4() {
        return None$.MODULE$;
    }

    public boolean createStorageClientFromStage$default$5() {
        return false;
    }

    public boolean createStorageClient$default$3() {
        return true;
    }

    public Option<String> createStorageClient$default$4() {
        return None$.MODULE$;
    }

    public String createStorageClient$default$5() {
        return "unload";
    }

    public void deleteFiles(List<String> files, CloudStorage storage, ServerConnection connection) {
        storage.deleteFiles(files);
    }

    public AmazonS3 createS3Client(String awsId, String awsKey, Option<String> awsToken, int parallelism, Option<ProxyInfo> proxyInfo, Option<String> useRegionUrl, Option<String> regionName, Option<String> stageEndPoint) {
        AmazonS3Client amazonS3Client;
        BasicAWSCredentials basicAWSCredentials;
        Option<String> option = awsToken;
        if (option instanceof Some) {
            Some some = (Some)option;
            String token = (String)some.value();
            basicAWSCredentials = new BasicSessionCredentials(awsId, awsKey, token);
        } else if (None$.MODULE$.equals(option)) {
            basicAWSCredentials = new BasicAWSCredentials(awsId, awsKey);
        } else {
            throw new MatchError(option);
        }
        BasicAWSCredentials awsCredentials = basicAWSCredentials;
        ClientConfiguration clientConfig = new ClientConfiguration();
        clientConfig.setMaxConnections(parallelism);
        clientConfig.setMaxErrorRetry(this.S3_MAX_RETRIES());
        clientConfig.setRetryPolicy(new RetryPolicy(PredefinedRetryPolicies.DEFAULT_RETRY_CONDITION, PredefinedRetryPolicies.DEFAULT_BACKOFF_STRATEGY, this.S3_MAX_RETRIES(), true));
        clientConfig.setConnectionTimeout(this.S3_MAX_TIMEOUT_MS());
        Option<ProxyInfo> option2 = proxyInfo;
        if (option2 instanceof Some) {
            Some some = (Some)option2;
            ProxyInfo proxyInfoValue = (ProxyInfo)some.value();
            proxyInfoValue.setProxyForS3(clientConfig);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (None$.MODULE$.equals(option2)) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError(option2);
        }
        if (useRegionUrl.isEmpty()) {
            amazonS3Client = new AmazonS3Client((AWSCredentials)awsCredentials, clientConfig);
        } else {
            AwsClientBuilder awsClientBuilder;
            AmazonS3ClientBuilder s3ClientBuilder = (AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().withCredentials((AWSCredentialsProvider)new AWSStaticCredentialsProvider((AWSCredentials)awsCredentials)).withClientConfiguration(clientConfig);
            if (stageEndPoint.nonEmpty()) {
                awsClientBuilder = s3ClientBuilder.withEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration((String)stageEndPoint.get(), (String)regionName.get()));
            } else if (new StringOps(Predef$.MODULE$.augmentString((String)useRegionUrl.get())).toBoolean()) {
                String awsDomain = ((String)regionName.get()).toLowerCase().startsWith("cn-") ? ".amazonaws.com.cn" : ".amazonaws.com";
                awsClientBuilder = s3ClientBuilder.withEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration(new StringBuilder(3).append("s3.").append(regionName.get()).append(awsDomain).toString(), (String)regionName.get()));
            } else {
                awsClientBuilder = s3ClientBuilder.withRegion((String)regionName.get());
            }
            amazonS3Client = (AmazonS3)s3ClientBuilder.build();
        }
        return amazonS3Client;
    }

    public final CloudBlobClient createAzureClient(String storageAccount, String endpoint, Option<String> sas, Option<ProxyInfo> proxyInfo) {
        URI storageEndpoint = new URI("https", new StringBuilder(2).append(storageAccount).append(".").append(endpoint).append("/").toString(), null, null);
        StorageCredentials azCreds = sas.isDefined() ? new StorageCredentialsSharedAccessSignature((String)sas.get()) : StorageCredentialsAnonymous.ANONYMOUS;
        Option<ProxyInfo> option = proxyInfo;
        if (option instanceof Some) {
            Some some = (Some)option;
            ProxyInfo proxyInfoValue = (ProxyInfo)some.value();
            proxyInfoValue.setProxyForAzure();
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (None$.MODULE$.equals(option)) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError(option);
        }
        return new CloudBlobClient(storageEndpoint, azCreds);
    }

    public final Option<String> createAzureClient$default$3() {
        return None$.MODULE$;
    }

    private static final String buildEncryptionMetadataJSON$1(String iv64, String key64) {
        return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(349).append("\n         | {\"EncryptionMode\":\"FullBlob\",\n         | \"WrappedContentKey\":\n         | {\"KeyId\":\"symmKey1\",\"EncryptedKey\":\"").append(key64).append("\",\"Algorithm\":\"AES_CBC_256\"},\n         | \"EncryptionAgent\":{\"Protocol\":\"1.0\",\"EncryptionAlgorithm\":\"AES_CBC_256\"},\n         | \"ContentEncryptionIV\":\"").append(iv64).append("\",\n         | \"KeyWrappingMetadata\":{\"EncryptionLibrary\":\"Java 5.3.0\"}}\n       ").toString())).stripMargin();
    }

    private CloudStorageOperations$() {
        MODULE$ = this;
        this.DEFAULT_PARALLELISM = 10;
        this.S3_MAX_RETRIES = 6;
        this.S3_MAX_TIMEOUT_MS = 30000;
        this.AES = "AES";
        this.AMZ_KEY = "x-amz-key";
        this.AMZ_IV = "x-amz-iv";
        this.DATA_CIPHER = "AES/CBC/PKCS5Padding";
        this.KEY_CIPHER = "AES/ECB/PKCS5Padding";
        this.AMZ_MATDESC = "x-amz-matdesc";
        this.AZ_ENCRYPTIONDATA = "encryptiondata";
        this.AZ_IV = "ContentEncryptionIV";
        this.AZ_KEY_WRAP = "WrappedContentKey";
        this.AZ_KEY = "EncryptedKey";
        this.AZ_MATDESC = "matdesc";
        this.log = LoggerFactory.getLogger(this.getClass());
    }
}

