/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.spark.snowflake;

import java.io.Serializable;
import java.security.PrivateKey;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import net.snowflake.client.jdbc.telemetry.Telemetry;
import net.snowflake.client.jdbc.telemetry.TelemetryClient;
import net.snowflake.spark.snowflake.DefaultJDBCWrapper;
import net.snowflake.spark.snowflake.DefaultJDBCWrapper$;
import net.snowflake.spark.snowflake.Parameters;
import net.snowflake.spark.snowflake.Parameters$;
import net.snowflake.spark.snowflake.ProxyInfo;
import net.snowflake.spark.snowflake.SnowflakeTelemetry$;
import net.snowflake.spark.snowflake.TelemetryClientInfoFields$;
import net.snowflake.spark.snowflake.Utils$;
import org.apache.spark.sql.execution.datasources.jdbc.DriverRegistry$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005]h!B\f\u0019\u0001ay\u0002\"\u0002\u0014\u0001\t\u0003A\u0003bB\u0016\u0001\u0005\u0004%I\u0001\f\u0005\u0007k\u0001\u0001\u000b\u0011B\u0017\t\u000fY\u0002!\u0019!C\u0005o!1a\b\u0001Q\u0001\naBQa\u0010\u0001\u0005\u0002\u0001CQa\u001d\u0001\u0005\u0002QDQ\u0001 \u0001\u0005\u0002uDaa \u0001\u0005\u0002\u0005\u0005\u0001bBA\u0006\u0001\u0011\u0005\u0011Q\u0002\u0005\b\u00033\u0001A\u0011AA\u000e\u0011\u001d\t9\u0003\u0001C\u0001\u0003SAq!a\n\u0001\t\u0003\t)\u0004C\u0004\u0002<\u0001!\t!!\u0010\t\u000f\u0005m\u0002\u0001\"\u0001\u0002H!9\u0011Q\n\u0001\u0005\u0002\u0005=\u0003bBA/\u0001\u0011\u0005\u0011q\f\u0005\b\u0003\u001b\u0002A\u0011AA3\u0011\u001d\ti\u0006\u0001C\u0001\u0003WBq!!\u0018\u0001\t\u0013\t\t\bC\u0004\u0002\u0018\u0002!I!!'\t\u000f\u0005]\u0006\u0001\"\u0001\u0002:\nY!\n\u0012\"D/J\f\u0007\u000f]3s\u0015\tI\"$A\u0005t]><h\r\\1lK*\u00111\u0004H\u0001\u0006gB\f'o\u001b\u0006\u00033uQ\u0011AH\u0001\u0004]\u0016$8C\u0001\u0001!!\t\tC%D\u0001#\u0015\u0005\u0019\u0013!B:dC2\f\u0017BA\u0013#\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\u001a\u0001\u0001F\u0001*!\tQ\u0003!D\u0001\u0019\u0003\rawnZ\u000b\u0002[A\u0011afM\u0007\u0002_)\u0011\u0001'M\u0001\u0006g24GG\u001b\u0006\u0002e\u0005\u0019qN]4\n\u0005Qz#A\u0002'pO\u001e,'/\u0001\u0003m_\u001e\u0004\u0013AA3d+\u0005A\u0004CA\u001d=\u001b\u0005Q$BA\u001e#\u0003)\u0019wN\\2veJ,g\u000e^\u0005\u0003{i\u0012\u0001#\u0012=fGV$\u0018n\u001c8D_:$X\r\u001f;\u0002\u0007\u0015\u001c\u0007%\u0001\u0007sKN|GN^3UC\ndW\r\u0006\u0003B\u0019V\u0013\u0007C\u0001\"K\u001b\u0005\u0019%B\u0001#F\u0003\u0015!\u0018\u0010]3t\u0015\t1u)A\u0002tc2T!a\u0007%\u000b\u0005%\u000b\u0014AB1qC\u000eDW-\u0003\u0002L\u0007\nQ1\u000b\u001e:vGR$\u0016\u0010]3\t\u000b53\u0001\u0019\u0001(\u0002\t\r|gN\u001c\t\u0003\u001fNk\u0011\u0001\u0015\u0006\u0003\rFS\u0011AU\u0001\u0005U\u00064\u0018-\u0003\u0002U!\nQ1i\u001c8oK\u000e$\u0018n\u001c8\t\u000bY3\u0001\u0019A,\u0002\u000bQ\f'\r\\3\u0011\u0005a{fBA-^!\tQ&%D\u0001\\\u0015\tav%\u0001\u0004=e>|GOP\u0005\u0003=\n\na\u0001\u0015:fI\u00164\u0017B\u00011b\u0005\u0019\u0019FO]5oO*\u0011aL\t\u0005\u0006G\u001a\u0001\r\u0001Z\u0001\u0007a\u0006\u0014\u0018-\\:\u0011\u0005\u0015\u0004hB\u00014o\u001d\t9WN\u0004\u0002iY:\u0011\u0011n\u001b\b\u00035*L\u0011AH\u0005\u00033uI!a\u0007\u000f\n\u0005eQ\u0012BA8\u0019\u0003)\u0001\u0016M]1nKR,'o]\u0005\u0003cJ\u0014\u0001#T3sO\u0016$\u0007+\u0019:b[\u0016$XM]:\u000b\u0005=D\u0012\u0001\u0006:fg>dg/\u001a+bE2,gI]8n\u001b\u0016$\u0018\r\u0006\u0003BkZ\\\b\"B'\b\u0001\u0004q\u0005\"B<\b\u0001\u0004A\u0018\u0001\u0002:t[\u0012\u0004\"aT=\n\u0005i\u0004&!\u0005*fgVdGoU3u\u001b\u0016$\u0018\rR1uC\")1m\u0002a\u0001I\u0006aq-\u001a;D_:tWm\u0019;peR\u0011aJ \u0005\u0006G\"\u0001\r\u0001Z\u0001\rg\u000eDW-\\1TiJLgn\u001a\u000b\u0006/\u0006\r\u0011q\u0001\u0005\u0007\u0003\u000bI\u0001\u0019A!\u0002\rM\u001c\u0007.Z7b\u0011\u0019\tI!\u0003a\u0001I\u0006)\u0001/\u0019:b[\u0006\u00012o\u00195f[\u0006\u001cuN\u001c<feNLwN\u001c\u000b\u0004/\u0006=\u0001bBA\t\u0015\u0001\u0007\u00111C\u0001\u0006M&,G\u000e\u001a\t\u0004\u0005\u0006U\u0011bAA\f\u0007\nY1\u000b\u001e:vGR4\u0015.\u001a7e\u0003-!\u0018M\u00197f\u000bbL7\u000f^:\u0015\r\u0005u\u00111EA\u0013!\r\t\u0013qD\u0005\u0004\u0003C\u0011#a\u0002\"p_2,\u0017M\u001c\u0005\u0006\u001b.\u0001\rA\u0014\u0005\u0006-.\u0001\raV\u0001\u001dKb,7-\u001e;f!J,\u0007/\u0019:fI&sG/\u001a:skB$\u0018N\u00197z)\u0011\ti\"a\u000b\t\u000f\u00055B\u00021\u0001\u00020\u0005I1\u000f^1uK6,g\u000e\u001e\t\u0004\u001f\u0006E\u0012bAA\u001a!\n\t\u0002K]3qCJ,Gm\u0015;bi\u0016lWM\u001c;\u0015\r\u0005u\u0011qGA\u001d\u0011\u0015iU\u00021\u0001O\u0011\u00151U\u00021\u0001X\u0003\u0005*\u00070Z2vi\u0016\u0004&/\u001a9be\u0016$\u0017+^3ss&sG/\u001a:skB$\u0018N\u00197z)\u0011\ty$!\u0012\u0011\u0007=\u000b\t%C\u0002\u0002DA\u0013\u0011BU3tk2$8+\u001a;\t\u000f\u00055b\u00021\u0001\u00020Q1\u0011qHA%\u0003\u0017BQ!T\bA\u00029CQAR\bA\u0002]\u000b\u0011$\u001a=fGV$X-U;fefLe\u000e^3seV\u0004H/\u001b2msR1\u0011qHA)\u00033Bq!!\f\u0011\u0001\u0004\t\u0019\u0006E\u0002P\u0003+J1!a\u0016Q\u0005%\u0019F/\u0019;f[\u0016tG\u000f\u0003\u0004\u0002\\A\u0001\raV\u0001\u0004gR\u0014\u0018\u0001F3yK\u000e,H/Z%oi\u0016\u0014(/\u001e9uS\nd\u0017\u0010\u0006\u0004\u0002\u001e\u0005\u0005\u00141\r\u0005\b\u0003[\t\u0002\u0019AA*\u0011\u0019\tY&\u0005a\u0001/R1\u0011qHA4\u0003SBQ!\u0014\nA\u00029CQA\u0012\nA\u0002]#b!!\b\u0002n\u0005=\u0004\"B'\u0014\u0001\u0004q\u0005\"\u0002$\u0014\u0001\u00049V\u0003BA:\u0003s\"b!!\u001e\u0002\f\u00065\u0005\u0003BA<\u0003sb\u0001\u0001B\u0004\u0002|Q\u0011\r!! \u0003\u0003Q\u000bB!a \u0002\u0006B\u0019\u0011%!!\n\u0007\u0005\r%EA\u0004O_RD\u0017N\\4\u0011\u0007\u0005\n9)C\u0002\u0002\n\n\u00121!\u00118z\u0011\u001d\ti\u0003\u0006a\u0001\u0003'Bq!a$\u0015\u0001\u0004\t\t*\u0001\u0002paB9\u0011%a%\u0002T\u0005U\u0014bAAKE\tIa)\u001e8di&|g.M\u0001\u0010O\u0016$8)\u0019;bYf\u001cH\u000fV=qKRQ\u00111TAQ\u0003W\u000by+a-\u0011\u0007\t\u000bi*C\u0002\u0002 \u000e\u0013\u0001\u0002R1uCRK\b/\u001a\u0005\b\u0003G+\u0002\u0019AAS\u0003\u001d\u0019\u0018\u000f\u001c+za\u0016\u00042!IAT\u0013\r\tIK\t\u0002\u0004\u0013:$\bbBAW+\u0001\u0007\u0011QU\u0001\naJ,7-[:j_:Dq!!-\u0016\u0001\u0004\t)+A\u0003tG\u0006dW\rC\u0004\u00026V\u0001\r!!\b\u0002\rMLwM\\3e\u000319W\r\u001e+fY\u0016lW\r\u001e:z)\u0011\tY,a4\u0011\t\u0005u\u00161Z\u0007\u0003\u0003\u007fSA!!1\u0002D\u0006IA/\u001a7f[\u0016$(/\u001f\u0006\u0005\u0003\u000b\f9-\u0001\u0003kI\n\u001c'bAAe9\u000511\r\\5f]RLA!!4\u0002@\nIA+\u001a7f[\u0016$(/\u001f\u0005\u0006\u001bZ\u0001\rA\u0014\u0015\b-\u0005M\u0017\u0011\\Aw!\r\t\u0013Q[\u0005\u0004\u0003/\u0014#A\u00033faJ,7-\u0019;fIFB1eVAn\u0003G\fi.\u0003\u0003\u0002^\u0006}\u0017a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$\u0013GC\u0002\u0002b\n\n!\u0002Z3qe\u0016\u001c\u0017\r^3ec%\u0019\u0013Q]At\u0003S\f\tOD\u0002\"\u0003OL1!!9#c\u0015\u0011\u0013EIAv\u0005\u0015\u00198-\u00197bc!\u0019s+a<\u0002t\u0006E\u0018\u0002BAy\u0003?\f1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\u0012\u0014'C\u0012\u0002f\u0006\u001d\u0018Q_Aqc\u0015\u0011\u0013EIAv\u0001")
public class JDBCWrapper {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final ExecutionContext ec;

    private Logger log() {
        return this.log;
    }

    private ExecutionContext ec() {
        return this.ec;
    }

    public StructType resolveTable(Connection conn, String table, Parameters.MergedParameters params) {
        return this.resolveTableFromMeta(conn, DefaultJDBCWrapper$.MODULE$.DataBaseOperations(conn).tableMetaData(table), params);
    }

    public StructType resolveTableFromMeta(Connection conn, ResultSetMetaData rsmd, Parameters.MergedParameters params) {
        int ncols = rsmd.getColumnCount();
        StructField[] fields = new StructField[ncols];
        for (int i = 0; i < ncols; ++i) {
            String columnName = rsmd.getColumnLabel(i + 1);
            int dataType = rsmd.getColumnType(i + 1);
            int fieldSize = rsmd.getPrecision(i + 1);
            int fieldScale = rsmd.getScale(i + 1);
            boolean isSigned = rsmd.isSigned(i + 1);
            boolean nullable = rsmd.isNullable(i + 1) != 0;
            DataType columnType = this.getCatalystType(dataType, fieldSize, fieldScale, isSigned);
            fields[i] = new StructField(params.keepOriginalColumnNameCase() ? columnName : (columnName.matches("[_A-Z]([_0-9A-Z])*") ? columnName : new StringBuilder(2).append("\"").append(columnName).append("\"").toString()), columnType, nullable, StructField$.MODULE$.apply$default$4());
        }
        return new StructType(fields);
    }

    public Connection getConnector(Parameters.MergedParameters params) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        String driverClassName = Utils$.MODULE$.JDBC_DRIVER();
        try {
            Class<?> driverClass = Utils$.MODULE$.classForName(driverClassName);
            DriverRegistry$.MODULE$.register(driverClass.getCanonicalName());
        }
        catch (ClassNotFoundException e) {
            throw new ClassNotFoundException(new StringBuilder(50).append("Could not load a Snowflake JDBC driver class < ").append(driverClassName).append(" > ").toString(), e);
        }
        String sfURL = params.sfURL();
        String jdbcURL = new StringBuilder(17).append("jdbc:snowflake://").append(sfURL).toString();
        Properties jdbcProperties = new Properties();
        jdbcProperties.put("db", params.sfDatabase());
        jdbcProperties.put("schema", params.sfSchema());
        jdbcProperties.put("user", params.sfUser());
        Option<PrivateKey> option = params.privateKey();
        if (option instanceof Some) {
            Some some = (Some)option;
            PrivateKey privateKey = (PrivateKey)some.value();
            object5 = jdbcProperties.put("privateKey", privateKey);
        } else if (None$.MODULE$.equals(option)) {
            Object object6;
            Option<String> option2 = params.sfToken();
            if (option2 instanceof Some) {
                Some some = (Some)option2;
                String value = (String)some.value();
                object6 = jdbcProperties.put("token", value);
            } else if (None$.MODULE$.equals(option2)) {
                object6 = jdbcProperties.put("password", params.sfPassword());
            } else {
                throw new MatchError(option2);
            }
            object5 = object6;
        } else {
            throw new MatchError(option);
        }
        jdbcProperties.put("ssl", params.sfSSL());
        Object object7 = params.sfAccount().isDefined() ? jdbcProperties.put("account", params.sfAccount().get()) : BoxedUnit.UNIT;
        Object object8 = params.sfWarehouse().isDefined() ? jdbcProperties.put("warehouse", params.sfWarehouse().get()) : BoxedUnit.UNIT;
        Object object9 = params.sfRole().isDefined() ? jdbcProperties.put("role", params.sfRole().get()) : BoxedUnit.UNIT;
        Option<String> option3 = params.getTimeOutputFormat();
        if (option3 instanceof Some) {
            Some some = (Some)option3;
            String value = (String)some.value();
            object4 = jdbcProperties.put(Parameters$.MODULE$.PARAM_TIME_OUTPUT_FORMAT(), value);
        } else {
            object4 = BoxedUnit.UNIT;
        }
        Option<String> option4 = params.getQueryResultFormat();
        if (option4 instanceof Some) {
            Some some = (Some)option4;
            String value = (String)some.value();
            object3 = jdbcProperties.put(Parameters$.MODULE$.PARAM_JDBC_QUERY_RESULT_FORMAT(), value);
        } else {
            object3 = BoxedUnit.UNIT;
        }
        Option<ProxyInfo> option5 = params.proxyInfo();
        if (option5 instanceof Some) {
            Some some = (Some)option5;
            ProxyInfo proxyInfoValue = (ProxyInfo)some.value();
            proxyInfoValue.setProxyForJDBC(jdbcProperties);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (None$.MODULE$.equals(option5)) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError(option5);
        }
        Option<String> option6 = params.sfAuthenticator();
        if (option6 instanceof Some) {
            Some some = (Some)option6;
            String value = (String)some.value();
            object2 = jdbcProperties.put("authenticator", value);
        } else {
            object2 = BoxedUnit.UNIT;
        }
        jdbcProperties.put("client_session_keep_alive", "true");
        jdbcProperties.put("JDBC_TREAT_DECIMAL_AS_INT", "false");
        Map<String, Object> extraOptions = params.sfExtraOptions();
        extraOptions.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)JDBCWrapper.$anonfun$getConnector$1(check$ifrefutable$1))).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            String string;
            Object v;
            block3: {
                Tuple2 tuple2;
                block2: {
                    tuple2 = x$1;
                    if (tuple2 == null) break block2;
                    String k = (String)tuple2._1();
                    v = tuple2._2();
                    if (k == null) break block2;
                    string = k;
                    if (v != null) break block3;
                }
                throw new MatchError((Object)tuple2);
            }
            Object object = v;
            Object object2 = jdbcProperties.put(string.toLowerCase(), object.toString());
            return object2;
        });
        if (!Utils$.MODULE$.CERTIFIED_JDBC_VERSION().equals(Utils$.MODULE$.jdbcVersion())) {
            this.log().warn((String)new StringOps(Predef$.MODULE$.augmentString(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(107).append("JDBC ").append(Utils$.MODULE$.jdbcVersion()).append(" is being used.\n           | But the certified JDBC version\n           | ").append(Utils$.MODULE$.CERTIFIED_JDBC_VERSION()).append(" is recommended.\n           |").toString())).stripMargin())).filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)JDBCWrapper.$anonfun$getConnector$3(BoxesRunTime.unboxToChar((Object)x$2)))));
        }
        String snowflakeClientInfo = Utils$.MODULE$.getClientInfoString();
        this.log().info(snowflakeClientInfo);
        System.setProperty("snowflake.client.info", snowflakeClientInfo);
        Connection conn = DriverManager.getConnection(jdbcURL, jdbcProperties);
        if (jdbcProperties.getProperty(Parameters$.MODULE$.PARAM_JDBC_QUERY_RESULT_FORMAT()) != null) {
            try {
                String resultFormat = jdbcProperties.getProperty(Parameters$.MODULE$.PARAM_JDBC_QUERY_RESULT_FORMAT());
                object = BoxesRunTime.boxToBoolean((boolean)conn.createStatement().execute(new StringBuilder(47).append("alter session set JDBC_QUERY_RESULT_FORMAT = '").append(resultFormat).append("'").toString()));
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (!(throwable2 instanceof SQLException)) {
                    if (throwable2 != null) {
                        Throwable throwable3 = throwable2;
                        throw throwable3;
                    }
                    throw throwable;
                }
                SQLException sQLException = (SQLException)throwable2;
                this.log().info(sQLException.getMessage());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                object = boxedUnit;
            }
        } else {
            object = BoxedUnit.UNIT;
        }
        Map extraValues = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)TelemetryClientInfoFields$.MODULE$.SFURL()), (Object)sfURL)}));
        SnowflakeTelemetry$.MODULE$.sendClientInfoTelemetryIfNotYet((Map<String, String>)extraValues, conn);
        return conn;
    }

    public String schemaString(StructType schema, Parameters.MergedParameters param) {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])schema.fields())).map((Function1 & Serializable & scala.Serializable)field -> {
            String name = param.keepOriginalColumnNameCase() ? Utils$.MODULE$.quotedNameIgnoreCase(field.name()) : Utils$.MODULE$.ensureQuoted(field.name());
            String type = this.schemaConversion((StructField)field);
            String nullable = field.nullable() ? "" : "NOT NULL";
            return new StringBuilder(2).append(name).append(" ").append(type).append(" ").append(nullable).toString();
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString(",");
    }

    public String schemaConversion(StructField field) {
        String string;
        DataType dataType = field.dataType();
        if (IntegerType$.MODULE$.equals(dataType)) {
            string = "INTEGER";
        } else if (LongType$.MODULE$.equals(dataType)) {
            string = "INTEGER";
        } else if (DoubleType$.MODULE$.equals(dataType)) {
            string = "DOUBLE";
        } else if (FloatType$.MODULE$.equals(dataType)) {
            string = "FLOAT";
        } else if (ShortType$.MODULE$.equals(dataType)) {
            string = "INTEGER";
        } else if (ByteType$.MODULE$.equals(dataType)) {
            string = "INTEGER";
        } else if (BooleanType$.MODULE$.equals(dataType)) {
            string = "BOOLEAN";
        } else if (StringType$.MODULE$.equals(dataType)) {
            string = field.metadata().contains("maxlength") ? new StringBuilder(9).append("VARCHAR(").append(field.metadata().getLong("maxlength")).append(")").toString() : "STRING";
        } else if (BinaryType$.MODULE$.equals(dataType)) {
            string = field.metadata().contains("maxlength") ? new StringBuilder(8).append("BINARY(").append(field.metadata().getLong("maxlength")).append(")").toString() : "BINARY";
        } else if (TimestampType$.MODULE$.equals(dataType)) {
            string = "TIMESTAMP";
        } else if (DateType$.MODULE$.equals(dataType)) {
            string = "DATE";
        } else if (dataType instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)dataType;
            string = new StringBuilder(10).append("DECIMAL(").append(decimalType.precision()).append(",").append(decimalType.scale()).append(")").toString();
        } else {
            boolean bl = dataType instanceof StructType ? true : (dataType instanceof ArrayType ? true : dataType instanceof MapType);
            if (bl) {
                string = "VARIANT";
            } else {
                throw new IllegalArgumentException(new StringBuilder(45).append("Don't know how to save ").append(field).append(" of type ").append(field.name()).append(" to Snowflake").toString());
            }
        }
        return string;
    }

    public boolean tableExists(Connection conn, String table) {
        DefaultJDBCWrapper.DataBaseOperations qual$1 = DefaultJDBCWrapper$.MODULE$.DataBaseOperations(conn);
        String x$1 = table;
        boolean x$2 = qual$1.tableExists$default$2();
        return qual$1.tableExists(x$1, x$2);
    }

    public boolean executePreparedInterruptibly(PreparedStatement statement) {
        return BoxesRunTime.unboxToBoolean(this.executeInterruptibly((Statement)statement, (Function1 & Serializable & scala.Serializable)stmt -> BoxesRunTime.boxToBoolean((boolean)JDBCWrapper.$anonfun$executePreparedInterruptibly$1(stmt))));
    }

    public boolean executePreparedInterruptibly(Connection conn, String sql) {
        return this.executePreparedInterruptibly(conn.prepareStatement(sql));
    }

    public ResultSet executePreparedQueryInterruptibly(PreparedStatement statement) {
        return (ResultSet)this.executeInterruptibly((Statement)statement, (Function1 & Serializable & scala.Serializable)stmt -> {
            PreparedStatement prepStmt = (PreparedStatement)stmt;
            return prepStmt.executeQuery();
        });
    }

    public ResultSet executePreparedQueryInterruptibly(Connection conn, String sql) {
        return this.executePreparedQueryInterruptibly(conn.prepareStatement(sql));
    }

    public ResultSet executeQueryInterruptibly(Statement statement, String str) {
        return (ResultSet)this.executeInterruptibly(statement, (Function1 & Serializable & scala.Serializable)x$3 -> x$3.executeQuery(str));
    }

    public boolean executeInterruptibly(Statement statement, String str) {
        return BoxesRunTime.unboxToBoolean(this.executeInterruptibly(statement, (Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)x$4.execute(str))));
    }

    public ResultSet executeQueryInterruptibly(Connection conn, String sql) {
        Statement stmt = conn.createStatement();
        return this.executeQueryInterruptibly(stmt, sql);
    }

    public boolean executeInterruptibly(Connection conn, String sql) {
        Statement stmt = conn.createStatement();
        return this.executeInterruptibly(stmt, sql);
    }

    private <T> T executeInterruptibly(Statement statement, Function1<Statement, T> op) {
        Object object;
        try {
            this.log().debug(new StringBuilder(18).append("Running statement ").append(statement).toString());
            Future future = Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> op.apply((Object)statement), this.ec());
            object = Await$.MODULE$.result((Awaitable)future, (Duration)Duration$.MODULE$.Inf());
        }
        catch (InterruptedException e) {
            try {
                this.log().info(new StringBuilder(21).append("Cancelling statement ").append(statement).toString());
                statement.cancel();
                this.log().info("Cancelling succeeded");
                throw e;
            }
            catch (SQLException s) {
                this.log().error("Exception occurred while cancelling query", (Throwable)s);
                throw e;
            }
        }
        return (T)object;
    }

    private DataType getCatalystType(int sqlType, int precision, int scale, boolean signed) {
        BooleanType$ booleanType$;
        int n = sqlType;
        switch (n) {
            case 2003: {
                booleanType$ = null;
                break;
            }
            case -5: {
                if (signed) {
                    booleanType$ = LongType$.MODULE$;
                    break;
                }
                booleanType$ = new DecimalType(20, 0);
                break;
            }
            case 16: {
                booleanType$ = BooleanType$.MODULE$;
                break;
            }
            case 1: {
                booleanType$ = StringType$.MODULE$;
                break;
            }
            case 2005: {
                booleanType$ = StringType$.MODULE$;
                break;
            }
            case 70: {
                booleanType$ = null;
                break;
            }
            case 91: {
                booleanType$ = DateType$.MODULE$;
                break;
            }
            case 3: {
                if (precision != 0 || scale != 0) {
                    if (precision > DecimalType$.MODULE$.MAX_PRECISION()) {
                        booleanType$ = new DecimalType(DecimalType$.MODULE$.MAX_PRECISION(), scale + (precision - DecimalType$.MODULE$.MAX_SCALE()));
                        break;
                    }
                    booleanType$ = new DecimalType(precision, scale);
                    break;
                }
                booleanType$ = new DecimalType(38, 18);
                break;
            }
            case 2001: {
                booleanType$ = null;
                break;
            }
            case 8: {
                booleanType$ = DoubleType$.MODULE$;
                break;
            }
            case 6: {
                booleanType$ = FloatType$.MODULE$;
                break;
            }
            case 4: {
                if (signed) {
                    booleanType$ = IntegerType$.MODULE$;
                    break;
                }
                booleanType$ = LongType$.MODULE$;
                break;
            }
            case 2000: {
                booleanType$ = null;
                break;
            }
            case -16: {
                booleanType$ = StringType$.MODULE$;
                break;
            }
            case -1: {
                booleanType$ = StringType$.MODULE$;
                break;
            }
            case -15: {
                booleanType$ = StringType$.MODULE$;
                break;
            }
            case 2011: {
                booleanType$ = StringType$.MODULE$;
                break;
            }
            case 0: {
                booleanType$ = null;
                break;
            }
            case 2: {
                if (precision != 0 || scale != 0) {
                    booleanType$ = new DecimalType(precision, scale);
                    break;
                }
                booleanType$ = new DecimalType(38, 18);
                break;
            }
            case -9: {
                booleanType$ = StringType$.MODULE$;
                break;
            }
            case 1111: {
                booleanType$ = null;
                break;
            }
            case 7: {
                booleanType$ = DoubleType$.MODULE$;
                break;
            }
            case 2006: {
                booleanType$ = StringType$.MODULE$;
                break;
            }
            case -8: {
                booleanType$ = LongType$.MODULE$;
                break;
            }
            case 5: {
                booleanType$ = IntegerType$.MODULE$;
                break;
            }
            case 2009: {
                booleanType$ = StringType$.MODULE$;
                break;
            }
            case 2002: {
                booleanType$ = StringType$.MODULE$;
                break;
            }
            case 92: {
                booleanType$ = StringType$.MODULE$;
                break;
            }
            case 93: {
                booleanType$ = TimestampType$.MODULE$;
                break;
            }
            case -6: {
                booleanType$ = IntegerType$.MODULE$;
                break;
            }
            case 12: {
                booleanType$ = StringType$.MODULE$;
                break;
            }
            case -2: {
                booleanType$ = BinaryType$.MODULE$;
                break;
            }
            default: {
                booleanType$ = null;
                break;
            }
        }
        BooleanType$ answer = booleanType$;
        if (answer == null) {
            throw new SQLException(new StringBuilder(17).append("Unsupported type ").append(sqlType).toString());
        }
        return answer;
    }

    public Telemetry getTelemetry(Connection conn) {
        return TelemetryClient.createTelemetry((Connection)conn);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$getConnector$1(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        if (tuple2 == null) return false;
        String k = (String)tuple2._1();
        Object v = tuple2._2();
        if (k == null) return false;
        if (v == null) return false;
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$getConnector$3(char x$2) {
        return x$2 >= ' ';
    }

    public static final /* synthetic */ boolean $anonfun$executePreparedInterruptibly$1(Statement stmt) {
        PreparedStatement prepStmt = (PreparedStatement)stmt;
        return prepStmt.execute();
    }

    public JDBCWrapper() {
        this.log().debug("Creating a new ExecutionContext");
        ThreadFactory threadFactory = new ThreadFactory(null){
            private final AtomicInteger count;

            /*
             * WARNING - void declaration
             */
            public Thread newThread(Runnable r) {
                void var2_2;
                Thread thread = new Thread(r);
                thread.setName(new StringBuilder(28).append("spark-snowflake-JDBCWrapper-").append(this.count.incrementAndGet()).toString());
                thread.setDaemon(true);
                return var2_2;
            }
            {
                this.count = new AtomicInteger();
            }
        };
        this.ec = ExecutionContext$.MODULE$.fromExecutorService(Executors.newCachedThreadPool(threadFactory));
    }
}

