/*
 * Decompiled with CFR 0.152.
 */
package proguard;

import java.util.List;
import proguard.ClassPath;
import proguard.ClassPathEntry;
import proguard.io.CascadingDataEntryWriter;
import proguard.io.DataEntryNameFilter;
import proguard.io.DataEntryParentFilter;
import proguard.io.DataEntryWriter;
import proguard.io.DirectoryWriter;
import proguard.io.FilteredDataEntryWriter;
import proguard.io.JarWriter;
import proguard.io.ParentDataEntryWriter;
import proguard.util.ExtensionMatcher;
import proguard.util.FileNameParser;
import proguard.util.ListParser;

public class DataEntryWriterFactory {
    public static DataEntryWriter createDataEntryWriter(ClassPath classPath, int fromIndex, int toIndex) {
        DataEntryWriter writer = null;
        for (int index = toIndex - 1; index >= fromIndex; --index) {
            ClassPathEntry entry = classPath.get(index);
            writer = DataEntryWriterFactory.createClassPathEntryWriter(entry, writer);
        }
        return writer;
    }

    private static DataEntryWriter createClassPathEntryWriter(ClassPathEntry classPathEntry, DataEntryWriter alternativeWriter) {
        boolean isApk = classPathEntry.isApk();
        boolean isJar = classPathEntry.isJar();
        boolean isAar = classPathEntry.isAar();
        boolean isWar = classPathEntry.isWar();
        boolean isEar = classPathEntry.isEar();
        boolean isZip = classPathEntry.isZip();
        List filter = classPathEntry.getFilter();
        List apkFilter = classPathEntry.getApkFilter();
        List jarFilter = classPathEntry.getJarFilter();
        List aarFilter = classPathEntry.getAarFilter();
        List warFilter = classPathEntry.getWarFilter();
        List earFilter = classPathEntry.getEarFilter();
        List zipFilter = classPathEntry.getZipFilter();
        System.out.println("Preparing output " + (isApk ? "apk" : (isJar ? "jar" : (isAar ? "aar" : (isWar ? "war" : (isEar ? "ear" : (isZip ? "zip" : "directory")))))) + " [" + classPathEntry.getName() + "]" + (filter != null || apkFilter != null || jarFilter != null || aarFilter != null || warFilter != null || earFilter != null || zipFilter != null ? " (filtered)" : ""));
        DataEntryWriter writer = new DirectoryWriter(classPathEntry.getFile(), isApk || isJar || isAar || isWar || isEar || isZip);
        writer = DataEntryWriterFactory.wrapInJarWriter(writer, isZip, zipFilter, ".zip", isApk || isJar || isAar || isWar || isEar);
        writer = DataEntryWriterFactory.wrapInJarWriter(writer, isEar, earFilter, ".ear", isApk || isJar || isAar || isWar);
        writer = DataEntryWriterFactory.wrapInJarWriter(writer, isWar, warFilter, ".war", isApk || isJar || isAar);
        writer = DataEntryWriterFactory.wrapInJarWriter(writer, isAar, aarFilter, ".aar", isApk || isJar);
        writer = DataEntryWriterFactory.wrapInJarWriter(writer, isJar, jarFilter, ".jar", isApk);
        writer = DataEntryWriterFactory.wrapInJarWriter(writer, isApk, apkFilter, ".apk", false);
        writer = filter != null ? new FilteredDataEntryWriter(new DataEntryNameFilter(new ListParser(new FileNameParser()).parse(filter)), writer) : writer;
        return alternativeWriter != null ? new CascadingDataEntryWriter(writer, alternativeWriter) : writer;
    }

    private static DataEntryWriter wrapInJarWriter(DataEntryWriter writer, boolean isJar, List jarFilter, String jarExtension, boolean dontWrap) {
        DataEntryWriter jarWriter = dontWrap ? new ParentDataEntryWriter(writer) : new JarWriter(writer);
        DataEntryWriter filteredJarWriter = jarFilter != null ? new FilteredDataEntryWriter(new DataEntryParentFilter(new DataEntryNameFilter(new ListParser(new FileNameParser()).parse(jarFilter))), jarWriter) : jarWriter;
        return new FilteredDataEntryWriter(new DataEntryParentFilter(new DataEntryNameFilter(new ExtensionMatcher(jarExtension))), filteredJarWriter, isJar ? jarWriter : writer);
    }
}

