/*
 * Decompiled with CFR 0.152.
 */
package org.openas2.util;

import java.util.HashMap;
import java.util.Map;
import org.openas2.Component;
import org.openas2.OpenAS2Exception;
import org.openas2.Session;
import org.openas2.WrappedException;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLUtil {
    public static Component getComponent(Node node, Session session) throws OpenAS2Exception {
        Node classNameNode = node.getAttributes().getNamedItem("classname");
        if (classNameNode == null) {
            throw new OpenAS2Exception("Missing classname");
        }
        String className = classNameNode.getNodeValue();
        try {
            Class<?> objClass = Class.forName(className);
            if (!Component.class.isAssignableFrom(objClass)) {
                throw new OpenAS2Exception("Class " + className + " must implement " + Component.class.getName());
            }
            Component obj = (Component)objClass.newInstance();
            Map<String, String> parameters = XMLUtil.mapAttributes(node);
            XMLUtil.updateDirectories(session.getBaseDirectory(), parameters);
            obj.init(session, parameters);
            return obj;
        }
        catch (Exception e) {
            throw new WrappedException("Error creating component: " + className, e);
        }
    }

    public static Node findChildNode(Node parent, String childName) {
        NodeList childNodes = parent.getChildNodes();
        int childCount = childNodes.getLength();
        for (int i = 0; i < childCount; ++i) {
            Node child = childNodes.item(i);
            if (!child.getNodeName().equals(childName)) continue;
            return child;
        }
        return null;
    }

    public static Map<String, String> mapAttributeNodes(NodeList nodes, String nodeName, String nodeKeyName, String nodeValueName) throws OpenAS2Exception {
        HashMap<String, String> attributes = new HashMap<String, String>();
        int nodeCount = nodes.getLength();
        for (int i = 0; i < nodeCount; ++i) {
            Node attrNode = nodes.item(i);
            if (!attrNode.getNodeName().equals(nodeName)) continue;
            NamedNodeMap nodeAttributes = attrNode.getAttributes();
            Node tmpNode = nodeAttributes.getNamedItem(nodeKeyName);
            if (tmpNode == null) {
                throw new OpenAS2Exception(attrNode.toString() + " does not have key attribute: " + nodeKeyName);
            }
            String attrName = tmpNode.getNodeValue();
            tmpNode = nodeAttributes.getNamedItem(nodeValueName);
            if (tmpNode == null) {
                throw new OpenAS2Exception(attrNode.toString() + " does not have value attribute: " + nodeValueName);
            }
            String attrValue = tmpNode.getNodeValue();
            attributes.put(attrName, attrValue);
        }
        return attributes;
    }

    public static Map<String, String> mapAttributes(Node node, boolean keyToLowerCase) {
        HashMap<String, String> attrMap = new HashMap<String, String>();
        NamedNodeMap attrNodes = node.getAttributes();
        int attrCount = attrNodes.getLength();
        for (int i = 0; i < attrCount; ++i) {
            Node attribute = attrNodes.item(i);
            String key = attribute.getNodeName();
            if (keyToLowerCase) {
                key = key.toLowerCase();
            }
            attrMap.put(key, attribute.getNodeValue());
        }
        return attrMap;
    }

    public static Map<String, String> mapAttributes(Node node) {
        return XMLUtil.mapAttributes(node, true);
    }

    public static Map<String, String> mapAttributes(Node node, String[] requiredAttributes) throws OpenAS2Exception {
        Map<String, String> attributes = XMLUtil.mapAttributes(node);
        for (String requiredAttribute : requiredAttributes) {
            String attrName = requiredAttribute;
            if (attributes.get(attrName) != null) continue;
            throw new OpenAS2Exception(node.toString() + " is missing required attribute: " + attrName);
        }
        return attributes;
    }

    private static void updateDirectories(String baseDirectory, Map<String, String> attributes) throws OpenAS2Exception {
        for (Map.Entry<String, String> attrEntry : attributes.entrySet()) {
            String value = attrEntry.getValue();
            if (!value.startsWith("%home%")) continue;
            if (baseDirectory != null) {
                value = baseDirectory + value.substring(6);
                attributes.put(attrEntry.getKey(), value);
                continue;
            }
            throw new OpenAS2Exception("Base directory isn't set");
        }
    }
}

