/*
 * Decompiled with CFR 0.152.
 */
package org.openas2.processor.sender;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.mail.Header;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.LogFactory;
import org.openas2.OpenAS2Exception;
import org.openas2.WrappedException;
import org.openas2.logging.Log;
import org.openas2.message.AS2Message;
import org.openas2.message.Message;
import org.openas2.message.MessageMDN;
import org.openas2.processor.sender.HttpResponseException;
import org.openas2.processor.sender.HttpSenderModule;
import org.openas2.util.AS2Util;
import org.openas2.util.DateUtil;
import org.openas2.util.DispositionType;
import org.openas2.util.IOUtilOld;
import org.openas2.util.Profiler;
import org.openas2.util.ProfilerStub;
import org.openas2.util.Properties;

public class AsynchMDNSenderModule
extends HttpSenderModule {
    private org.apache.commons.logging.Log logger = LogFactory.getLog((String)AsynchMDNSenderModule.class.getSimpleName());

    @Override
    public boolean canHandle(String action, Message msg, Map<Object, Object> options) {
        if (!action.equals("sendmdn")) {
            return false;
        }
        return msg instanceof AS2Message;
    }

    @Override
    public void handle(String action, Message msg, Map<Object, Object> options) throws OpenAS2Exception {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"ASYNC MDN send started...");
        }
        if (options == null) {
            options = new HashMap<Object, Object>();
        }
        options.put("DIRECTION", "RECEIVE");
        this.sendAsyncMDN((AS2Message)msg, options);
    }

    protected void updateHttpHeaders(HttpURLConnection conn, Message msg) {
        MessageMDN mdn = msg.getMDN();
        conn.setRequestProperty("Connection", "close, TE");
        conn.setRequestProperty("User-Agent", msg.getAppTitle() + " (AsynchMDNSender)");
        conn.setRequestProperty("Date", DateUtil.formatDate(Properties.getProperty("HTTP_HEADER_DATE_FORMAT", "EEE, dd MMM yyyy HH:mm:ss Z"), Locale.ENGLISH));
        conn.setRequestProperty("Message-ID", msg.getMessageID());
        conn.setRequestProperty("Mime-Version", "1.0");
        conn.setRequestProperty("Content-type", msg.getHeader("Content-type"));
        conn.setRequestProperty("AS2-Version", "1.1");
        conn.setRequestProperty("Recipient-Address", msg.getHeader("Recipient-Address"));
        conn.setRequestProperty("AS2-To", mdn.getHeader("AS2-To"));
        conn.setRequestProperty("AS2-From", mdn.getHeader("AS2-From"));
        conn.setRequestProperty("Subject", msg.getHeader("Subject"));
        conn.setRequestProperty("From", mdn.getHeader("From"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendAsyncMDN(AS2Message msg, Map<Object, Object> options) throws OpenAS2Exception {
        DispositionType disposition = new DispositionType("automatic-action", "MDN-sent-automatically", "processed");
        String url = msg.getAsyncMDNurl();
        try {
            MessageMDN mdn = msg.getMDN();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("ASYNC MDN attempting connection to: " + url + msg.getLogMsgID()));
            }
            HttpURLConnection conn = this.getConnection(url, true, true, false, "POST");
            try {
                if (this.logger.isInfoEnabled()) {
                    this.logger.info((Object)("connected to " + url + msg.getLogMsgID()));
                }
                conn.setRequestProperty("Connection", "close, TE");
                conn.setRequestProperty("User-Agent", msg.getAppTitle() + " (AsyncMDNSenderModule)");
                Enumeration headers = mdn.getHeaders().getAllHeaders();
                Header header = null;
                while (headers.hasMoreElements()) {
                    header = (Header)headers.nextElement();
                    String headerValue = header.getValue();
                    headerValue.replace('\t', ' ');
                    headerValue.replace('\n', ' ');
                    headerValue.replace('\r', ' ');
                    conn.setRequestProperty(header.getName(), headerValue);
                    if (!this.logger.isTraceEnabled()) continue;
                    this.logger.trace((Object)("Set HTTP response request property: " + header.getName() + " -> " + headerValue + msg.getLogMsgID()));
                }
                OutputStream messageOut = conn.getOutputStream();
                InputStream messageIn = mdn.getData().getInputStream();
                try {
                    ProfilerStub transferStub = Profiler.startProfile();
                    int bytes = IOUtils.copy((InputStream)messageIn, (OutputStream)messageOut);
                    Profiler.endProfile(transferStub);
                    if (this.logger.isInfoEnabled()) {
                        this.logger.info((Object)("transferred " + IOUtilOld.getTransferRate(bytes, transferStub) + msg.getLogMsgID()));
                    }
                }
                finally {
                    messageIn.close();
                }
                int respCode = conn.getResponseCode();
                if (respCode != 200 && respCode != 201 && respCode != 202 && respCode != 206 && respCode != 204) {
                    if (this.logger.isErrorEnabled()) {
                        msg.setLogMsg("Error sending AsyncMDN [" + disposition.toString() + "] HTTP response code: " + respCode);
                        this.logger.error((Object)msg);
                    }
                    throw new HttpResponseException(url.toString(), respCode, conn.getResponseMessage());
                }
                if (this.logger.isInfoEnabled()) {
                    this.logger.info((Object)("sent AsyncMDN [" + disposition.toString() + "] OK " + msg.getLogMsgID()));
                }
                this.getSession().getProcessor().handle("storemdn", msg, null);
                msg.setOption("STATE", "msg_rxd_mdn_sent_ok");
                msg.trackMsgState(this.getSession());
            }
            finally {
                conn.disconnect();
            }
        }
        catch (HttpResponseException hre) {
            this.logger.warn((Object)("HTTP exception sending ASYNC MDN: " + Log.getExceptionMsg(hre) + msg.getLogMsgID()), (Throwable)hre);
            hre.terminate();
            this.resend(msg, hre);
            msg.setOption("STATE", "mdn_sending_exception");
            msg.trackMsgState(this.getSession());
        }
        catch (IOException ioe) {
            this.logger.warn((Object)("IO exception sending ASYNC MDN: " + Log.getExceptionMsg(ioe) + msg.getLogMsgID()), (Throwable)ioe);
            WrappedException wioe = new WrappedException(ioe);
            wioe.addSource("message", msg);
            wioe.terminate();
            this.resend(msg, wioe);
            msg.setOption("STATE", "mdn_sending_exception");
            msg.trackMsgState(this.getSession());
        }
        catch (Exception e) {
            this.logger.warn((Object)("Unexpected exception sending ASYNC MDN: " + Log.getExceptionMsg(e) + msg.getLogMsgID()), (Throwable)e);
            this.getSession().getProcessor().handle("storemdn", msg, null);
            msg.setOption("STATE", "mdn_sending_exception");
            msg.trackMsgState(this.getSession());
            throw new WrappedException(e);
        }
    }

    protected void resend(Message msg, OpenAS2Exception cause) throws OpenAS2Exception {
        Map<Object, Object> msgOptions = msg.getOptions();
        String tries = AS2Util.retries(msgOptions, this.getParameter("retries", false));
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("MDN resend retries: MSG - " + msgOptions.get("retries") + "   ::: RETRIES - " + tries));
        }
        int retries = -1;
        if (tries == null) {
            tries = "-1";
        }
        try {
            retries = Integer.parseInt(tries);
        }
        catch (Exception e) {
            msg.setLogMsg("The retry count is not a valid integer value: " + tries);
            this.logger.error((Object)msg);
        }
        if (msgOptions.get("retries") == null) {
            msgOptions.put("retries", retries);
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Send MDN retry count: " + retries));
        }
        if (retries >= 0 && retries-- <= 0) {
            msg.setLogMsg("MDN response abandoned after retry limit reached.");
            this.logger.error((Object)msg);
            msg.setOption("STATE", "msg_rxd_mdn_sending_fail");
            msg.trackMsgState(this.getSession());
            AS2Util.cleanupFiles(msg, false);
            throw new OpenAS2Exception("MDN response abandoned after retry limit reached." + msg.getLogMsgID());
        }
        HashMap<Object, Object> options = new HashMap<Object, Object>();
        options.put("cause", cause);
        options.put("initial_sender", this);
        options.put("resend_method", "sendmdn");
        options.put("retries", "" + retries);
        this.getSession().getProcessor().handle("resend", msg, options);
    }
}

