/*
 * Decompiled with CFR 0.152.
 */
package org.openas2.lib.helper;

import java.security.Key;
import java.security.cert.Certificate;
import javax.mail.internet.MimeBodyPart;
import org.openas2.lib.CryptoException;
import org.openas2.lib.helper.ICryptoHelper;
import org.openas2.lib.message.EDIINTMessage;
import org.openas2.message.Message;
import org.openas2.partner.Partnership;

public class EDIINTHelper {
    private ICryptoHelper cryptoHelper;

    public EDIINTHelper(ICryptoHelper crypto) {
        this.setCryptoHelper(crypto);
    }

    public void encrypt(EDIINTMessage msg, Certificate cert, String algorithm) throws CryptoException {
        try {
            MimeBodyPart data = msg.getData();
            String contentTxfrEncoding = ((Message)((Object)msg)).getPartnership().getAttribute("content_transfer_encoding");
            if (contentTxfrEncoding == null) {
                contentTxfrEncoding = "binary";
            }
            MimeBodyPart encryptedData = this.getCryptoHelper().encrypt(data, cert, algorithm, contentTxfrEncoding);
            msg.setData(encryptedData);
            msg.setContentType(encryptedData.getContentType());
            msg.setHeader("Content-Transfer-Encoding", encryptedData.getEncoding());
        }
        catch (Exception e) {
            throw new CryptoException("Encryption failed", e);
        }
    }

    public void decrypt(EDIINTMessage msg, Certificate cert, Key key) throws CryptoException {
        try {
            ICryptoHelper crypto = this.getCryptoHelper();
            MimeBodyPart data = msg.getData();
            if (!crypto.isEncrypted(data)) {
                throw new CryptoException("Data is not encrypted");
            }
            MimeBodyPart decryptedData = crypto.decrypt(data, cert, key);
            msg.setData(decryptedData);
            msg.setContentType(decryptedData.getContentType());
            msg.setHeader("Content-Transfer-Encoding", decryptedData.getEncoding());
        }
        catch (Exception e) {
            throw new CryptoException("Decryption failed", e);
        }
    }

    public void sign(EDIINTMessage msg, Certificate cert, Key key, String digest) throws CryptoException {
        try {
            MimeBodyPart data = msg.getData();
            Partnership p = ((Message)((Object)msg)).getPartnership();
            String contentTxfrEncoding = p.getAttribute("content_transfer_encoding");
            boolean isRemoveCmsAlgorithmProtectionAttr = "true".equalsIgnoreCase(p.getAttribute("remove_cms_algorithm_protection_attrib"));
            if (contentTxfrEncoding == null) {
                contentTxfrEncoding = "binary";
            }
            MimeBodyPart signedData = this.getCryptoHelper().sign(data, cert, key, digest, contentTxfrEncoding, false, isRemoveCmsAlgorithmProtectionAttr);
            msg.setData(signedData);
            msg.setContentType(signedData.getContentType());
            String contentTxfrEnc = signedData.getEncoding();
            if (contentTxfrEnc == null) {
                contentTxfrEnc = "binary";
            }
            msg.setHeader("Content-Transfer-Encoding", contentTxfrEnc);
        }
        catch (Exception e) {
            throw new CryptoException("Sign failed", e);
        }
    }

    public void verify(EDIINTMessage msg, Certificate cert) throws CryptoException {
        try {
            ICryptoHelper crypto = this.getCryptoHelper();
            MimeBodyPart data = msg.getData();
            if (!crypto.isSigned(data)) {
                throw new CryptoException("Data is not signed");
            }
            MimeBodyPart verifiedData = crypto.verifySignature(data, cert);
            msg.setData(verifiedData);
            msg.setContentType(verifiedData.getContentType());
        }
        catch (Exception e) {
            throw new CryptoException("Verify failed", e);
        }
    }

    public boolean isEncrypted(EDIINTMessage msg) throws CryptoException {
        try {
            return this.getCryptoHelper().isEncrypted(msg.getData());
        }
        catch (Exception e) {
            throw new CryptoException("Error detecting encryption", e);
        }
    }

    public boolean isSigned(EDIINTMessage msg) throws CryptoException {
        try {
            return this.getCryptoHelper().isSigned(msg.getData());
        }
        catch (Exception e) {
            throw new CryptoException("Error detecting signature", e);
        }
    }

    public ICryptoHelper getCryptoHelper() {
        return this.cryptoHelper;
    }

    public void setCryptoHelper(ICryptoHelper cryptoHelper) {
        this.cryptoHelper = cryptoHelper;
    }
}

