/*
 * Decompiled with CFR 0.152.
 */
package org.openas2.lib;

import org.openas2.lib.OpenAS2Exception;
import org.openas2.lib.partner.IPartnership;

public class EngineResults {
    public static final int STATUS_NONE = 0;
    public static final int STATUS_OK = 1;
    public static final int STATUS_ERROR = 2;
    private OpenAS2Exception exception;
    private IPartnership partnership;
    private int encryption;
    private int signature;

    public IPartnership getPartnership() {
        return this.partnership;
    }

    public void setPartnership(IPartnership partnership) {
        this.partnership = partnership;
    }

    public int getEncryption() {
        return this.encryption;
    }

    public void setEncryption(int encryption) {
        this.encryption = encryption;
    }

    public OpenAS2Exception getException() {
        return this.exception;
    }

    public void setException(OpenAS2Exception exception) {
        this.exception = exception;
    }

    public int getSignature() {
        return this.signature;
    }

    public void setSignature(int signature) {
        this.signature = signature;
    }

    public boolean errorOccurred() {
        if (this.getException() != null) {
            return true;
        }
        if (this.getPartnership() == null) {
            return true;
        }
        if (this.getEncryption() == 2) {
            return true;
        }
        return this.getSignature() == 2;
    }

    public String getStatusDescription(int status) {
        switch (status) {
            case 0: {
                return "None";
            }
            case 1: {
                return "Ok";
            }
            case 2: {
                return "Error";
            }
        }
        return "Unknown";
    }

    public String getDisposition() {
        if (!this.errorOccurred()) {
            return "automatic-action/MDN-sent-automatically; processed";
        }
        if (this.getPartnership() == null) {
            return "automatic-action/MDN-sent-automatically; processed/Error: authentication-failed";
        }
        if (this.getEncryption() == 2) {
            return "automatic-action/MDN-sent-automatically; processed/Error: decryption-failed";
        }
        if (this.getSignature() == 2) {
            return "automatic-action/MDN-sent-automatically; processed/Error: integrity-check-failed";
        }
        return "automatic-action/MDN-sent-automatically; processed/Error: unexpected-processing-error";
    }

    public String toString() {
        StringBuffer strBuf = new StringBuffer();
        strBuf.append("Partnership: ").append(this.getPartnership());
        strBuf.append("  Encryption: ").append(this.getStatusDescription(this.getEncryption()));
        strBuf.append("  Signature: ").append(this.getStatusDescription(this.getSignature()));
        if (this.getException() != null) {
            strBuf.append("  Exception: ").append(this.getException().toString());
        }
        return strBuf.toString();
    }
}

