/*
 * Decompiled with CFR 0.152.
 */
package org.openas2;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openas2.BaseSession;
import org.openas2.Component;
import org.openas2.OpenAS2Exception;
import org.openas2.cert.CertificateFactory;
import org.openas2.cmd.CommandManager;
import org.openas2.cmd.CommandRegistry;
import org.openas2.cmd.processor.BaseCommandProcessor;
import org.openas2.logging.LogManager;
import org.openas2.logging.Logger;
import org.openas2.partner.PartnershipFactory;
import org.openas2.processor.Processor;
import org.openas2.processor.ProcessorModule;
import org.openas2.schedule.SchedulerComponent;
import org.openas2.util.Properties;
import org.openas2.util.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XMLSession
extends BaseSession {
    private static final String EL_PROPERTIES = "properties";
    private static final String EL_CERTIFICATES = "certificates";
    private static final String EL_CMDPROCESSOR = "commandProcessors";
    private static final String EL_PROCESSOR = "processor";
    private static final String EL_PARTNERSHIPS = "partnerships";
    private static final String EL_COMMANDS = "commands";
    private static final String EL_LOGGERS = "loggers";
    private static final String PARAM_BASE_DIRECTORY = "basedir";
    private CommandRegistry commandRegistry;
    private CommandManager cmdManager = new CommandManager();
    private String VERSION;
    private String TITLE;
    private static final Log LOGGER = LogFactory.getLog((String)XMLSession.class.getSimpleName());

    public XMLSession(String configAbsPath) throws OpenAS2Exception, ParserConfigurationException, SAXException, IOException {
        File configXml = new File(configAbsPath);
        File configDir = configXml.getParentFile();
        FileInputStream configAsStream = new FileInputStream(configXml);
        this.setBaseDirectory(configDir.getAbsolutePath());
        this.load(configAsStream);
        this.addSchedulerComponent();
    }

    private void addSchedulerComponent() throws OpenAS2Exception {
        SchedulerComponent comp = new SchedulerComponent();
        this.setComponent("scheduler", comp);
        comp.init(this, Collections.<String, String>emptyMap());
    }

    protected void load(InputStream in) throws ParserConfigurationException, SAXException, IOException, OpenAS2Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder parser = factory.newDocumentBuilder();
        Document document = parser.parse(in);
        Element root = document.getDocumentElement();
        NodeList rootNodes = root.getChildNodes();
        LOGGER.info((Object)"Loading configuration...");
        for (int i = 0; i < rootNodes.getLength(); ++i) {
            Node rootNode = rootNodes.item(i);
            String nodeName = rootNode.getNodeName();
            if (nodeName.equals(EL_PROPERTIES)) {
                this.loadProperties(rootNode);
                continue;
            }
            if (nodeName.equals(EL_CERTIFICATES)) {
                this.loadCertificates(rootNode);
                continue;
            }
            if (nodeName.equals(EL_PROCESSOR)) {
                this.loadProcessor(rootNode);
                continue;
            }
            if (nodeName.equals(EL_CMDPROCESSOR)) {
                this.loadCommandProcessors(rootNode);
                continue;
            }
            if (nodeName.equals(EL_PARTNERSHIPS)) {
                this.loadPartnerships(rootNode);
                continue;
            }
            if (nodeName.equals(EL_COMMANDS)) {
                this.loadCommands(rootNode);
                continue;
            }
            if (nodeName.equals(EL_LOGGERS)) {
                this.loadLoggers(rootNode);
                continue;
            }
            if (nodeName.equals("#text") || nodeName.equals("#comment")) continue;
            throw new OpenAS2Exception("Undefined tag: " + nodeName);
        }
        this.cmdManager.registerCommands(this.commandRegistry);
    }

    private void loadProperties(Node propNode) {
        LOGGER.info((Object)"Loading properties...");
        Map<String, String> properties = XMLUtil.mapAttributes(propNode, false);
        properties.put(Properties.APP_TITLE_PROP, this.getAppTitle());
        properties.put(Properties.APP_VERSION_PROP, this.getAppVersion());
        Properties.setProperties(properties);
    }

    private void loadCertificates(Node rootNode) throws OpenAS2Exception {
        CertificateFactory certFx = (CertificateFactory)XMLUtil.getComponent(rootNode, this);
        this.setComponent("certificatefactory", certFx);
    }

    private void loadCommands(Node rootNode) throws OpenAS2Exception {
        Component component = XMLUtil.getComponent(rootNode, this);
        this.commandRegistry = (CommandRegistry)component;
    }

    private void loadLoggers(Node rootNode) throws OpenAS2Exception {
        LOGGER.info((Object)"Loading log manager(s)...");
        LogManager manager = LogManager.getLogManager();
        if (!LogManager.isRegisteredWithApache()) {
            throw new OpenAS2Exception("the OpenAS2 loggers' log manager must registered with the jvm argument -Dorg.apache.commons.logging.Log=org.openas2.logging.Log");
        }
        NodeList loggers = rootNode.getChildNodes();
        for (int i = 0; i < loggers.getLength(); ++i) {
            Node logger = loggers.item(i);
            if (!logger.getNodeName().equals("logger")) continue;
            this.loadLogger(manager, logger);
        }
    }

    private void loadLogger(LogManager manager, Node loggerNode) throws OpenAS2Exception {
        Logger logger = (Logger)XMLUtil.getComponent(loggerNode, this);
        manager.addLogger(logger);
    }

    private void loadCommandProcessors(Node rootNode) throws OpenAS2Exception {
        LOGGER.info((Object)"Loading command processor(s)...");
        NodeList cmdProcessor = rootNode.getChildNodes();
        for (int i = 0; i < cmdProcessor.getLength(); ++i) {
            Node processor = cmdProcessor.item(i);
            if (!processor.getNodeName().equals("commandProcessor")) continue;
            this.loadCommandProcessor(this.cmdManager, processor);
        }
    }

    private void loadCommandProcessor(CommandManager manager, Node cmdPrcessorNode) throws OpenAS2Exception {
        BaseCommandProcessor cmdProcesor = (BaseCommandProcessor)XMLUtil.getComponent(cmdPrcessorNode, this);
        manager.addProcessor(cmdProcesor);
        this.setComponent(cmdProcesor.getName(), cmdProcesor);
    }

    private void loadPartnerships(Node rootNode) throws OpenAS2Exception {
        LOGGER.info((Object)"Loading partnerships...");
        PartnershipFactory partnerFx = (PartnershipFactory)XMLUtil.getComponent(rootNode, this);
        this.setComponent("partnershipfactory", partnerFx);
    }

    private void loadProcessor(Node rootNode) throws OpenAS2Exception {
        Processor proc = (Processor)XMLUtil.getComponent(rootNode, this);
        this.setComponent(EL_PROCESSOR, proc);
        LOGGER.info((Object)"Loading processor modules...");
        NodeList modules = rootNode.getChildNodes();
        for (int i = 0; i < modules.getLength(); ++i) {
            Node module = modules.item(i);
            if (!module.getNodeName().equals("module")) continue;
            this.loadProcessorModule(proc, module);
        }
    }

    private void loadProcessorModule(Processor proc, Node moduleNode) throws OpenAS2Exception {
        ProcessorModule procmod = (ProcessorModule)XMLUtil.getComponent(moduleNode, this);
        proc.getModules().add(procmod);
    }

    @Nullable
    private String getManifestAttribValue(@Nonnull String attrib) {
        try {
            Enumeration<URL> resEnum = Thread.currentThread().getContextClassLoader().getResources("META-INF/MANIFEST.MF");
            while (resEnum.hasMoreElements()) {
                try {
                    Manifest manifest;
                    Attributes mainAttribs;
                    String value;
                    InputStream is;
                    URL url = resEnum.nextElement();
                    if (!url.getPath().contains("openas2") || (is = url.openStream()) == null || (value = (mainAttribs = (manifest = new Manifest(is)).getMainAttributes()).getValue(attrib)) == null) continue;
                    return value;
                }
                catch (Exception e) {
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public String getAppVersion() {
        if (this.VERSION == null) {
            this.VERSION = this.getManifestAttribValue("Implementation-Version");
        }
        return this.VERSION;
    }

    @Override
    public String getAppTitle() {
        if (this.TITLE == null) {
            this.TITLE = this.getManifestAttribValue("Implementation-Title") + " v" + this.getAppVersion();
        }
        return this.TITLE;
    }
}

