/*
 * Decompiled with CFR 0.152.
 */
package com.gc.iotools.stream.is;

import java.io.IOException;
import java.io.InputStream;

public class SizeLimitInputStream
extends InputStream {
    private boolean closed = false;
    protected long currentPosition = 0L;
    protected InputStream in;
    protected long markPosition = 0L;
    protected final long maxSize;

    public SizeLimitInputStream(InputStream in, long maxSize) {
        this.in = in;
        this.maxSize = maxSize;
    }

    @Override
    public int available() throws IOException {
        return Math.min(this.in.available(), (int)this.getBytesLeft());
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            this.closed = true;
            this.in.close();
        }
    }

    public long getBytesLeft() {
        return this.maxSize - this.currentPosition;
    }

    public long getBytesRead() {
        return this.currentPosition;
    }

    public long getMaxSize() {
        return this.maxSize;
    }

    @Override
    public void mark(int readlimit) {
        this.in.mark(readlimit);
        this.markPosition = this.currentPosition;
    }

    @Override
    public boolean markSupported() {
        return this.in.markSupported();
    }

    @Override
    public int read() throws IOException {
        int result;
        if (this.currentPosition >= this.maxSize) {
            result = -1;
        } else {
            result = this.in.read();
            if (result >= 0) {
                ++this.currentPosition;
            }
        }
        return result;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int bytesRead;
        if (this.currentPosition >= this.maxSize) {
            bytesRead = -1;
        } else {
            int n = (int)Math.min(this.getBytesLeft(), (long)len);
            bytesRead = this.in.read(b, off, n);
            if (bytesRead > 0) {
                this.currentPosition += (long)bytesRead;
            }
        }
        return bytesRead;
    }

    @Override
    public void reset() throws IOException {
        this.in.reset();
        this.currentPosition = this.markPosition;
        this.markPosition = 0L;
    }

    @Override
    public long skip(long n) throws IOException {
        long result;
        if (this.currentPosition >= this.maxSize) {
            result = -1L;
        } else {
            result = this.in.skip(Math.min(n, this.getBytesLeft()));
            if (result > 0L) {
                this.currentPosition += result;
            }
        }
        return result;
    }
}

