/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.hibernate;

import jakarta.persistence.Tuple;
import java.util.Iterator;
import java.util.List;
import net.sf.jasperreports.engine.JRRewindableDataSource;
import net.sf.jasperreports.hibernate.JRHibernateAbstractDataSource;
import net.sf.jasperreports.hibernate.JRHibernateQueryExecuter;

public class JRHibernateListDataSource
extends JRHibernateAbstractDataSource
implements JRRewindableDataSource {
    private final int pageSize;
    private int pageCount;
    private boolean nextPage;
    private List<Tuple> returnValues;
    private Iterator<Tuple> iterator;

    public JRHibernateListDataSource(JRHibernateQueryExecuter queryExecuter, boolean useFieldDescription, int pageSize) {
        super(queryExecuter, useFieldDescription);
        this.pageSize = pageSize;
        this.pageCount = 0;
        this.fetchPage();
    }

    protected void fetchPage() {
        if (this.pageSize <= 0) {
            this.returnValues = this.queryExecuter.list();
            this.nextPage = false;
        } else {
            this.returnValues = this.queryExecuter.list(this.pageCount * this.pageSize, this.pageSize);
            this.nextPage = this.returnValues.size() == this.pageSize;
        }
        ++this.pageCount;
        this.initIterator();
    }

    public boolean next() {
        if (this.iterator == null) {
            return false;
        }
        boolean hasNext = this.iterator.hasNext();
        if (!hasNext && this.nextPage) {
            this.fetchPage();
            boolean bl = hasNext = this.iterator != null && this.iterator.hasNext();
        }
        if (hasNext) {
            this.setCurrentRowValue(this.iterator.next());
        }
        return hasNext;
    }

    public void moveFirst() {
        if (this.pageCount == 1) {
            this.initIterator();
        } else {
            this.pageCount = 0;
            this.fetchPage();
        }
    }

    private void initIterator() {
        this.iterator = this.returnValues == null ? null : this.returnValues.iterator();
    }
}

