/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.web.domassign;

import cz.vutbr.web.css.CSSFactory;
import cz.vutbr.web.css.CombinedSelector;
import cz.vutbr.web.css.Declaration;
import cz.vutbr.web.css.MatchCondition;
import cz.vutbr.web.css.MediaSpec;
import cz.vutbr.web.css.NodeData;
import cz.vutbr.web.css.RuleSet;
import cz.vutbr.web.css.Selector;
import cz.vutbr.web.css.StyleSheet;
import cz.vutbr.web.csskit.ElementUtil;
import cz.vutbr.web.domassign.Analyzer;
import cz.vutbr.web.domassign.AssignedDeclaration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DirectAnalyzer
extends Analyzer {
    private static final Logger log = LoggerFactory.getLogger(DirectAnalyzer.class);

    public DirectAnalyzer(StyleSheet sheet) {
        super(sheet);
    }

    public DirectAnalyzer(List<StyleSheet> sheets) {
        super(sheets);
    }

    public NodeData getElementStyle(Element el, Selector.PseudoDeclaration pseudo, MediaSpec media) {
        if (this.rules == null) {
            this.classifyAllSheets(media);
        }
        List<Declaration> decls = this.getDeclarationsForElement(el, pseudo, this.rules);
        NodeData main = CSSFactory.createNodeData();
        for (Declaration d : decls) {
            main.push(d);
        }
        return main;
    }

    public NodeData getElementStyle(Element el, Selector.PseudoDeclaration pseudo, String media) {
        return this.getElementStyle(el, pseudo, new MediaSpec(media));
    }

    protected List<Declaration> getDeclarationsForElement(Element e, Selector.PseudoDeclaration pseudo, Analyzer.Holder holder) {
        List<Analyzer.OrderedRule> rules;
        List<Analyzer.OrderedRule> rules2;
        if (log.isDebugEnabled()) {
            log.debug("Traversal of {} {}.", (Object)e.getNodeName(), (Object)e.getNodeValue());
        }
        HashSet<Analyzer.OrderedRule> candidates = new HashSet<Analyzer.OrderedRule>();
        for (String cname : ElementUtil.elementClasses(e)) {
            rules2 = holder.get(Analyzer.HolderItem.CLASS, cname.toLowerCase());
            if (rules2 == null) continue;
            candidates.addAll(rules2);
        }
        log.trace("After CLASSes {} total candidates.", (Object)candidates.size());
        String id = ElementUtil.elementID(e);
        if (id != null && id.length() != 0 && (rules = holder.get(Analyzer.HolderItem.ID, id.toLowerCase())) != null) {
            candidates.addAll(rules);
        }
        log.trace("After IDs {} total candidates.", (Object)candidates.size());
        String name = ElementUtil.elementName(e);
        if (name != null && (rules2 = holder.get(Analyzer.HolderItem.ELEMENT, name.toLowerCase())) != null) {
            candidates.addAll(rules2);
        }
        log.trace("After ELEMENTs {} total candidates.", (Object)candidates.size());
        candidates.addAll(holder.get(Analyzer.HolderItem.OTHER, null));
        ArrayList clist = new ArrayList(candidates);
        Collections.sort(clist);
        log.debug("Totally {} candidates.", (Object)candidates.size());
        log.trace("With values: {}", clist);
        ArrayList<Declaration> eldecl = new ArrayList<Declaration>();
        for (Analyzer.OrderedRule orule : clist) {
            RuleSet rule = orule.getRule();
            StyleSheet sheet = rule.getStyleSheet();
            StyleSheet.Origin origin = sheet == null ? StyleSheet.Origin.AGENT : sheet.getOrigin();
            for (CombinedSelector s : rule.getSelectors()) {
                if (!this.matchSelector(s, e)) {
                    log.trace("CombinedSelector \"{}\" NOT matched!", (Object)s);
                    continue;
                }
                log.trace("CombinedSelector \"{}\" matched", (Object)s);
                Selector.PseudoDeclaration psel = s.getPseudoElement();
                CombinedSelector.Specificity spec = s.computeSpecificity();
                if (psel != pseudo) continue;
                for (Declaration d : rule) {
                    eldecl.add(new AssignedDeclaration(d, spec, origin));
                }
            }
        }
        Collections.sort(eldecl);
        log.debug("Sorted {} declarations.", (Object)eldecl.size());
        log.trace("With values: {}", eldecl);
        return eldecl;
    }

    private boolean nodeSelectorMatches(Selector s, Node n) {
        if (n.getNodeType() == 1) {
            Element e = (Element)n;
            MatchCondition matchCond = this.getMatchCondition();
            return matchCond == null ? s.matches(e) : s.matches(e, matchCond);
        }
        return false;
    }

    protected boolean matchSelector(CombinedSelector sel, Element e) {
        boolean retval = false;
        Selector.Combinator combinator = null;
        Element current = e;
        for (int i = sel.size() - 1; i >= 0; --i) {
            Selector s = (Selector)sel.get(i);
            log.trace("Iterating loop with selector {}, combinator {}", (Object)s, combinator);
            if (combinator == null) {
                retval = this.elementSelectorMatches(s, current);
            } else if (combinator == Selector.Combinator.ADJACENT) {
                Node adjacent = current;
                while ((adjacent = adjacent.getPreviousSibling()) != null && adjacent.getNodeType() != 1) {
                }
                retval = false;
                if (adjacent != null && adjacent.getNodeType() == 1) {
                    current = (Element)adjacent;
                    retval = this.elementSelectorMatches(s, current);
                }
            } else if (combinator == Selector.Combinator.PRECEDING) {
                Node preceding = current.getPreviousSibling();
                retval = false;
                do {
                    if (preceding == null) continue;
                    if (this.nodeSelectorMatches(s, preceding)) {
                        current = (Element)preceding;
                        retval = true;
                        continue;
                    }
                    preceding = preceding.getPreviousSibling();
                } while (!retval && preceding != null);
            } else if (combinator == Selector.Combinator.DESCENDANT) {
                Node ancestor = current.getParentNode();
                retval = false;
                do {
                    if (ancestor == null) continue;
                    if (this.nodeSelectorMatches(s, ancestor)) {
                        current = (Element)ancestor;
                        retval = true;
                        continue;
                    }
                    ancestor = ancestor.getParentNode();
                } while (!retval && ancestor != null);
            } else if (combinator == Selector.Combinator.CHILD) {
                Node parent = current.getParentNode();
                retval = false;
                if (parent != null && parent.getNodeType() == 1) {
                    current = (Element)parent;
                    retval = this.elementSelectorMatches(s, current);
                }
            }
            combinator = s.getCombinator();
            if (!retval) break;
        }
        return retval;
    }
}

