/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.web.csskit.antlr;

import cz.vutbr.web.css.CSSException;
import cz.vutbr.web.css.CSSFactory;
import cz.vutbr.web.css.MediaQuery;
import cz.vutbr.web.css.NetworkProcessor;
import cz.vutbr.web.css.RuleList;
import cz.vutbr.web.css.StyleSheet;
import cz.vutbr.web.csskit.antlr.CSSInputStream;
import cz.vutbr.web.csskit.antlr.CSSLexer;
import cz.vutbr.web.csskit.antlr.CSSParser;
import cz.vutbr.web.csskit.antlr.CSSTreeParser;
import cz.vutbr.web.csskit.antlr.Preparator;
import cz.vutbr.web.csskit.antlr.SimplePreparator;
import cz.vutbr.web.csskit.antlr.TreeUtil;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.antlr.runtime.tree.CommonTree;
import org.antlr.runtime.tree.CommonTreeNodeStream;
import org.antlr.runtime.tree.TreeNodeStream;
import org.fit.net.DataURLHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class CSSParserFactory {
    private static final Logger log = LoggerFactory.getLogger(CSSParserFactory.class);

    private CSSParserFactory() {
        throw new AssertionError();
    }

    public static StyleSheet parse(Object source, NetworkProcessor network, String encoding, SourceType type, Element inline, boolean inlinePriority, URL base) throws IOException, CSSException {
        StyleSheet sheet = (StyleSheet)CSSFactory.getRuleFactory().createStyleSheet().unlock();
        SimplePreparator preparator = new SimplePreparator(inline, inlinePriority);
        StyleSheet ret = CSSParserFactory.parseAndImport(source, network, encoding, type, sheet, preparator, base, null);
        return ret;
    }

    public static StyleSheet parse(Object source, NetworkProcessor network, String encoding, SourceType type, URL base) throws IOException, CSSException {
        if (type == SourceType.INLINE) {
            throw new IllegalArgumentException("Missing element for INLINE input");
        }
        return CSSParserFactory.parse(source, network, encoding, type, null, false, base);
    }

    public static StyleSheet append(Object source, NetworkProcessor network, String encoding, SourceType type, Element inline, boolean inlinePriority, StyleSheet sheet, URL base) throws IOException, CSSException {
        SimplePreparator preparator = new SimplePreparator(inline, inlinePriority);
        StyleSheet ret = CSSParserFactory.parseAndImport(source, network, encoding, type, sheet, preparator, base, null);
        return ret;
    }

    public static StyleSheet append(Object source, NetworkProcessor network, String encoding, SourceType type, StyleSheet sheet, URL base) throws IOException, CSSException {
        if (type == SourceType.INLINE) {
            throw new IllegalArgumentException("Missing element for INLINE input");
        }
        return CSSParserFactory.append(source, network, encoding, type, null, false, sheet, base);
    }

    private static StyleSheet parseAndImport(Object source, NetworkProcessor network, String encoding, SourceType type, StyleSheet sheet, Preparator preparator, URL base, List<MediaQuery> media) throws CSSException, IOException {
        CSSTreeParser parser = CSSParserFactory.createTreeParser(source, network, encoding, type, preparator, base, media);
        type.parse(parser);
        for (int i = 0; i < parser.getImportPaths().size(); ++i) {
            String path = parser.getImportPaths().get(i);
            List<MediaQuery> imedia = parser.getImportMedia().get(i);
            if ((imedia == null || imedia.isEmpty()) && CSSFactory.getAutoImportMedia().matchesEmpty() || CSSFactory.getAutoImportMedia().matchesOneOf(imedia)) {
                URL url = DataURLHandler.createURL(base, path);
                try {
                    CSSParserFactory.parseAndImport(url, network, encoding, SourceType.URL, sheet, preparator, url, imedia);
                }
                catch (IOException e) {
                    log.warn("Couldn't read imported style sheet: {}", (Object)e.getMessage());
                }
                continue;
            }
            log.trace("Skipping import {} (media not matching)", (Object)path);
        }
        return parser.addRulesToStyleSheet(sheet);
    }

    private static CSSTreeParser createTreeParser(Object source, NetworkProcessor network, String encoding, SourceType type, Preparator preparator, URL base, List<MediaQuery> media) throws IOException, CSSException {
        CSSInputStream input = type.getInput(source, network, encoding);
        input.setBase(base);
        CommonTokenStream tokens = CSSParserFactory.feedLexer(input);
        CommonTree ast = CSSParserFactory.feedParser(tokens, type);
        return CSSParserFactory.feedAST(tokens, ast, preparator, media);
    }

    private static CommonTokenStream feedLexer(CSSInputStream source) throws CSSException {
        try {
            CSSLexer lexer = new CSSLexer(source);
            lexer.init();
            return new CommonTokenStream((TokenSource)lexer);
        }
        catch (RuntimeException re) {
            if (re.getCause() instanceof CSSException) {
                throw (CSSException)re.getCause();
            }
            log.error("LEXER THROWS:", (Throwable)re);
            throw re;
        }
    }

    private static CommonTree feedParser(CommonTokenStream source, SourceType type) throws CSSException {
        CSSParser parser = new CSSParser((TokenStream)source);
        parser.init();
        return type.getAST(parser);
    }

    private static CSSTreeParser feedAST(CommonTokenStream source, CommonTree ast, Preparator preparator, List<MediaQuery> media) {
        if (log.isTraceEnabled()) {
            log.trace("Feeding tree parser with AST:\n{}", (Object)TreeUtil.toStringTree(ast));
        }
        CommonTreeNodeStream nodes = new CommonTreeNodeStream((Object)ast);
        nodes.setTokenStream((TokenStream)source);
        CSSTreeParser parser = new CSSTreeParser((TreeNodeStream)nodes);
        return parser.init(preparator, media);
    }

    public static List<MediaQuery> parseMediaQuery(String query) {
        try {
            CSSInputStream input = CSSInputStream.stringStream(query);
            input.setBase(new URL("file://media/query/url"));
            CommonTokenStream tokens = CSSParserFactory.feedLexer(input);
            CSSParser parser = new CSSParser((TokenStream)tokens);
            parser.init();
            CSSParser.media_return retval = parser.media();
            CommonTree ast = (CommonTree)retval.getTree();
            CSSTreeParser tparser = CSSParserFactory.feedAST(tokens, ast, null, null);
            return tparser.media();
        }
        catch (IOException e) {
            log.error("I/O error during media query parsing: {}", (Object)e.getMessage());
            return null;
        }
        catch (CSSException e) {
            log.warn("Malformed media query {}", (Object)query);
            return null;
        }
        catch (RecognitionException e) {
            log.warn("Malformed media query {}", (Object)query);
            return null;
        }
    }

    public static enum SourceType {
        INLINE{

            @Override
            public CommonTree getAST(CSSParser parser) throws CSSException {
                try {
                    CSSParser.inlinestyle_return retval = parser.inlinestyle();
                    return (CommonTree)retval.getTree();
                }
                catch (RecognitionException re) {
                    throw SourceType.encapsulateException(re, "Unable to parse inline CSS style");
                }
                catch (RuntimeException re) {
                    throw SourceType.encapsulateException(re, "Unable to parse inline CSS style");
                }
            }

            @Override
            public RuleList parse(CSSTreeParser parser) throws CSSException {
                try {
                    return parser.inlinestyle();
                }
                catch (RecognitionException re) {
                    throw SourceType.encapsulateException(re, "Unable to parse inline CSS style [AST]");
                }
                catch (RuntimeException re) {
                    throw SourceType.encapsulateException(re, "Unable to parse inline CSS style [AST]");
                }
            }

            @Override
            public CSSInputStream getInput(Object source, NetworkProcessor network, String encoding) throws IOException {
                return CSSInputStream.stringStream((String)source);
            }
        }
        ,
        EMBEDDED{

            @Override
            public CommonTree getAST(CSSParser parser) throws CSSException {
                try {
                    CSSParser.stylesheet_return retval = parser.stylesheet();
                    return (CommonTree)retval.getTree();
                }
                catch (RecognitionException re) {
                    throw SourceType.encapsulateException(re, "Unable to parse embedded CSS style");
                }
                catch (RuntimeException re) {
                    throw SourceType.encapsulateException(re, "Unable to parse embedded CSS style");
                }
            }

            @Override
            public RuleList parse(CSSTreeParser parser) throws CSSException {
                try {
                    return parser.stylesheet();
                }
                catch (RecognitionException re) {
                    throw SourceType.encapsulateException(re, "Unable to parse embedded CSS style [AST]");
                }
                catch (RuntimeException re) {
                    throw SourceType.encapsulateException(re, "Unable to parse embedded CSS style [AST]");
                }
            }

            @Override
            public CSSInputStream getInput(Object source, NetworkProcessor network, String encoding) throws IOException {
                return CSSInputStream.stringStream((String)source);
            }
        }
        ,
        URL{

            @Override
            public CommonTree getAST(CSSParser parser) throws CSSException {
                try {
                    CSSParser.stylesheet_return retval = parser.stylesheet();
                    return (CommonTree)retval.getTree();
                }
                catch (RecognitionException re) {
                    throw SourceType.encapsulateException(re, "Unable to parse URL CSS style");
                }
                catch (RuntimeException re) {
                    throw SourceType.encapsulateException(re, "Unable to parse URL CSS style");
                }
            }

            @Override
            public RuleList parse(CSSTreeParser parser) throws CSSException {
                try {
                    return parser.stylesheet();
                }
                catch (RecognitionException re) {
                    throw SourceType.encapsulateException(re, "Unable to parse file CSS style [AST]");
                }
                catch (RuntimeException re) {
                    throw SourceType.encapsulateException(re, "Unable to parse file CSS style [AST]");
                }
            }

            @Override
            public CSSInputStream getInput(Object source, NetworkProcessor network, String encoding) throws IOException {
                return CSSInputStream.urlStream((URL)source, network, encoding);
            }
        };


        public abstract CSSInputStream getInput(Object var1, NetworkProcessor var2, String var3) throws IOException;

        public abstract CommonTree getAST(CSSParser var1) throws CSSException;

        public abstract RuleList parse(CSSTreeParser var1) throws CSSException;

        private static CSSException encapsulateException(Throwable t, String msg) {
            log.error("THROWN:", t);
            return new CSSException(msg, t);
        }
    }
}

