// $ANTLR 3.5.2 cz/vutbr/web/csskit/antlr/CSS.g 2014-06-03 21:06:52
 
package cz.vutbr.web.csskit.antlr;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import cz.vutbr.web.css.StyleSheet;
import cz.vutbr.web.css.CSSFactory;
import cz.vutbr.web.css.SupportedCSS;
import cz.vutbr.web.csskit.antlr.CSSLexer.LexerState;


import org.antlr.runtime.*;
import java.util.Stack;
import java.util.List;
import java.util.ArrayList;

import org.antlr.runtime.tree.*;


/**
 * A basic CSS grammar.
 */
@SuppressWarnings("all")
public class CSSParser extends Parser {
	public static final String[] tokenNames = new String[] {
		"<invalid>", "<EOR>", "<DOWN>", "<UP>", "ADJACENT", "APOS", "ASTERISK", 
		"ATBLOCK", "ATKEYWORD", "ATTRIBUTE", "BRACEBLOCK", "CDC", "CDO", "CHARSET", 
		"CHILD", "CLASSKEYWORD", "COLON", "COMMA", "COMMENT", "CONTAINS", "CTRL", 
		"CTRL_CHAR", "CURLYBLOCK", "DASHMATCH", "DECLARATION", "DESCENDANT", "DIMENSION", 
		"ELEMENT", "ENDSWITH", "EQUALS", "ESCAPE_CHAR", "EXCLAMATION", "EXPRESSION", 
		"FONTFACE", "FUNCTION", "GREATER", "HASH", "IDENT", "IDENT_MACR", "IMPORT", 
		"IMPORTANT", "IMPORT_END", "INCLUDES", "INDEX", "INLINESTYLE", "INTEGER_MACR", 
		"INVALID_DECLARATION", "INVALID_DIRECTIVE", "INVALID_IMPORT", "INVALID_SELECTOR", 
		"INVALID_SELPART", "INVALID_STATEMENT", "INVALID_STRING", "INVALID_TOKEN", 
		"LBRACE", "LCURLY", "LESS", "LPAREN", "MARGIN_AREA", "MEDIA", "MINUS", 
		"NAME_CHAR", "NAME_MACR", "NAME_START", "NL_CHAR", "NON_ASCII", "NUMBER", 
		"NUMBER_MACR", "PAGE", "PARENBLOCK", "PERCENT", "PERCENTAGE", "PLUS", 
		"PRECEDING", "PSEUDO", "QUESTION", "QUOT", "RBRACE", "RCURLY", "RPAREN", 
		"RULE", "S", "SELECTOR", "SEMICOLON", "SET", "SLASH", "SL_COMMENT", "STARTSWITH", 
		"STRING", "STRING_CHAR", "STRING_MACR", "STYLESHEET", "TILDE", "UNIRANGE", 
		"URI", "URI_CHAR", "URI_MACR", "VALUE", "VIEWPORT", "W_CHAR", "W_MACR", 
		"'#'", "'^'", "'important'"
	};
	public static final int EOF=-1;
	public static final int T__101=101;
	public static final int T__102=102;
	public static final int T__103=103;
	public static final int ADJACENT=4;
	public static final int APOS=5;
	public static final int ASTERISK=6;
	public static final int ATBLOCK=7;
	public static final int ATKEYWORD=8;
	public static final int ATTRIBUTE=9;
	public static final int BRACEBLOCK=10;
	public static final int CDC=11;
	public static final int CDO=12;
	public static final int CHARSET=13;
	public static final int CHILD=14;
	public static final int CLASSKEYWORD=15;
	public static final int COLON=16;
	public static final int COMMA=17;
	public static final int COMMENT=18;
	public static final int CONTAINS=19;
	public static final int CTRL=20;
	public static final int CTRL_CHAR=21;
	public static final int CURLYBLOCK=22;
	public static final int DASHMATCH=23;
	public static final int DECLARATION=24;
	public static final int DESCENDANT=25;
	public static final int DIMENSION=26;
	public static final int ELEMENT=27;
	public static final int ENDSWITH=28;
	public static final int EQUALS=29;
	public static final int ESCAPE_CHAR=30;
	public static final int EXCLAMATION=31;
	public static final int EXPRESSION=32;
	public static final int FONTFACE=33;
	public static final int FUNCTION=34;
	public static final int GREATER=35;
	public static final int HASH=36;
	public static final int IDENT=37;
	public static final int IDENT_MACR=38;
	public static final int IMPORT=39;
	public static final int IMPORTANT=40;
	public static final int IMPORT_END=41;
	public static final int INCLUDES=42;
	public static final int INDEX=43;
	public static final int INLINESTYLE=44;
	public static final int INTEGER_MACR=45;
	public static final int INVALID_DECLARATION=46;
	public static final int INVALID_DIRECTIVE=47;
	public static final int INVALID_IMPORT=48;
	public static final int INVALID_SELECTOR=49;
	public static final int INVALID_SELPART=50;
	public static final int INVALID_STATEMENT=51;
	public static final int INVALID_STRING=52;
	public static final int INVALID_TOKEN=53;
	public static final int LBRACE=54;
	public static final int LCURLY=55;
	public static final int LESS=56;
	public static final int LPAREN=57;
	public static final int MARGIN_AREA=58;
	public static final int MEDIA=59;
	public static final int MINUS=60;
	public static final int NAME_CHAR=61;
	public static final int NAME_MACR=62;
	public static final int NAME_START=63;
	public static final int NL_CHAR=64;
	public static final int NON_ASCII=65;
	public static final int NUMBER=66;
	public static final int NUMBER_MACR=67;
	public static final int PAGE=68;
	public static final int PARENBLOCK=69;
	public static final int PERCENT=70;
	public static final int PERCENTAGE=71;
	public static final int PLUS=72;
	public static final int PRECEDING=73;
	public static final int PSEUDO=74;
	public static final int QUESTION=75;
	public static final int QUOT=76;
	public static final int RBRACE=77;
	public static final int RCURLY=78;
	public static final int RPAREN=79;
	public static final int RULE=80;
	public static final int S=81;
	public static final int SELECTOR=82;
	public static final int SEMICOLON=83;
	public static final int SET=84;
	public static final int SLASH=85;
	public static final int SL_COMMENT=86;
	public static final int STARTSWITH=87;
	public static final int STRING=88;
	public static final int STRING_CHAR=89;
	public static final int STRING_MACR=90;
	public static final int STYLESHEET=91;
	public static final int TILDE=92;
	public static final int UNIRANGE=93;
	public static final int URI=94;
	public static final int URI_CHAR=95;
	public static final int URI_MACR=96;
	public static final int VALUE=97;
	public static final int VIEWPORT=98;
	public static final int W_CHAR=99;
	public static final int W_MACR=100;

	// delegates
	public Parser[] getDelegates() {
		return new Parser[] {};
	}

	// delegators


	public CSSParser(TokenStream input) {
		this(input, new RecognizerSharedState());
	}
	public CSSParser(TokenStream input, RecognizerSharedState state) {
		super(input, state);
	}

	protected TreeAdaptor adaptor = new CommonTreeAdaptor();

	public void setTreeAdaptor(TreeAdaptor adaptor) {
		this.adaptor = adaptor;
	}
	public TreeAdaptor getTreeAdaptor() {
		return adaptor;
	}
	@Override public String[] getTokenNames() { return CSSParser.tokenNames; }
	@Override public String getGrammarFileName() { return "cz/vutbr/web/csskit/antlr/CSS.g"; }


	    private static Logger log = LoggerFactory.getLogger(CSSParser.class);
	    
	    private static SupportedCSS css = CSSFactory.getSupportedCSS();
	    
	    private StyleSheet stylesheet;
	    
	    private int functLevel = 0;
	    
	    /**
	     * This function must be called to initialize parser's state.
	     * Because we can't change directly generated constructors.
	     * @param stylesheet CSS StyleSheet instance  
	     */
	    public CSSParser init(StyleSheet stylesheet) {
	    	this.stylesheet = stylesheet;
	    	return this;
	    }
	    
	    @Override
	    public void emitErrorMessage(String msg) {
	    	log.info("ANTLR: {}", msg);
		}    

		private Object invalidReplacement(int ttype, String ttext) {
			
			Object root = (Object) adaptor.nil();
			Object node = (Object) adaptor.create(ttype, ttext);
			
			adaptor.addChild(root, node);	
			
			if(log.isDebugEnabled()) {
				log.debug("Invalid fallback with: {}", TreeUtil.toStringTree((CommonTree) root));
			}
			
			return root;	
		}

		/**
		 * Recovers and logs error, prepares tree part replacement
		 */ 
		private Object invalidFallback(int ttype, String ttext, RecognitionException re) {
		    reportError(re);
			recover(input, re);
			return invalidReplacement(ttype, ttext);
		}
		
		/**
		 * Recovers and logs error, using custom follow set,
		 * prepares tree part replacement
		 */ 
		private Object invalidFallbackGreedy(int ttype, String ttext, BitSet follow, RecognitionException re) {
			reportError(re);
			if ( state.lastErrorIndex==input.index() ) {
				// uh oh, another error at same token index; must be a case
		 		// where LT(1) is in the recovery token set so nothing is
	            // consumed; consume a single token so at least to prevent
	            // an infinite loop; this is a failsafe.
	            input.consume();
	        }
	    state.lastErrorIndex = input.index();
	    beginResync();
			consumeUntilGreedy(input, follow);
	    endResync();
			return invalidReplacement(ttype, ttext);
			
	    }
		
		/**
		 * Consumes token until lexer state is balanced and
		 * token from follow is matched. Matched token is also consumed
		 */ 
		private void consumeUntilGreedy(TokenStream input, BitSet follow) {
			CSSToken t = null;
			do{
			  Token next = input.LT(1);
			  if (next instanceof CSSToken)
			      t= (CSSToken) input.LT(1);
			  else
			      break; /* not a CSSToken, probably EOF */
			  log.trace("Skipped greedy: {} follow: {}", t, follow);
			  // consume token even if it will match
			  input.consume();
			}while(!(t.getLexerState().isBalanced() && follow.member(t.getType())));
		} 

	  /**
	   * Recovers and logs error inside a function, using custom follow set,
	   * prepares tree part replacement
	   */ 
	  private Object invalidFallbackGreedy(int ttype, String ttext, BitSet follow, LexerState.RecoveryMode mode, LexerState ls, RecognitionException re) {
	    reportError(re);
	    if ( state.lastErrorIndex==input.index() ) {
	      // uh oh, another error at same token index; must be a case
	      // where LT(1) is in the recovery token set so nothing is
	            // consumed; consume a single token so at least to prevent
	            // an infinite loop; this is a failsafe.
	            input.consume();
	        }
	    state.lastErrorIndex = input.index();
	    beginResync();
	    consumeUntilGreedy(input, follow, mode, ls);
	    endResync();
	    return invalidReplacement(ttype, ttext);
	    
	    }
	  
	  /**
	   * Consumes token until lexer state is function-balanced and
	   * token from follow is matched. Matched token is also consumed
	   */ 
	  private void consumeUntilGreedy(TokenStream input, BitSet follow, LexerState.RecoveryMode mode, LexerState ls) {
	    CSSToken t = null;
	    do{
	      Token next = input.LT(1);
	      if (next instanceof CSSToken)
	          t= (CSSToken) input.LT(1);
	      else
	          break; /* not a CSSToken, probably EOF */
	      log.trace("Skipped greedy: {}", t);
	      // consume token even if it will match
	      input.consume();
	    }while(!(t.getLexerState().isBalanced(mode, ls) && follow.member(t.getType())));
	  }
	  
	  /**
	   * Recovers and logs error inside a function, using custom follow set,
	   * prepares tree part replacement
	   */ 
	  private Object invalidFallback(int ttype, String ttext, BitSet follow, LexerState.RecoveryMode mode, LexerState ls, RecognitionException re) {
	    reportError(re);
	    if ( state.lastErrorIndex==input.index() ) {
	      // uh oh, another error at same token index; must be a case
	      // where LT(1) is in the recovery token set so nothing is
	            // consumed; consume a single token so at least to prevent
	            // an infinite loop; this is a failsafe.
	            input.consume();
	        }
	    state.lastErrorIndex = input.index();
	    beginResync();
	    consumeUntil(input, follow, mode, ls);
	    endResync();
	    return invalidReplacement(ttype, ttext);
	    
	    }
	  
	  /**
	   * Consumes token until lexer state is function-balanced and
	   * token from follow is matched.
	   */ 
	  private void consumeUntil(TokenStream input, BitSet follow, LexerState.RecoveryMode mode, LexerState ls) {
	    CSSToken t = null;
	    boolean finish = false;
	    do{
	      Token next = input.LT(1);
	      if (next instanceof CSSToken)
	          t= (CSSToken) input.LT(1);
	      else
	          break; /* not a CSSToken, probably EOF */
	      // consume token if does not match
	      finish = (t.getLexerState().isBalanced(mode, ls) && follow.member(t.getType()));
	      if (!finish)
	      { 
	          log.trace("Skipped: {}", t);
	          input.consume();
	      }
	    }while(!finish);
	  }
	    
	  /**
	   * Obtains the current lexer state from current token
	   */
	  private LexerState getCurrentLexerState(Token t)
	  {
	      if (t instanceof CSSToken)
	          return ((CSSToken) t).getLexerState();
	      else
	          return null;
	  }
	     
	  //this switches the single token insertion / deletion off because it interferes with our own error recovery
	  protected Object recoverFromMismatchedToken(IntStream input, int ttype, BitSet follow)
	      throws RecognitionException
	  {
	      throw new MismatchedTokenException(ttype, input);
	  }
	   


	public static class inlinestyle_return extends ParserRuleReturnScope {
		Object tree;
		@Override
		public Object getTree() { return tree; }
	};


	// $ANTLR start "inlinestyle"
	// cz/vutbr/web/csskit/antlr/CSS.g:753:1: inlinestyle : ( S )* ( declarations -> ^( INLINESTYLE declarations ) | ( inlineset )+ -> ^( INLINESTYLE ( inlineset )+ ) ) ;
	public final CSSParser.inlinestyle_return inlinestyle() throws RecognitionException {
		CSSParser.inlinestyle_return retval = new CSSParser.inlinestyle_return();
		retval.start = input.LT(1);

		Object root_0 = null;

		Token S1=null;
		ParserRuleReturnScope declarations2 =null;
		ParserRuleReturnScope inlineset3 =null;

		Object S1_tree=null;
		RewriteRuleTokenStream stream_S=new RewriteRuleTokenStream(adaptor,"token S");
		RewriteRuleSubtreeStream stream_inlineset=new RewriteRuleSubtreeStream(adaptor,"rule inlineset");
		RewriteRuleSubtreeStream stream_declarations=new RewriteRuleSubtreeStream(adaptor,"rule declarations");

		try {
			// cz/vutbr/web/csskit/antlr/CSS.g:754:2: ( ( S )* ( declarations -> ^( INLINESTYLE declarations ) | ( inlineset )+ -> ^( INLINESTYLE ( inlineset )+ ) ) )
			// cz/vutbr/web/csskit/antlr/CSS.g:754:4: ( S )* ( declarations -> ^( INLINESTYLE declarations ) | ( inlineset )+ -> ^( INLINESTYLE ( inlineset )+ ) )
			{
			// cz/vutbr/web/csskit/antlr/CSS.g:754:4: ( S )*
			loop1:
			while (true) {
				int alt1=2;
				int LA1_0 = input.LA(1);
				if ( (LA1_0==S) ) {
					alt1=1;
				}

				switch (alt1) {
				case 1 :
					// cz/vutbr/web/csskit/antlr/CSS.g:754:4: S
					{
					S1=(Token)match(input,S,FOLLOW_S_in_inlinestyle205);  
					stream_S.add(S1);

					}
					break;

				default :
					break loop1;
				}
			}

			// cz/vutbr/web/csskit/antlr/CSS.g:754:8: ( declarations -> ^( INLINESTYLE declarations ) | ( inlineset )+ -> ^( INLINESTYLE ( inlineset )+ ) )
			int alt3=2;
			switch ( input.LA(1) ) {
			case EOF:
			case ASTERISK:
			case CLASSKEYWORD:
			case COMMA:
			case CTRL:
			case DASHMATCH:
			case EQUALS:
			case EXCLAMATION:
			case GREATER:
			case IDENT:
			case INCLUDES:
			case INVALID_TOKEN:
			case LESS:
			case MINUS:
			case NUMBER:
			case PERCENT:
			case PLUS:
			case QUESTION:
			case SEMICOLON:
			case SLASH:
			case STRING_CHAR:
				{
				alt3=1;
				}
				break;
			case COLON:
				{
				switch ( input.LA(2) ) {
				case EOF:
				case ASTERISK:
				case CLASSKEYWORD:
				case COMMA:
				case DASHMATCH:
				case DIMENSION:
				case EQUALS:
				case EXCLAMATION:
				case GREATER:
				case HASH:
				case INCLUDES:
				case INVALID_STRING:
				case LBRACE:
				case LESS:
				case LPAREN:
				case MINUS:
				case NUMBER:
				case PERCENT:
				case PERCENTAGE:
				case PLUS:
				case QUESTION:
				case S:
				case SEMICOLON:
				case SLASH:
				case STRING:
				case UNIRANGE:
				case URI:
					{
					alt3=1;
					}
					break;
				case IDENT:
					{
					alt3=1;
					}
					break;
				case COLON:
					{
					alt3=1;
					}
					break;
				case FUNCTION:
					{
					alt3=1;
					}
					break;
				default:
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 3, 17, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}
				}
				break;
			case LCURLY:
				{
				alt3=2;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 3, 0, input);
				throw nvae;
			}
			switch (alt3) {
				case 1 :
					// cz/vutbr/web/csskit/antlr/CSS.g:754:9: declarations
					{
					pushFollow(FOLLOW_declarations_in_inlinestyle210);
					declarations2=declarations();
					state._fsp--;

					stream_declarations.add(declarations2.getTree());
					// AST REWRITE
					// elements: declarations
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (Object)adaptor.nil();
					// 754:22: -> ^( INLINESTYLE declarations )
					{
						// cz/vutbr/web/csskit/antlr/CSS.g:754:25: ^( INLINESTYLE declarations )
						{
						Object root_1 = (Object)adaptor.nil();
						root_1 = (Object)adaptor.becomeRoot((Object)adaptor.create(INLINESTYLE, "INLINESTYLE"), root_1);
						adaptor.addChild(root_1, stream_declarations.nextTree());
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;
				case 2 :
					// cz/vutbr/web/csskit/antlr/CSS.g:755:10: ( inlineset )+
					{
					// cz/vutbr/web/csskit/antlr/CSS.g:755:10: ( inlineset )+
					int cnt2=0;
					loop2:
					while (true) {
						int alt2=2;
						int LA2_0 = input.LA(1);
						if ( (LA2_0==COLON||LA2_0==LCURLY) ) {
							alt2=1;
						}

						switch (alt2) {
						case 1 :
							// cz/vutbr/web/csskit/antlr/CSS.g:755:10: inlineset
							{
							pushFollow(FOLLOW_inlineset_in_inlinestyle230);
							inlineset3=inlineset();
							state._fsp--;

							stream_inlineset.add(inlineset3.getTree());
							}
							break;

						default :
							if ( cnt2 >= 1 ) break loop2;
							EarlyExitException eee = new EarlyExitException(2, input);
							throw eee;
						}
						cnt2++;
					}

					// AST REWRITE
					// elements: inlineset
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (Object)adaptor.nil();
					// 755:21: -> ^( INLINESTYLE ( inlineset )+ )
					{
						// cz/vutbr/web/csskit/antlr/CSS.g:755:24: ^( INLINESTYLE ( inlineset )+ )
						{
						Object root_1 = (Object)adaptor.nil();
						root_1 = (Object)adaptor.becomeRoot((Object)adaptor.create(INLINESTYLE, "INLINESTYLE"), root_1);
						if ( !(stream_inlineset.hasNext()) ) {
							throw new RewriteEarlyExitException();
						}
						while ( stream_inlineset.hasNext() ) {
							adaptor.addChild(root_1, stream_inlineset.nextTree());
						}
						stream_inlineset.reset();

						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;

			}

			}

			retval.stop = input.LT(-1);

			retval.tree = (Object)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "inlinestyle"


	public static class stylesheet_return extends ParserRuleReturnScope {
		Object tree;
		@Override
		public Object getTree() { return tree; }
	};


	// $ANTLR start "stylesheet"
	// cz/vutbr/web/csskit/antlr/CSS.g:759:1: stylesheet : ( CDO | CDC | S | nostatement | statement )* -> ^( STYLESHEET ( statement )* ) ;
	public final CSSParser.stylesheet_return stylesheet() throws RecognitionException {
		CSSParser.stylesheet_return retval = new CSSParser.stylesheet_return();
		retval.start = input.LT(1);

		Object root_0 = null;

		Token CDO4=null;
		Token CDC5=null;
		Token S6=null;
		ParserRuleReturnScope nostatement7 =null;
		ParserRuleReturnScope statement8 =null;

		Object CDO4_tree=null;
		Object CDC5_tree=null;
		Object S6_tree=null;
		RewriteRuleTokenStream stream_S=new RewriteRuleTokenStream(adaptor,"token S");
		RewriteRuleTokenStream stream_CDO=new RewriteRuleTokenStream(adaptor,"token CDO");
		RewriteRuleTokenStream stream_CDC=new RewriteRuleTokenStream(adaptor,"token CDC");
		RewriteRuleSubtreeStream stream_statement=new RewriteRuleSubtreeStream(adaptor,"rule statement");
		RewriteRuleSubtreeStream stream_nostatement=new RewriteRuleSubtreeStream(adaptor,"rule nostatement");

		try {
			// cz/vutbr/web/csskit/antlr/CSS.g:760:2: ( ( CDO | CDC | S | nostatement | statement )* -> ^( STYLESHEET ( statement )* ) )
			// cz/vutbr/web/csskit/antlr/CSS.g:760:4: ( CDO | CDC | S | nostatement | statement )*
			{
			// cz/vutbr/web/csskit/antlr/CSS.g:760:4: ( CDO | CDC | S | nostatement | statement )*
			loop4:
			while (true) {
				int alt4=6;
				switch ( input.LA(1) ) {
				case CDO:
					{
					alt4=1;
					}
					break;
				case CDC:
					{
					alt4=2;
					}
					break;
				case S:
					{
					alt4=3;
					}
					break;
				case APOS:
				case QUOT:
				case RCURLY:
				case SEMICOLON:
					{
					alt4=4;
					}
					break;
				case ASTERISK:
				case ATKEYWORD:
				case CHARSET:
				case CLASSKEYWORD:
				case COLON:
				case COMMA:
				case CTRL:
				case DASHMATCH:
				case DIMENSION:
				case EQUALS:
				case EXCLAMATION:
				case FONTFACE:
				case GREATER:
				case HASH:
				case IDENT:
				case IMPORT:
				case IMPORT_END:
				case INCLUDES:
				case INVALID_IMPORT:
				case INVALID_SELPART:
				case INVALID_STRING:
				case LBRACE:
				case LESS:
				case MEDIA:
				case MINUS:
				case NUMBER:
				case PAGE:
				case PERCENT:
				case PERCENTAGE:
				case PLUS:
				case QUESTION:
				case RPAREN:
				case SLASH:
				case STRING:
				case UNIRANGE:
				case URI:
				case VIEWPORT:
				case 101:
				case 102:
					{
					alt4=5;
					}
					break;
				}
				switch (alt4) {
				case 1 :
					// cz/vutbr/web/csskit/antlr/CSS.g:760:6: CDO
					{
					CDO4=(Token)match(input,CDO,FOLLOW_CDO_in_stylesheet258);  
					stream_CDO.add(CDO4);

					}
					break;
				case 2 :
					// cz/vutbr/web/csskit/antlr/CSS.g:760:12: CDC
					{
					CDC5=(Token)match(input,CDC,FOLLOW_CDC_in_stylesheet262);  
					stream_CDC.add(CDC5);

					}
					break;
				case 3 :
					// cz/vutbr/web/csskit/antlr/CSS.g:760:18: S
					{
					S6=(Token)match(input,S,FOLLOW_S_in_stylesheet266);  
					stream_S.add(S6);

					}
					break;
				case 4 :
					// cz/vutbr/web/csskit/antlr/CSS.g:760:22: nostatement
					{
					pushFollow(FOLLOW_nostatement_in_stylesheet270);
					nostatement7=nostatement();
					state._fsp--;

					stream_nostatement.add(nostatement7.getTree());
					}
					break;
				case 5 :
					// cz/vutbr/web/csskit/antlr/CSS.g:760:36: statement
					{
					pushFollow(FOLLOW_statement_in_stylesheet274);
					statement8=statement();
					state._fsp--;

					stream_statement.add(statement8.getTree());
					}
					break;

				default :
					break loop4;
				}
			}

			// AST REWRITE
			// elements: statement
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (Object)adaptor.nil();
			// 761:3: -> ^( STYLESHEET ( statement )* )
			{
				// cz/vutbr/web/csskit/antlr/CSS.g:761:6: ^( STYLESHEET ( statement )* )
				{
				Object root_1 = (Object)adaptor.nil();
				root_1 = (Object)adaptor.becomeRoot((Object)adaptor.create(STYLESHEET, "STYLESHEET"), root_1);
				// cz/vutbr/web/csskit/antlr/CSS.g:761:19: ( statement )*
				while ( stream_statement.hasNext() ) {
					adaptor.addChild(root_1, stream_statement.nextTree());
				}
				stream_statement.reset();

				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (Object)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "stylesheet"


	public static class statement_return extends ParserRuleReturnScope {
		Object tree;
		@Override
		public Object getTree() { return tree; }
	};


	// $ANTLR start "statement"
	// cz/vutbr/web/csskit/antlr/CSS.g:764:1: statement : ( ruleset | atstatement );
	public final CSSParser.statement_return statement() throws RecognitionException {
		CSSParser.statement_return retval = new CSSParser.statement_return();
		retval.start = input.LT(1);

		Object root_0 = null;

		ParserRuleReturnScope ruleset9 =null;
		ParserRuleReturnScope atstatement10 =null;


		try {
			// cz/vutbr/web/csskit/antlr/CSS.g:765:2: ( ruleset | atstatement )
			int alt5=2;
			int LA5_0 = input.LA(1);
			if ( (LA5_0==ASTERISK||(LA5_0 >= CLASSKEYWORD && LA5_0 <= COMMA)||LA5_0==CTRL||LA5_0==DASHMATCH||LA5_0==DIMENSION||LA5_0==EQUALS||LA5_0==EXCLAMATION||(LA5_0 >= GREATER && LA5_0 <= IDENT)||LA5_0==INCLUDES||LA5_0==INVALID_SELPART||LA5_0==INVALID_STRING||LA5_0==LBRACE||LA5_0==LESS||LA5_0==MINUS||LA5_0==NUMBER||(LA5_0 >= PERCENT && LA5_0 <= PLUS)||LA5_0==QUESTION||LA5_0==RPAREN||LA5_0==SLASH||LA5_0==STRING||(LA5_0 >= UNIRANGE && LA5_0 <= URI)||(LA5_0 >= 101 && LA5_0 <= 102)) ) {
				alt5=1;
			}
			else if ( (LA5_0==ATKEYWORD||LA5_0==CHARSET||LA5_0==FONTFACE||LA5_0==IMPORT||LA5_0==IMPORT_END||LA5_0==INVALID_IMPORT||LA5_0==MEDIA||LA5_0==PAGE||LA5_0==VIEWPORT) ) {
				alt5=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 5, 0, input);
				throw nvae;
			}

			switch (alt5) {
				case 1 :
					// cz/vutbr/web/csskit/antlr/CSS.g:765:4: ruleset
					{
					root_0 = (Object)adaptor.nil();


					pushFollow(FOLLOW_ruleset_in_statement304);
					ruleset9=ruleset();
					state._fsp--;

					adaptor.addChild(root_0, ruleset9.getTree());

					}
					break;
				case 2 :
					// cz/vutbr/web/csskit/antlr/CSS.g:765:14: atstatement
					{
					root_0 = (Object)adaptor.nil();


					pushFollow(FOLLOW_atstatement_in_statement308);
					atstatement10=atstatement();
					state._fsp--;

					adaptor.addChild(root_0, atstatement10.getTree());

					}
					break;

			}
			retval.stop = input.LT(-1);

			retval.tree = (Object)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "statement"


	public static class atstatement_return extends ParserRuleReturnScope {
		Object tree;
		@Override
		public Object getTree() { return tree; }
	};


	// $ANTLR start "atstatement"
	// cz/vutbr/web/csskit/antlr/CSS.g:768:1: atstatement : ( CHARSET | IMPORT | INVALID_IMPORT | IMPORT_END | page | VIEWPORT ( S )* LCURLY ( S )* declarations RCURLY -> ^( VIEWPORT declarations ) | FONTFACE ( S )* LCURLY ( S )* declarations RCURLY -> ^( FONTFACE declarations ) | MEDIA ( S )* ( media )? LCURLY ( S )* ( ruleset ( S )* )* RCURLY -> ^( MEDIA ( media )? ( ruleset )* ) | ATKEYWORD ( S )* LCURLY ( any )* RCURLY -> INVALID_STATEMENT );
	public final CSSParser.atstatement_return atstatement() throws RecognitionException {
		CSSParser.atstatement_return retval = new CSSParser.atstatement_return();
		retval.start = input.LT(1);

		Object root_0 = null;

		Token CHARSET11=null;
		Token IMPORT12=null;
		Token INVALID_IMPORT13=null;
		Token IMPORT_END14=null;
		Token VIEWPORT16=null;
		Token S17=null;
		Token LCURLY18=null;
		Token S19=null;
		Token RCURLY21=null;
		Token FONTFACE22=null;
		Token S23=null;
		Token LCURLY24=null;
		Token S25=null;
		Token RCURLY27=null;
		Token MEDIA28=null;
		Token S29=null;
		Token LCURLY31=null;
		Token S32=null;
		Token S34=null;
		Token RCURLY35=null;
		Token ATKEYWORD36=null;
		Token S37=null;
		Token LCURLY38=null;
		Token RCURLY40=null;
		ParserRuleReturnScope page15 =null;
		ParserRuleReturnScope declarations20 =null;
		ParserRuleReturnScope declarations26 =null;
		ParserRuleReturnScope media30 =null;
		ParserRuleReturnScope ruleset33 =null;
		ParserRuleReturnScope any39 =null;

		Object CHARSET11_tree=null;
		Object IMPORT12_tree=null;
		Object INVALID_IMPORT13_tree=null;
		Object IMPORT_END14_tree=null;
		Object VIEWPORT16_tree=null;
		Object S17_tree=null;
		Object LCURLY18_tree=null;
		Object S19_tree=null;
		Object RCURLY21_tree=null;
		Object FONTFACE22_tree=null;
		Object S23_tree=null;
		Object LCURLY24_tree=null;
		Object S25_tree=null;
		Object RCURLY27_tree=null;
		Object MEDIA28_tree=null;
		Object S29_tree=null;
		Object LCURLY31_tree=null;
		Object S32_tree=null;
		Object S34_tree=null;
		Object RCURLY35_tree=null;
		Object ATKEYWORD36_tree=null;
		Object S37_tree=null;
		Object LCURLY38_tree=null;
		Object RCURLY40_tree=null;
		RewriteRuleTokenStream stream_ATKEYWORD=new RewriteRuleTokenStream(adaptor,"token ATKEYWORD");
		RewriteRuleTokenStream stream_VIEWPORT=new RewriteRuleTokenStream(adaptor,"token VIEWPORT");
		RewriteRuleTokenStream stream_LCURLY=new RewriteRuleTokenStream(adaptor,"token LCURLY");
		RewriteRuleTokenStream stream_FONTFACE=new RewriteRuleTokenStream(adaptor,"token FONTFACE");
		RewriteRuleTokenStream stream_S=new RewriteRuleTokenStream(adaptor,"token S");
		RewriteRuleTokenStream stream_MEDIA=new RewriteRuleTokenStream(adaptor,"token MEDIA");
		RewriteRuleTokenStream stream_RCURLY=new RewriteRuleTokenStream(adaptor,"token RCURLY");
		RewriteRuleSubtreeStream stream_ruleset=new RewriteRuleSubtreeStream(adaptor,"rule ruleset");
		RewriteRuleSubtreeStream stream_any=new RewriteRuleSubtreeStream(adaptor,"rule any");
		RewriteRuleSubtreeStream stream_media=new RewriteRuleSubtreeStream(adaptor,"rule media");
		RewriteRuleSubtreeStream stream_declarations=new RewriteRuleSubtreeStream(adaptor,"rule declarations");

		try {
			// cz/vutbr/web/csskit/antlr/CSS.g:769:2: ( CHARSET | IMPORT | INVALID_IMPORT | IMPORT_END | page | VIEWPORT ( S )* LCURLY ( S )* declarations RCURLY -> ^( VIEWPORT declarations ) | FONTFACE ( S )* LCURLY ( S )* declarations RCURLY -> ^( FONTFACE declarations ) | MEDIA ( S )* ( media )? LCURLY ( S )* ( ruleset ( S )* )* RCURLY -> ^( MEDIA ( media )? ( ruleset )* ) | ATKEYWORD ( S )* LCURLY ( any )* RCURLY -> INVALID_STATEMENT )
			int alt17=9;
			switch ( input.LA(1) ) {
			case CHARSET:
				{
				alt17=1;
				}
				break;
			case IMPORT:
				{
				alt17=2;
				}
				break;
			case INVALID_IMPORT:
				{
				alt17=3;
				}
				break;
			case IMPORT_END:
				{
				alt17=4;
				}
				break;
			case PAGE:
				{
				alt17=5;
				}
				break;
			case VIEWPORT:
				{
				alt17=6;
				}
				break;
			case FONTFACE:
				{
				alt17=7;
				}
				break;
			case MEDIA:
				{
				alt17=8;
				}
				break;
			case ATKEYWORD:
				{
				alt17=9;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 17, 0, input);
				throw nvae;
			}
			switch (alt17) {
				case 1 :
					// cz/vutbr/web/csskit/antlr/CSS.g:769:4: CHARSET
					{
					root_0 = (Object)adaptor.nil();


					CHARSET11=(Token)match(input,CHARSET,FOLLOW_CHARSET_in_atstatement319); 
					CHARSET11_tree = (Object)adaptor.create(CHARSET11);
					adaptor.addChild(root_0, CHARSET11_tree);

					}
					break;
				case 2 :
					// cz/vutbr/web/csskit/antlr/CSS.g:770:4: IMPORT
					{
					root_0 = (Object)adaptor.nil();


					IMPORT12=(Token)match(input,IMPORT,FOLLOW_IMPORT_in_atstatement324); 
					IMPORT12_tree = (Object)adaptor.create(IMPORT12);
					adaptor.addChild(root_0, IMPORT12_tree);

					}
					break;
				case 3 :
					// cz/vutbr/web/csskit/antlr/CSS.g:771:4: INVALID_IMPORT
					{
					root_0 = (Object)adaptor.nil();


					INVALID_IMPORT13=(Token)match(input,INVALID_IMPORT,FOLLOW_INVALID_IMPORT_in_atstatement329); 
					INVALID_IMPORT13_tree = (Object)adaptor.create(INVALID_IMPORT13);
					adaptor.addChild(root_0, INVALID_IMPORT13_tree);

					}
					break;
				case 4 :
					// cz/vutbr/web/csskit/antlr/CSS.g:772:4: IMPORT_END
					{
					root_0 = (Object)adaptor.nil();


					IMPORT_END14=(Token)match(input,IMPORT_END,FOLLOW_IMPORT_END_in_atstatement334); 
					IMPORT_END14_tree = (Object)adaptor.create(IMPORT_END14);
					adaptor.addChild(root_0, IMPORT_END14_tree);

					}
					break;
				case 5 :
					// cz/vutbr/web/csskit/antlr/CSS.g:773:4: page
					{
					root_0 = (Object)adaptor.nil();


					pushFollow(FOLLOW_page_in_atstatement339);
					page15=page();
					state._fsp--;

					adaptor.addChild(root_0, page15.getTree());

					}
					break;
				case 6 :
					// cz/vutbr/web/csskit/antlr/CSS.g:774:5: VIEWPORT ( S )* LCURLY ( S )* declarations RCURLY
					{
					VIEWPORT16=(Token)match(input,VIEWPORT,FOLLOW_VIEWPORT_in_atstatement345);  
					stream_VIEWPORT.add(VIEWPORT16);

					// cz/vutbr/web/csskit/antlr/CSS.g:774:14: ( S )*
					loop6:
					while (true) {
						int alt6=2;
						int LA6_0 = input.LA(1);
						if ( (LA6_0==S) ) {
							alt6=1;
						}

						switch (alt6) {
						case 1 :
							// cz/vutbr/web/csskit/antlr/CSS.g:774:14: S
							{
							S17=(Token)match(input,S,FOLLOW_S_in_atstatement347);  
							stream_S.add(S17);

							}
							break;

						default :
							break loop6;
						}
					}

					LCURLY18=(Token)match(input,LCURLY,FOLLOW_LCURLY_in_atstatement354);  
					stream_LCURLY.add(LCURLY18);

					// cz/vutbr/web/csskit/antlr/CSS.g:775:12: ( S )*
					loop7:
					while (true) {
						int alt7=2;
						int LA7_0 = input.LA(1);
						if ( (LA7_0==S) ) {
							alt7=1;
						}

						switch (alt7) {
						case 1 :
							// cz/vutbr/web/csskit/antlr/CSS.g:775:12: S
							{
							S19=(Token)match(input,S,FOLLOW_S_in_atstatement356);  
							stream_S.add(S19);

							}
							break;

						default :
							break loop7;
						}
					}

					pushFollow(FOLLOW_declarations_in_atstatement359);
					declarations20=declarations();
					state._fsp--;

					stream_declarations.add(declarations20.getTree());
					RCURLY21=(Token)match(input,RCURLY,FOLLOW_RCURLY_in_atstatement365);  
					stream_RCURLY.add(RCURLY21);

					// AST REWRITE
					// elements: VIEWPORT, declarations
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (Object)adaptor.nil();
					// 776:12: -> ^( VIEWPORT declarations )
					{
						// cz/vutbr/web/csskit/antlr/CSS.g:776:15: ^( VIEWPORT declarations )
						{
						Object root_1 = (Object)adaptor.nil();
						root_1 = (Object)adaptor.becomeRoot(stream_VIEWPORT.nextNode(), root_1);
						adaptor.addChild(root_1, stream_declarations.nextTree());
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;
				case 7 :
					// cz/vutbr/web/csskit/antlr/CSS.g:777:4: FONTFACE ( S )* LCURLY ( S )* declarations RCURLY
					{
					FONTFACE22=(Token)match(input,FONTFACE,FOLLOW_FONTFACE_in_atstatement378);  
					stream_FONTFACE.add(FONTFACE22);

					// cz/vutbr/web/csskit/antlr/CSS.g:777:13: ( S )*
					loop8:
					while (true) {
						int alt8=2;
						int LA8_0 = input.LA(1);
						if ( (LA8_0==S) ) {
							alt8=1;
						}

						switch (alt8) {
						case 1 :
							// cz/vutbr/web/csskit/antlr/CSS.g:777:13: S
							{
							S23=(Token)match(input,S,FOLLOW_S_in_atstatement380);  
							stream_S.add(S23);

							}
							break;

						default :
							break loop8;
						}
					}

					LCURLY24=(Token)match(input,LCURLY,FOLLOW_LCURLY_in_atstatement386);  
					stream_LCURLY.add(LCURLY24);

					// cz/vutbr/web/csskit/antlr/CSS.g:778:11: ( S )*
					loop9:
					while (true) {
						int alt9=2;
						int LA9_0 = input.LA(1);
						if ( (LA9_0==S) ) {
							alt9=1;
						}

						switch (alt9) {
						case 1 :
							// cz/vutbr/web/csskit/antlr/CSS.g:778:11: S
							{
							S25=(Token)match(input,S,FOLLOW_S_in_atstatement388);  
							stream_S.add(S25);

							}
							break;

						default :
							break loop9;
						}
					}

					pushFollow(FOLLOW_declarations_in_atstatement391);
					declarations26=declarations();
					state._fsp--;

					stream_declarations.add(declarations26.getTree());
					RCURLY27=(Token)match(input,RCURLY,FOLLOW_RCURLY_in_atstatement396);  
					stream_RCURLY.add(RCURLY27);

					// AST REWRITE
					// elements: declarations, FONTFACE
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (Object)adaptor.nil();
					// 779:11: -> ^( FONTFACE declarations )
					{
						// cz/vutbr/web/csskit/antlr/CSS.g:779:14: ^( FONTFACE declarations )
						{
						Object root_1 = (Object)adaptor.nil();
						root_1 = (Object)adaptor.becomeRoot(stream_FONTFACE.nextNode(), root_1);
						adaptor.addChild(root_1, stream_declarations.nextTree());
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;
				case 8 :
					// cz/vutbr/web/csskit/antlr/CSS.g:780:4: MEDIA ( S )* ( media )? LCURLY ( S )* ( ruleset ( S )* )* RCURLY
					{
					MEDIA28=(Token)match(input,MEDIA,FOLLOW_MEDIA_in_atstatement409);  
					stream_MEDIA.add(MEDIA28);

					// cz/vutbr/web/csskit/antlr/CSS.g:780:10: ( S )*
					loop10:
					while (true) {
						int alt10=2;
						int LA10_0 = input.LA(1);
						if ( (LA10_0==S) ) {
							alt10=1;
						}

						switch (alt10) {
						case 1 :
							// cz/vutbr/web/csskit/antlr/CSS.g:780:10: S
							{
							S29=(Token)match(input,S,FOLLOW_S_in_atstatement411);  
							stream_S.add(S29);

							}
							break;

						default :
							break loop10;
						}
					}

					// cz/vutbr/web/csskit/antlr/CSS.g:780:13: ( media )?
					int alt11=2;
					int LA11_0 = input.LA(1);
					if ( (LA11_0==IDENT) ) {
						alt11=1;
					}
					switch (alt11) {
						case 1 :
							// cz/vutbr/web/csskit/antlr/CSS.g:780:13: media
							{
							pushFollow(FOLLOW_media_in_atstatement414);
							media30=media();
							state._fsp--;

							stream_media.add(media30.getTree());
							}
							break;

					}

					LCURLY31=(Token)match(input,LCURLY,FOLLOW_LCURLY_in_atstatement420);  
					stream_LCURLY.add(LCURLY31);

					// cz/vutbr/web/csskit/antlr/CSS.g:781:10: ( S )*
					loop12:
					while (true) {
						int alt12=2;
						int LA12_0 = input.LA(1);
						if ( (LA12_0==S) ) {
							alt12=1;
						}

						switch (alt12) {
						case 1 :
							// cz/vutbr/web/csskit/antlr/CSS.g:781:10: S
							{
							S32=(Token)match(input,S,FOLLOW_S_in_atstatement422);  
							stream_S.add(S32);

							}
							break;

						default :
							break loop12;
						}
					}

					// cz/vutbr/web/csskit/antlr/CSS.g:781:13: ( ruleset ( S )* )*
					loop14:
					while (true) {
						int alt14=2;
						int LA14_0 = input.LA(1);
						if ( (LA14_0==ASTERISK||(LA14_0 >= CLASSKEYWORD && LA14_0 <= COMMA)||LA14_0==CTRL||LA14_0==DASHMATCH||LA14_0==DIMENSION||LA14_0==EQUALS||LA14_0==EXCLAMATION||(LA14_0 >= GREATER && LA14_0 <= IDENT)||LA14_0==INCLUDES||LA14_0==INVALID_SELPART||LA14_0==INVALID_STRING||LA14_0==LBRACE||LA14_0==LESS||LA14_0==MINUS||LA14_0==NUMBER||(LA14_0 >= PERCENT && LA14_0 <= PLUS)||LA14_0==QUESTION||LA14_0==RPAREN||LA14_0==SLASH||LA14_0==STRING||(LA14_0 >= UNIRANGE && LA14_0 <= URI)||(LA14_0 >= 101 && LA14_0 <= 102)) ) {
							alt14=1;
						}

						switch (alt14) {
						case 1 :
							// cz/vutbr/web/csskit/antlr/CSS.g:781:14: ruleset ( S )*
							{
							pushFollow(FOLLOW_ruleset_in_atstatement426);
							ruleset33=ruleset();
							state._fsp--;

							stream_ruleset.add(ruleset33.getTree());
							// cz/vutbr/web/csskit/antlr/CSS.g:781:22: ( S )*
							loop13:
							while (true) {
								int alt13=2;
								int LA13_0 = input.LA(1);
								if ( (LA13_0==S) ) {
									alt13=1;
								}

								switch (alt13) {
								case 1 :
									// cz/vutbr/web/csskit/antlr/CSS.g:781:22: S
									{
									S34=(Token)match(input,S,FOLLOW_S_in_atstatement428);  
									stream_S.add(S34);

									}
									break;

								default :
									break loop13;
								}
							}

							}
							break;

						default :
							break loop14;
						}
					}

					RCURLY35=(Token)match(input,RCURLY,FOLLOW_RCURLY_in_atstatement433);  
					stream_RCURLY.add(RCURLY35);

					// AST REWRITE
					// elements: MEDIA, ruleset, media
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (Object)adaptor.nil();
					// 781:34: -> ^( MEDIA ( media )? ( ruleset )* )
					{
						// cz/vutbr/web/csskit/antlr/CSS.g:781:37: ^( MEDIA ( media )? ( ruleset )* )
						{
						Object root_1 = (Object)adaptor.nil();
						root_1 = (Object)adaptor.becomeRoot(stream_MEDIA.nextNode(), root_1);
						// cz/vutbr/web/csskit/antlr/CSS.g:781:45: ( media )?
						if ( stream_media.hasNext() ) {
							adaptor.addChild(root_1, stream_media.nextTree());
						}
						stream_media.reset();

						// cz/vutbr/web/csskit/antlr/CSS.g:781:52: ( ruleset )*
						while ( stream_ruleset.hasNext() ) {
							adaptor.addChild(root_1, stream_ruleset.nextTree());
						}
						stream_ruleset.reset();

						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;
				case 9 :
					// cz/vutbr/web/csskit/antlr/CSS.g:782:4: ATKEYWORD ( S )* LCURLY ( any )* RCURLY
					{
					ATKEYWORD36=(Token)match(input,ATKEYWORD,FOLLOW_ATKEYWORD_in_atstatement451);  
					stream_ATKEYWORD.add(ATKEYWORD36);

					// cz/vutbr/web/csskit/antlr/CSS.g:782:14: ( S )*
					loop15:
					while (true) {
						int alt15=2;
						int LA15_0 = input.LA(1);
						if ( (LA15_0==S) ) {
							alt15=1;
						}

						switch (alt15) {
						case 1 :
							// cz/vutbr/web/csskit/antlr/CSS.g:782:14: S
							{
							S37=(Token)match(input,S,FOLLOW_S_in_atstatement453);  
							stream_S.add(S37);

							}
							break;

						default :
							break loop15;
						}
					}

					LCURLY38=(Token)match(input,LCURLY,FOLLOW_LCURLY_in_atstatement456);  
					stream_LCURLY.add(LCURLY38);

					// cz/vutbr/web/csskit/antlr/CSS.g:782:24: ( any )*
					loop16:
					while (true) {
						int alt16=2;
						int LA16_0 = input.LA(1);
						if ( (LA16_0==ASTERISK||(LA16_0 >= CLASSKEYWORD && LA16_0 <= COMMA)||LA16_0==DASHMATCH||LA16_0==DIMENSION||LA16_0==EQUALS||LA16_0==EXCLAMATION||(LA16_0 >= FUNCTION && LA16_0 <= IDENT)||LA16_0==INCLUDES||LA16_0==INVALID_STRING||LA16_0==LBRACE||(LA16_0 >= LESS && LA16_0 <= LPAREN)||LA16_0==MINUS||LA16_0==NUMBER||(LA16_0 >= PERCENT && LA16_0 <= PLUS)||LA16_0==QUESTION||LA16_0==SLASH||LA16_0==STRING||(LA16_0 >= UNIRANGE && LA16_0 <= URI)) ) {
							alt16=1;
						}

						switch (alt16) {
						case 1 :
							// cz/vutbr/web/csskit/antlr/CSS.g:782:24: any
							{
							pushFollow(FOLLOW_any_in_atstatement458);
							any39=any();
							state._fsp--;

							stream_any.add(any39.getTree());
							}
							break;

						default :
							break loop16;
						}
					}

					RCURLY40=(Token)match(input,RCURLY,FOLLOW_RCURLY_in_atstatement461);  
					stream_RCURLY.add(RCURLY40);

					// AST REWRITE
					// elements: 
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (Object)adaptor.nil();
					// 782:36: -> INVALID_STATEMENT
					{
						adaptor.addChild(root_0, (Object)adaptor.create(INVALID_STATEMENT, "INVALID_STATEMENT"));
					}


					retval.tree = root_0;

					}
					break;

			}
			retval.stop = input.LT(-1);

			retval.tree = (Object)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {

			      	final BitSet follow = BitSet.of(CSSLexer.RCURLY, CSSLexer.SEMICOLON);								
				    retval.tree = invalidFallbackGreedy(CSSLexer.INVALID_STATEMENT, 
				  		"INVALID_STATEMENT", follow, re);							
				
		}

		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "atstatement"


	public static class page_return extends ParserRuleReturnScope {
		Object tree;
		@Override
		public Object getTree() { return tree; }
	};


	// $ANTLR start "page"
	// cz/vutbr/web/csskit/antlr/CSS.g:790:1: page : PAGE ( S )* ( ( IDENT | IDENT page_pseudo | page_pseudo ) ( S )* )? LCURLY ( S )* declarations ( margin_rule )* RCURLY -> ^( PAGE ( IDENT )? ( page_pseudo )? declarations ^( SET ( margin_rule )* ) ) ;
	public final CSSParser.page_return page() throws RecognitionException {
		CSSParser.page_return retval = new CSSParser.page_return();
		retval.start = input.LT(1);

		Object root_0 = null;

		Token PAGE41=null;
		Token S42=null;
		Token IDENT43=null;
		Token IDENT44=null;
		Token S47=null;
		Token LCURLY48=null;
		Token S49=null;
		Token RCURLY52=null;
		ParserRuleReturnScope page_pseudo45 =null;
		ParserRuleReturnScope page_pseudo46 =null;
		ParserRuleReturnScope declarations50 =null;
		ParserRuleReturnScope margin_rule51 =null;

		Object PAGE41_tree=null;
		Object S42_tree=null;
		Object IDENT43_tree=null;
		Object IDENT44_tree=null;
		Object S47_tree=null;
		Object LCURLY48_tree=null;
		Object S49_tree=null;
		Object RCURLY52_tree=null;
		RewriteRuleTokenStream stream_IDENT=new RewriteRuleTokenStream(adaptor,"token IDENT");
		RewriteRuleTokenStream stream_LCURLY=new RewriteRuleTokenStream(adaptor,"token LCURLY");
		RewriteRuleTokenStream stream_PAGE=new RewriteRuleTokenStream(adaptor,"token PAGE");
		RewriteRuleTokenStream stream_S=new RewriteRuleTokenStream(adaptor,"token S");
		RewriteRuleTokenStream stream_RCURLY=new RewriteRuleTokenStream(adaptor,"token RCURLY");
		RewriteRuleSubtreeStream stream_page_pseudo=new RewriteRuleSubtreeStream(adaptor,"rule page_pseudo");
		RewriteRuleSubtreeStream stream_declarations=new RewriteRuleSubtreeStream(adaptor,"rule declarations");
		RewriteRuleSubtreeStream stream_margin_rule=new RewriteRuleSubtreeStream(adaptor,"rule margin_rule");

		try {
			// cz/vutbr/web/csskit/antlr/CSS.g:791:2: ( PAGE ( S )* ( ( IDENT | IDENT page_pseudo | page_pseudo ) ( S )* )? LCURLY ( S )* declarations ( margin_rule )* RCURLY -> ^( PAGE ( IDENT )? ( page_pseudo )? declarations ^( SET ( margin_rule )* ) ) )
			// cz/vutbr/web/csskit/antlr/CSS.g:791:4: PAGE ( S )* ( ( IDENT | IDENT page_pseudo | page_pseudo ) ( S )* )? LCURLY ( S )* declarations ( margin_rule )* RCURLY
			{
			PAGE41=(Token)match(input,PAGE,FOLLOW_PAGE_in_page483);  
			stream_PAGE.add(PAGE41);

			// cz/vutbr/web/csskit/antlr/CSS.g:791:9: ( S )*
			loop18:
			while (true) {
				int alt18=2;
				int LA18_0 = input.LA(1);
				if ( (LA18_0==S) ) {
					alt18=1;
				}

				switch (alt18) {
				case 1 :
					// cz/vutbr/web/csskit/antlr/CSS.g:791:9: S
					{
					S42=(Token)match(input,S,FOLLOW_S_in_page485);  
					stream_S.add(S42);

					}
					break;

				default :
					break loop18;
				}
			}

			// cz/vutbr/web/csskit/antlr/CSS.g:791:12: ( ( IDENT | IDENT page_pseudo | page_pseudo ) ( S )* )?
			int alt21=2;
			int LA21_0 = input.LA(1);
			if ( (LA21_0==COLON||LA21_0==IDENT) ) {
				alt21=1;
			}
			switch (alt21) {
				case 1 :
					// cz/vutbr/web/csskit/antlr/CSS.g:791:13: ( IDENT | IDENT page_pseudo | page_pseudo ) ( S )*
					{
					// cz/vutbr/web/csskit/antlr/CSS.g:791:13: ( IDENT | IDENT page_pseudo | page_pseudo )
					int alt19=3;
					int LA19_0 = input.LA(1);
					if ( (LA19_0==IDENT) ) {
						int LA19_1 = input.LA(2);
						if ( (LA19_1==LCURLY||LA19_1==S) ) {
							alt19=1;
						}
						else if ( (LA19_1==COLON) ) {
							alt19=2;
						}

						else {
							int nvaeMark = input.mark();
							try {
								input.consume();
								NoViableAltException nvae =
									new NoViableAltException("", 19, 1, input);
								throw nvae;
							} finally {
								input.rewind(nvaeMark);
							}
						}

					}
					else if ( (LA19_0==COLON) ) {
						alt19=3;
					}

					else {
						NoViableAltException nvae =
							new NoViableAltException("", 19, 0, input);
						throw nvae;
					}

					switch (alt19) {
						case 1 :
							// cz/vutbr/web/csskit/antlr/CSS.g:791:15: IDENT
							{
							IDENT43=(Token)match(input,IDENT,FOLLOW_IDENT_in_page491);  
							stream_IDENT.add(IDENT43);

							}
							break;
						case 2 :
							// cz/vutbr/web/csskit/antlr/CSS.g:791:23: IDENT page_pseudo
							{
							IDENT44=(Token)match(input,IDENT,FOLLOW_IDENT_in_page495);  
							stream_IDENT.add(IDENT44);

							pushFollow(FOLLOW_page_pseudo_in_page497);
							page_pseudo45=page_pseudo();
							state._fsp--;

							stream_page_pseudo.add(page_pseudo45.getTree());
							}
							break;
						case 3 :
							// cz/vutbr/web/csskit/antlr/CSS.g:791:43: page_pseudo
							{
							pushFollow(FOLLOW_page_pseudo_in_page501);
							page_pseudo46=page_pseudo();
							state._fsp--;

							stream_page_pseudo.add(page_pseudo46.getTree());
							}
							break;

					}

					// cz/vutbr/web/csskit/antlr/CSS.g:791:56: ( S )*
					loop20:
					while (true) {
						int alt20=2;
						int LA20_0 = input.LA(1);
						if ( (LA20_0==S) ) {
							alt20=1;
						}

						switch (alt20) {
						case 1 :
							// cz/vutbr/web/csskit/antlr/CSS.g:791:56: S
							{
							S47=(Token)match(input,S,FOLLOW_S_in_page504);  
							stream_S.add(S47);

							}
							break;

						default :
							break loop20;
						}
					}

					}
					break;

			}

			LCURLY48=(Token)match(input,LCURLY,FOLLOW_LCURLY_in_page512);  
			stream_LCURLY.add(LCURLY48);

			// cz/vutbr/web/csskit/antlr/CSS.g:792:10: ( S )*
			loop22:
			while (true) {
				int alt22=2;
				int LA22_0 = input.LA(1);
				if ( (LA22_0==S) ) {
					alt22=1;
				}

				switch (alt22) {
				case 1 :
					// cz/vutbr/web/csskit/antlr/CSS.g:792:10: S
					{
					S49=(Token)match(input,S,FOLLOW_S_in_page514);  
					stream_S.add(S49);

					}
					break;

				default :
					break loop22;
				}
			}

			pushFollow(FOLLOW_declarations_in_page519);
			declarations50=declarations();
			state._fsp--;

			stream_declarations.add(declarations50.getTree());
			// cz/vutbr/web/csskit/antlr/CSS.g:793:16: ( margin_rule )*
			loop23:
			while (true) {
				int alt23=2;
				int LA23_0 = input.LA(1);
				if ( (LA23_0==MARGIN_AREA) ) {
					alt23=1;
				}

				switch (alt23) {
				case 1 :
					// cz/vutbr/web/csskit/antlr/CSS.g:793:16: margin_rule
					{
					pushFollow(FOLLOW_margin_rule_in_page521);
					margin_rule51=margin_rule();
					state._fsp--;

					stream_margin_rule.add(margin_rule51.getTree());
					}
					break;

				default :
					break loop23;
				}
			}

			RCURLY52=(Token)match(input,RCURLY,FOLLOW_RCURLY_in_page526);  
			stream_RCURLY.add(RCURLY52);

			// AST REWRITE
			// elements: PAGE, declarations, IDENT, margin_rule, page_pseudo
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (Object)adaptor.nil();
			// 795:3: -> ^( PAGE ( IDENT )? ( page_pseudo )? declarations ^( SET ( margin_rule )* ) )
			{
				// cz/vutbr/web/csskit/antlr/CSS.g:795:6: ^( PAGE ( IDENT )? ( page_pseudo )? declarations ^( SET ( margin_rule )* ) )
				{
				Object root_1 = (Object)adaptor.nil();
				root_1 = (Object)adaptor.becomeRoot(stream_PAGE.nextNode(), root_1);
				// cz/vutbr/web/csskit/antlr/CSS.g:795:13: ( IDENT )?
				if ( stream_IDENT.hasNext() ) {
					adaptor.addChild(root_1, stream_IDENT.nextNode());
				}
				stream_IDENT.reset();

				// cz/vutbr/web/csskit/antlr/CSS.g:795:20: ( page_pseudo )?
				if ( stream_page_pseudo.hasNext() ) {
					adaptor.addChild(root_1, stream_page_pseudo.nextTree());
				}
				stream_page_pseudo.reset();

				adaptor.addChild(root_1, stream_declarations.nextTree());
				// cz/vutbr/web/csskit/antlr/CSS.g:795:46: ^( SET ( margin_rule )* )
				{
				Object root_2 = (Object)adaptor.nil();
				root_2 = (Object)adaptor.becomeRoot((Object)adaptor.create(SET, "SET"), root_2);
				// cz/vutbr/web/csskit/antlr/CSS.g:795:52: ( margin_rule )*
				while ( stream_margin_rule.hasNext() ) {
					adaptor.addChild(root_2, stream_margin_rule.nextTree());
				}
				stream_margin_rule.reset();

				adaptor.addChild(root_1, root_2);
				}

				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (Object)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "page"


	public static class page_pseudo_return extends ParserRuleReturnScope {
		Object tree;
		@Override
		public Object getTree() { return tree; }
	};


	// $ANTLR start "page_pseudo"
	// cz/vutbr/web/csskit/antlr/CSS.g:798:1: page_pseudo : pseudocolon ^ IDENT ;
	public final CSSParser.page_pseudo_return page_pseudo() throws RecognitionException {
		CSSParser.page_pseudo_return retval = new CSSParser.page_pseudo_return();
		retval.start = input.LT(1);

		Object root_0 = null;

		Token IDENT54=null;
		ParserRuleReturnScope pseudocolon53 =null;

		Object IDENT54_tree=null;

		try {
			// cz/vutbr/web/csskit/antlr/CSS.g:799:2: ( pseudocolon ^ IDENT )
			// cz/vutbr/web/csskit/antlr/CSS.g:799:4: pseudocolon ^ IDENT
			{
			root_0 = (Object)adaptor.nil();


			pushFollow(FOLLOW_pseudocolon_in_page_pseudo560);
			pseudocolon53=pseudocolon();
			state._fsp--;

			root_0 = (Object)adaptor.becomeRoot(pseudocolon53.getTree(), root_0);
			IDENT54=(Token)match(input,IDENT,FOLLOW_IDENT_in_page_pseudo563); 
			IDENT54_tree = (Object)adaptor.create(IDENT54);
			adaptor.addChild(root_0, IDENT54_tree);

			}

			retval.stop = input.LT(-1);

			retval.tree = (Object)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "page_pseudo"


	public static class margin_rule_return extends ParserRuleReturnScope {
		Object tree;
		@Override
		public Object getTree() { return tree; }
	};


	// $ANTLR start "margin_rule"
	// cz/vutbr/web/csskit/antlr/CSS.g:802:1: margin_rule : MARGIN_AREA ( S )* LCURLY ( S )* declarations RCURLY ( S )* -> ^( MARGIN_AREA declarations ) ;
	public final CSSParser.margin_rule_return margin_rule() throws RecognitionException {
		CSSParser.margin_rule_return retval = new CSSParser.margin_rule_return();
		retval.start = input.LT(1);

		Object root_0 = null;

		Token MARGIN_AREA55=null;
		Token S56=null;
		Token LCURLY57=null;
		Token S58=null;
		Token RCURLY60=null;
		Token S61=null;
		ParserRuleReturnScope declarations59 =null;

		Object MARGIN_AREA55_tree=null;
		Object S56_tree=null;
		Object LCURLY57_tree=null;
		Object S58_tree=null;
		Object RCURLY60_tree=null;
		Object S61_tree=null;
		RewriteRuleTokenStream stream_LCURLY=new RewriteRuleTokenStream(adaptor,"token LCURLY");
		RewriteRuleTokenStream stream_S=new RewriteRuleTokenStream(adaptor,"token S");
		RewriteRuleTokenStream stream_RCURLY=new RewriteRuleTokenStream(adaptor,"token RCURLY");
		RewriteRuleTokenStream stream_MARGIN_AREA=new RewriteRuleTokenStream(adaptor,"token MARGIN_AREA");
		RewriteRuleSubtreeStream stream_declarations=new RewriteRuleSubtreeStream(adaptor,"rule declarations");

		try {
			// cz/vutbr/web/csskit/antlr/CSS.g:803:2: ( MARGIN_AREA ( S )* LCURLY ( S )* declarations RCURLY ( S )* -> ^( MARGIN_AREA declarations ) )
			// cz/vutbr/web/csskit/antlr/CSS.g:803:4: MARGIN_AREA ( S )* LCURLY ( S )* declarations RCURLY ( S )*
			{
			MARGIN_AREA55=(Token)match(input,MARGIN_AREA,FOLLOW_MARGIN_AREA_in_margin_rule574);  
			stream_MARGIN_AREA.add(MARGIN_AREA55);

			// cz/vutbr/web/csskit/antlr/CSS.g:803:16: ( S )*
			loop24:
			while (true) {
				int alt24=2;
				int LA24_0 = input.LA(1);
				if ( (LA24_0==S) ) {
					alt24=1;
				}

				switch (alt24) {
				case 1 :
					// cz/vutbr/web/csskit/antlr/CSS.g:803:16: S
					{
					S56=(Token)match(input,S,FOLLOW_S_in_margin_rule576);  
					stream_S.add(S56);

					}
					break;

				default :
					break loop24;
				}
			}

			LCURLY57=(Token)match(input,LCURLY,FOLLOW_LCURLY_in_margin_rule579);  
			stream_LCURLY.add(LCURLY57);

			// cz/vutbr/web/csskit/antlr/CSS.g:803:26: ( S )*
			loop25:
			while (true) {
				int alt25=2;
				int LA25_0 = input.LA(1);
				if ( (LA25_0==S) ) {
					alt25=1;
				}

				switch (alt25) {
				case 1 :
					// cz/vutbr/web/csskit/antlr/CSS.g:803:26: S
					{
					S58=(Token)match(input,S,FOLLOW_S_in_margin_rule581);  
					stream_S.add(S58);

					}
					break;

				default :
					break loop25;
				}
			}

			pushFollow(FOLLOW_declarations_in_margin_rule584);
			declarations59=declarations();
			state._fsp--;

			stream_declarations.add(declarations59.getTree());
			RCURLY60=(Token)match(input,RCURLY,FOLLOW_RCURLY_in_margin_rule586);  
			stream_RCURLY.add(RCURLY60);

			// cz/vutbr/web/csskit/antlr/CSS.g:803:49: ( S )*
			loop26:
			while (true) {
				int alt26=2;
				int LA26_0 = input.LA(1);
				if ( (LA26_0==S) ) {
					alt26=1;
				}

				switch (alt26) {
				case 1 :
					// cz/vutbr/web/csskit/antlr/CSS.g:803:49: S
					{
					S61=(Token)match(input,S,FOLLOW_S_in_margin_rule588);  
					stream_S.add(S61);

					}
					break;

				default :
					break loop26;
				}
			}

			// AST REWRITE
			// elements: declarations, MARGIN_AREA
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (Object)adaptor.nil();
			// 803:52: -> ^( MARGIN_AREA declarations )
			{
				// cz/vutbr/web/csskit/antlr/CSS.g:803:55: ^( MARGIN_AREA declarations )
				{
				Object root_1 = (Object)adaptor.nil();
				root_1 = (Object)adaptor.becomeRoot(stream_MARGIN_AREA.nextNode(), root_1);
				adaptor.addChild(root_1, stream_declarations.nextTree());
				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (Object)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "margin_rule"


	public static class inlineset_return extends ParserRuleReturnScope {
		Object tree;
		@Override
		public Object getTree() { return tree; }
	};


	// $ANTLR start "inlineset"
	// cz/vutbr/web/csskit/antlr/CSS.g:808:1: inlineset : ( pseudo ( S )* ( COMMA ( S )* pseudo ( S )* )* )? LCURLY declarations RCURLY -> ^( RULE ( pseudo )* declarations ) ;
	public final CSSParser.inlineset_return inlineset() throws RecognitionException {
		CSSParser.inlineset_return retval = new CSSParser.inlineset_return();
		retval.start = input.LT(1);

		Object root_0 = null;

		Token S63=null;
		Token COMMA64=null;
		Token S65=null;
		Token S67=null;
		Token LCURLY68=null;
		Token RCURLY70=null;
		ParserRuleReturnScope pseudo62 =null;
		ParserRuleReturnScope pseudo66 =null;
		ParserRuleReturnScope declarations69 =null;

		Object S63_tree=null;
		Object COMMA64_tree=null;
		Object S65_tree=null;
		Object S67_tree=null;
		Object LCURLY68_tree=null;
		Object RCURLY70_tree=null;
		RewriteRuleTokenStream stream_LCURLY=new RewriteRuleTokenStream(adaptor,"token LCURLY");
		RewriteRuleTokenStream stream_S=new RewriteRuleTokenStream(adaptor,"token S");
		RewriteRuleTokenStream stream_COMMA=new RewriteRuleTokenStream(adaptor,"token COMMA");
		RewriteRuleTokenStream stream_RCURLY=new RewriteRuleTokenStream(adaptor,"token RCURLY");
		RewriteRuleSubtreeStream stream_pseudo=new RewriteRuleSubtreeStream(adaptor,"rule pseudo");
		RewriteRuleSubtreeStream stream_declarations=new RewriteRuleSubtreeStream(adaptor,"rule declarations");

		try {
			// cz/vutbr/web/csskit/antlr/CSS.g:809:2: ( ( pseudo ( S )* ( COMMA ( S )* pseudo ( S )* )* )? LCURLY declarations RCURLY -> ^( RULE ( pseudo )* declarations ) )
			// cz/vutbr/web/csskit/antlr/CSS.g:809:4: ( pseudo ( S )* ( COMMA ( S )* pseudo ( S )* )* )? LCURLY declarations RCURLY
			{
			// cz/vutbr/web/csskit/antlr/CSS.g:809:4: ( pseudo ( S )* ( COMMA ( S )* pseudo ( S )* )* )?
			int alt31=2;
			int LA31_0 = input.LA(1);
			if ( (LA31_0==COLON) ) {
				alt31=1;
			}
			switch (alt31) {
				case 1 :
					// cz/vutbr/web/csskit/antlr/CSS.g:809:5: pseudo ( S )* ( COMMA ( S )* pseudo ( S )* )*
					{
					pushFollow(FOLLOW_pseudo_in_inlineset611);
					pseudo62=pseudo();
					state._fsp--;

					stream_pseudo.add(pseudo62.getTree());
					// cz/vutbr/web/csskit/antlr/CSS.g:809:12: ( S )*
					loop27:
					while (true) {
						int alt27=2;
						int LA27_0 = input.LA(1);
						if ( (LA27_0==S) ) {
							alt27=1;
						}

						switch (alt27) {
						case 1 :
							// cz/vutbr/web/csskit/antlr/CSS.g:809:12: S
							{
							S63=(Token)match(input,S,FOLLOW_S_in_inlineset613);  
							stream_S.add(S63);

							}
							break;

						default :
							break loop27;
						}
					}

					// cz/vutbr/web/csskit/antlr/CSS.g:809:15: ( COMMA ( S )* pseudo ( S )* )*
					loop30:
					while (true) {
						int alt30=2;
						int LA30_0 = input.LA(1);
						if ( (LA30_0==COMMA) ) {
							alt30=1;
						}

						switch (alt30) {
						case 1 :
							// cz/vutbr/web/csskit/antlr/CSS.g:809:16: COMMA ( S )* pseudo ( S )*
							{
							COMMA64=(Token)match(input,COMMA,FOLLOW_COMMA_in_inlineset617);  
							stream_COMMA.add(COMMA64);

							// cz/vutbr/web/csskit/antlr/CSS.g:809:22: ( S )*
							loop28:
							while (true) {
								int alt28=2;
								int LA28_0 = input.LA(1);
								if ( (LA28_0==S) ) {
									alt28=1;
								}

								switch (alt28) {
								case 1 :
									// cz/vutbr/web/csskit/antlr/CSS.g:809:22: S
									{
									S65=(Token)match(input,S,FOLLOW_S_in_inlineset619);  
									stream_S.add(S65);

									}
									break;

								default :
									break loop28;
								}
							}

							pushFollow(FOLLOW_pseudo_in_inlineset622);
							pseudo66=pseudo();
							state._fsp--;

							stream_pseudo.add(pseudo66.getTree());
							// cz/vutbr/web/csskit/antlr/CSS.g:809:32: ( S )*
							loop29:
							while (true) {
								int alt29=2;
								int LA29_0 = input.LA(1);
								if ( (LA29_0==S) ) {
									alt29=1;
								}

								switch (alt29) {
								case 1 :
									// cz/vutbr/web/csskit/antlr/CSS.g:809:32: S
									{
									S67=(Token)match(input,S,FOLLOW_S_in_inlineset624);  
									stream_S.add(S67);

									}
									break;

								default :
									break loop29;
								}
							}

							}
							break;

						default :
							break loop30;
						}
					}

					}
					break;

			}

			LCURLY68=(Token)match(input,LCURLY,FOLLOW_LCURLY_in_inlineset637);  
			stream_LCURLY.add(LCURLY68);

			pushFollow(FOLLOW_declarations_in_inlineset643);
			declarations69=declarations();
			state._fsp--;

			stream_declarations.add(declarations69.getTree());
			RCURLY70=(Token)match(input,RCURLY,FOLLOW_RCURLY_in_inlineset648);  
			stream_RCURLY.add(RCURLY70);

			// AST REWRITE
			// elements: pseudo, declarations
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (Object)adaptor.nil();
			// 813:4: -> ^( RULE ( pseudo )* declarations )
			{
				// cz/vutbr/web/csskit/antlr/CSS.g:813:7: ^( RULE ( pseudo )* declarations )
				{
				Object root_1 = (Object)adaptor.nil();
				root_1 = (Object)adaptor.becomeRoot((Object)adaptor.create(RULE, "RULE"), root_1);
				// cz/vutbr/web/csskit/antlr/CSS.g:813:14: ( pseudo )*
				while ( stream_pseudo.hasNext() ) {
					adaptor.addChild(root_1, stream_pseudo.nextTree());
				}
				stream_pseudo.reset();

				adaptor.addChild(root_1, stream_declarations.nextTree());
				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (Object)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "inlineset"


	public static class media_return extends ParserRuleReturnScope {
		Object tree;
		@Override
		public Object getTree() { return tree; }
	};


	// $ANTLR start "media"
	// cz/vutbr/web/csskit/antlr/CSS.g:816:1: media : IDENT ( S )* ( COMMA ( S )* IDENT ( S )* )* -> ( IDENT )+ ;
	public final CSSParser.media_return media() throws RecognitionException {
		CSSParser.media_return retval = new CSSParser.media_return();
		retval.start = input.LT(1);

		Object root_0 = null;

		Token IDENT71=null;
		Token S72=null;
		Token COMMA73=null;
		Token S74=null;
		Token IDENT75=null;
		Token S76=null;

		Object IDENT71_tree=null;
		Object S72_tree=null;
		Object COMMA73_tree=null;
		Object S74_tree=null;
		Object IDENT75_tree=null;
		Object S76_tree=null;
		RewriteRuleTokenStream stream_IDENT=new RewriteRuleTokenStream(adaptor,"token IDENT");
		RewriteRuleTokenStream stream_S=new RewriteRuleTokenStream(adaptor,"token S");
		RewriteRuleTokenStream stream_COMMA=new RewriteRuleTokenStream(adaptor,"token COMMA");

		try {
			// cz/vutbr/web/csskit/antlr/CSS.g:817:2: ( IDENT ( S )* ( COMMA ( S )* IDENT ( S )* )* -> ( IDENT )+ )
			// cz/vutbr/web/csskit/antlr/CSS.g:817:4: IDENT ( S )* ( COMMA ( S )* IDENT ( S )* )*
			{
			IDENT71=(Token)match(input,IDENT,FOLLOW_IDENT_in_media675);  
			stream_IDENT.add(IDENT71);

			// cz/vutbr/web/csskit/antlr/CSS.g:817:10: ( S )*
			loop32:
			while (true) {
				int alt32=2;
				int LA32_0 = input.LA(1);
				if ( (LA32_0==S) ) {
					alt32=1;
				}

				switch (alt32) {
				case 1 :
					// cz/vutbr/web/csskit/antlr/CSS.g:817:10: S
					{
					S72=(Token)match(input,S,FOLLOW_S_in_media677);  
					stream_S.add(S72);

					}
					break;

				default :
					break loop32;
				}
			}

			// cz/vutbr/web/csskit/antlr/CSS.g:817:13: ( COMMA ( S )* IDENT ( S )* )*
			loop35:
			while (true) {
				int alt35=2;
				int LA35_0 = input.LA(1);
				if ( (LA35_0==COMMA) ) {
					alt35=1;
				}

				switch (alt35) {
				case 1 :
					// cz/vutbr/web/csskit/antlr/CSS.g:817:14: COMMA ( S )* IDENT ( S )*
					{
					COMMA73=(Token)match(input,COMMA,FOLLOW_COMMA_in_media681);  
					stream_COMMA.add(COMMA73);

					// cz/vutbr/web/csskit/antlr/CSS.g:817:20: ( S )*
					loop33:
					while (true) {
						int alt33=2;
						int LA33_0 = input.LA(1);
						if ( (LA33_0==S) ) {
							alt33=1;
						}

						switch (alt33) {
						case 1 :
							// cz/vutbr/web/csskit/antlr/CSS.g:817:20: S
							{
							S74=(Token)match(input,S,FOLLOW_S_in_media683);  
							stream_S.add(S74);

							}
							break;

						default :
							break loop33;
						}
					}

					IDENT75=(Token)match(input,IDENT,FOLLOW_IDENT_in_media686);  
					stream_IDENT.add(IDENT75);

					// cz/vutbr/web/csskit/antlr/CSS.g:817:29: ( S )*
					loop34:
					while (true) {
						int alt34=2;
						int LA34_0 = input.LA(1);
						if ( (LA34_0==S) ) {
							alt34=1;
						}

						switch (alt34) {
						case 1 :
							// cz/vutbr/web/csskit/antlr/CSS.g:817:29: S
							{
							S76=(Token)match(input,S,FOLLOW_S_in_media688);  
							stream_S.add(S76);

							}
							break;

						default :
							break loop34;
						}
					}

					}
					break;

				default :
					break loop35;
				}
			}

			// AST REWRITE
			// elements: IDENT
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (Object)adaptor.nil();
			// 818:3: -> ( IDENT )+
			{
				if ( !(stream_IDENT.hasNext()) ) {
					throw new RewriteEarlyExitException();
				}
				while ( stream_IDENT.hasNext() ) {
					adaptor.addChild(root_0, stream_IDENT.nextNode());
				}
				stream_IDENT.reset();

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (Object)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "media"


	public static class ruleset_return extends ParserRuleReturnScope {
		Object tree;
		@Override
		public Object getTree() { return tree; }
	};


	// $ANTLR start "ruleset"
	// cz/vutbr/web/csskit/antlr/CSS.g:821:1: ruleset : ( combined_selector ( COMMA ( S )* combined_selector )* LCURLY ( S )* declarations RCURLY -> ^( RULE ( combined_selector )+ declarations ) | norule -> INVALID_STATEMENT );
	public final CSSParser.ruleset_return ruleset() throws RecognitionException {
		CSSParser.ruleset_return retval = new CSSParser.ruleset_return();
		retval.start = input.LT(1);

		Object root_0 = null;

		Token COMMA78=null;
		Token S79=null;
		Token LCURLY81=null;
		Token S82=null;
		Token RCURLY84=null;
		ParserRuleReturnScope combined_selector77 =null;
		ParserRuleReturnScope combined_selector80 =null;
		ParserRuleReturnScope declarations83 =null;
		ParserRuleReturnScope norule85 =null;

		Object COMMA78_tree=null;
		Object S79_tree=null;
		Object LCURLY81_tree=null;
		Object S82_tree=null;
		Object RCURLY84_tree=null;
		RewriteRuleTokenStream stream_LCURLY=new RewriteRuleTokenStream(adaptor,"token LCURLY");
		RewriteRuleTokenStream stream_S=new RewriteRuleTokenStream(adaptor,"token S");
		RewriteRuleTokenStream stream_COMMA=new RewriteRuleTokenStream(adaptor,"token COMMA");
		RewriteRuleTokenStream stream_RCURLY=new RewriteRuleTokenStream(adaptor,"token RCURLY");
		RewriteRuleSubtreeStream stream_combined_selector=new RewriteRuleSubtreeStream(adaptor,"rule combined_selector");
		RewriteRuleSubtreeStream stream_norule=new RewriteRuleSubtreeStream(adaptor,"rule norule");
		RewriteRuleSubtreeStream stream_declarations=new RewriteRuleSubtreeStream(adaptor,"rule declarations");

		try {
			// cz/vutbr/web/csskit/antlr/CSS.g:822:2: ( combined_selector ( COMMA ( S )* combined_selector )* LCURLY ( S )* declarations RCURLY -> ^( RULE ( combined_selector )+ declarations ) | norule -> INVALID_STATEMENT )
			int alt39=2;
			int LA39_0 = input.LA(1);
			if ( (LA39_0==ASTERISK||(LA39_0 >= CLASSKEYWORD && LA39_0 <= COLON)||(LA39_0 >= HASH && LA39_0 <= IDENT)||LA39_0==INVALID_SELPART||LA39_0==LBRACE) ) {
				alt39=1;
			}
			else if ( (LA39_0==COMMA||LA39_0==CTRL||LA39_0==DASHMATCH||LA39_0==DIMENSION||LA39_0==EQUALS||LA39_0==EXCLAMATION||LA39_0==GREATER||LA39_0==INCLUDES||LA39_0==INVALID_STRING||LA39_0==LESS||LA39_0==MINUS||LA39_0==NUMBER||(LA39_0 >= PERCENT && LA39_0 <= PLUS)||LA39_0==QUESTION||LA39_0==RPAREN||LA39_0==SLASH||LA39_0==STRING||(LA39_0 >= UNIRANGE && LA39_0 <= URI)||(LA39_0 >= 101 && LA39_0 <= 102)) ) {
				alt39=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 39, 0, input);
				throw nvae;
			}

			switch (alt39) {
				case 1 :
					// cz/vutbr/web/csskit/antlr/CSS.g:822:4: combined_selector ( COMMA ( S )* combined_selector )* LCURLY ( S )* declarations RCURLY
					{
					pushFollow(FOLLOW_combined_selector_in_ruleset713);
					combined_selector77=combined_selector();
					state._fsp--;

					stream_combined_selector.add(combined_selector77.getTree());
					// cz/vutbr/web/csskit/antlr/CSS.g:822:22: ( COMMA ( S )* combined_selector )*
					loop37:
					while (true) {
						int alt37=2;
						int LA37_0 = input.LA(1);
						if ( (LA37_0==COMMA) ) {
							alt37=1;
						}

						switch (alt37) {
						case 1 :
							// cz/vutbr/web/csskit/antlr/CSS.g:822:23: COMMA ( S )* combined_selector
							{
							COMMA78=(Token)match(input,COMMA,FOLLOW_COMMA_in_ruleset716);  
							stream_COMMA.add(COMMA78);

							// cz/vutbr/web/csskit/antlr/CSS.g:822:29: ( S )*
							loop36:
							while (true) {
								int alt36=2;
								int LA36_0 = input.LA(1);
								if ( (LA36_0==S) ) {
									alt36=1;
								}

								switch (alt36) {
								case 1 :
									// cz/vutbr/web/csskit/antlr/CSS.g:822:29: S
									{
									S79=(Token)match(input,S,FOLLOW_S_in_ruleset718);  
									stream_S.add(S79);

									}
									break;

								default :
									break loop36;
								}
							}

							pushFollow(FOLLOW_combined_selector_in_ruleset721);
							combined_selector80=combined_selector();
							state._fsp--;

							stream_combined_selector.add(combined_selector80.getTree());
							}
							break;

						default :
							break loop37;
						}
					}

					LCURLY81=(Token)match(input,LCURLY,FOLLOW_LCURLY_in_ruleset729);  
					stream_LCURLY.add(LCURLY81);

					// cz/vutbr/web/csskit/antlr/CSS.g:823:11: ( S )*
					loop38:
					while (true) {
						int alt38=2;
						int LA38_0 = input.LA(1);
						if ( (LA38_0==S) ) {
							alt38=1;
						}

						switch (alt38) {
						case 1 :
							// cz/vutbr/web/csskit/antlr/CSS.g:823:11: S
							{
							S82=(Token)match(input,S,FOLLOW_S_in_ruleset731);  
							stream_S.add(S82);

							}
							break;

						default :
							break loop38;
						}
					}

					pushFollow(FOLLOW_declarations_in_ruleset739);
					declarations83=declarations();
					state._fsp--;

					stream_declarations.add(declarations83.getTree());
					RCURLY84=(Token)match(input,RCURLY,FOLLOW_RCURLY_in_ruleset744);  
					stream_RCURLY.add(RCURLY84);

					// AST REWRITE
					// elements: combined_selector, declarations
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (Object)adaptor.nil();
					// 826:4: -> ^( RULE ( combined_selector )+ declarations )
					{
						// cz/vutbr/web/csskit/antlr/CSS.g:826:7: ^( RULE ( combined_selector )+ declarations )
						{
						Object root_1 = (Object)adaptor.nil();
						root_1 = (Object)adaptor.becomeRoot((Object)adaptor.create(RULE, "RULE"), root_1);
						if ( !(stream_combined_selector.hasNext()) ) {
							throw new RewriteEarlyExitException();
						}
						while ( stream_combined_selector.hasNext() ) {
							adaptor.addChild(root_1, stream_combined_selector.nextTree());
						}
						stream_combined_selector.reset();

						adaptor.addChild(root_1, stream_declarations.nextTree());
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;
				case 2 :
					// cz/vutbr/web/csskit/antlr/CSS.g:827:4: norule
					{
					pushFollow(FOLLOW_norule_in_ruleset763);
					norule85=norule();
					state._fsp--;

					stream_norule.add(norule85.getTree());
					// AST REWRITE
					// elements: 
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (Object)adaptor.nil();
					// 827:11: -> INVALID_STATEMENT
					{
						adaptor.addChild(root_0, (Object)adaptor.create(INVALID_STATEMENT, "INVALID_STATEMENT"));
					}


					retval.tree = root_0;

					}
					break;

			}
			retval.stop = input.LT(-1);

			retval.tree = (Object)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {

			      final BitSet follow = BitSet.of(CSSLexer.RCURLY);
			      //we don't require {} to be balanced here because of possible parent 'media' sections that may remain open => RecoveryMode.RULE
				    retval.tree = invalidFallbackGreedy(CSSLexer.INVALID_STATEMENT,	"INVALID_STATEMENT", follow, LexerState.RecoveryMode.RULE, null, re);							
				
		}

		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "ruleset"


	public static class declarations_return extends ParserRuleReturnScope {
		Object tree;
		@Override
		public Object getTree() { return tree; }
	};


	// $ANTLR start "declarations"
	// cz/vutbr/web/csskit/antlr/CSS.g:835:1: declarations : ( declaration )? ( SEMICOLON ( S )* ( declaration )? )* -> ^( SET ( declaration )* ) ;
	public final CSSParser.declarations_return declarations() throws RecognitionException {
		CSSParser.declarations_return retval = new CSSParser.declarations_return();
		retval.start = input.LT(1);

		Object root_0 = null;

		Token SEMICOLON87=null;
		Token S88=null;
		ParserRuleReturnScope declaration86 =null;
		ParserRuleReturnScope declaration89 =null;

		Object SEMICOLON87_tree=null;
		Object S88_tree=null;
		RewriteRuleTokenStream stream_SEMICOLON=new RewriteRuleTokenStream(adaptor,"token SEMICOLON");
		RewriteRuleTokenStream stream_S=new RewriteRuleTokenStream(adaptor,"token S");
		RewriteRuleSubtreeStream stream_declaration=new RewriteRuleSubtreeStream(adaptor,"rule declaration");

		try {
			// cz/vutbr/web/csskit/antlr/CSS.g:836:2: ( ( declaration )? ( SEMICOLON ( S )* ( declaration )? )* -> ^( SET ( declaration )* ) )
			// cz/vutbr/web/csskit/antlr/CSS.g:836:4: ( declaration )? ( SEMICOLON ( S )* ( declaration )? )*
			{
			// cz/vutbr/web/csskit/antlr/CSS.g:836:4: ( declaration )?
			int alt40=2;
			int LA40_0 = input.LA(1);
			if ( (LA40_0==ASTERISK||(LA40_0 >= CLASSKEYWORD && LA40_0 <= COMMA)||LA40_0==CTRL||LA40_0==DASHMATCH||LA40_0==EQUALS||LA40_0==EXCLAMATION||LA40_0==GREATER||LA40_0==IDENT||LA40_0==INCLUDES||LA40_0==INVALID_TOKEN||LA40_0==LESS||LA40_0==MINUS||LA40_0==NUMBER||LA40_0==PERCENT||LA40_0==PLUS||LA40_0==QUESTION||LA40_0==SLASH||LA40_0==STRING_CHAR) ) {
				alt40=1;
			}
			switch (alt40) {
				case 1 :
					// cz/vutbr/web/csskit/antlr/CSS.g:836:4: declaration
					{
					pushFollow(FOLLOW_declaration_in_declarations785);
					declaration86=declaration();
					state._fsp--;

					stream_declaration.add(declaration86.getTree());
					}
					break;

			}

			// cz/vutbr/web/csskit/antlr/CSS.g:836:17: ( SEMICOLON ( S )* ( declaration )? )*
			loop43:
			while (true) {
				int alt43=2;
				int LA43_0 = input.LA(1);
				if ( (LA43_0==SEMICOLON) ) {
					alt43=1;
				}

				switch (alt43) {
				case 1 :
					// cz/vutbr/web/csskit/antlr/CSS.g:836:18: SEMICOLON ( S )* ( declaration )?
					{
					SEMICOLON87=(Token)match(input,SEMICOLON,FOLLOW_SEMICOLON_in_declarations789);  
					stream_SEMICOLON.add(SEMICOLON87);

					// cz/vutbr/web/csskit/antlr/CSS.g:836:28: ( S )*
					loop41:
					while (true) {
						int alt41=2;
						int LA41_0 = input.LA(1);
						if ( (LA41_0==S) ) {
							alt41=1;
						}

						switch (alt41) {
						case 1 :
							// cz/vutbr/web/csskit/antlr/CSS.g:836:28: S
							{
							S88=(Token)match(input,S,FOLLOW_S_in_declarations791);  
							stream_S.add(S88);

							}
							break;

						default :
							break loop41;
						}
					}

					// cz/vutbr/web/csskit/antlr/CSS.g:836:31: ( declaration )?
					int alt42=2;
					int LA42_0 = input.LA(1);
					if ( (LA42_0==ASTERISK||(LA42_0 >= CLASSKEYWORD && LA42_0 <= COMMA)||LA42_0==CTRL||LA42_0==DASHMATCH||LA42_0==EQUALS||LA42_0==EXCLAMATION||LA42_0==GREATER||LA42_0==IDENT||LA42_0==INCLUDES||LA42_0==INVALID_TOKEN||LA42_0==LESS||LA42_0==MINUS||LA42_0==NUMBER||LA42_0==PERCENT||LA42_0==PLUS||LA42_0==QUESTION||LA42_0==SLASH||LA42_0==STRING_CHAR) ) {
						alt42=1;
					}
					switch (alt42) {
						case 1 :
							// cz/vutbr/web/csskit/antlr/CSS.g:836:31: declaration
							{
							pushFollow(FOLLOW_declaration_in_declarations794);
							declaration89=declaration();
							state._fsp--;

							stream_declaration.add(declaration89.getTree());
							}
							break;

					}

					}
					break;

				default :
					break loop43;
				}
			}

			// AST REWRITE
			// elements: declaration
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (Object)adaptor.nil();
			// 837:4: -> ^( SET ( declaration )* )
			{
				// cz/vutbr/web/csskit/antlr/CSS.g:837:7: ^( SET ( declaration )* )
				{
				Object root_1 = (Object)adaptor.nil();
				root_1 = (Object)adaptor.becomeRoot((Object)adaptor.create(SET, "SET"), root_1);
				// cz/vutbr/web/csskit/antlr/CSS.g:837:13: ( declaration )*
				while ( stream_declaration.hasNext() ) {
					adaptor.addChild(root_1, stream_declaration.nextTree());
				}
				stream_declaration.reset();

				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (Object)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "declarations"


	public static class declaration_return extends ParserRuleReturnScope {
		Object tree;
		@Override
		public Object getTree() { return tree; }
	};


	// $ANTLR start "declaration"
	// cz/vutbr/web/csskit/antlr/CSS.g:840:1: declaration : ( property COLON ( S )* ( terms )? ( important )? -> ^( DECLARATION ( important )? property ( terms )? ) | noprop ( any )* -> INVALID_DECLARATION );
	public final CSSParser.declaration_return declaration() throws RecognitionException {
		CSSParser.declaration_return retval = new CSSParser.declaration_return();
		retval.start = input.LT(1);

		Object root_0 = null;

		Token COLON91=null;
		Token S92=null;
		ParserRuleReturnScope property90 =null;
		ParserRuleReturnScope terms93 =null;
		ParserRuleReturnScope important94 =null;
		ParserRuleReturnScope noprop95 =null;
		ParserRuleReturnScope any96 =null;

		Object COLON91_tree=null;
		Object S92_tree=null;
		RewriteRuleTokenStream stream_COLON=new RewriteRuleTokenStream(adaptor,"token COLON");
		RewriteRuleTokenStream stream_S=new RewriteRuleTokenStream(adaptor,"token S");
		RewriteRuleSubtreeStream stream_important=new RewriteRuleSubtreeStream(adaptor,"rule important");
		RewriteRuleSubtreeStream stream_any=new RewriteRuleSubtreeStream(adaptor,"rule any");
		RewriteRuleSubtreeStream stream_terms=new RewriteRuleSubtreeStream(adaptor,"rule terms");
		RewriteRuleSubtreeStream stream_property=new RewriteRuleSubtreeStream(adaptor,"rule property");
		RewriteRuleSubtreeStream stream_noprop=new RewriteRuleSubtreeStream(adaptor,"rule noprop");


		  LexerState begin = getCurrentLexerState(retval.start);
		  log.trace("Decl begin: " + begin);

		try {
			// cz/vutbr/web/csskit/antlr/CSS.g:845:2: ( property COLON ( S )* ( terms )? ( important )? -> ^( DECLARATION ( important )? property ( terms )? ) | noprop ( any )* -> INVALID_DECLARATION )
			int alt48=2;
			int LA48_0 = input.LA(1);
			if ( (LA48_0==IDENT||LA48_0==MINUS) ) {
				alt48=1;
			}
			else if ( (LA48_0==ASTERISK||(LA48_0 >= CLASSKEYWORD && LA48_0 <= COMMA)||LA48_0==CTRL||LA48_0==DASHMATCH||LA48_0==EQUALS||LA48_0==EXCLAMATION||LA48_0==GREATER||LA48_0==INCLUDES||LA48_0==INVALID_TOKEN||LA48_0==LESS||LA48_0==NUMBER||LA48_0==PERCENT||LA48_0==PLUS||LA48_0==QUESTION||LA48_0==SLASH||LA48_0==STRING_CHAR) ) {
				alt48=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 48, 0, input);
				throw nvae;
			}

			switch (alt48) {
				case 1 :
					// cz/vutbr/web/csskit/antlr/CSS.g:845:4: property COLON ( S )* ( terms )? ( important )?
					{
					pushFollow(FOLLOW_property_in_declaration826);
					property90=property();
					state._fsp--;

					stream_property.add(property90.getTree());
					COLON91=(Token)match(input,COLON,FOLLOW_COLON_in_declaration828);  
					stream_COLON.add(COLON91);

					// cz/vutbr/web/csskit/antlr/CSS.g:845:19: ( S )*
					loop44:
					while (true) {
						int alt44=2;
						int LA44_0 = input.LA(1);
						if ( (LA44_0==S) ) {
							alt44=1;
						}

						switch (alt44) {
						case 1 :
							// cz/vutbr/web/csskit/antlr/CSS.g:845:19: S
							{
							S92=(Token)match(input,S,FOLLOW_S_in_declaration830);  
							stream_S.add(S92);

							}
							break;

						default :
							break loop44;
						}
					}

					// cz/vutbr/web/csskit/antlr/CSS.g:845:22: ( terms )?
					int alt45=2;
					int LA45_0 = input.LA(1);
					if ( (LA45_0==ASTERISK||LA45_0==ATKEYWORD||(LA45_0 >= CLASSKEYWORD && LA45_0 <= COMMA)||LA45_0==DASHMATCH||LA45_0==DIMENSION||LA45_0==EQUALS||LA45_0==EXPRESSION||(LA45_0 >= FUNCTION && LA45_0 <= IDENT)||LA45_0==INCLUDES||LA45_0==INVALID_STRING||(LA45_0 >= LBRACE && LA45_0 <= LPAREN)||LA45_0==MINUS||LA45_0==NUMBER||(LA45_0 >= PERCENT && LA45_0 <= PLUS)||LA45_0==QUESTION||LA45_0==SLASH||LA45_0==STRING||(LA45_0 >= UNIRANGE && LA45_0 <= URI)) ) {
						alt45=1;
					}
					switch (alt45) {
						case 1 :
							// cz/vutbr/web/csskit/antlr/CSS.g:845:22: terms
							{
							pushFollow(FOLLOW_terms_in_declaration833);
							terms93=terms();
							state._fsp--;

							stream_terms.add(terms93.getTree());
							}
							break;

					}

					// cz/vutbr/web/csskit/antlr/CSS.g:845:29: ( important )?
					int alt46=2;
					int LA46_0 = input.LA(1);
					if ( (LA46_0==EXCLAMATION) ) {
						alt46=1;
					}
					switch (alt46) {
						case 1 :
							// cz/vutbr/web/csskit/antlr/CSS.g:845:29: important
							{
							pushFollow(FOLLOW_important_in_declaration836);
							important94=important();
							state._fsp--;

							stream_important.add(important94.getTree());
							}
							break;

					}

					// AST REWRITE
					// elements: terms, property, important
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (Object)adaptor.nil();
					// 845:40: -> ^( DECLARATION ( important )? property ( terms )? )
					{
						// cz/vutbr/web/csskit/antlr/CSS.g:845:43: ^( DECLARATION ( important )? property ( terms )? )
						{
						Object root_1 = (Object)adaptor.nil();
						root_1 = (Object)adaptor.becomeRoot((Object)adaptor.create(DECLARATION, "DECLARATION"), root_1);
						// cz/vutbr/web/csskit/antlr/CSS.g:845:57: ( important )?
						if ( stream_important.hasNext() ) {
							adaptor.addChild(root_1, stream_important.nextTree());
						}
						stream_important.reset();

						adaptor.addChild(root_1, stream_property.nextTree());
						// cz/vutbr/web/csskit/antlr/CSS.g:845:77: ( terms )?
						if ( stream_terms.hasNext() ) {
							adaptor.addChild(root_1, stream_terms.nextTree());
						}
						stream_terms.reset();

						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;
				case 2 :
					// cz/vutbr/web/csskit/antlr/CSS.g:846:4: noprop ( any )*
					{
					pushFollow(FOLLOW_noprop_in_declaration856);
					noprop95=noprop();
					state._fsp--;

					stream_noprop.add(noprop95.getTree());
					// cz/vutbr/web/csskit/antlr/CSS.g:846:11: ( any )*
					loop47:
					while (true) {
						int alt47=2;
						int LA47_0 = input.LA(1);
						if ( (LA47_0==ASTERISK||(LA47_0 >= CLASSKEYWORD && LA47_0 <= COMMA)||LA47_0==DASHMATCH||LA47_0==DIMENSION||LA47_0==EQUALS||LA47_0==EXCLAMATION||(LA47_0 >= FUNCTION && LA47_0 <= IDENT)||LA47_0==INCLUDES||LA47_0==INVALID_STRING||LA47_0==LBRACE||(LA47_0 >= LESS && LA47_0 <= LPAREN)||LA47_0==MINUS||LA47_0==NUMBER||(LA47_0 >= PERCENT && LA47_0 <= PLUS)||LA47_0==QUESTION||LA47_0==SLASH||LA47_0==STRING||(LA47_0 >= UNIRANGE && LA47_0 <= URI)) ) {
							alt47=1;
						}

						switch (alt47) {
						case 1 :
							// cz/vutbr/web/csskit/antlr/CSS.g:846:11: any
							{
							pushFollow(FOLLOW_any_in_declaration858);
							any96=any();
							state._fsp--;

							stream_any.add(any96.getTree());
							}
							break;

						default :
							break loop47;
						}
					}

					// AST REWRITE
					// elements: 
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (Object)adaptor.nil();
					// 846:16: -> INVALID_DECLARATION
					{
						adaptor.addChild(root_0, (Object)adaptor.create(INVALID_DECLARATION, "INVALID_DECLARATION"));
					}


					retval.tree = root_0;

					}
					break;

			}
			retval.stop = input.LT(-1);

			retval.tree = (Object)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {

				  //retval.tree = invalidFallback(CSSLexer.INVALID_DECLARATION, "INVALID_DECLARATION", re);									
			      final BitSet follow = BitSet.of(CSSLexer.SEMICOLON);               
			      retval.tree = invalidFallback(CSSLexer.INVALID_DECLARATION, "INVALID_DECLARATION", follow, LexerState.RecoveryMode.DECL, begin, re);             
				
		}

		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "declaration"


	public static class important_return extends ParserRuleReturnScope {
		Object tree;
		@Override
		public Object getTree() { return tree; }
	};


	// $ANTLR start "important"
	// cz/vutbr/web/csskit/antlr/CSS.g:854:1: important : EXCLAMATION ( S )* 'important' ( S )* -> IMPORTANT ;
	public final CSSParser.important_return important() throws RecognitionException {
		CSSParser.important_return retval = new CSSParser.important_return();
		retval.start = input.LT(1);

		Object root_0 = null;

		Token EXCLAMATION97=null;
		Token S98=null;
		Token string_literal99=null;
		Token S100=null;

		Object EXCLAMATION97_tree=null;
		Object S98_tree=null;
		Object string_literal99_tree=null;
		Object S100_tree=null;
		RewriteRuleTokenStream stream_EXCLAMATION=new RewriteRuleTokenStream(adaptor,"token EXCLAMATION");
		RewriteRuleTokenStream stream_S=new RewriteRuleTokenStream(adaptor,"token S");
		RewriteRuleTokenStream stream_103=new RewriteRuleTokenStream(adaptor,"token 103");

		try {
			// cz/vutbr/web/csskit/antlr/CSS.g:855:3: ( EXCLAMATION ( S )* 'important' ( S )* -> IMPORTANT )
			// cz/vutbr/web/csskit/antlr/CSS.g:855:5: EXCLAMATION ( S )* 'important' ( S )*
			{
			EXCLAMATION97=(Token)match(input,EXCLAMATION,FOLLOW_EXCLAMATION_in_important884);  
			stream_EXCLAMATION.add(EXCLAMATION97);

			// cz/vutbr/web/csskit/antlr/CSS.g:855:17: ( S )*
			loop49:
			while (true) {
				int alt49=2;
				int LA49_0 = input.LA(1);
				if ( (LA49_0==S) ) {
					alt49=1;
				}

				switch (alt49) {
				case 1 :
					// cz/vutbr/web/csskit/antlr/CSS.g:855:17: S
					{
					S98=(Token)match(input,S,FOLLOW_S_in_important886);  
					stream_S.add(S98);

					}
					break;

				default :
					break loop49;
				}
			}

			string_literal99=(Token)match(input,103,FOLLOW_103_in_important889);  
			stream_103.add(string_literal99);

			// cz/vutbr/web/csskit/antlr/CSS.g:855:32: ( S )*
			loop50:
			while (true) {
				int alt50=2;
				int LA50_0 = input.LA(1);
				if ( (LA50_0==S) ) {
					alt50=1;
				}

				switch (alt50) {
				case 1 :
					// cz/vutbr/web/csskit/antlr/CSS.g:855:32: S
					{
					S100=(Token)match(input,S,FOLLOW_S_in_important891);  
					stream_S.add(S100);

					}
					break;

				default :
					break loop50;
				}
			}

			// AST REWRITE
			// elements: 
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (Object)adaptor.nil();
			// 855:35: -> IMPORTANT
			{
				adaptor.addChild(root_0, (Object)adaptor.create(IMPORTANT, "IMPORTANT"));
			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (Object)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {

			      final BitSet follow = BitSet.of(CSSLexer.RCURLY, CSSLexer.SEMICOLON);               
			      retval.tree = invalidFallback(CSSLexer.INVALID_DIRECTIVE, "INVALID_DIRECTIVE", follow, LexerState.RecoveryMode.RULE, null, re);
			  
		}

		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "important"


	public static class property_return extends ParserRuleReturnScope {
		Object tree;
		@Override
		public Object getTree() { return tree; }
	};


	// $ANTLR start "property"
	// cz/vutbr/web/csskit/antlr/CSS.g:862:1: property : ( MINUS )? IDENT ( S )* -> ( MINUS )? IDENT ;
	public final CSSParser.property_return property() throws RecognitionException {
		CSSParser.property_return retval = new CSSParser.property_return();
		retval.start = input.LT(1);

		Object root_0 = null;

		Token MINUS101=null;
		Token IDENT102=null;
		Token S103=null;

		Object MINUS101_tree=null;
		Object IDENT102_tree=null;
		Object S103_tree=null;
		RewriteRuleTokenStream stream_IDENT=new RewriteRuleTokenStream(adaptor,"token IDENT");
		RewriteRuleTokenStream stream_S=new RewriteRuleTokenStream(adaptor,"token S");
		RewriteRuleTokenStream stream_MINUS=new RewriteRuleTokenStream(adaptor,"token MINUS");

		try {
			// cz/vutbr/web/csskit/antlr/CSS.g:863:2: ( ( MINUS )? IDENT ( S )* -> ( MINUS )? IDENT )
			// cz/vutbr/web/csskit/antlr/CSS.g:863:4: ( MINUS )? IDENT ( S )*
			{
			// cz/vutbr/web/csskit/antlr/CSS.g:863:4: ( MINUS )?
			int alt51=2;
			int LA51_0 = input.LA(1);
			if ( (LA51_0==MINUS) ) {
				alt51=1;
			}
			switch (alt51) {
				case 1 :
					// cz/vutbr/web/csskit/antlr/CSS.g:863:4: MINUS
					{
					MINUS101=(Token)match(input,MINUS,FOLLOW_MINUS_in_property920);  
					stream_MINUS.add(MINUS101);

					}
					break;

			}

			IDENT102=(Token)match(input,IDENT,FOLLOW_IDENT_in_property923);  
			stream_IDENT.add(IDENT102);

			// cz/vutbr/web/csskit/antlr/CSS.g:863:17: ( S )*
			loop52:
			while (true) {
				int alt52=2;
				int LA52_0 = input.LA(1);
				if ( (LA52_0==S) ) {
					alt52=1;
				}

				switch (alt52) {
				case 1 :
					// cz/vutbr/web/csskit/antlr/CSS.g:863:17: S
					{
					S103=(Token)match(input,S,FOLLOW_S_in_property925);  
					stream_S.add(S103);

					}
					break;

				default :
					break loop52;
				}
			}

			// AST REWRITE
			// elements: MINUS, IDENT
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (Object)adaptor.nil();
			// 863:20: -> ( MINUS )? IDENT
			{
				// cz/vutbr/web/csskit/antlr/CSS.g:863:23: ( MINUS )?
				if ( stream_MINUS.hasNext() ) {
					adaptor.addChild(root_0, stream_MINUS.nextNode());
				}
				stream_MINUS.reset();

				adaptor.addChild(root_0, stream_IDENT.nextNode());
			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (Object)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "property"


	public static class terms_return extends ParserRuleReturnScope {
		Object tree;
		@Override
		public Object getTree() { return tree; }
	};


	// $ANTLR start "terms"
	// cz/vutbr/web/csskit/antlr/CSS.g:866:1: terms : ( term )+ -> ^( VALUE ( term )+ ) ;
	public final CSSParser.terms_return terms() throws RecognitionException {
		CSSParser.terms_return retval = new CSSParser.terms_return();
		retval.start = input.LT(1);

		Object root_0 = null;

		ParserRuleReturnScope term104 =null;

		RewriteRuleSubtreeStream stream_term=new RewriteRuleSubtreeStream(adaptor,"rule term");

		try {
			// cz/vutbr/web/csskit/antlr/CSS.g:867:2: ( ( term )+ -> ^( VALUE ( term )+ ) )
			// cz/vutbr/web/csskit/antlr/CSS.g:867:4: ( term )+
			{
			// cz/vutbr/web/csskit/antlr/CSS.g:867:4: ( term )+
			int cnt53=0;
			loop53:
			while (true) {
				int alt53=2;
				int LA53_0 = input.LA(1);
				if ( (LA53_0==ASTERISK||LA53_0==ATKEYWORD||(LA53_0 >= CLASSKEYWORD && LA53_0 <= COMMA)||LA53_0==DASHMATCH||LA53_0==DIMENSION||LA53_0==EQUALS||LA53_0==EXPRESSION||(LA53_0 >= FUNCTION && LA53_0 <= IDENT)||LA53_0==INCLUDES||LA53_0==INVALID_STRING||(LA53_0 >= LBRACE && LA53_0 <= LPAREN)||LA53_0==MINUS||LA53_0==NUMBER||(LA53_0 >= PERCENT && LA53_0 <= PLUS)||LA53_0==QUESTION||LA53_0==SLASH||LA53_0==STRING||(LA53_0 >= UNIRANGE && LA53_0 <= URI)) ) {
					alt53=1;
				}

				switch (alt53) {
				case 1 :
					// cz/vutbr/web/csskit/antlr/CSS.g:867:4: term
					{
					pushFollow(FOLLOW_term_in_terms953);
					term104=term();
					state._fsp--;

					stream_term.add(term104.getTree());
					}
					break;

				default :
					if ( cnt53 >= 1 ) break loop53;
					EarlyExitException eee = new EarlyExitException(53, input);
					throw eee;
				}
				cnt53++;
			}

			// AST REWRITE
			// elements: term
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (Object)adaptor.nil();
			// 868:2: -> ^( VALUE ( term )+ )
			{
				// cz/vutbr/web/csskit/antlr/CSS.g:868:5: ^( VALUE ( term )+ )
				{
				Object root_1 = (Object)adaptor.nil();
				root_1 = (Object)adaptor.becomeRoot((Object)adaptor.create(VALUE, "VALUE"), root_1);
				if ( !(stream_term.hasNext()) ) {
					throw new RewriteEarlyExitException();
				}
				while ( stream_term.hasNext() ) {
					adaptor.addChild(root_1, stream_term.nextTree());
				}
				stream_term.reset();

				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (Object)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {

					if (functLevel == 0)
					{
				      final BitSet follow = BitSet.of(CSSLexer.RCURLY, CSSLexer.SEMICOLON);								
					    retval.tree = invalidFallbackGreedy(CSSLexer.INVALID_STATEMENT, 
					  		"INVALID_STATEMENT", follow, re);
					}
					else
					{
			        final BitSet follow = BitSet.of(CSSLexer.RPAREN, CSSLexer.RCURLY, CSSLexer.SEMICOLON);               
			        retval.tree = invalidFallbackGreedy(CSSLexer.INVALID_STATEMENT, "INVALID_STATEMENT", follow, LexerState.RecoveryMode.FUNCTION, null, re);
					}
				
		}

		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "terms"


	public static class term_return extends ParserRuleReturnScope {
		Object tree;
		@Override
		public Object getTree() { return tree; }
	};


	// $ANTLR start "term"
	// cz/vutbr/web/csskit/antlr/CSS.g:884:1: term : ( valuepart -> valuepart | LCURLY ( S )* ( any | SEMICOLON ( S )* )* RCURLY -> CURLYBLOCK | ATKEYWORD ( S )* -> ATKEYWORD );
	public final CSSParser.term_return term() throws RecognitionException {
		CSSParser.term_return retval = new CSSParser.term_return();
		retval.start = input.LT(1);

		Object root_0 = null;

		Token LCURLY106=null;
		Token S107=null;
		Token SEMICOLON109=null;
		Token S110=null;
		Token RCURLY111=null;
		Token ATKEYWORD112=null;
		Token S113=null;
		ParserRuleReturnScope valuepart105 =null;
		ParserRuleReturnScope any108 =null;

		Object LCURLY106_tree=null;
		Object S107_tree=null;
		Object SEMICOLON109_tree=null;
		Object S110_tree=null;
		Object RCURLY111_tree=null;
		Object ATKEYWORD112_tree=null;
		Object S113_tree=null;
		RewriteRuleTokenStream stream_ATKEYWORD=new RewriteRuleTokenStream(adaptor,"token ATKEYWORD");
		RewriteRuleTokenStream stream_LCURLY=new RewriteRuleTokenStream(adaptor,"token LCURLY");
		RewriteRuleTokenStream stream_SEMICOLON=new RewriteRuleTokenStream(adaptor,"token SEMICOLON");
		RewriteRuleTokenStream stream_S=new RewriteRuleTokenStream(adaptor,"token S");
		RewriteRuleTokenStream stream_RCURLY=new RewriteRuleTokenStream(adaptor,"token RCURLY");
		RewriteRuleSubtreeStream stream_valuepart=new RewriteRuleSubtreeStream(adaptor,"rule valuepart");
		RewriteRuleSubtreeStream stream_any=new RewriteRuleSubtreeStream(adaptor,"rule any");

		try {
			// cz/vutbr/web/csskit/antlr/CSS.g:885:5: ( valuepart -> valuepart | LCURLY ( S )* ( any | SEMICOLON ( S )* )* RCURLY -> CURLYBLOCK | ATKEYWORD ( S )* -> ATKEYWORD )
			int alt58=3;
			switch ( input.LA(1) ) {
			case ASTERISK:
			case CLASSKEYWORD:
			case COLON:
			case COMMA:
			case DASHMATCH:
			case DIMENSION:
			case EQUALS:
			case EXPRESSION:
			case FUNCTION:
			case GREATER:
			case HASH:
			case IDENT:
			case INCLUDES:
			case INVALID_STRING:
			case LBRACE:
			case LESS:
			case LPAREN:
			case MINUS:
			case NUMBER:
			case PERCENT:
			case PERCENTAGE:
			case PLUS:
			case QUESTION:
			case SLASH:
			case STRING:
			case UNIRANGE:
			case URI:
				{
				alt58=1;
				}
				break;
			case LCURLY:
				{
				alt58=2;
				}
				break;
			case ATKEYWORD:
				{
				alt58=3;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 58, 0, input);
				throw nvae;
			}
			switch (alt58) {
				case 1 :
					// cz/vutbr/web/csskit/antlr/CSS.g:885:7: valuepart
					{
					pushFollow(FOLLOW_valuepart_in_term986);
					valuepart105=valuepart();
					state._fsp--;

					stream_valuepart.add(valuepart105.getTree());
					// AST REWRITE
					// elements: valuepart
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (Object)adaptor.nil();
					// 885:17: -> valuepart
					{
						adaptor.addChild(root_0, stream_valuepart.nextTree());
					}


					retval.tree = root_0;

					}
					break;
				case 2 :
					// cz/vutbr/web/csskit/antlr/CSS.g:886:7: LCURLY ( S )* ( any | SEMICOLON ( S )* )* RCURLY
					{
					LCURLY106=(Token)match(input,LCURLY,FOLLOW_LCURLY_in_term998);  
					stream_LCURLY.add(LCURLY106);

					// cz/vutbr/web/csskit/antlr/CSS.g:886:14: ( S )*
					loop54:
					while (true) {
						int alt54=2;
						int LA54_0 = input.LA(1);
						if ( (LA54_0==S) ) {
							alt54=1;
						}

						switch (alt54) {
						case 1 :
							// cz/vutbr/web/csskit/antlr/CSS.g:886:14: S
							{
							S107=(Token)match(input,S,FOLLOW_S_in_term1000);  
							stream_S.add(S107);

							}
							break;

						default :
							break loop54;
						}
					}

					// cz/vutbr/web/csskit/antlr/CSS.g:886:17: ( any | SEMICOLON ( S )* )*
					loop56:
					while (true) {
						int alt56=3;
						int LA56_0 = input.LA(1);
						if ( (LA56_0==ASTERISK||(LA56_0 >= CLASSKEYWORD && LA56_0 <= COMMA)||LA56_0==DASHMATCH||LA56_0==DIMENSION||LA56_0==EQUALS||LA56_0==EXCLAMATION||(LA56_0 >= FUNCTION && LA56_0 <= IDENT)||LA56_0==INCLUDES||LA56_0==INVALID_STRING||LA56_0==LBRACE||(LA56_0 >= LESS && LA56_0 <= LPAREN)||LA56_0==MINUS||LA56_0==NUMBER||(LA56_0 >= PERCENT && LA56_0 <= PLUS)||LA56_0==QUESTION||LA56_0==SLASH||LA56_0==STRING||(LA56_0 >= UNIRANGE && LA56_0 <= URI)) ) {
							alt56=1;
						}
						else if ( (LA56_0==SEMICOLON) ) {
							alt56=2;
						}

						switch (alt56) {
						case 1 :
							// cz/vutbr/web/csskit/antlr/CSS.g:886:18: any
							{
							pushFollow(FOLLOW_any_in_term1004);
							any108=any();
							state._fsp--;

							stream_any.add(any108.getTree());
							}
							break;
						case 2 :
							// cz/vutbr/web/csskit/antlr/CSS.g:886:24: SEMICOLON ( S )*
							{
							SEMICOLON109=(Token)match(input,SEMICOLON,FOLLOW_SEMICOLON_in_term1008);  
							stream_SEMICOLON.add(SEMICOLON109);

							// cz/vutbr/web/csskit/antlr/CSS.g:886:34: ( S )*
							loop55:
							while (true) {
								int alt55=2;
								int LA55_0 = input.LA(1);
								if ( (LA55_0==S) ) {
									alt55=1;
								}

								switch (alt55) {
								case 1 :
									// cz/vutbr/web/csskit/antlr/CSS.g:886:34: S
									{
									S110=(Token)match(input,S,FOLLOW_S_in_term1010);  
									stream_S.add(S110);

									}
									break;

								default :
									break loop55;
								}
							}

							}
							break;

						default :
							break loop56;
						}
					}

					RCURLY111=(Token)match(input,RCURLY,FOLLOW_RCURLY_in_term1015);  
					stream_RCURLY.add(RCURLY111);

					// AST REWRITE
					// elements: 
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (Object)adaptor.nil();
					// 886:46: -> CURLYBLOCK
					{
						adaptor.addChild(root_0, (Object)adaptor.create(CURLYBLOCK, "CURLYBLOCK"));
					}


					retval.tree = root_0;

					}
					break;
				case 3 :
					// cz/vutbr/web/csskit/antlr/CSS.g:887:7: ATKEYWORD ( S )*
					{
					ATKEYWORD112=(Token)match(input,ATKEYWORD,FOLLOW_ATKEYWORD_in_term1027);  
					stream_ATKEYWORD.add(ATKEYWORD112);

					// cz/vutbr/web/csskit/antlr/CSS.g:887:17: ( S )*
					loop57:
					while (true) {
						int alt57=2;
						int LA57_0 = input.LA(1);
						if ( (LA57_0==S) ) {
							alt57=1;
						}

						switch (alt57) {
						case 1 :
							// cz/vutbr/web/csskit/antlr/CSS.g:887:17: S
							{
							S113=(Token)match(input,S,FOLLOW_S_in_term1029);  
							stream_S.add(S113);

							}
							break;

						default :
							break loop57;
						}
					}

					// AST REWRITE
					// elements: ATKEYWORD
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (Object)adaptor.nil();
					// 887:20: -> ATKEYWORD
					{
						adaptor.addChild(root_0, stream_ATKEYWORD.nextNode());
					}


					retval.tree = root_0;

					}
					break;

			}
			retval.stop = input.LT(-1);

			retval.tree = (Object)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "term"


	public static class funct_return extends ParserRuleReturnScope {
		Object tree;
		@Override
		public Object getTree() { return tree; }
	};


	// $ANTLR start "funct"
	// cz/vutbr/web/csskit/antlr/CSS.g:891:1: funct : ( EXPRESSION -> EXPRESSION | FUNCTION ( S )* ( terms )? RPAREN -> ^( FUNCTION ( terms )? ) );
	public final CSSParser.funct_return funct() throws RecognitionException {
		CSSParser.funct_return retval = new CSSParser.funct_return();
		retval.start = input.LT(1);

		Object root_0 = null;

		Token EXPRESSION114=null;
		Token FUNCTION115=null;
		Token S116=null;
		Token RPAREN118=null;
		ParserRuleReturnScope terms117 =null;

		Object EXPRESSION114_tree=null;
		Object FUNCTION115_tree=null;
		Object S116_tree=null;
		Object RPAREN118_tree=null;
		RewriteRuleTokenStream stream_FUNCTION=new RewriteRuleTokenStream(adaptor,"token FUNCTION");
		RewriteRuleTokenStream stream_RPAREN=new RewriteRuleTokenStream(adaptor,"token RPAREN");
		RewriteRuleTokenStream stream_S=new RewriteRuleTokenStream(adaptor,"token S");
		RewriteRuleTokenStream stream_EXPRESSION=new RewriteRuleTokenStream(adaptor,"token EXPRESSION");
		RewriteRuleSubtreeStream stream_terms=new RewriteRuleSubtreeStream(adaptor,"rule terms");


			functLevel++;

		try {
			// cz/vutbr/web/csskit/antlr/CSS.g:898:3: ( EXPRESSION -> EXPRESSION | FUNCTION ( S )* ( terms )? RPAREN -> ^( FUNCTION ( terms )? ) )
			int alt61=2;
			int LA61_0 = input.LA(1);
			if ( (LA61_0==EXPRESSION) ) {
				alt61=1;
			}
			else if ( (LA61_0==FUNCTION) ) {
				alt61=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 61, 0, input);
				throw nvae;
			}

			switch (alt61) {
				case 1 :
					// cz/vutbr/web/csskit/antlr/CSS.g:898:5: EXPRESSION
					{
					EXPRESSION114=(Token)match(input,EXPRESSION,FOLLOW_EXPRESSION_in_funct1062);  
					stream_EXPRESSION.add(EXPRESSION114);

					// AST REWRITE
					// elements: EXPRESSION
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (Object)adaptor.nil();
					// 898:16: -> EXPRESSION
					{
						adaptor.addChild(root_0, stream_EXPRESSION.nextNode());
					}


					retval.tree = root_0;

					}
					break;
				case 2 :
					// cz/vutbr/web/csskit/antlr/CSS.g:899:4: FUNCTION ( S )* ( terms )? RPAREN
					{
					FUNCTION115=(Token)match(input,FUNCTION,FOLLOW_FUNCTION_in_funct1071);  
					stream_FUNCTION.add(FUNCTION115);

					// cz/vutbr/web/csskit/antlr/CSS.g:899:13: ( S )*
					loop59:
					while (true) {
						int alt59=2;
						int LA59_0 = input.LA(1);
						if ( (LA59_0==S) ) {
							alt59=1;
						}

						switch (alt59) {
						case 1 :
							// cz/vutbr/web/csskit/antlr/CSS.g:899:13: S
							{
							S116=(Token)match(input,S,FOLLOW_S_in_funct1073);  
							stream_S.add(S116);

							}
							break;

						default :
							break loop59;
						}
					}

					// cz/vutbr/web/csskit/antlr/CSS.g:899:16: ( terms )?
					int alt60=2;
					int LA60_0 = input.LA(1);
					if ( (LA60_0==ASTERISK||LA60_0==ATKEYWORD||(LA60_0 >= CLASSKEYWORD && LA60_0 <= COMMA)||LA60_0==DASHMATCH||LA60_0==DIMENSION||LA60_0==EQUALS||LA60_0==EXPRESSION||(LA60_0 >= FUNCTION && LA60_0 <= IDENT)||LA60_0==INCLUDES||LA60_0==INVALID_STRING||(LA60_0 >= LBRACE && LA60_0 <= LPAREN)||LA60_0==MINUS||LA60_0==NUMBER||(LA60_0 >= PERCENT && LA60_0 <= PLUS)||LA60_0==QUESTION||LA60_0==SLASH||LA60_0==STRING||(LA60_0 >= UNIRANGE && LA60_0 <= URI)) ) {
						alt60=1;
					}
					switch (alt60) {
						case 1 :
							// cz/vutbr/web/csskit/antlr/CSS.g:899:16: terms
							{
							pushFollow(FOLLOW_terms_in_funct1076);
							terms117=terms();
							state._fsp--;

							stream_terms.add(terms117.getTree());
							}
							break;

					}

					RPAREN118=(Token)match(input,RPAREN,FOLLOW_RPAREN_in_funct1079);  
					stream_RPAREN.add(RPAREN118);

					// AST REWRITE
					// elements: terms, FUNCTION
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (Object)adaptor.nil();
					// 899:30: -> ^( FUNCTION ( terms )? )
					{
						// cz/vutbr/web/csskit/antlr/CSS.g:899:33: ^( FUNCTION ( terms )? )
						{
						Object root_1 = (Object)adaptor.nil();
						root_1 = (Object)adaptor.becomeRoot(stream_FUNCTION.nextNode(), root_1);
						// cz/vutbr/web/csskit/antlr/CSS.g:899:44: ( terms )?
						if ( stream_terms.hasNext() ) {
							adaptor.addChild(root_1, stream_terms.nextTree());
						}
						stream_terms.reset();

						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;

			}
			retval.stop = input.LT(-1);

			retval.tree = (Object)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);


				functLevel--;

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "funct"


	public static class valuepart_return extends ParserRuleReturnScope {
		Object tree;
		@Override
		public Object getTree() { return tree; }
	};


	// $ANTLR start "valuepart"
	// cz/vutbr/web/csskit/antlr/CSS.g:903:1: valuepart : ( ( MINUS )? IDENT -> ( MINUS )? IDENT | CLASSKEYWORD -> CLASSKEYWORD | ( MINUS )? NUMBER -> ( MINUS )? NUMBER | ( MINUS )? PERCENTAGE -> ( MINUS )? PERCENTAGE | ( MINUS )? DIMENSION -> ( MINUS )? DIMENSION | string -> string | URI -> URI | HASH -> HASH | UNIRANGE -> UNIRANGE | INCLUDES -> INCLUDES | COLON -> COLON | COMMA -> COMMA | GREATER -> GREATER | LESS -> LESS | QUESTION -> QUESTION | PERCENT -> PERCENT | EQUALS -> EQUALS | SLASH -> SLASH | PLUS -> PLUS | ASTERISK -> ASTERISK | ( MINUS )? funct -> ( MINUS )? funct | DASHMATCH -> DASHMATCH | LPAREN ( valuepart )* RPAREN -> ^( PARENBLOCK ( valuepart )* ) | LBRACE ( valuepart )* RBRACE -> ^( BRACEBLOCK ( valuepart )* ) ) ! ( S )* ;
	public final CSSParser.valuepart_return valuepart() throws RecognitionException {
		CSSParser.valuepart_return retval = new CSSParser.valuepart_return();
		retval.start = input.LT(1);

		Object root_0 = null;

		Token MINUS119=null;
		Token IDENT120=null;
		Token CLASSKEYWORD121=null;
		Token MINUS122=null;
		Token NUMBER123=null;
		Token MINUS124=null;
		Token PERCENTAGE125=null;
		Token MINUS126=null;
		Token DIMENSION127=null;
		Token URI129=null;
		Token HASH130=null;
		Token UNIRANGE131=null;
		Token INCLUDES132=null;
		Token COLON133=null;
		Token COMMA134=null;
		Token GREATER135=null;
		Token LESS136=null;
		Token QUESTION137=null;
		Token PERCENT138=null;
		Token EQUALS139=null;
		Token SLASH140=null;
		Token PLUS141=null;
		Token ASTERISK142=null;
		Token MINUS143=null;
		Token DASHMATCH145=null;
		Token LPAREN146=null;
		Token RPAREN148=null;
		Token LBRACE149=null;
		Token RBRACE151=null;
		Token S152=null;
		ParserRuleReturnScope string128 =null;
		ParserRuleReturnScope funct144 =null;
		ParserRuleReturnScope valuepart147 =null;
		ParserRuleReturnScope valuepart150 =null;

		Object MINUS119_tree=null;
		Object IDENT120_tree=null;
		Object CLASSKEYWORD121_tree=null;
		Object MINUS122_tree=null;
		Object NUMBER123_tree=null;
		Object MINUS124_tree=null;
		Object PERCENTAGE125_tree=null;
		Object MINUS126_tree=null;
		Object DIMENSION127_tree=null;
		Object URI129_tree=null;
		Object HASH130_tree=null;
		Object UNIRANGE131_tree=null;
		Object INCLUDES132_tree=null;
		Object COLON133_tree=null;
		Object COMMA134_tree=null;
		Object GREATER135_tree=null;
		Object LESS136_tree=null;
		Object QUESTION137_tree=null;
		Object PERCENT138_tree=null;
		Object EQUALS139_tree=null;
		Object SLASH140_tree=null;
		Object PLUS141_tree=null;
		Object ASTERISK142_tree=null;
		Object MINUS143_tree=null;
		Object DASHMATCH145_tree=null;
		Object LPAREN146_tree=null;
		Object RPAREN148_tree=null;
		Object LBRACE149_tree=null;
		Object RBRACE151_tree=null;
		Object S152_tree=null;
		RewriteRuleTokenStream stream_PERCENT=new RewriteRuleTokenStream(adaptor,"token PERCENT");
		RewriteRuleTokenStream stream_RBRACE=new RewriteRuleTokenStream(adaptor,"token RBRACE");
		RewriteRuleTokenStream stream_CLASSKEYWORD=new RewriteRuleTokenStream(adaptor,"token CLASSKEYWORD");
		RewriteRuleTokenStream stream_LBRACE=new RewriteRuleTokenStream(adaptor,"token LBRACE");
		RewriteRuleTokenStream stream_NUMBER=new RewriteRuleTokenStream(adaptor,"token NUMBER");
		RewriteRuleTokenStream stream_HASH=new RewriteRuleTokenStream(adaptor,"token HASH");
		RewriteRuleTokenStream stream_EQUALS=new RewriteRuleTokenStream(adaptor,"token EQUALS");
		RewriteRuleTokenStream stream_S=new RewriteRuleTokenStream(adaptor,"token S");
		RewriteRuleTokenStream stream_MINUS=new RewriteRuleTokenStream(adaptor,"token MINUS");
		RewriteRuleTokenStream stream_PERCENTAGE=new RewriteRuleTokenStream(adaptor,"token PERCENTAGE");
		RewriteRuleTokenStream stream_LPAREN=new RewriteRuleTokenStream(adaptor,"token LPAREN");
		RewriteRuleTokenStream stream_ASTERISK=new RewriteRuleTokenStream(adaptor,"token ASTERISK");
		RewriteRuleTokenStream stream_URI=new RewriteRuleTokenStream(adaptor,"token URI");
		RewriteRuleTokenStream stream_COLON=new RewriteRuleTokenStream(adaptor,"token COLON");
		RewriteRuleTokenStream stream_INCLUDES=new RewriteRuleTokenStream(adaptor,"token INCLUDES");
		RewriteRuleTokenStream stream_RPAREN=new RewriteRuleTokenStream(adaptor,"token RPAREN");
		RewriteRuleTokenStream stream_GREATER=new RewriteRuleTokenStream(adaptor,"token GREATER");
		RewriteRuleTokenStream stream_SLASH=new RewriteRuleTokenStream(adaptor,"token SLASH");
		RewriteRuleTokenStream stream_DASHMATCH=new RewriteRuleTokenStream(adaptor,"token DASHMATCH");
		RewriteRuleTokenStream stream_QUESTION=new RewriteRuleTokenStream(adaptor,"token QUESTION");
		RewriteRuleTokenStream stream_COMMA=new RewriteRuleTokenStream(adaptor,"token COMMA");
		RewriteRuleTokenStream stream_LESS=new RewriteRuleTokenStream(adaptor,"token LESS");
		RewriteRuleTokenStream stream_IDENT=new RewriteRuleTokenStream(adaptor,"token IDENT");
		RewriteRuleTokenStream stream_PLUS=new RewriteRuleTokenStream(adaptor,"token PLUS");
		RewriteRuleTokenStream stream_DIMENSION=new RewriteRuleTokenStream(adaptor,"token DIMENSION");
		RewriteRuleTokenStream stream_UNIRANGE=new RewriteRuleTokenStream(adaptor,"token UNIRANGE");
		RewriteRuleSubtreeStream stream_valuepart=new RewriteRuleSubtreeStream(adaptor,"rule valuepart");
		RewriteRuleSubtreeStream stream_string=new RewriteRuleSubtreeStream(adaptor,"rule string");
		RewriteRuleSubtreeStream stream_funct=new RewriteRuleSubtreeStream(adaptor,"rule funct");

		try {
			// cz/vutbr/web/csskit/antlr/CSS.g:904:5: ( ( ( MINUS )? IDENT -> ( MINUS )? IDENT | CLASSKEYWORD -> CLASSKEYWORD | ( MINUS )? NUMBER -> ( MINUS )? NUMBER | ( MINUS )? PERCENTAGE -> ( MINUS )? PERCENTAGE | ( MINUS )? DIMENSION -> ( MINUS )? DIMENSION | string -> string | URI -> URI | HASH -> HASH | UNIRANGE -> UNIRANGE | INCLUDES -> INCLUDES | COLON -> COLON | COMMA -> COMMA | GREATER -> GREATER | LESS -> LESS | QUESTION -> QUESTION | PERCENT -> PERCENT | EQUALS -> EQUALS | SLASH -> SLASH | PLUS -> PLUS | ASTERISK -> ASTERISK | ( MINUS )? funct -> ( MINUS )? funct | DASHMATCH -> DASHMATCH | LPAREN ( valuepart )* RPAREN -> ^( PARENBLOCK ( valuepart )* ) | LBRACE ( valuepart )* RBRACE -> ^( BRACEBLOCK ( valuepart )* ) ) ! ( S )* )
			// cz/vutbr/web/csskit/antlr/CSS.g:904:7: ( ( MINUS )? IDENT -> ( MINUS )? IDENT | CLASSKEYWORD -> CLASSKEYWORD | ( MINUS )? NUMBER -> ( MINUS )? NUMBER | ( MINUS )? PERCENTAGE -> ( MINUS )? PERCENTAGE | ( MINUS )? DIMENSION -> ( MINUS )? DIMENSION | string -> string | URI -> URI | HASH -> HASH | UNIRANGE -> UNIRANGE | INCLUDES -> INCLUDES | COLON -> COLON | COMMA -> COMMA | GREATER -> GREATER | LESS -> LESS | QUESTION -> QUESTION | PERCENT -> PERCENT | EQUALS -> EQUALS | SLASH -> SLASH | PLUS -> PLUS | ASTERISK -> ASTERISK | ( MINUS )? funct -> ( MINUS )? funct | DASHMATCH -> DASHMATCH | LPAREN ( valuepart )* RPAREN -> ^( PARENBLOCK ( valuepart )* ) | LBRACE ( valuepart )* RBRACE -> ^( BRACEBLOCK ( valuepart )* ) ) ! ( S )*
			{
			// cz/vutbr/web/csskit/antlr/CSS.g:904:7: ( ( MINUS )? IDENT -> ( MINUS )? IDENT | CLASSKEYWORD -> CLASSKEYWORD | ( MINUS )? NUMBER -> ( MINUS )? NUMBER | ( MINUS )? PERCENTAGE -> ( MINUS )? PERCENTAGE | ( MINUS )? DIMENSION -> ( MINUS )? DIMENSION | string -> string | URI -> URI | HASH -> HASH | UNIRANGE -> UNIRANGE | INCLUDES -> INCLUDES | COLON -> COLON | COMMA -> COMMA | GREATER -> GREATER | LESS -> LESS | QUESTION -> QUESTION | PERCENT -> PERCENT | EQUALS -> EQUALS | SLASH -> SLASH | PLUS -> PLUS | ASTERISK -> ASTERISK | ( MINUS )? funct -> ( MINUS )? funct | DASHMATCH -> DASHMATCH | LPAREN ( valuepart )* RPAREN -> ^( PARENBLOCK ( valuepart )* ) | LBRACE ( valuepart )* RBRACE -> ^( BRACEBLOCK ( valuepart )* ) )
			int alt69=24;
			switch ( input.LA(1) ) {
			case MINUS:
				{
				switch ( input.LA(2) ) {
				case IDENT:
					{
					alt69=1;
					}
					break;
				case NUMBER:
					{
					alt69=3;
					}
					break;
				case PERCENTAGE:
					{
					alt69=4;
					}
					break;
				case DIMENSION:
					{
					alt69=5;
					}
					break;
				case EXPRESSION:
				case FUNCTION:
					{
					alt69=21;
					}
					break;
				default:
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 69, 1, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}
				}
				break;
			case IDENT:
				{
				alt69=1;
				}
				break;
			case CLASSKEYWORD:
				{
				alt69=2;
				}
				break;
			case NUMBER:
				{
				alt69=3;
				}
				break;
			case PERCENTAGE:
				{
				alt69=4;
				}
				break;
			case DIMENSION:
				{
				alt69=5;
				}
				break;
			case INVALID_STRING:
			case STRING:
				{
				alt69=6;
				}
				break;
			case URI:
				{
				alt69=7;
				}
				break;
			case HASH:
				{
				alt69=8;
				}
				break;
			case UNIRANGE:
				{
				alt69=9;
				}
				break;
			case INCLUDES:
				{
				alt69=10;
				}
				break;
			case COLON:
				{
				alt69=11;
				}
				break;
			case COMMA:
				{
				alt69=12;
				}
				break;
			case GREATER:
				{
				alt69=13;
				}
				break;
			case LESS:
				{
				alt69=14;
				}
				break;
			case QUESTION:
				{
				alt69=15;
				}
				break;
			case PERCENT:
				{
				alt69=16;
				}
				break;
			case EQUALS:
				{
				alt69=17;
				}
				break;
			case SLASH:
				{
				alt69=18;
				}
				break;
			case PLUS:
				{
				alt69=19;
				}
				break;
			case ASTERISK:
				{
				alt69=20;
				}
				break;
			case EXPRESSION:
			case FUNCTION:
				{
				alt69=21;
				}
				break;
			case DASHMATCH:
				{
				alt69=22;
				}
				break;
			case LPAREN:
				{
				alt69=23;
				}
				break;
			case LBRACE:
				{
				alt69=24;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 69, 0, input);
				throw nvae;
			}
			switch (alt69) {
				case 1 :
					// cz/vutbr/web/csskit/antlr/CSS.g:904:9: ( MINUS )? IDENT
					{
					// cz/vutbr/web/csskit/antlr/CSS.g:904:9: ( MINUS )?
					int alt62=2;
					int LA62_0 = input.LA(1);
					if ( (LA62_0==MINUS) ) {
						alt62=1;
					}
					switch (alt62) {
						case 1 :
							// cz/vutbr/web/csskit/antlr/CSS.g:904:9: MINUS
							{
							MINUS119=(Token)match(input,MINUS,FOLLOW_MINUS_in_valuepart1106);  
							stream_MINUS.add(MINUS119);

							}
							break;

					}

					IDENT120=(Token)match(input,IDENT,FOLLOW_IDENT_in_valuepart1109);  
					stream_IDENT.add(IDENT120);

					// AST REWRITE
					// elements: MINUS, IDENT
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (Object)adaptor.nil();
					// 904:22: -> ( MINUS )? IDENT
					{
						// cz/vutbr/web/csskit/antlr/CSS.g:904:25: ( MINUS )?
						if ( stream_MINUS.hasNext() ) {
							adaptor.addChild(root_0, stream_MINUS.nextNode());
						}
						stream_MINUS.reset();

						adaptor.addChild(root_0, stream_IDENT.nextNode());
					}


					retval.tree = root_0;

					}
					break;
				case 2 :
					// cz/vutbr/web/csskit/antlr/CSS.g:905:9: CLASSKEYWORD
					{
					CLASSKEYWORD121=(Token)match(input,CLASSKEYWORD,FOLLOW_CLASSKEYWORD_in_valuepart1126);  
					stream_CLASSKEYWORD.add(CLASSKEYWORD121);

					// AST REWRITE
					// elements: CLASSKEYWORD
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (Object)adaptor.nil();
					// 905:22: -> CLASSKEYWORD
					{
						adaptor.addChild(root_0, stream_CLASSKEYWORD.nextNode());
					}


					retval.tree = root_0;

					}
					break;
				case 3 :
					// cz/vutbr/web/csskit/antlr/CSS.g:906:9: ( MINUS )? NUMBER
					{
					// cz/vutbr/web/csskit/antlr/CSS.g:906:9: ( MINUS )?
					int alt63=2;
					int LA63_0 = input.LA(1);
					if ( (LA63_0==MINUS) ) {
						alt63=1;
					}
					switch (alt63) {
						case 1 :
							// cz/vutbr/web/csskit/antlr/CSS.g:906:9: MINUS
							{
							MINUS122=(Token)match(input,MINUS,FOLLOW_MINUS_in_valuepart1140);  
							stream_MINUS.add(MINUS122);

							}
							break;

					}

					NUMBER123=(Token)match(input,NUMBER,FOLLOW_NUMBER_in_valuepart1143);  
					stream_NUMBER.add(NUMBER123);

					// AST REWRITE
					// elements: MINUS, NUMBER
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (Object)adaptor.nil();
					// 906:23: -> ( MINUS )? NUMBER
					{
						// cz/vutbr/web/csskit/antlr/CSS.g:906:26: ( MINUS )?
						if ( stream_MINUS.hasNext() ) {
							adaptor.addChild(root_0, stream_MINUS.nextNode());
						}
						stream_MINUS.reset();

						adaptor.addChild(root_0, stream_NUMBER.nextNode());
					}


					retval.tree = root_0;

					}
					break;
				case 4 :
					// cz/vutbr/web/csskit/antlr/CSS.g:907:9: ( MINUS )? PERCENTAGE
					{
					// cz/vutbr/web/csskit/antlr/CSS.g:907:9: ( MINUS )?
					int alt64=2;
					int LA64_0 = input.LA(1);
					if ( (LA64_0==MINUS) ) {
						alt64=1;
					}
					switch (alt64) {
						case 1 :
							// cz/vutbr/web/csskit/antlr/CSS.g:907:9: MINUS
							{
							MINUS124=(Token)match(input,MINUS,FOLLOW_MINUS_in_valuepart1160);  
							stream_MINUS.add(MINUS124);

							}
							break;

					}

					PERCENTAGE125=(Token)match(input,PERCENTAGE,FOLLOW_PERCENTAGE_in_valuepart1163);  
					stream_PERCENTAGE.add(PERCENTAGE125);

					// AST REWRITE
					// elements: MINUS, PERCENTAGE
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (Object)adaptor.nil();
					// 907:27: -> ( MINUS )? PERCENTAGE
					{
						// cz/vutbr/web/csskit/antlr/CSS.g:907:30: ( MINUS )?
						if ( stream_MINUS.hasNext() ) {
							adaptor.addChild(root_0, stream_MINUS.nextNode());
						}
						stream_MINUS.reset();

						adaptor.addChild(root_0, stream_PERCENTAGE.nextNode());
					}


					retval.tree = root_0;

					}
					break;
				case 5 :
					// cz/vutbr/web/csskit/antlr/CSS.g:908:9: ( MINUS )? DIMENSION
					{
					// cz/vutbr/web/csskit/antlr/CSS.g:908:9: ( MINUS )?
					int alt65=2;
					int LA65_0 = input.LA(1);
					if ( (LA65_0==MINUS) ) {
						alt65=1;
					}
					switch (alt65) {
						case 1 :
							// cz/vutbr/web/csskit/antlr/CSS.g:908:9: MINUS
							{
							MINUS126=(Token)match(input,MINUS,FOLLOW_MINUS_in_valuepart1180);  
							stream_MINUS.add(MINUS126);

							}
							break;

					}

					DIMENSION127=(Token)match(input,DIMENSION,FOLLOW_DIMENSION_in_valuepart1183);  
					stream_DIMENSION.add(DIMENSION127);

					// AST REWRITE
					// elements: MINUS, DIMENSION
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (Object)adaptor.nil();
					// 908:26: -> ( MINUS )? DIMENSION
					{
						// cz/vutbr/web/csskit/antlr/CSS.g:908:29: ( MINUS )?
						if ( stream_MINUS.hasNext() ) {
							adaptor.addChild(root_0, stream_MINUS.nextNode());
						}
						stream_MINUS.reset();

						adaptor.addChild(root_0, stream_DIMENSION.nextNode());
					}


					retval.tree = root_0;

					}
					break;
				case 6 :
					// cz/vutbr/web/csskit/antlr/CSS.g:909:9: string
					{
					pushFollow(FOLLOW_string_in_valuepart1200);
					string128=string();
					state._fsp--;

					stream_string.add(string128.getTree());
					// AST REWRITE
					// elements: string
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (Object)adaptor.nil();
					// 909:16: -> string
					{
						adaptor.addChild(root_0, stream_string.nextTree());
					}


					retval.tree = root_0;

					}
					break;
				case 7 :
					// cz/vutbr/web/csskit/antlr/CSS.g:910:9: URI
					{
					URI129=(Token)match(input,URI,FOLLOW_URI_in_valuepart1214);  
					stream_URI.add(URI129);

					// AST REWRITE
					// elements: URI
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (Object)adaptor.nil();
					// 910:16: -> URI
					{
						adaptor.addChild(root_0, stream_URI.nextNode());
					}


					retval.tree = root_0;

					}
					break;
				case 8 :
					// cz/vutbr/web/csskit/antlr/CSS.g:911:9: HASH
					{
					HASH130=(Token)match(input,HASH,FOLLOW_HASH_in_valuepart1231);  
					stream_HASH.add(HASH130);

					// AST REWRITE
					// elements: HASH
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (Object)adaptor.nil();
					// 911:14: -> HASH
					{
						adaptor.addChild(root_0, stream_HASH.nextNode());
					}


					retval.tree = root_0;

					}
					break;
				case 9 :
					// cz/vutbr/web/csskit/antlr/CSS.g:912:9: UNIRANGE
					{
					UNIRANGE131=(Token)match(input,UNIRANGE,FOLLOW_UNIRANGE_in_valuepart1245);  
					stream_UNIRANGE.add(UNIRANGE131);

					// AST REWRITE
					// elements: UNIRANGE
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (Object)adaptor.nil();
					// 912:18: -> UNIRANGE
					{
						adaptor.addChild(root_0, stream_UNIRANGE.nextNode());
					}


					retval.tree = root_0;

					}
					break;
				case 10 :
					// cz/vutbr/web/csskit/antlr/CSS.g:913:9: INCLUDES
					{
					INCLUDES132=(Token)match(input,INCLUDES,FOLLOW_INCLUDES_in_valuepart1259);  
					stream_INCLUDES.add(INCLUDES132);

					// AST REWRITE
					// elements: INCLUDES
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (Object)adaptor.nil();
					// 913:18: -> INCLUDES
					{
						adaptor.addChild(root_0, stream_INCLUDES.nextNode());
					}


					retval.tree = root_0;

					}
					break;
				case 11 :
					// cz/vutbr/web/csskit/antlr/CSS.g:914:9: COLON
					{
					COLON133=(Token)match(input,COLON,FOLLOW_COLON_in_valuepart1273);  
					stream_COLON.add(COLON133);

					// AST REWRITE
					// elements: COLON
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (Object)adaptor.nil();
					// 914:15: -> COLON
					{
						adaptor.addChild(root_0, stream_COLON.nextNode());
					}


					retval.tree = root_0;

					}
					break;
				case 12 :
					// cz/vutbr/web/csskit/antlr/CSS.g:915:9: COMMA
					{
					COMMA134=(Token)match(input,COMMA,FOLLOW_COMMA_in_valuepart1287);  
					stream_COMMA.add(COMMA134);

					// AST REWRITE
					// elements: COMMA
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (Object)adaptor.nil();
					// 915:15: -> COMMA
					{
						adaptor.addChild(root_0, stream_COMMA.nextNode());
					}


					retval.tree = root_0;

					}
					break;
				case 13 :
					// cz/vutbr/web/csskit/antlr/CSS.g:916:9: GREATER
					{
					GREATER135=(Token)match(input,GREATER,FOLLOW_GREATER_in_valuepart1301);  
					stream_GREATER.add(GREATER135);

					// AST REWRITE
					// elements: GREATER
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (Object)adaptor.nil();
					// 916:17: -> GREATER
					{
						adaptor.addChild(root_0, stream_GREATER.nextNode());
					}


					retval.tree = root_0;

					}
					break;
				case 14 :
					// cz/vutbr/web/csskit/antlr/CSS.g:917:9: LESS
					{
					LESS136=(Token)match(input,LESS,FOLLOW_LESS_in_valuepart1315);  
					stream_LESS.add(LESS136);

					// AST REWRITE
					// elements: LESS
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (Object)adaptor.nil();
					// 917:14: -> LESS
					{
						adaptor.addChild(root_0, stream_LESS.nextNode());
					}


					retval.tree = root_0;

					}
					break;
				case 15 :
					// cz/vutbr/web/csskit/antlr/CSS.g:918:9: QUESTION
					{
					QUESTION137=(Token)match(input,QUESTION,FOLLOW_QUESTION_in_valuepart1329);  
					stream_QUESTION.add(QUESTION137);

					// AST REWRITE
					// elements: QUESTION
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (Object)adaptor.nil();
					// 918:18: -> QUESTION
					{
						adaptor.addChild(root_0, stream_QUESTION.nextNode());
					}


					retval.tree = root_0;

					}
					break;
				case 16 :
					// cz/vutbr/web/csskit/antlr/CSS.g:919:9: PERCENT
					{
					PERCENT138=(Token)match(input,PERCENT,FOLLOW_PERCENT_in_valuepart1343);  
					stream_PERCENT.add(PERCENT138);

					// AST REWRITE
					// elements: PERCENT
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (Object)adaptor.nil();
					// 919:17: -> PERCENT
					{
						adaptor.addChild(root_0, stream_PERCENT.nextNode());
					}


					retval.tree = root_0;

					}
					break;
				case 17 :
					// cz/vutbr/web/csskit/antlr/CSS.g:920:9: EQUALS
					{
					EQUALS139=(Token)match(input,EQUALS,FOLLOW_EQUALS_in_valuepart1357);  
					stream_EQUALS.add(EQUALS139);

					// AST REWRITE
					// elements: EQUALS
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (Object)adaptor.nil();
					// 920:16: -> EQUALS
					{
						adaptor.addChild(root_0, stream_EQUALS.nextNode());
					}


					retval.tree = root_0;

					}
					break;
				case 18 :
					// cz/vutbr/web/csskit/antlr/CSS.g:921:9: SLASH
					{
					SLASH140=(Token)match(input,SLASH,FOLLOW_SLASH_in_valuepart1371);  
					stream_SLASH.add(SLASH140);

					// AST REWRITE
					// elements: SLASH
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (Object)adaptor.nil();
					// 921:15: -> SLASH
					{
						adaptor.addChild(root_0, stream_SLASH.nextNode());
					}


					retval.tree = root_0;

					}
					break;
				case 19 :
					// cz/vutbr/web/csskit/antlr/CSS.g:922:8: PLUS
					{
					PLUS141=(Token)match(input,PLUS,FOLLOW_PLUS_in_valuepart1384);  
					stream_PLUS.add(PLUS141);

					// AST REWRITE
					// elements: PLUS
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (Object)adaptor.nil();
					// 922:13: -> PLUS
					{
						adaptor.addChild(root_0, stream_PLUS.nextNode());
					}


					retval.tree = root_0;

					}
					break;
				case 20 :
					// cz/vutbr/web/csskit/antlr/CSS.g:923:8: ASTERISK
					{
					ASTERISK142=(Token)match(input,ASTERISK,FOLLOW_ASTERISK_in_valuepart1397);  
					stream_ASTERISK.add(ASTERISK142);

					// AST REWRITE
					// elements: ASTERISK
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (Object)adaptor.nil();
					// 923:17: -> ASTERISK
					{
						adaptor.addChild(root_0, stream_ASTERISK.nextNode());
					}


					retval.tree = root_0;

					}
					break;
				case 21 :
					// cz/vutbr/web/csskit/antlr/CSS.g:924:9: ( MINUS )? funct
					{
					// cz/vutbr/web/csskit/antlr/CSS.g:924:9: ( MINUS )?
					int alt66=2;
					int LA66_0 = input.LA(1);
					if ( (LA66_0==MINUS) ) {
						alt66=1;
					}
					switch (alt66) {
						case 1 :
							// cz/vutbr/web/csskit/antlr/CSS.g:924:9: MINUS
							{
							MINUS143=(Token)match(input,MINUS,FOLLOW_MINUS_in_valuepart1414);  
							stream_MINUS.add(MINUS143);

							}
							break;

					}

					pushFollow(FOLLOW_funct_in_valuepart1417);
					funct144=funct();
					state._fsp--;

					stream_funct.add(funct144.getTree());
					// AST REWRITE
					// elements: MINUS, funct
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (Object)adaptor.nil();
					// 924:22: -> ( MINUS )? funct
					{
						// cz/vutbr/web/csskit/antlr/CSS.g:924:25: ( MINUS )?
						if ( stream_MINUS.hasNext() ) {
							adaptor.addChild(root_0, stream_MINUS.nextNode());
						}
						stream_MINUS.reset();

						adaptor.addChild(root_0, stream_funct.nextTree());
					}


					retval.tree = root_0;

					}
					break;
				case 22 :
					// cz/vutbr/web/csskit/antlr/CSS.g:925:9: DASHMATCH
					{
					DASHMATCH145=(Token)match(input,DASHMATCH,FOLLOW_DASHMATCH_in_valuepart1435);  
					stream_DASHMATCH.add(DASHMATCH145);

					// AST REWRITE
					// elements: DASHMATCH
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (Object)adaptor.nil();
					// 925:19: -> DASHMATCH
					{
						adaptor.addChild(root_0, stream_DASHMATCH.nextNode());
					}


					retval.tree = root_0;

					}
					break;
				case 23 :
					// cz/vutbr/web/csskit/antlr/CSS.g:926:9: LPAREN ( valuepart )* RPAREN
					{
					LPAREN146=(Token)match(input,LPAREN,FOLLOW_LPAREN_in_valuepart1449);  
					stream_LPAREN.add(LPAREN146);

					// cz/vutbr/web/csskit/antlr/CSS.g:926:16: ( valuepart )*
					loop67:
					while (true) {
						int alt67=2;
						int LA67_0 = input.LA(1);
						if ( (LA67_0==ASTERISK||(LA67_0 >= CLASSKEYWORD && LA67_0 <= COMMA)||LA67_0==DASHMATCH||LA67_0==DIMENSION||LA67_0==EQUALS||LA67_0==EXPRESSION||(LA67_0 >= FUNCTION && LA67_0 <= IDENT)||LA67_0==INCLUDES||LA67_0==INVALID_STRING||LA67_0==LBRACE||(LA67_0 >= LESS && LA67_0 <= LPAREN)||LA67_0==MINUS||LA67_0==NUMBER||(LA67_0 >= PERCENT && LA67_0 <= PLUS)||LA67_0==QUESTION||LA67_0==SLASH||LA67_0==STRING||(LA67_0 >= UNIRANGE && LA67_0 <= URI)) ) {
							alt67=1;
						}

						switch (alt67) {
						case 1 :
							// cz/vutbr/web/csskit/antlr/CSS.g:926:16: valuepart
							{
							pushFollow(FOLLOW_valuepart_in_valuepart1451);
							valuepart147=valuepart();
							state._fsp--;

							stream_valuepart.add(valuepart147.getTree());
							}
							break;

						default :
							break loop67;
						}
					}

					RPAREN148=(Token)match(input,RPAREN,FOLLOW_RPAREN_in_valuepart1454);  
					stream_RPAREN.add(RPAREN148);

					// AST REWRITE
					// elements: valuepart
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (Object)adaptor.nil();
					// 926:34: -> ^( PARENBLOCK ( valuepart )* )
					{
						// cz/vutbr/web/csskit/antlr/CSS.g:926:37: ^( PARENBLOCK ( valuepart )* )
						{
						Object root_1 = (Object)adaptor.nil();
						root_1 = (Object)adaptor.becomeRoot((Object)adaptor.create(PARENBLOCK, "PARENBLOCK"), root_1);
						// cz/vutbr/web/csskit/antlr/CSS.g:926:50: ( valuepart )*
						while ( stream_valuepart.hasNext() ) {
							adaptor.addChild(root_1, stream_valuepart.nextTree());
						}
						stream_valuepart.reset();

						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;
				case 24 :
					// cz/vutbr/web/csskit/antlr/CSS.g:927:9: LBRACE ( valuepart )* RBRACE
					{
					LBRACE149=(Token)match(input,LBRACE,FOLLOW_LBRACE_in_valuepart1473);  
					stream_LBRACE.add(LBRACE149);

					// cz/vutbr/web/csskit/antlr/CSS.g:927:16: ( valuepart )*
					loop68:
					while (true) {
						int alt68=2;
						int LA68_0 = input.LA(1);
						if ( (LA68_0==ASTERISK||(LA68_0 >= CLASSKEYWORD && LA68_0 <= COMMA)||LA68_0==DASHMATCH||LA68_0==DIMENSION||LA68_0==EQUALS||LA68_0==EXPRESSION||(LA68_0 >= FUNCTION && LA68_0 <= IDENT)||LA68_0==INCLUDES||LA68_0==INVALID_STRING||LA68_0==LBRACE||(LA68_0 >= LESS && LA68_0 <= LPAREN)||LA68_0==MINUS||LA68_0==NUMBER||(LA68_0 >= PERCENT && LA68_0 <= PLUS)||LA68_0==QUESTION||LA68_0==SLASH||LA68_0==STRING||(LA68_0 >= UNIRANGE && LA68_0 <= URI)) ) {
							alt68=1;
						}

						switch (alt68) {
						case 1 :
							// cz/vutbr/web/csskit/antlr/CSS.g:927:16: valuepart
							{
							pushFollow(FOLLOW_valuepart_in_valuepart1475);
							valuepart150=valuepart();
							state._fsp--;

							stream_valuepart.add(valuepart150.getTree());
							}
							break;

						default :
							break loop68;
						}
					}

					RBRACE151=(Token)match(input,RBRACE,FOLLOW_RBRACE_in_valuepart1478);  
					stream_RBRACE.add(RBRACE151);

					// AST REWRITE
					// elements: valuepart
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (Object)adaptor.nil();
					// 927:34: -> ^( BRACEBLOCK ( valuepart )* )
					{
						// cz/vutbr/web/csskit/antlr/CSS.g:927:37: ^( BRACEBLOCK ( valuepart )* )
						{
						Object root_1 = (Object)adaptor.nil();
						root_1 = (Object)adaptor.becomeRoot((Object)adaptor.create(BRACEBLOCK, "BRACEBLOCK"), root_1);
						// cz/vutbr/web/csskit/antlr/CSS.g:927:50: ( valuepart )*
						while ( stream_valuepart.hasNext() ) {
							adaptor.addChild(root_1, stream_valuepart.nextTree());
						}
						stream_valuepart.reset();

						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;

			}

			// cz/vutbr/web/csskit/antlr/CSS.g:928:8: ( S )*
			loop70:
			while (true) {
				int alt70=2;
				int LA70_0 = input.LA(1);
				if ( (LA70_0==S) ) {
					alt70=1;
				}

				switch (alt70) {
				case 1 :
					// cz/vutbr/web/csskit/antlr/CSS.g:928:8: S
					{
					S152=(Token)match(input,S,FOLLOW_S_in_valuepart1496);  
					stream_S.add(S152);

					}
					break;

				default :
					break loop70;
				}
			}

			}

			retval.stop = input.LT(-1);

			retval.tree = (Object)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "valuepart"


	public static class combined_selector_return extends ParserRuleReturnScope {
		Object tree;
		@Override
		public Object getTree() { return tree; }
	};


	// $ANTLR start "combined_selector"
	// cz/vutbr/web/csskit/antlr/CSS.g:931:1: combined_selector : selector ( ( combinator ) selector )* ;
	public final CSSParser.combined_selector_return combined_selector() throws RecognitionException {
		CSSParser.combined_selector_return retval = new CSSParser.combined_selector_return();
		retval.start = input.LT(1);

		Object root_0 = null;

		ParserRuleReturnScope selector153 =null;
		ParserRuleReturnScope combinator154 =null;
		ParserRuleReturnScope selector155 =null;


		try {
			// cz/vutbr/web/csskit/antlr/CSS.g:932:2: ( selector ( ( combinator ) selector )* )
			// cz/vutbr/web/csskit/antlr/CSS.g:932:4: selector ( ( combinator ) selector )*
			{
			root_0 = (Object)adaptor.nil();


			pushFollow(FOLLOW_selector_in_combined_selector1513);
			selector153=selector();
			state._fsp--;

			adaptor.addChild(root_0, selector153.getTree());

			// cz/vutbr/web/csskit/antlr/CSS.g:932:13: ( ( combinator ) selector )*
			loop71:
			while (true) {
				int alt71=2;
				int LA71_0 = input.LA(1);
				if ( (LA71_0==GREATER||LA71_0==PLUS||LA71_0==S||LA71_0==TILDE) ) {
					alt71=1;
				}

				switch (alt71) {
				case 1 :
					// cz/vutbr/web/csskit/antlr/CSS.g:932:14: ( combinator ) selector
					{
					// cz/vutbr/web/csskit/antlr/CSS.g:932:14: ( combinator )
					// cz/vutbr/web/csskit/antlr/CSS.g:932:15: combinator
					{
					pushFollow(FOLLOW_combinator_in_combined_selector1517);
					combinator154=combinator();
					state._fsp--;

					adaptor.addChild(root_0, combinator154.getTree());

					}

					pushFollow(FOLLOW_selector_in_combined_selector1520);
					selector155=selector();
					state._fsp--;

					adaptor.addChild(root_0, selector155.getTree());

					}
					break;

				default :
					break loop71;
				}
			}

			}

			retval.stop = input.LT(-1);

			retval.tree = (Object)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {

				  log.warn("INVALID COMBINED SELECTOR");
				  reportError(re);
			      recover(input,re);
				
		}

		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "combined_selector"


	public static class combinator_return extends ParserRuleReturnScope {
		Object tree;
		@Override
		public Object getTree() { return tree; }
	};


	// $ANTLR start "combinator"
	// cz/vutbr/web/csskit/antlr/CSS.g:940:1: combinator : ( GREATER ( S )* -> CHILD | PLUS ( S )* -> ADJACENT | TILDE ( S )* -> PRECEDING | S -> DESCENDANT );
	public final CSSParser.combinator_return combinator() throws RecognitionException {
		CSSParser.combinator_return retval = new CSSParser.combinator_return();
		retval.start = input.LT(1);

		Object root_0 = null;

		Token GREATER156=null;
		Token S157=null;
		Token PLUS158=null;
		Token S159=null;
		Token TILDE160=null;
		Token S161=null;
		Token S162=null;

		Object GREATER156_tree=null;
		Object S157_tree=null;
		Object PLUS158_tree=null;
		Object S159_tree=null;
		Object TILDE160_tree=null;
		Object S161_tree=null;
		Object S162_tree=null;
		RewriteRuleTokenStream stream_PLUS=new RewriteRuleTokenStream(adaptor,"token PLUS");
		RewriteRuleTokenStream stream_GREATER=new RewriteRuleTokenStream(adaptor,"token GREATER");
		RewriteRuleTokenStream stream_S=new RewriteRuleTokenStream(adaptor,"token S");
		RewriteRuleTokenStream stream_TILDE=new RewriteRuleTokenStream(adaptor,"token TILDE");

		try {
			// cz/vutbr/web/csskit/antlr/CSS.g:941:2: ( GREATER ( S )* -> CHILD | PLUS ( S )* -> ADJACENT | TILDE ( S )* -> PRECEDING | S -> DESCENDANT )
			int alt75=4;
			switch ( input.LA(1) ) {
			case GREATER:
				{
				alt75=1;
				}
				break;
			case PLUS:
				{
				alt75=2;
				}
				break;
			case TILDE:
				{
				alt75=3;
				}
				break;
			case S:
				{
				alt75=4;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 75, 0, input);
				throw nvae;
			}
			switch (alt75) {
				case 1 :
					// cz/vutbr/web/csskit/antlr/CSS.g:941:4: GREATER ( S )*
					{
					GREATER156=(Token)match(input,GREATER,FOLLOW_GREATER_in_combinator1540);  
					stream_GREATER.add(GREATER156);

					// cz/vutbr/web/csskit/antlr/CSS.g:941:12: ( S )*
					loop72:
					while (true) {
						int alt72=2;
						int LA72_0 = input.LA(1);
						if ( (LA72_0==S) ) {
							alt72=1;
						}

						switch (alt72) {
						case 1 :
							// cz/vutbr/web/csskit/antlr/CSS.g:941:12: S
							{
							S157=(Token)match(input,S,FOLLOW_S_in_combinator1542);  
							stream_S.add(S157);

							}
							break;

						default :
							break loop72;
						}
					}

					// AST REWRITE
					// elements: 
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (Object)adaptor.nil();
					// 941:15: -> CHILD
					{
						adaptor.addChild(root_0, (Object)adaptor.create(CHILD, "CHILD"));
					}


					retval.tree = root_0;

					}
					break;
				case 2 :
					// cz/vutbr/web/csskit/antlr/CSS.g:942:4: PLUS ( S )*
					{
					PLUS158=(Token)match(input,PLUS,FOLLOW_PLUS_in_combinator1552);  
					stream_PLUS.add(PLUS158);

					// cz/vutbr/web/csskit/antlr/CSS.g:942:9: ( S )*
					loop73:
					while (true) {
						int alt73=2;
						int LA73_0 = input.LA(1);
						if ( (LA73_0==S) ) {
							alt73=1;
						}

						switch (alt73) {
						case 1 :
							// cz/vutbr/web/csskit/antlr/CSS.g:942:9: S
							{
							S159=(Token)match(input,S,FOLLOW_S_in_combinator1554);  
							stream_S.add(S159);

							}
							break;

						default :
							break loop73;
						}
					}

					// AST REWRITE
					// elements: 
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (Object)adaptor.nil();
					// 942:12: -> ADJACENT
					{
						adaptor.addChild(root_0, (Object)adaptor.create(ADJACENT, "ADJACENT"));
					}


					retval.tree = root_0;

					}
					break;
				case 3 :
					// cz/vutbr/web/csskit/antlr/CSS.g:943:4: TILDE ( S )*
					{
					TILDE160=(Token)match(input,TILDE,FOLLOW_TILDE_in_combinator1564);  
					stream_TILDE.add(TILDE160);

					// cz/vutbr/web/csskit/antlr/CSS.g:943:10: ( S )*
					loop74:
					while (true) {
						int alt74=2;
						int LA74_0 = input.LA(1);
						if ( (LA74_0==S) ) {
							alt74=1;
						}

						switch (alt74) {
						case 1 :
							// cz/vutbr/web/csskit/antlr/CSS.g:943:10: S
							{
							S161=(Token)match(input,S,FOLLOW_S_in_combinator1566);  
							stream_S.add(S161);

							}
							break;

						default :
							break loop74;
						}
					}

					// AST REWRITE
					// elements: 
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (Object)adaptor.nil();
					// 943:13: -> PRECEDING
					{
						adaptor.addChild(root_0, (Object)adaptor.create(PRECEDING, "PRECEDING"));
					}


					retval.tree = root_0;

					}
					break;
				case 4 :
					// cz/vutbr/web/csskit/antlr/CSS.g:944:4: S
					{
					S162=(Token)match(input,S,FOLLOW_S_in_combinator1576);  
					stream_S.add(S162);

					// AST REWRITE
					// elements: 
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (Object)adaptor.nil();
					// 944:6: -> DESCENDANT
					{
						adaptor.addChild(root_0, (Object)adaptor.create(DESCENDANT, "DESCENDANT"));
					}


					retval.tree = root_0;

					}
					break;

			}
			retval.stop = input.LT(-1);

			retval.tree = (Object)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "combinator"


	public static class selector_return extends ParserRuleReturnScope {
		Object tree;
		@Override
		public Object getTree() { return tree; }
	};


	// $ANTLR start "selector"
	// cz/vutbr/web/csskit/antlr/CSS.g:947:1: selector : ( ( IDENT | ASTERISK ) ( selpart )* ( S )* -> ^( SELECTOR ^( ELEMENT ( IDENT )? ) ( selpart )* ) | ( selpart )+ ( S )* -> ^( SELECTOR ( selpart )+ ) );
	public final CSSParser.selector_return selector() throws RecognitionException {
		CSSParser.selector_return retval = new CSSParser.selector_return();
		retval.start = input.LT(1);

		Object root_0 = null;

		Token IDENT163=null;
		Token ASTERISK164=null;
		Token S166=null;
		Token S168=null;
		ParserRuleReturnScope selpart165 =null;
		ParserRuleReturnScope selpart167 =null;

		Object IDENT163_tree=null;
		Object ASTERISK164_tree=null;
		Object S166_tree=null;
		Object S168_tree=null;
		RewriteRuleTokenStream stream_IDENT=new RewriteRuleTokenStream(adaptor,"token IDENT");
		RewriteRuleTokenStream stream_S=new RewriteRuleTokenStream(adaptor,"token S");
		RewriteRuleTokenStream stream_ASTERISK=new RewriteRuleTokenStream(adaptor,"token ASTERISK");
		RewriteRuleSubtreeStream stream_selpart=new RewriteRuleSubtreeStream(adaptor,"rule selpart");

		try {
			// cz/vutbr/web/csskit/antlr/CSS.g:948:5: ( ( IDENT | ASTERISK ) ( selpart )* ( S )* -> ^( SELECTOR ^( ELEMENT ( IDENT )? ) ( selpart )* ) | ( selpart )+ ( S )* -> ^( SELECTOR ( selpart )+ ) )
			int alt81=2;
			int LA81_0 = input.LA(1);
			if ( (LA81_0==ASTERISK||LA81_0==IDENT) ) {
				alt81=1;
			}
			else if ( ((LA81_0 >= CLASSKEYWORD && LA81_0 <= COLON)||LA81_0==HASH||LA81_0==INVALID_SELPART||LA81_0==LBRACE) ) {
				alt81=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 81, 0, input);
				throw nvae;
			}

			switch (alt81) {
				case 1 :
					// cz/vutbr/web/csskit/antlr/CSS.g:948:7: ( IDENT | ASTERISK ) ( selpart )* ( S )*
					{
					// cz/vutbr/web/csskit/antlr/CSS.g:948:7: ( IDENT | ASTERISK )
					int alt76=2;
					int LA76_0 = input.LA(1);
					if ( (LA76_0==IDENT) ) {
						alt76=1;
					}
					else if ( (LA76_0==ASTERISK) ) {
						alt76=2;
					}

					else {
						NoViableAltException nvae =
							new NoViableAltException("", 76, 0, input);
						throw nvae;
					}

					switch (alt76) {
						case 1 :
							// cz/vutbr/web/csskit/antlr/CSS.g:948:8: IDENT
							{
							IDENT163=(Token)match(input,IDENT,FOLLOW_IDENT_in_selector1595);  
							stream_IDENT.add(IDENT163);

							}
							break;
						case 2 :
							// cz/vutbr/web/csskit/antlr/CSS.g:948:16: ASTERISK
							{
							ASTERISK164=(Token)match(input,ASTERISK,FOLLOW_ASTERISK_in_selector1599);  
							stream_ASTERISK.add(ASTERISK164);

							}
							break;

					}

					// cz/vutbr/web/csskit/antlr/CSS.g:948:27: ( selpart )*
					loop77:
					while (true) {
						int alt77=2;
						int LA77_0 = input.LA(1);
						if ( ((LA77_0 >= CLASSKEYWORD && LA77_0 <= COLON)||LA77_0==HASH||LA77_0==INVALID_SELPART||LA77_0==LBRACE) ) {
							alt77=1;
						}

						switch (alt77) {
						case 1 :
							// cz/vutbr/web/csskit/antlr/CSS.g:948:27: selpart
							{
							pushFollow(FOLLOW_selpart_in_selector1603);
							selpart165=selpart();
							state._fsp--;

							stream_selpart.add(selpart165.getTree());
							}
							break;

						default :
							break loop77;
						}
					}

					// cz/vutbr/web/csskit/antlr/CSS.g:948:36: ( S )*
					loop78:
					while (true) {
						int alt78=2;
						int LA78_0 = input.LA(1);
						if ( (LA78_0==S) ) {
							int LA78_4 = input.LA(2);
							if ( (LA78_4==COMMA||LA78_4==GREATER||LA78_4==LCURLY||LA78_4==PLUS||LA78_4==S||LA78_4==TILDE) ) {
								alt78=1;
							}

						}

						switch (alt78) {
						case 1 :
							// cz/vutbr/web/csskit/antlr/CSS.g:948:36: S
							{
							S166=(Token)match(input,S,FOLLOW_S_in_selector1606);  
							stream_S.add(S166);

							}
							break;

						default :
							break loop78;
						}
					}

					// AST REWRITE
					// elements: IDENT, selpart
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (Object)adaptor.nil();
					// 949:6: -> ^( SELECTOR ^( ELEMENT ( IDENT )? ) ( selpart )* )
					{
						// cz/vutbr/web/csskit/antlr/CSS.g:949:9: ^( SELECTOR ^( ELEMENT ( IDENT )? ) ( selpart )* )
						{
						Object root_1 = (Object)adaptor.nil();
						root_1 = (Object)adaptor.becomeRoot((Object)adaptor.create(SELECTOR, "SELECTOR"), root_1);
						// cz/vutbr/web/csskit/antlr/CSS.g:949:20: ^( ELEMENT ( IDENT )? )
						{
						Object root_2 = (Object)adaptor.nil();
						root_2 = (Object)adaptor.becomeRoot((Object)adaptor.create(ELEMENT, "ELEMENT"), root_2);
						// cz/vutbr/web/csskit/antlr/CSS.g:949:30: ( IDENT )?
						if ( stream_IDENT.hasNext() ) {
							adaptor.addChild(root_2, stream_IDENT.nextNode());
						}
						stream_IDENT.reset();

						adaptor.addChild(root_1, root_2);
						}

						// cz/vutbr/web/csskit/antlr/CSS.g:949:38: ( selpart )*
						while ( stream_selpart.hasNext() ) {
							adaptor.addChild(root_1, stream_selpart.nextTree());
						}
						stream_selpart.reset();

						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;
				case 2 :
					// cz/vutbr/web/csskit/antlr/CSS.g:950:7: ( selpart )+ ( S )*
					{
					// cz/vutbr/web/csskit/antlr/CSS.g:950:7: ( selpart )+
					int cnt79=0;
					loop79:
					while (true) {
						int alt79=2;
						int LA79_0 = input.LA(1);
						if ( ((LA79_0 >= CLASSKEYWORD && LA79_0 <= COLON)||LA79_0==HASH||LA79_0==INVALID_SELPART||LA79_0==LBRACE) ) {
							alt79=1;
						}

						switch (alt79) {
						case 1 :
							// cz/vutbr/web/csskit/antlr/CSS.g:950:7: selpart
							{
							pushFollow(FOLLOW_selpart_in_selector1636);
							selpart167=selpart();
							state._fsp--;

							stream_selpart.add(selpart167.getTree());
							}
							break;

						default :
							if ( cnt79 >= 1 ) break loop79;
							EarlyExitException eee = new EarlyExitException(79, input);
							throw eee;
						}
						cnt79++;
					}

					// cz/vutbr/web/csskit/antlr/CSS.g:950:16: ( S )*
					loop80:
					while (true) {
						int alt80=2;
						int LA80_0 = input.LA(1);
						if ( (LA80_0==S) ) {
							int LA80_4 = input.LA(2);
							if ( (LA80_4==COMMA||LA80_4==GREATER||LA80_4==LCURLY||LA80_4==PLUS||LA80_4==S||LA80_4==TILDE) ) {
								alt80=1;
							}

						}

						switch (alt80) {
						case 1 :
							// cz/vutbr/web/csskit/antlr/CSS.g:950:16: S
							{
							S168=(Token)match(input,S,FOLLOW_S_in_selector1639);  
							stream_S.add(S168);

							}
							break;

						default :
							break loop80;
						}
					}

					// AST REWRITE
					// elements: selpart
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (Object)adaptor.nil();
					// 951:9: -> ^( SELECTOR ( selpart )+ )
					{
						// cz/vutbr/web/csskit/antlr/CSS.g:951:12: ^( SELECTOR ( selpart )+ )
						{
						Object root_1 = (Object)adaptor.nil();
						root_1 = (Object)adaptor.becomeRoot((Object)adaptor.create(SELECTOR, "SELECTOR"), root_1);
						if ( !(stream_selpart.hasNext()) ) {
							throw new RewriteEarlyExitException();
						}
						while ( stream_selpart.hasNext() ) {
							adaptor.addChild(root_1, stream_selpart.nextTree());
						}
						stream_selpart.reset();

						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;

			}
			retval.stop = input.LT(-1);

			retval.tree = (Object)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {

			      retval.tree = invalidFallback(CSSLexer.INVALID_SELECTOR, "INVALID_SELECTOR", re);
				  
		}

		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "selector"


	public static class selpart_return extends ParserRuleReturnScope {
		Object tree;
		@Override
		public Object getTree() { return tree; }
	};


	// $ANTLR start "selpart"
	// cz/vutbr/web/csskit/antlr/CSS.g:957:1: selpart : ( HASH | CLASSKEYWORD | LBRACE ( S )* attribute RBRACE -> ^( ATTRIBUTE attribute ) | pseudo | INVALID_SELPART );
	public final CSSParser.selpart_return selpart() throws RecognitionException {
		CSSParser.selpart_return retval = new CSSParser.selpart_return();
		retval.start = input.LT(1);

		Object root_0 = null;

		Token HASH169=null;
		Token CLASSKEYWORD170=null;
		Token LBRACE171=null;
		Token S172=null;
		Token RBRACE174=null;
		Token INVALID_SELPART176=null;
		ParserRuleReturnScope attribute173 =null;
		ParserRuleReturnScope pseudo175 =null;

		Object HASH169_tree=null;
		Object CLASSKEYWORD170_tree=null;
		Object LBRACE171_tree=null;
		Object S172_tree=null;
		Object RBRACE174_tree=null;
		Object INVALID_SELPART176_tree=null;
		RewriteRuleTokenStream stream_S=new RewriteRuleTokenStream(adaptor,"token S");
		RewriteRuleTokenStream stream_RBRACE=new RewriteRuleTokenStream(adaptor,"token RBRACE");
		RewriteRuleTokenStream stream_LBRACE=new RewriteRuleTokenStream(adaptor,"token LBRACE");
		RewriteRuleSubtreeStream stream_attribute=new RewriteRuleSubtreeStream(adaptor,"rule attribute");

		try {
			// cz/vutbr/web/csskit/antlr/CSS.g:958:5: ( HASH | CLASSKEYWORD | LBRACE ( S )* attribute RBRACE -> ^( ATTRIBUTE attribute ) | pseudo | INVALID_SELPART )
			int alt83=5;
			switch ( input.LA(1) ) {
			case HASH:
				{
				alt83=1;
				}
				break;
			case CLASSKEYWORD:
				{
				alt83=2;
				}
				break;
			case LBRACE:
				{
				alt83=3;
				}
				break;
			case COLON:
				{
				alt83=4;
				}
				break;
			case INVALID_SELPART:
				{
				alt83=5;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 83, 0, input);
				throw nvae;
			}
			switch (alt83) {
				case 1 :
					// cz/vutbr/web/csskit/antlr/CSS.g:958:8: HASH
					{
					root_0 = (Object)adaptor.nil();


					HASH169=(Token)match(input,HASH,FOLLOW_HASH_in_selpart1686); 
					HASH169_tree = (Object)adaptor.create(HASH169);
					adaptor.addChild(root_0, HASH169_tree);

					}
					break;
				case 2 :
					// cz/vutbr/web/csskit/antlr/CSS.g:959:7: CLASSKEYWORD
					{
					root_0 = (Object)adaptor.nil();


					CLASSKEYWORD170=(Token)match(input,CLASSKEYWORD,FOLLOW_CLASSKEYWORD_in_selpart1694); 
					CLASSKEYWORD170_tree = (Object)adaptor.create(CLASSKEYWORD170);
					adaptor.addChild(root_0, CLASSKEYWORD170_tree);

					}
					break;
				case 3 :
					// cz/vutbr/web/csskit/antlr/CSS.g:960:6: LBRACE ( S )* attribute RBRACE
					{
					LBRACE171=(Token)match(input,LBRACE,FOLLOW_LBRACE_in_selpart1701);  
					stream_LBRACE.add(LBRACE171);

					// cz/vutbr/web/csskit/antlr/CSS.g:960:13: ( S )*
					loop82:
					while (true) {
						int alt82=2;
						int LA82_0 = input.LA(1);
						if ( (LA82_0==S) ) {
							alt82=1;
						}

						switch (alt82) {
						case 1 :
							// cz/vutbr/web/csskit/antlr/CSS.g:960:13: S
							{
							S172=(Token)match(input,S,FOLLOW_S_in_selpart1703);  
							stream_S.add(S172);

							}
							break;

						default :
							break loop82;
						}
					}

					pushFollow(FOLLOW_attribute_in_selpart1706);
					attribute173=attribute();
					state._fsp--;

					stream_attribute.add(attribute173.getTree());
					RBRACE174=(Token)match(input,RBRACE,FOLLOW_RBRACE_in_selpart1708);  
					stream_RBRACE.add(RBRACE174);

					// AST REWRITE
					// elements: attribute
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (Object)adaptor.nil();
					// 960:33: -> ^( ATTRIBUTE attribute )
					{
						// cz/vutbr/web/csskit/antlr/CSS.g:960:36: ^( ATTRIBUTE attribute )
						{
						Object root_1 = (Object)adaptor.nil();
						root_1 = (Object)adaptor.becomeRoot((Object)adaptor.create(ATTRIBUTE, "ATTRIBUTE"), root_1);
						adaptor.addChild(root_1, stream_attribute.nextTree());
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;
				case 4 :
					// cz/vutbr/web/csskit/antlr/CSS.g:961:7: pseudo
					{
					root_0 = (Object)adaptor.nil();


					pushFollow(FOLLOW_pseudo_in_selpart1724);
					pseudo175=pseudo();
					state._fsp--;

					adaptor.addChild(root_0, pseudo175.getTree());

					}
					break;
				case 5 :
					// cz/vutbr/web/csskit/antlr/CSS.g:962:7: INVALID_SELPART
					{
					root_0 = (Object)adaptor.nil();


					INVALID_SELPART176=(Token)match(input,INVALID_SELPART,FOLLOW_INVALID_SELPART_in_selpart1732); 
					INVALID_SELPART176_tree = (Object)adaptor.create(INVALID_SELPART176);
					adaptor.addChild(root_0, INVALID_SELPART176_tree);

					}
					break;

			}
			retval.stop = input.LT(-1);

			retval.tree = (Object)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {

			      retval.tree = invalidFallback(CSSLexer.INVALID_SELPART, "INVALID_SELPART", re);
				  
		}

		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "selpart"


	public static class attribute_return extends ParserRuleReturnScope {
		Object tree;
		@Override
		public Object getTree() { return tree; }
	};


	// $ANTLR start "attribute"
	// cz/vutbr/web/csskit/antlr/CSS.g:968:1: attribute : IDENT ( S !)* ( ( EQUALS | INCLUDES | DASHMATCH | STARTSWITH | ENDSWITH | CONTAINS ) ( S !)* ( IDENT | string ) ( S !)* )? ;
	public final CSSParser.attribute_return attribute() throws RecognitionException {
		CSSParser.attribute_return retval = new CSSParser.attribute_return();
		retval.start = input.LT(1);

		Object root_0 = null;

		Token IDENT177=null;
		Token S178=null;
		Token set179=null;
		Token S180=null;
		Token IDENT181=null;
		Token S183=null;
		ParserRuleReturnScope string182 =null;

		Object IDENT177_tree=null;
		Object S178_tree=null;
		Object set179_tree=null;
		Object S180_tree=null;
		Object IDENT181_tree=null;
		Object S183_tree=null;

		try {
			// cz/vutbr/web/csskit/antlr/CSS.g:969:2: ( IDENT ( S !)* ( ( EQUALS | INCLUDES | DASHMATCH | STARTSWITH | ENDSWITH | CONTAINS ) ( S !)* ( IDENT | string ) ( S !)* )? )
			// cz/vutbr/web/csskit/antlr/CSS.g:969:4: IDENT ( S !)* ( ( EQUALS | INCLUDES | DASHMATCH | STARTSWITH | ENDSWITH | CONTAINS ) ( S !)* ( IDENT | string ) ( S !)* )?
			{
			root_0 = (Object)adaptor.nil();


			IDENT177=(Token)match(input,IDENT,FOLLOW_IDENT_in_attribute1756); 
			IDENT177_tree = (Object)adaptor.create(IDENT177);
			adaptor.addChild(root_0, IDENT177_tree);

			// cz/vutbr/web/csskit/antlr/CSS.g:969:11: ( S !)*
			loop84:
			while (true) {
				int alt84=2;
				int LA84_0 = input.LA(1);
				if ( (LA84_0==S) ) {
					alt84=1;
				}

				switch (alt84) {
				case 1 :
					// cz/vutbr/web/csskit/antlr/CSS.g:969:11: S !
					{
					S178=(Token)match(input,S,FOLLOW_S_in_attribute1758); 
					}
					break;

				default :
					break loop84;
				}
			}

			// cz/vutbr/web/csskit/antlr/CSS.g:970:4: ( ( EQUALS | INCLUDES | DASHMATCH | STARTSWITH | ENDSWITH | CONTAINS ) ( S !)* ( IDENT | string ) ( S !)* )?
			int alt88=2;
			int LA88_0 = input.LA(1);
			if ( (LA88_0==CONTAINS||LA88_0==DASHMATCH||(LA88_0 >= ENDSWITH && LA88_0 <= EQUALS)||LA88_0==INCLUDES||LA88_0==STARTSWITH) ) {
				alt88=1;
			}
			switch (alt88) {
				case 1 :
					// cz/vutbr/web/csskit/antlr/CSS.g:970:5: ( EQUALS | INCLUDES | DASHMATCH | STARTSWITH | ENDSWITH | CONTAINS ) ( S !)* ( IDENT | string ) ( S !)*
					{
					set179=input.LT(1);
					if ( input.LA(1)==CONTAINS||input.LA(1)==DASHMATCH||(input.LA(1) >= ENDSWITH && input.LA(1) <= EQUALS)||input.LA(1)==INCLUDES||input.LA(1)==STARTSWITH ) {
						input.consume();
						adaptor.addChild(root_0, (Object)adaptor.create(set179));
						state.errorRecovery=false;
					}
					else {
						MismatchedSetException mse = new MismatchedSetException(null,input);
						throw mse;
					}
					// cz/vutbr/web/csskit/antlr/CSS.g:970:73: ( S !)*
					loop85:
					while (true) {
						int alt85=2;
						int LA85_0 = input.LA(1);
						if ( (LA85_0==S) ) {
							alt85=1;
						}

						switch (alt85) {
						case 1 :
							// cz/vutbr/web/csskit/antlr/CSS.g:970:73: S !
							{
							S180=(Token)match(input,S,FOLLOW_S_in_attribute1790); 
							}
							break;

						default :
							break loop85;
						}
					}

					// cz/vutbr/web/csskit/antlr/CSS.g:970:76: ( IDENT | string )
					int alt86=2;
					int LA86_0 = input.LA(1);
					if ( (LA86_0==IDENT) ) {
						alt86=1;
					}
					else if ( (LA86_0==INVALID_STRING||LA86_0==STRING) ) {
						alt86=2;
					}

					else {
						NoViableAltException nvae =
							new NoViableAltException("", 86, 0, input);
						throw nvae;
					}

					switch (alt86) {
						case 1 :
							// cz/vutbr/web/csskit/antlr/CSS.g:970:77: IDENT
							{
							IDENT181=(Token)match(input,IDENT,FOLLOW_IDENT_in_attribute1795); 
							IDENT181_tree = (Object)adaptor.create(IDENT181);
							adaptor.addChild(root_0, IDENT181_tree);

							}
							break;
						case 2 :
							// cz/vutbr/web/csskit/antlr/CSS.g:970:85: string
							{
							pushFollow(FOLLOW_string_in_attribute1799);
							string182=string();
							state._fsp--;

							adaptor.addChild(root_0, string182.getTree());

							}
							break;

					}

					// cz/vutbr/web/csskit/antlr/CSS.g:970:94: ( S !)*
					loop87:
					while (true) {
						int alt87=2;
						int LA87_0 = input.LA(1);
						if ( (LA87_0==S) ) {
							alt87=1;
						}

						switch (alt87) {
						case 1 :
							// cz/vutbr/web/csskit/antlr/CSS.g:970:94: S !
							{
							S183=(Token)match(input,S,FOLLOW_S_in_attribute1802); 
							}
							break;

						default :
							break loop87;
						}
					}

					}
					break;

			}

			}

			retval.stop = input.LT(-1);

			retval.tree = (Object)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "attribute"


	public static class pseudo_return extends ParserRuleReturnScope {
		Object tree;
		@Override
		public Object getTree() { return tree; }
	};


	// $ANTLR start "pseudo"
	// cz/vutbr/web/csskit/antlr/CSS.g:973:1: pseudo : pseudocolon ^ ( IDENT | FUNCTION ( S !)* ( IDENT | ( MINUS )? NUMBER | ( MINUS )? INDEX ) ( S !)* RPAREN !) ;
	public final CSSParser.pseudo_return pseudo() throws RecognitionException {
		CSSParser.pseudo_return retval = new CSSParser.pseudo_return();
		retval.start = input.LT(1);

		Object root_0 = null;

		Token IDENT185=null;
		Token FUNCTION186=null;
		Token S187=null;
		Token IDENT188=null;
		Token MINUS189=null;
		Token NUMBER190=null;
		Token MINUS191=null;
		Token INDEX192=null;
		Token S193=null;
		Token RPAREN194=null;
		ParserRuleReturnScope pseudocolon184 =null;

		Object IDENT185_tree=null;
		Object FUNCTION186_tree=null;
		Object S187_tree=null;
		Object IDENT188_tree=null;
		Object MINUS189_tree=null;
		Object NUMBER190_tree=null;
		Object MINUS191_tree=null;
		Object INDEX192_tree=null;
		Object S193_tree=null;
		Object RPAREN194_tree=null;

		try {
			// cz/vutbr/web/csskit/antlr/CSS.g:974:2: ( pseudocolon ^ ( IDENT | FUNCTION ( S !)* ( IDENT | ( MINUS )? NUMBER | ( MINUS )? INDEX ) ( S !)* RPAREN !) )
			// cz/vutbr/web/csskit/antlr/CSS.g:974:4: pseudocolon ^ ( IDENT | FUNCTION ( S !)* ( IDENT | ( MINUS )? NUMBER | ( MINUS )? INDEX ) ( S !)* RPAREN !)
			{
			root_0 = (Object)adaptor.nil();


			pushFollow(FOLLOW_pseudocolon_in_pseudo1817);
			pseudocolon184=pseudocolon();
			state._fsp--;

			root_0 = (Object)adaptor.becomeRoot(pseudocolon184.getTree(), root_0);
			// cz/vutbr/web/csskit/antlr/CSS.g:974:17: ( IDENT | FUNCTION ( S !)* ( IDENT | ( MINUS )? NUMBER | ( MINUS )? INDEX ) ( S !)* RPAREN !)
			int alt94=2;
			int LA94_0 = input.LA(1);
			if ( (LA94_0==IDENT) ) {
				alt94=1;
			}
			else if ( (LA94_0==FUNCTION) ) {
				alt94=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 94, 0, input);
				throw nvae;
			}

			switch (alt94) {
				case 1 :
					// cz/vutbr/web/csskit/antlr/CSS.g:974:18: IDENT
					{
					IDENT185=(Token)match(input,IDENT,FOLLOW_IDENT_in_pseudo1821); 
					IDENT185_tree = (Object)adaptor.create(IDENT185);
					adaptor.addChild(root_0, IDENT185_tree);

					}
					break;
				case 2 :
					// cz/vutbr/web/csskit/antlr/CSS.g:974:26: FUNCTION ( S !)* ( IDENT | ( MINUS )? NUMBER | ( MINUS )? INDEX ) ( S !)* RPAREN !
					{
					FUNCTION186=(Token)match(input,FUNCTION,FOLLOW_FUNCTION_in_pseudo1825); 
					FUNCTION186_tree = (Object)adaptor.create(FUNCTION186);
					adaptor.addChild(root_0, FUNCTION186_tree);

					// cz/vutbr/web/csskit/antlr/CSS.g:974:36: ( S !)*
					loop89:
					while (true) {
						int alt89=2;
						int LA89_0 = input.LA(1);
						if ( (LA89_0==S) ) {
							alt89=1;
						}

						switch (alt89) {
						case 1 :
							// cz/vutbr/web/csskit/antlr/CSS.g:974:36: S !
							{
							S187=(Token)match(input,S,FOLLOW_S_in_pseudo1827); 
							}
							break;

						default :
							break loop89;
						}
					}

					// cz/vutbr/web/csskit/antlr/CSS.g:974:39: ( IDENT | ( MINUS )? NUMBER | ( MINUS )? INDEX )
					int alt92=3;
					switch ( input.LA(1) ) {
					case IDENT:
						{
						alt92=1;
						}
						break;
					case MINUS:
						{
						int LA92_2 = input.LA(2);
						if ( (LA92_2==NUMBER) ) {
							alt92=2;
						}
						else if ( (LA92_2==INDEX) ) {
							alt92=3;
						}

						else {
							int nvaeMark = input.mark();
							try {
								input.consume();
								NoViableAltException nvae =
									new NoViableAltException("", 92, 2, input);
								throw nvae;
							} finally {
								input.rewind(nvaeMark);
							}
						}

						}
						break;
					case NUMBER:
						{
						alt92=2;
						}
						break;
					case INDEX:
						{
						alt92=3;
						}
						break;
					default:
						NoViableAltException nvae =
							new NoViableAltException("", 92, 0, input);
						throw nvae;
					}
					switch (alt92) {
						case 1 :
							// cz/vutbr/web/csskit/antlr/CSS.g:974:40: IDENT
							{
							IDENT188=(Token)match(input,IDENT,FOLLOW_IDENT_in_pseudo1832); 
							IDENT188_tree = (Object)adaptor.create(IDENT188);
							adaptor.addChild(root_0, IDENT188_tree);

							}
							break;
						case 2 :
							// cz/vutbr/web/csskit/antlr/CSS.g:974:48: ( MINUS )? NUMBER
							{
							// cz/vutbr/web/csskit/antlr/CSS.g:974:48: ( MINUS )?
							int alt90=2;
							int LA90_0 = input.LA(1);
							if ( (LA90_0==MINUS) ) {
								alt90=1;
							}
							switch (alt90) {
								case 1 :
									// cz/vutbr/web/csskit/antlr/CSS.g:974:48: MINUS
									{
									MINUS189=(Token)match(input,MINUS,FOLLOW_MINUS_in_pseudo1836); 
									MINUS189_tree = (Object)adaptor.create(MINUS189);
									adaptor.addChild(root_0, MINUS189_tree);

									}
									break;

							}

							NUMBER190=(Token)match(input,NUMBER,FOLLOW_NUMBER_in_pseudo1839); 
							NUMBER190_tree = (Object)adaptor.create(NUMBER190);
							adaptor.addChild(root_0, NUMBER190_tree);

							}
							break;
						case 3 :
							// cz/vutbr/web/csskit/antlr/CSS.g:974:64: ( MINUS )? INDEX
							{
							// cz/vutbr/web/csskit/antlr/CSS.g:974:64: ( MINUS )?
							int alt91=2;
							int LA91_0 = input.LA(1);
							if ( (LA91_0==MINUS) ) {
								alt91=1;
							}
							switch (alt91) {
								case 1 :
									// cz/vutbr/web/csskit/antlr/CSS.g:974:64: MINUS
									{
									MINUS191=(Token)match(input,MINUS,FOLLOW_MINUS_in_pseudo1843); 
									MINUS191_tree = (Object)adaptor.create(MINUS191);
									adaptor.addChild(root_0, MINUS191_tree);

									}
									break;

							}

							INDEX192=(Token)match(input,INDEX,FOLLOW_INDEX_in_pseudo1846); 
							INDEX192_tree = (Object)adaptor.create(INDEX192);
							adaptor.addChild(root_0, INDEX192_tree);

							}
							break;

					}

					// cz/vutbr/web/csskit/antlr/CSS.g:974:79: ( S !)*
					loop93:
					while (true) {
						int alt93=2;
						int LA93_0 = input.LA(1);
						if ( (LA93_0==S) ) {
							alt93=1;
						}

						switch (alt93) {
						case 1 :
							// cz/vutbr/web/csskit/antlr/CSS.g:974:79: S !
							{
							S193=(Token)match(input,S,FOLLOW_S_in_pseudo1849); 
							}
							break;

						default :
							break loop93;
						}
					}

					RPAREN194=(Token)match(input,RPAREN,FOLLOW_RPAREN_in_pseudo1853); 
					}
					break;

			}

			}

			retval.stop = input.LT(-1);

			retval.tree = (Object)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {

			     retval.tree = invalidFallback(CSSLexer.INVALID_SELPART, "INVALID_SELPART", re);
			  
		}

		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "pseudo"


	public static class pseudocolon_return extends ParserRuleReturnScope {
		Object tree;
		@Override
		public Object getTree() { return tree; }
	};


	// $ANTLR start "pseudocolon"
	// cz/vutbr/web/csskit/antlr/CSS.g:980:1: pseudocolon : COLON ( COLON )? -> PSEUDO ;
	public final CSSParser.pseudocolon_return pseudocolon() throws RecognitionException {
		CSSParser.pseudocolon_return retval = new CSSParser.pseudocolon_return();
		retval.start = input.LT(1);

		Object root_0 = null;

		Token COLON195=null;
		Token COLON196=null;

		Object COLON195_tree=null;
		Object COLON196_tree=null;
		RewriteRuleTokenStream stream_COLON=new RewriteRuleTokenStream(adaptor,"token COLON");

		try {
			// cz/vutbr/web/csskit/antlr/CSS.g:981:2: ( COLON ( COLON )? -> PSEUDO )
			// cz/vutbr/web/csskit/antlr/CSS.g:981:4: COLON ( COLON )?
			{
			COLON195=(Token)match(input,COLON,FOLLOW_COLON_in_pseudocolon1874);  
			stream_COLON.add(COLON195);

			// cz/vutbr/web/csskit/antlr/CSS.g:981:10: ( COLON )?
			int alt95=2;
			int LA95_0 = input.LA(1);
			if ( (LA95_0==COLON) ) {
				alt95=1;
			}
			switch (alt95) {
				case 1 :
					// cz/vutbr/web/csskit/antlr/CSS.g:981:10: COLON
					{
					COLON196=(Token)match(input,COLON,FOLLOW_COLON_in_pseudocolon1876);  
					stream_COLON.add(COLON196);

					}
					break;

			}

			// AST REWRITE
			// elements: 
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (Object)adaptor.nil();
			// 981:17: -> PSEUDO
			{
				adaptor.addChild(root_0, (Object)adaptor.create(PSEUDO, "PSEUDO"));
			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (Object)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "pseudocolon"


	public static class string_return extends ParserRuleReturnScope {
		Object tree;
		@Override
		public Object getTree() { return tree; }
	};


	// $ANTLR start "string"
	// cz/vutbr/web/csskit/antlr/CSS.g:984:1: string : ( STRING | INVALID_STRING );
	public final CSSParser.string_return string() throws RecognitionException {
		CSSParser.string_return retval = new CSSParser.string_return();
		retval.start = input.LT(1);

		Object root_0 = null;

		Token set197=null;

		Object set197_tree=null;

		try {
			// cz/vutbr/web/csskit/antlr/CSS.g:985:2: ( STRING | INVALID_STRING )
			// cz/vutbr/web/csskit/antlr/CSS.g:
			{
			root_0 = (Object)adaptor.nil();


			set197=input.LT(1);
			if ( input.LA(1)==INVALID_STRING||input.LA(1)==STRING ) {
				input.consume();
				adaptor.addChild(root_0, (Object)adaptor.create(set197));
				state.errorRecovery=false;
			}
			else {
				MismatchedSetException mse = new MismatchedSetException(null,input);
				throw mse;
			}
			}

			retval.stop = input.LT(-1);

			retval.tree = (Object)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "string"


	public static class any_return extends ParserRuleReturnScope {
		Object tree;
		@Override
		public Object getTree() { return tree; }
	};


	// $ANTLR start "any"
	// cz/vutbr/web/csskit/antlr/CSS.g:990:1: any : ( IDENT -> IDENT | CLASSKEYWORD -> CLASSKEYWORD | NUMBER -> NUMBER | PERCENTAGE -> PERCENTAGE | DIMENSION -> DIMENSION | string -> string | URI -> URI | HASH -> HASH | UNIRANGE -> UNIRANGE | INCLUDES -> INCLUDES | COLON -> COLON | COMMA -> COMMA | GREATER -> GREATER | LESS -> LESS | QUESTION -> QUESTION | PERCENT -> PERCENT | EQUALS -> EQUALS | SLASH -> SLASH | EXCLAMATION -> EXCLAMATION | MINUS -> MINUS | PLUS -> PLUS | ASTERISK -> ASTERISK | FUNCTION ( S )* ( any )* RPAREN -> ^( FUNCTION ( any )* ) | DASHMATCH -> DASHMATCH | LPAREN ( any )* RPAREN -> ^( PARENBLOCK ( any )* ) | LBRACE ( any )* RBRACE -> ^( BRACEBLOCK ( any )* ) ) ! ( S )* ;
	public final CSSParser.any_return any() throws RecognitionException {
		CSSParser.any_return retval = new CSSParser.any_return();
		retval.start = input.LT(1);

		Object root_0 = null;

		Token IDENT198=null;
		Token CLASSKEYWORD199=null;
		Token NUMBER200=null;
		Token PERCENTAGE201=null;
		Token DIMENSION202=null;
		Token URI204=null;
		Token HASH205=null;
		Token UNIRANGE206=null;
		Token INCLUDES207=null;
		Token COLON208=null;
		Token COMMA209=null;
		Token GREATER210=null;
		Token LESS211=null;
		Token QUESTION212=null;
		Token PERCENT213=null;
		Token EQUALS214=null;
		Token SLASH215=null;
		Token EXCLAMATION216=null;
		Token MINUS217=null;
		Token PLUS218=null;
		Token ASTERISK219=null;
		Token FUNCTION220=null;
		Token S221=null;
		Token RPAREN223=null;
		Token DASHMATCH224=null;
		Token LPAREN225=null;
		Token RPAREN227=null;
		Token LBRACE228=null;
		Token RBRACE230=null;
		Token S231=null;
		ParserRuleReturnScope string203 =null;
		ParserRuleReturnScope any222 =null;
		ParserRuleReturnScope any226 =null;
		ParserRuleReturnScope any229 =null;

		Object IDENT198_tree=null;
		Object CLASSKEYWORD199_tree=null;
		Object NUMBER200_tree=null;
		Object PERCENTAGE201_tree=null;
		Object DIMENSION202_tree=null;
		Object URI204_tree=null;
		Object HASH205_tree=null;
		Object UNIRANGE206_tree=null;
		Object INCLUDES207_tree=null;
		Object COLON208_tree=null;
		Object COMMA209_tree=null;
		Object GREATER210_tree=null;
		Object LESS211_tree=null;
		Object QUESTION212_tree=null;
		Object PERCENT213_tree=null;
		Object EQUALS214_tree=null;
		Object SLASH215_tree=null;
		Object EXCLAMATION216_tree=null;
		Object MINUS217_tree=null;
		Object PLUS218_tree=null;
		Object ASTERISK219_tree=null;
		Object FUNCTION220_tree=null;
		Object S221_tree=null;
		Object RPAREN223_tree=null;
		Object DASHMATCH224_tree=null;
		Object LPAREN225_tree=null;
		Object RPAREN227_tree=null;
		Object LBRACE228_tree=null;
		Object RBRACE230_tree=null;
		Object S231_tree=null;
		RewriteRuleTokenStream stream_FUNCTION=new RewriteRuleTokenStream(adaptor,"token FUNCTION");
		RewriteRuleTokenStream stream_PERCENT=new RewriteRuleTokenStream(adaptor,"token PERCENT");
		RewriteRuleTokenStream stream_RBRACE=new RewriteRuleTokenStream(adaptor,"token RBRACE");
		RewriteRuleTokenStream stream_CLASSKEYWORD=new RewriteRuleTokenStream(adaptor,"token CLASSKEYWORD");
		RewriteRuleTokenStream stream_LBRACE=new RewriteRuleTokenStream(adaptor,"token LBRACE");
		RewriteRuleTokenStream stream_NUMBER=new RewriteRuleTokenStream(adaptor,"token NUMBER");
		RewriteRuleTokenStream stream_HASH=new RewriteRuleTokenStream(adaptor,"token HASH");
		RewriteRuleTokenStream stream_EQUALS=new RewriteRuleTokenStream(adaptor,"token EQUALS");
		RewriteRuleTokenStream stream_S=new RewriteRuleTokenStream(adaptor,"token S");
		RewriteRuleTokenStream stream_MINUS=new RewriteRuleTokenStream(adaptor,"token MINUS");
		RewriteRuleTokenStream stream_PERCENTAGE=new RewriteRuleTokenStream(adaptor,"token PERCENTAGE");
		RewriteRuleTokenStream stream_LPAREN=new RewriteRuleTokenStream(adaptor,"token LPAREN");
		RewriteRuleTokenStream stream_ASTERISK=new RewriteRuleTokenStream(adaptor,"token ASTERISK");
		RewriteRuleTokenStream stream_URI=new RewriteRuleTokenStream(adaptor,"token URI");
		RewriteRuleTokenStream stream_COLON=new RewriteRuleTokenStream(adaptor,"token COLON");
		RewriteRuleTokenStream stream_INCLUDES=new RewriteRuleTokenStream(adaptor,"token INCLUDES");
		RewriteRuleTokenStream stream_RPAREN=new RewriteRuleTokenStream(adaptor,"token RPAREN");
		RewriteRuleTokenStream stream_GREATER=new RewriteRuleTokenStream(adaptor,"token GREATER");
		RewriteRuleTokenStream stream_SLASH=new RewriteRuleTokenStream(adaptor,"token SLASH");
		RewriteRuleTokenStream stream_DASHMATCH=new RewriteRuleTokenStream(adaptor,"token DASHMATCH");
		RewriteRuleTokenStream stream_QUESTION=new RewriteRuleTokenStream(adaptor,"token QUESTION");
		RewriteRuleTokenStream stream_EXCLAMATION=new RewriteRuleTokenStream(adaptor,"token EXCLAMATION");
		RewriteRuleTokenStream stream_COMMA=new RewriteRuleTokenStream(adaptor,"token COMMA");
		RewriteRuleTokenStream stream_LESS=new RewriteRuleTokenStream(adaptor,"token LESS");
		RewriteRuleTokenStream stream_IDENT=new RewriteRuleTokenStream(adaptor,"token IDENT");
		RewriteRuleTokenStream stream_PLUS=new RewriteRuleTokenStream(adaptor,"token PLUS");
		RewriteRuleTokenStream stream_DIMENSION=new RewriteRuleTokenStream(adaptor,"token DIMENSION");
		RewriteRuleTokenStream stream_UNIRANGE=new RewriteRuleTokenStream(adaptor,"token UNIRANGE");
		RewriteRuleSubtreeStream stream_string=new RewriteRuleSubtreeStream(adaptor,"rule string");
		RewriteRuleSubtreeStream stream_any=new RewriteRuleSubtreeStream(adaptor,"rule any");

		try {
			// cz/vutbr/web/csskit/antlr/CSS.g:991:2: ( ( IDENT -> IDENT | CLASSKEYWORD -> CLASSKEYWORD | NUMBER -> NUMBER | PERCENTAGE -> PERCENTAGE | DIMENSION -> DIMENSION | string -> string | URI -> URI | HASH -> HASH | UNIRANGE -> UNIRANGE | INCLUDES -> INCLUDES | COLON -> COLON | COMMA -> COMMA | GREATER -> GREATER | LESS -> LESS | QUESTION -> QUESTION | PERCENT -> PERCENT | EQUALS -> EQUALS | SLASH -> SLASH | EXCLAMATION -> EXCLAMATION | MINUS -> MINUS | PLUS -> PLUS | ASTERISK -> ASTERISK | FUNCTION ( S )* ( any )* RPAREN -> ^( FUNCTION ( any )* ) | DASHMATCH -> DASHMATCH | LPAREN ( any )* RPAREN -> ^( PARENBLOCK ( any )* ) | LBRACE ( any )* RBRACE -> ^( BRACEBLOCK ( any )* ) ) ! ( S )* )
			// cz/vutbr/web/csskit/antlr/CSS.g:991:4: ( IDENT -> IDENT | CLASSKEYWORD -> CLASSKEYWORD | NUMBER -> NUMBER | PERCENTAGE -> PERCENTAGE | DIMENSION -> DIMENSION | string -> string | URI -> URI | HASH -> HASH | UNIRANGE -> UNIRANGE | INCLUDES -> INCLUDES | COLON -> COLON | COMMA -> COMMA | GREATER -> GREATER | LESS -> LESS | QUESTION -> QUESTION | PERCENT -> PERCENT | EQUALS -> EQUALS | SLASH -> SLASH | EXCLAMATION -> EXCLAMATION | MINUS -> MINUS | PLUS -> PLUS | ASTERISK -> ASTERISK | FUNCTION ( S )* ( any )* RPAREN -> ^( FUNCTION ( any )* ) | DASHMATCH -> DASHMATCH | LPAREN ( any )* RPAREN -> ^( PARENBLOCK ( any )* ) | LBRACE ( any )* RBRACE -> ^( BRACEBLOCK ( any )* ) ) ! ( S )*
			{
			// cz/vutbr/web/csskit/antlr/CSS.g:991:4: ( IDENT -> IDENT | CLASSKEYWORD -> CLASSKEYWORD | NUMBER -> NUMBER | PERCENTAGE -> PERCENTAGE | DIMENSION -> DIMENSION | string -> string | URI -> URI | HASH -> HASH | UNIRANGE -> UNIRANGE | INCLUDES -> INCLUDES | COLON -> COLON | COMMA -> COMMA | GREATER -> GREATER | LESS -> LESS | QUESTION -> QUESTION | PERCENT -> PERCENT | EQUALS -> EQUALS | SLASH -> SLASH | EXCLAMATION -> EXCLAMATION | MINUS -> MINUS | PLUS -> PLUS | ASTERISK -> ASTERISK | FUNCTION ( S )* ( any )* RPAREN -> ^( FUNCTION ( any )* ) | DASHMATCH -> DASHMATCH | LPAREN ( any )* RPAREN -> ^( PARENBLOCK ( any )* ) | LBRACE ( any )* RBRACE -> ^( BRACEBLOCK ( any )* ) )
			int alt100=26;
			switch ( input.LA(1) ) {
			case IDENT:
				{
				alt100=1;
				}
				break;
			case CLASSKEYWORD:
				{
				alt100=2;
				}
				break;
			case NUMBER:
				{
				alt100=3;
				}
				break;
			case PERCENTAGE:
				{
				alt100=4;
				}
				break;
			case DIMENSION:
				{
				alt100=5;
				}
				break;
			case INVALID_STRING:
			case STRING:
				{
				alt100=6;
				}
				break;
			case URI:
				{
				alt100=7;
				}
				break;
			case HASH:
				{
				alt100=8;
				}
				break;
			case UNIRANGE:
				{
				alt100=9;
				}
				break;
			case INCLUDES:
				{
				alt100=10;
				}
				break;
			case COLON:
				{
				alt100=11;
				}
				break;
			case COMMA:
				{
				alt100=12;
				}
				break;
			case GREATER:
				{
				alt100=13;
				}
				break;
			case LESS:
				{
				alt100=14;
				}
				break;
			case QUESTION:
				{
				alt100=15;
				}
				break;
			case PERCENT:
				{
				alt100=16;
				}
				break;
			case EQUALS:
				{
				alt100=17;
				}
				break;
			case SLASH:
				{
				alt100=18;
				}
				break;
			case EXCLAMATION:
				{
				alt100=19;
				}
				break;
			case MINUS:
				{
				alt100=20;
				}
				break;
			case PLUS:
				{
				alt100=21;
				}
				break;
			case ASTERISK:
				{
				alt100=22;
				}
				break;
			case FUNCTION:
				{
				alt100=23;
				}
				break;
			case DASHMATCH:
				{
				alt100=24;
				}
				break;
			case LPAREN:
				{
				alt100=25;
				}
				break;
			case LBRACE:
				{
				alt100=26;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 100, 0, input);
				throw nvae;
			}
			switch (alt100) {
				case 1 :
					// cz/vutbr/web/csskit/antlr/CSS.g:991:6: IDENT
					{
					IDENT198=(Token)match(input,IDENT,FOLLOW_IDENT_in_any1913);  
					stream_IDENT.add(IDENT198);

					// AST REWRITE
					// elements: IDENT
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (Object)adaptor.nil();
					// 991:12: -> IDENT
					{
						adaptor.addChild(root_0, stream_IDENT.nextNode());
					}


					retval.tree = root_0;

					}
					break;
				case 2 :
					// cz/vutbr/web/csskit/antlr/CSS.g:992:6: CLASSKEYWORD
					{
					CLASSKEYWORD199=(Token)match(input,CLASSKEYWORD,FOLLOW_CLASSKEYWORD_in_any1924);  
					stream_CLASSKEYWORD.add(CLASSKEYWORD199);

					// AST REWRITE
					// elements: CLASSKEYWORD
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (Object)adaptor.nil();
					// 992:19: -> CLASSKEYWORD
					{
						adaptor.addChild(root_0, stream_CLASSKEYWORD.nextNode());
					}


					retval.tree = root_0;

					}
					break;
				case 3 :
					// cz/vutbr/web/csskit/antlr/CSS.g:993:6: NUMBER
					{
					NUMBER200=(Token)match(input,NUMBER,FOLLOW_NUMBER_in_any1935);  
					stream_NUMBER.add(NUMBER200);

					// AST REWRITE
					// elements: NUMBER
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (Object)adaptor.nil();
					// 993:13: -> NUMBER
					{
						adaptor.addChild(root_0, stream_NUMBER.nextNode());
					}


					retval.tree = root_0;

					}
					break;
				case 4 :
					// cz/vutbr/web/csskit/antlr/CSS.g:994:6: PERCENTAGE
					{
					PERCENTAGE201=(Token)match(input,PERCENTAGE,FOLLOW_PERCENTAGE_in_any1946);  
					stream_PERCENTAGE.add(PERCENTAGE201);

					// AST REWRITE
					// elements: PERCENTAGE
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (Object)adaptor.nil();
					// 994:17: -> PERCENTAGE
					{
						adaptor.addChild(root_0, stream_PERCENTAGE.nextNode());
					}


					retval.tree = root_0;

					}
					break;
				case 5 :
					// cz/vutbr/web/csskit/antlr/CSS.g:995:6: DIMENSION
					{
					DIMENSION202=(Token)match(input,DIMENSION,FOLLOW_DIMENSION_in_any1956);  
					stream_DIMENSION.add(DIMENSION202);

					// AST REWRITE
					// elements: DIMENSION
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (Object)adaptor.nil();
					// 995:16: -> DIMENSION
					{
						adaptor.addChild(root_0, stream_DIMENSION.nextNode());
					}


					retval.tree = root_0;

					}
					break;
				case 6 :
					// cz/vutbr/web/csskit/antlr/CSS.g:996:6: string
					{
					pushFollow(FOLLOW_string_in_any1967);
					string203=string();
					state._fsp--;

					stream_string.add(string203.getTree());
					// AST REWRITE
					// elements: string
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (Object)adaptor.nil();
					// 996:13: -> string
					{
						adaptor.addChild(root_0, stream_string.nextTree());
					}


					retval.tree = root_0;

					}
					break;
				case 7 :
					// cz/vutbr/web/csskit/antlr/CSS.g:997:9: URI
					{
					URI204=(Token)match(input,URI,FOLLOW_URI_in_any1981);  
					stream_URI.add(URI204);

					// AST REWRITE
					// elements: URI
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (Object)adaptor.nil();
					// 997:16: -> URI
					{
						adaptor.addChild(root_0, stream_URI.nextNode());
					}


					retval.tree = root_0;

					}
					break;
				case 8 :
					// cz/vutbr/web/csskit/antlr/CSS.g:998:9: HASH
					{
					HASH205=(Token)match(input,HASH,FOLLOW_HASH_in_any1998);  
					stream_HASH.add(HASH205);

					// AST REWRITE
					// elements: HASH
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (Object)adaptor.nil();
					// 998:14: -> HASH
					{
						adaptor.addChild(root_0, stream_HASH.nextNode());
					}


					retval.tree = root_0;

					}
					break;
				case 9 :
					// cz/vutbr/web/csskit/antlr/CSS.g:999:9: UNIRANGE
					{
					UNIRANGE206=(Token)match(input,UNIRANGE,FOLLOW_UNIRANGE_in_any2012);  
					stream_UNIRANGE.add(UNIRANGE206);

					// AST REWRITE
					// elements: UNIRANGE
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (Object)adaptor.nil();
					// 999:18: -> UNIRANGE
					{
						adaptor.addChild(root_0, stream_UNIRANGE.nextNode());
					}


					retval.tree = root_0;

					}
					break;
				case 10 :
					// cz/vutbr/web/csskit/antlr/CSS.g:1000:9: INCLUDES
					{
					INCLUDES207=(Token)match(input,INCLUDES,FOLLOW_INCLUDES_in_any2026);  
					stream_INCLUDES.add(INCLUDES207);

					// AST REWRITE
					// elements: INCLUDES
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (Object)adaptor.nil();
					// 1000:18: -> INCLUDES
					{
						adaptor.addChild(root_0, stream_INCLUDES.nextNode());
					}


					retval.tree = root_0;

					}
					break;
				case 11 :
					// cz/vutbr/web/csskit/antlr/CSS.g:1001:9: COLON
					{
					COLON208=(Token)match(input,COLON,FOLLOW_COLON_in_any2040);  
					stream_COLON.add(COLON208);

					// AST REWRITE
					// elements: COLON
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (Object)adaptor.nil();
					// 1001:15: -> COLON
					{
						adaptor.addChild(root_0, stream_COLON.nextNode());
					}


					retval.tree = root_0;

					}
					break;
				case 12 :
					// cz/vutbr/web/csskit/antlr/CSS.g:1002:9: COMMA
					{
					COMMA209=(Token)match(input,COMMA,FOLLOW_COMMA_in_any2054);  
					stream_COMMA.add(COMMA209);

					// AST REWRITE
					// elements: COMMA
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (Object)adaptor.nil();
					// 1002:15: -> COMMA
					{
						adaptor.addChild(root_0, stream_COMMA.nextNode());
					}


					retval.tree = root_0;

					}
					break;
				case 13 :
					// cz/vutbr/web/csskit/antlr/CSS.g:1003:9: GREATER
					{
					GREATER210=(Token)match(input,GREATER,FOLLOW_GREATER_in_any2068);  
					stream_GREATER.add(GREATER210);

					// AST REWRITE
					// elements: GREATER
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (Object)adaptor.nil();
					// 1003:17: -> GREATER
					{
						adaptor.addChild(root_0, stream_GREATER.nextNode());
					}


					retval.tree = root_0;

					}
					break;
				case 14 :
					// cz/vutbr/web/csskit/antlr/CSS.g:1004:9: LESS
					{
					LESS211=(Token)match(input,LESS,FOLLOW_LESS_in_any2082);  
					stream_LESS.add(LESS211);

					// AST REWRITE
					// elements: LESS
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (Object)adaptor.nil();
					// 1004:14: -> LESS
					{
						adaptor.addChild(root_0, stream_LESS.nextNode());
					}


					retval.tree = root_0;

					}
					break;
				case 15 :
					// cz/vutbr/web/csskit/antlr/CSS.g:1005:9: QUESTION
					{
					QUESTION212=(Token)match(input,QUESTION,FOLLOW_QUESTION_in_any2096);  
					stream_QUESTION.add(QUESTION212);

					// AST REWRITE
					// elements: QUESTION
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (Object)adaptor.nil();
					// 1005:18: -> QUESTION
					{
						adaptor.addChild(root_0, stream_QUESTION.nextNode());
					}


					retval.tree = root_0;

					}
					break;
				case 16 :
					// cz/vutbr/web/csskit/antlr/CSS.g:1006:9: PERCENT
					{
					PERCENT213=(Token)match(input,PERCENT,FOLLOW_PERCENT_in_any2110);  
					stream_PERCENT.add(PERCENT213);

					// AST REWRITE
					// elements: PERCENT
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (Object)adaptor.nil();
					// 1006:17: -> PERCENT
					{
						adaptor.addChild(root_0, stream_PERCENT.nextNode());
					}


					retval.tree = root_0;

					}
					break;
				case 17 :
					// cz/vutbr/web/csskit/antlr/CSS.g:1007:9: EQUALS
					{
					EQUALS214=(Token)match(input,EQUALS,FOLLOW_EQUALS_in_any2124);  
					stream_EQUALS.add(EQUALS214);

					// AST REWRITE
					// elements: EQUALS
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (Object)adaptor.nil();
					// 1007:16: -> EQUALS
					{
						adaptor.addChild(root_0, stream_EQUALS.nextNode());
					}


					retval.tree = root_0;

					}
					break;
				case 18 :
					// cz/vutbr/web/csskit/antlr/CSS.g:1008:9: SLASH
					{
					SLASH215=(Token)match(input,SLASH,FOLLOW_SLASH_in_any2138);  
					stream_SLASH.add(SLASH215);

					// AST REWRITE
					// elements: SLASH
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (Object)adaptor.nil();
					// 1008:15: -> SLASH
					{
						adaptor.addChild(root_0, stream_SLASH.nextNode());
					}


					retval.tree = root_0;

					}
					break;
				case 19 :
					// cz/vutbr/web/csskit/antlr/CSS.g:1009:9: EXCLAMATION
					{
					EXCLAMATION216=(Token)match(input,EXCLAMATION,FOLLOW_EXCLAMATION_in_any2152);  
					stream_EXCLAMATION.add(EXCLAMATION216);

					// AST REWRITE
					// elements: EXCLAMATION
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (Object)adaptor.nil();
					// 1009:21: -> EXCLAMATION
					{
						adaptor.addChild(root_0, stream_EXCLAMATION.nextNode());
					}


					retval.tree = root_0;

					}
					break;
				case 20 :
					// cz/vutbr/web/csskit/antlr/CSS.g:1010:6: MINUS
					{
					MINUS217=(Token)match(input,MINUS,FOLLOW_MINUS_in_any2163);  
					stream_MINUS.add(MINUS217);

					// AST REWRITE
					// elements: MINUS
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (Object)adaptor.nil();
					// 1010:12: -> MINUS
					{
						adaptor.addChild(root_0, stream_MINUS.nextNode());
					}


					retval.tree = root_0;

					}
					break;
				case 21 :
					// cz/vutbr/web/csskit/antlr/CSS.g:1011:6: PLUS
					{
					PLUS218=(Token)match(input,PLUS,FOLLOW_PLUS_in_any2174);  
					stream_PLUS.add(PLUS218);

					// AST REWRITE
					// elements: PLUS
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (Object)adaptor.nil();
					// 1011:11: -> PLUS
					{
						adaptor.addChild(root_0, stream_PLUS.nextNode());
					}


					retval.tree = root_0;

					}
					break;
				case 22 :
					// cz/vutbr/web/csskit/antlr/CSS.g:1012:6: ASTERISK
					{
					ASTERISK219=(Token)match(input,ASTERISK,FOLLOW_ASTERISK_in_any2185);  
					stream_ASTERISK.add(ASTERISK219);

					// AST REWRITE
					// elements: ASTERISK
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (Object)adaptor.nil();
					// 1012:15: -> ASTERISK
					{
						adaptor.addChild(root_0, stream_ASTERISK.nextNode());
					}


					retval.tree = root_0;

					}
					break;
				case 23 :
					// cz/vutbr/web/csskit/antlr/CSS.g:1013:9: FUNCTION ( S )* ( any )* RPAREN
					{
					FUNCTION220=(Token)match(input,FUNCTION,FOLLOW_FUNCTION_in_any2202);  
					stream_FUNCTION.add(FUNCTION220);

					// cz/vutbr/web/csskit/antlr/CSS.g:1013:18: ( S )*
					loop96:
					while (true) {
						int alt96=2;
						int LA96_0 = input.LA(1);
						if ( (LA96_0==S) ) {
							alt96=1;
						}

						switch (alt96) {
						case 1 :
							// cz/vutbr/web/csskit/antlr/CSS.g:1013:18: S
							{
							S221=(Token)match(input,S,FOLLOW_S_in_any2204);  
							stream_S.add(S221);

							}
							break;

						default :
							break loop96;
						}
					}

					// cz/vutbr/web/csskit/antlr/CSS.g:1013:21: ( any )*
					loop97:
					while (true) {
						int alt97=2;
						int LA97_0 = input.LA(1);
						if ( (LA97_0==ASTERISK||(LA97_0 >= CLASSKEYWORD && LA97_0 <= COMMA)||LA97_0==DASHMATCH||LA97_0==DIMENSION||LA97_0==EQUALS||LA97_0==EXCLAMATION||(LA97_0 >= FUNCTION && LA97_0 <= IDENT)||LA97_0==INCLUDES||LA97_0==INVALID_STRING||LA97_0==LBRACE||(LA97_0 >= LESS && LA97_0 <= LPAREN)||LA97_0==MINUS||LA97_0==NUMBER||(LA97_0 >= PERCENT && LA97_0 <= PLUS)||LA97_0==QUESTION||LA97_0==SLASH||LA97_0==STRING||(LA97_0 >= UNIRANGE && LA97_0 <= URI)) ) {
							alt97=1;
						}

						switch (alt97) {
						case 1 :
							// cz/vutbr/web/csskit/antlr/CSS.g:1013:21: any
							{
							pushFollow(FOLLOW_any_in_any2207);
							any222=any();
							state._fsp--;

							stream_any.add(any222.getTree());
							}
							break;

						default :
							break loop97;
						}
					}

					RPAREN223=(Token)match(input,RPAREN,FOLLOW_RPAREN_in_any2210);  
					stream_RPAREN.add(RPAREN223);

					// AST REWRITE
					// elements: FUNCTION, any
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (Object)adaptor.nil();
					// 1013:33: -> ^( FUNCTION ( any )* )
					{
						// cz/vutbr/web/csskit/antlr/CSS.g:1013:36: ^( FUNCTION ( any )* )
						{
						Object root_1 = (Object)adaptor.nil();
						root_1 = (Object)adaptor.becomeRoot(stream_FUNCTION.nextNode(), root_1);
						// cz/vutbr/web/csskit/antlr/CSS.g:1013:47: ( any )*
						while ( stream_any.hasNext() ) {
							adaptor.addChild(root_1, stream_any.nextTree());
						}
						stream_any.reset();

						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;
				case 24 :
					// cz/vutbr/web/csskit/antlr/CSS.g:1014:9: DASHMATCH
					{
					DASHMATCH224=(Token)match(input,DASHMATCH,FOLLOW_DASHMATCH_in_any2230);  
					stream_DASHMATCH.add(DASHMATCH224);

					// AST REWRITE
					// elements: DASHMATCH
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (Object)adaptor.nil();
					// 1014:19: -> DASHMATCH
					{
						adaptor.addChild(root_0, stream_DASHMATCH.nextNode());
					}


					retval.tree = root_0;

					}
					break;
				case 25 :
					// cz/vutbr/web/csskit/antlr/CSS.g:1015:9: LPAREN ( any )* RPAREN
					{
					LPAREN225=(Token)match(input,LPAREN,FOLLOW_LPAREN_in_any2244);  
					stream_LPAREN.add(LPAREN225);

					// cz/vutbr/web/csskit/antlr/CSS.g:1015:16: ( any )*
					loop98:
					while (true) {
						int alt98=2;
						int LA98_0 = input.LA(1);
						if ( (LA98_0==ASTERISK||(LA98_0 >= CLASSKEYWORD && LA98_0 <= COMMA)||LA98_0==DASHMATCH||LA98_0==DIMENSION||LA98_0==EQUALS||LA98_0==EXCLAMATION||(LA98_0 >= FUNCTION && LA98_0 <= IDENT)||LA98_0==INCLUDES||LA98_0==INVALID_STRING||LA98_0==LBRACE||(LA98_0 >= LESS && LA98_0 <= LPAREN)||LA98_0==MINUS||LA98_0==NUMBER||(LA98_0 >= PERCENT && LA98_0 <= PLUS)||LA98_0==QUESTION||LA98_0==SLASH||LA98_0==STRING||(LA98_0 >= UNIRANGE && LA98_0 <= URI)) ) {
							alt98=1;
						}

						switch (alt98) {
						case 1 :
							// cz/vutbr/web/csskit/antlr/CSS.g:1015:16: any
							{
							pushFollow(FOLLOW_any_in_any2246);
							any226=any();
							state._fsp--;

							stream_any.add(any226.getTree());
							}
							break;

						default :
							break loop98;
						}
					}

					RPAREN227=(Token)match(input,RPAREN,FOLLOW_RPAREN_in_any2249);  
					stream_RPAREN.add(RPAREN227);

					// AST REWRITE
					// elements: any
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (Object)adaptor.nil();
					// 1015:28: -> ^( PARENBLOCK ( any )* )
					{
						// cz/vutbr/web/csskit/antlr/CSS.g:1015:31: ^( PARENBLOCK ( any )* )
						{
						Object root_1 = (Object)adaptor.nil();
						root_1 = (Object)adaptor.becomeRoot((Object)adaptor.create(PARENBLOCK, "PARENBLOCK"), root_1);
						// cz/vutbr/web/csskit/antlr/CSS.g:1015:44: ( any )*
						while ( stream_any.hasNext() ) {
							adaptor.addChild(root_1, stream_any.nextTree());
						}
						stream_any.reset();

						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;
				case 26 :
					// cz/vutbr/web/csskit/antlr/CSS.g:1016:9: LBRACE ( any )* RBRACE
					{
					LBRACE228=(Token)match(input,LBRACE,FOLLOW_LBRACE_in_any2268);  
					stream_LBRACE.add(LBRACE228);

					// cz/vutbr/web/csskit/antlr/CSS.g:1016:16: ( any )*
					loop99:
					while (true) {
						int alt99=2;
						int LA99_0 = input.LA(1);
						if ( (LA99_0==ASTERISK||(LA99_0 >= CLASSKEYWORD && LA99_0 <= COMMA)||LA99_0==DASHMATCH||LA99_0==DIMENSION||LA99_0==EQUALS||LA99_0==EXCLAMATION||(LA99_0 >= FUNCTION && LA99_0 <= IDENT)||LA99_0==INCLUDES||LA99_0==INVALID_STRING||LA99_0==LBRACE||(LA99_0 >= LESS && LA99_0 <= LPAREN)||LA99_0==MINUS||LA99_0==NUMBER||(LA99_0 >= PERCENT && LA99_0 <= PLUS)||LA99_0==QUESTION||LA99_0==SLASH||LA99_0==STRING||(LA99_0 >= UNIRANGE && LA99_0 <= URI)) ) {
							alt99=1;
						}

						switch (alt99) {
						case 1 :
							// cz/vutbr/web/csskit/antlr/CSS.g:1016:16: any
							{
							pushFollow(FOLLOW_any_in_any2270);
							any229=any();
							state._fsp--;

							stream_any.add(any229.getTree());
							}
							break;

						default :
							break loop99;
						}
					}

					RBRACE230=(Token)match(input,RBRACE,FOLLOW_RBRACE_in_any2273);  
					stream_RBRACE.add(RBRACE230);

					// AST REWRITE
					// elements: any
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (Object)adaptor.nil();
					// 1016:28: -> ^( BRACEBLOCK ( any )* )
					{
						// cz/vutbr/web/csskit/antlr/CSS.g:1016:31: ^( BRACEBLOCK ( any )* )
						{
						Object root_1 = (Object)adaptor.nil();
						root_1 = (Object)adaptor.becomeRoot((Object)adaptor.create(BRACEBLOCK, "BRACEBLOCK"), root_1);
						// cz/vutbr/web/csskit/antlr/CSS.g:1016:44: ( any )*
						while ( stream_any.hasNext() ) {
							adaptor.addChild(root_1, stream_any.nextTree());
						}
						stream_any.reset();

						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;

			}

			// cz/vutbr/web/csskit/antlr/CSS.g:1017:8: ( S )*
			loop101:
			while (true) {
				int alt101=2;
				int LA101_0 = input.LA(1);
				if ( (LA101_0==S) ) {
					alt101=1;
				}

				switch (alt101) {
				case 1 :
					// cz/vutbr/web/csskit/antlr/CSS.g:1017:8: S
					{
					S231=(Token)match(input,S,FOLLOW_S_in_any2291);  
					stream_S.add(S231);

					}
					break;

				default :
					break loop101;
				}
			}

			}

			retval.stop = input.LT(-1);

			retval.tree = (Object)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "any"


	public static class nostatement_return extends ParserRuleReturnScope {
		Object tree;
		@Override
		public Object getTree() { return tree; }
	};


	// $ANTLR start "nostatement"
	// cz/vutbr/web/csskit/antlr/CSS.g:1020:1: nostatement : ( RCURLY -> RCURLY | SEMICOLON -> SEMICOLON | QUOT -> QUOT | APOS -> APOS ) ;
	public final CSSParser.nostatement_return nostatement() throws RecognitionException {
		CSSParser.nostatement_return retval = new CSSParser.nostatement_return();
		retval.start = input.LT(1);

		Object root_0 = null;

		Token RCURLY232=null;
		Token SEMICOLON233=null;
		Token QUOT234=null;
		Token APOS235=null;

		Object RCURLY232_tree=null;
		Object SEMICOLON233_tree=null;
		Object QUOT234_tree=null;
		Object APOS235_tree=null;
		RewriteRuleTokenStream stream_APOS=new RewriteRuleTokenStream(adaptor,"token APOS");
		RewriteRuleTokenStream stream_SEMICOLON=new RewriteRuleTokenStream(adaptor,"token SEMICOLON");
		RewriteRuleTokenStream stream_RCURLY=new RewriteRuleTokenStream(adaptor,"token RCURLY");
		RewriteRuleTokenStream stream_QUOT=new RewriteRuleTokenStream(adaptor,"token QUOT");

		try {
			// cz/vutbr/web/csskit/antlr/CSS.g:1021:3: ( ( RCURLY -> RCURLY | SEMICOLON -> SEMICOLON | QUOT -> QUOT | APOS -> APOS ) )
			// cz/vutbr/web/csskit/antlr/CSS.g:1021:5: ( RCURLY -> RCURLY | SEMICOLON -> SEMICOLON | QUOT -> QUOT | APOS -> APOS )
			{
			// cz/vutbr/web/csskit/antlr/CSS.g:1021:5: ( RCURLY -> RCURLY | SEMICOLON -> SEMICOLON | QUOT -> QUOT | APOS -> APOS )
			int alt102=4;
			switch ( input.LA(1) ) {
			case RCURLY:
				{
				alt102=1;
				}
				break;
			case SEMICOLON:
				{
				alt102=2;
				}
				break;
			case QUOT:
				{
				alt102=3;
				}
				break;
			case APOS:
				{
				alt102=4;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 102, 0, input);
				throw nvae;
			}
			switch (alt102) {
				case 1 :
					// cz/vutbr/web/csskit/antlr/CSS.g:1021:7: RCURLY
					{
					RCURLY232=(Token)match(input,RCURLY,FOLLOW_RCURLY_in_nostatement2306);  
					stream_RCURLY.add(RCURLY232);

					// AST REWRITE
					// elements: RCURLY
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (Object)adaptor.nil();
					// 1021:14: -> RCURLY
					{
						adaptor.addChild(root_0, stream_RCURLY.nextNode());
					}


					retval.tree = root_0;

					}
					break;
				case 2 :
					// cz/vutbr/web/csskit/antlr/CSS.g:1022:9: SEMICOLON
					{
					SEMICOLON233=(Token)match(input,SEMICOLON,FOLLOW_SEMICOLON_in_nostatement2320);  
					stream_SEMICOLON.add(SEMICOLON233);

					// AST REWRITE
					// elements: SEMICOLON
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (Object)adaptor.nil();
					// 1022:19: -> SEMICOLON
					{
						adaptor.addChild(root_0, stream_SEMICOLON.nextNode());
					}


					retval.tree = root_0;

					}
					break;
				case 3 :
					// cz/vutbr/web/csskit/antlr/CSS.g:1023:9: QUOT
					{
					QUOT234=(Token)match(input,QUOT,FOLLOW_QUOT_in_nostatement2334);  
					stream_QUOT.add(QUOT234);

					// AST REWRITE
					// elements: QUOT
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (Object)adaptor.nil();
					// 1023:14: -> QUOT
					{
						adaptor.addChild(root_0, stream_QUOT.nextNode());
					}


					retval.tree = root_0;

					}
					break;
				case 4 :
					// cz/vutbr/web/csskit/antlr/CSS.g:1024:9: APOS
					{
					APOS235=(Token)match(input,APOS,FOLLOW_APOS_in_nostatement2348);  
					stream_APOS.add(APOS235);

					// AST REWRITE
					// elements: APOS
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (Object)adaptor.nil();
					// 1024:14: -> APOS
					{
						adaptor.addChild(root_0, stream_APOS.nextNode());
					}


					retval.tree = root_0;

					}
					break;

			}

			}

			retval.stop = input.LT(-1);

			retval.tree = (Object)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "nostatement"


	public static class noprop_return extends ParserRuleReturnScope {
		Object tree;
		@Override
		public Object getTree() { return tree; }
	};


	// $ANTLR start "noprop"
	// cz/vutbr/web/csskit/antlr/CSS.g:1028:1: noprop : ( CLASSKEYWORD -> CLASSKEYWORD | NUMBER -> NUMBER | COMMA -> COMMA | GREATER -> GREATER | LESS -> LESS | QUESTION -> QUESTION | PERCENT -> PERCENT | EQUALS -> EQUALS | SLASH -> SLASH | EXCLAMATION -> EXCLAMATION | PLUS -> PLUS | ASTERISK -> ASTERISK | DASHMATCH -> DASHMATCH | INCLUDES -> INCLUDES | COLON -> COLON | STRING_CHAR -> STRING_CHAR | CTRL -> CTRL | INVALID_TOKEN -> INVALID_TOKEN ) ! ( S )* ;
	public final CSSParser.noprop_return noprop() throws RecognitionException {
		CSSParser.noprop_return retval = new CSSParser.noprop_return();
		retval.start = input.LT(1);

		Object root_0 = null;

		Token CLASSKEYWORD236=null;
		Token NUMBER237=null;
		Token COMMA238=null;
		Token GREATER239=null;
		Token LESS240=null;
		Token QUESTION241=null;
		Token PERCENT242=null;
		Token EQUALS243=null;
		Token SLASH244=null;
		Token EXCLAMATION245=null;
		Token PLUS246=null;
		Token ASTERISK247=null;
		Token DASHMATCH248=null;
		Token INCLUDES249=null;
		Token COLON250=null;
		Token STRING_CHAR251=null;
		Token CTRL252=null;
		Token INVALID_TOKEN253=null;
		Token S254=null;

		Object CLASSKEYWORD236_tree=null;
		Object NUMBER237_tree=null;
		Object COMMA238_tree=null;
		Object GREATER239_tree=null;
		Object LESS240_tree=null;
		Object QUESTION241_tree=null;
		Object PERCENT242_tree=null;
		Object EQUALS243_tree=null;
		Object SLASH244_tree=null;
		Object EXCLAMATION245_tree=null;
		Object PLUS246_tree=null;
		Object ASTERISK247_tree=null;
		Object DASHMATCH248_tree=null;
		Object INCLUDES249_tree=null;
		Object COLON250_tree=null;
		Object STRING_CHAR251_tree=null;
		Object CTRL252_tree=null;
		Object INVALID_TOKEN253_tree=null;
		Object S254_tree=null;
		RewriteRuleTokenStream stream_COLON=new RewriteRuleTokenStream(adaptor,"token COLON");
		RewriteRuleTokenStream stream_INCLUDES=new RewriteRuleTokenStream(adaptor,"token INCLUDES");
		RewriteRuleTokenStream stream_STRING_CHAR=new RewriteRuleTokenStream(adaptor,"token STRING_CHAR");
		RewriteRuleTokenStream stream_GREATER=new RewriteRuleTokenStream(adaptor,"token GREATER");
		RewriteRuleTokenStream stream_SLASH=new RewriteRuleTokenStream(adaptor,"token SLASH");
		RewriteRuleTokenStream stream_DASHMATCH=new RewriteRuleTokenStream(adaptor,"token DASHMATCH");
		RewriteRuleTokenStream stream_QUESTION=new RewriteRuleTokenStream(adaptor,"token QUESTION");
		RewriteRuleTokenStream stream_PERCENT=new RewriteRuleTokenStream(adaptor,"token PERCENT");
		RewriteRuleTokenStream stream_EXCLAMATION=new RewriteRuleTokenStream(adaptor,"token EXCLAMATION");
		RewriteRuleTokenStream stream_COMMA=new RewriteRuleTokenStream(adaptor,"token COMMA");
		RewriteRuleTokenStream stream_CLASSKEYWORD=new RewriteRuleTokenStream(adaptor,"token CLASSKEYWORD");
		RewriteRuleTokenStream stream_LESS=new RewriteRuleTokenStream(adaptor,"token LESS");
		RewriteRuleTokenStream stream_NUMBER=new RewriteRuleTokenStream(adaptor,"token NUMBER");
		RewriteRuleTokenStream stream_INVALID_TOKEN=new RewriteRuleTokenStream(adaptor,"token INVALID_TOKEN");
		RewriteRuleTokenStream stream_PLUS=new RewriteRuleTokenStream(adaptor,"token PLUS");
		RewriteRuleTokenStream stream_EQUALS=new RewriteRuleTokenStream(adaptor,"token EQUALS");
		RewriteRuleTokenStream stream_S=new RewriteRuleTokenStream(adaptor,"token S");
		RewriteRuleTokenStream stream_ASTERISK=new RewriteRuleTokenStream(adaptor,"token ASTERISK");
		RewriteRuleTokenStream stream_CTRL=new RewriteRuleTokenStream(adaptor,"token CTRL");

		try {
			// cz/vutbr/web/csskit/antlr/CSS.g:1029:2: ( ( CLASSKEYWORD -> CLASSKEYWORD | NUMBER -> NUMBER | COMMA -> COMMA | GREATER -> GREATER | LESS -> LESS | QUESTION -> QUESTION | PERCENT -> PERCENT | EQUALS -> EQUALS | SLASH -> SLASH | EXCLAMATION -> EXCLAMATION | PLUS -> PLUS | ASTERISK -> ASTERISK | DASHMATCH -> DASHMATCH | INCLUDES -> INCLUDES | COLON -> COLON | STRING_CHAR -> STRING_CHAR | CTRL -> CTRL | INVALID_TOKEN -> INVALID_TOKEN ) ! ( S )* )
			// cz/vutbr/web/csskit/antlr/CSS.g:1029:4: ( CLASSKEYWORD -> CLASSKEYWORD | NUMBER -> NUMBER | COMMA -> COMMA | GREATER -> GREATER | LESS -> LESS | QUESTION -> QUESTION | PERCENT -> PERCENT | EQUALS -> EQUALS | SLASH -> SLASH | EXCLAMATION -> EXCLAMATION | PLUS -> PLUS | ASTERISK -> ASTERISK | DASHMATCH -> DASHMATCH | INCLUDES -> INCLUDES | COLON -> COLON | STRING_CHAR -> STRING_CHAR | CTRL -> CTRL | INVALID_TOKEN -> INVALID_TOKEN ) ! ( S )*
			{
			// cz/vutbr/web/csskit/antlr/CSS.g:1029:4: ( CLASSKEYWORD -> CLASSKEYWORD | NUMBER -> NUMBER | COMMA -> COMMA | GREATER -> GREATER | LESS -> LESS | QUESTION -> QUESTION | PERCENT -> PERCENT | EQUALS -> EQUALS | SLASH -> SLASH | EXCLAMATION -> EXCLAMATION | PLUS -> PLUS | ASTERISK -> ASTERISK | DASHMATCH -> DASHMATCH | INCLUDES -> INCLUDES | COLON -> COLON | STRING_CHAR -> STRING_CHAR | CTRL -> CTRL | INVALID_TOKEN -> INVALID_TOKEN )
			int alt103=18;
			switch ( input.LA(1) ) {
			case CLASSKEYWORD:
				{
				alt103=1;
				}
				break;
			case NUMBER:
				{
				alt103=2;
				}
				break;
			case COMMA:
				{
				alt103=3;
				}
				break;
			case GREATER:
				{
				alt103=4;
				}
				break;
			case LESS:
				{
				alt103=5;
				}
				break;
			case QUESTION:
				{
				alt103=6;
				}
				break;
			case PERCENT:
				{
				alt103=7;
				}
				break;
			case EQUALS:
				{
				alt103=8;
				}
				break;
			case SLASH:
				{
				alt103=9;
				}
				break;
			case EXCLAMATION:
				{
				alt103=10;
				}
				break;
			case PLUS:
				{
				alt103=11;
				}
				break;
			case ASTERISK:
				{
				alt103=12;
				}
				break;
			case DASHMATCH:
				{
				alt103=13;
				}
				break;
			case INCLUDES:
				{
				alt103=14;
				}
				break;
			case COLON:
				{
				alt103=15;
				}
				break;
			case STRING_CHAR:
				{
				alt103=16;
				}
				break;
			case CTRL:
				{
				alt103=17;
				}
				break;
			case INVALID_TOKEN:
				{
				alt103=18;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 103, 0, input);
				throw nvae;
			}
			switch (alt103) {
				case 1 :
					// cz/vutbr/web/csskit/antlr/CSS.g:1029:6: CLASSKEYWORD
					{
					CLASSKEYWORD236=(Token)match(input,CLASSKEYWORD,FOLLOW_CLASSKEYWORD_in_noprop2371);  
					stream_CLASSKEYWORD.add(CLASSKEYWORD236);

					// AST REWRITE
					// elements: CLASSKEYWORD
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (Object)adaptor.nil();
					// 1029:19: -> CLASSKEYWORD
					{
						adaptor.addChild(root_0, stream_CLASSKEYWORD.nextNode());
					}


					retval.tree = root_0;

					}
					break;
				case 2 :
					// cz/vutbr/web/csskit/antlr/CSS.g:1030:8: NUMBER
					{
					NUMBER237=(Token)match(input,NUMBER,FOLLOW_NUMBER_in_noprop2384);  
					stream_NUMBER.add(NUMBER237);

					// AST REWRITE
					// elements: NUMBER
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (Object)adaptor.nil();
					// 1030:15: -> NUMBER
					{
						adaptor.addChild(root_0, stream_NUMBER.nextNode());
					}


					retval.tree = root_0;

					}
					break;
				case 3 :
					// cz/vutbr/web/csskit/antlr/CSS.g:1031:7: COMMA
					{
					COMMA238=(Token)match(input,COMMA,FOLLOW_COMMA_in_noprop2396);  
					stream_COMMA.add(COMMA238);

					// AST REWRITE
					// elements: COMMA
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (Object)adaptor.nil();
					// 1031:13: -> COMMA
					{
						adaptor.addChild(root_0, stream_COMMA.nextNode());
					}


					retval.tree = root_0;

					}
					break;
				case 4 :
					// cz/vutbr/web/csskit/antlr/CSS.g:1032:7: GREATER
					{
					GREATER239=(Token)match(input,GREATER,FOLLOW_GREATER_in_noprop2408);  
					stream_GREATER.add(GREATER239);

					// AST REWRITE
					// elements: GREATER
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (Object)adaptor.nil();
					// 1032:15: -> GREATER
					{
						adaptor.addChild(root_0, stream_GREATER.nextNode());
					}


					retval.tree = root_0;

					}
					break;
				case 5 :
					// cz/vutbr/web/csskit/antlr/CSS.g:1033:7: LESS
					{
					LESS240=(Token)match(input,LESS,FOLLOW_LESS_in_noprop2420);  
					stream_LESS.add(LESS240);

					// AST REWRITE
					// elements: LESS
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (Object)adaptor.nil();
					// 1033:12: -> LESS
					{
						adaptor.addChild(root_0, stream_LESS.nextNode());
					}


					retval.tree = root_0;

					}
					break;
				case 6 :
					// cz/vutbr/web/csskit/antlr/CSS.g:1034:7: QUESTION
					{
					QUESTION241=(Token)match(input,QUESTION,FOLLOW_QUESTION_in_noprop2432);  
					stream_QUESTION.add(QUESTION241);

					// AST REWRITE
					// elements: QUESTION
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (Object)adaptor.nil();
					// 1034:16: -> QUESTION
					{
						adaptor.addChild(root_0, stream_QUESTION.nextNode());
					}


					retval.tree = root_0;

					}
					break;
				case 7 :
					// cz/vutbr/web/csskit/antlr/CSS.g:1035:7: PERCENT
					{
					PERCENT242=(Token)match(input,PERCENT,FOLLOW_PERCENT_in_noprop2444);  
					stream_PERCENT.add(PERCENT242);

					// AST REWRITE
					// elements: PERCENT
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (Object)adaptor.nil();
					// 1035:15: -> PERCENT
					{
						adaptor.addChild(root_0, stream_PERCENT.nextNode());
					}


					retval.tree = root_0;

					}
					break;
				case 8 :
					// cz/vutbr/web/csskit/antlr/CSS.g:1036:7: EQUALS
					{
					EQUALS243=(Token)match(input,EQUALS,FOLLOW_EQUALS_in_noprop2456);  
					stream_EQUALS.add(EQUALS243);

					// AST REWRITE
					// elements: EQUALS
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (Object)adaptor.nil();
					// 1036:14: -> EQUALS
					{
						adaptor.addChild(root_0, stream_EQUALS.nextNode());
					}


					retval.tree = root_0;

					}
					break;
				case 9 :
					// cz/vutbr/web/csskit/antlr/CSS.g:1037:7: SLASH
					{
					SLASH244=(Token)match(input,SLASH,FOLLOW_SLASH_in_noprop2468);  
					stream_SLASH.add(SLASH244);

					// AST REWRITE
					// elements: SLASH
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (Object)adaptor.nil();
					// 1037:13: -> SLASH
					{
						adaptor.addChild(root_0, stream_SLASH.nextNode());
					}


					retval.tree = root_0;

					}
					break;
				case 10 :
					// cz/vutbr/web/csskit/antlr/CSS.g:1038:7: EXCLAMATION
					{
					EXCLAMATION245=(Token)match(input,EXCLAMATION,FOLLOW_EXCLAMATION_in_noprop2480);  
					stream_EXCLAMATION.add(EXCLAMATION245);

					// AST REWRITE
					// elements: EXCLAMATION
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (Object)adaptor.nil();
					// 1038:19: -> EXCLAMATION
					{
						adaptor.addChild(root_0, stream_EXCLAMATION.nextNode());
					}


					retval.tree = root_0;

					}
					break;
				case 11 :
					// cz/vutbr/web/csskit/antlr/CSS.g:1039:7: PLUS
					{
					PLUS246=(Token)match(input,PLUS,FOLLOW_PLUS_in_noprop2492);  
					stream_PLUS.add(PLUS246);

					// AST REWRITE
					// elements: PLUS
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (Object)adaptor.nil();
					// 1039:12: -> PLUS
					{
						adaptor.addChild(root_0, stream_PLUS.nextNode());
					}


					retval.tree = root_0;

					}
					break;
				case 12 :
					// cz/vutbr/web/csskit/antlr/CSS.g:1040:7: ASTERISK
					{
					ASTERISK247=(Token)match(input,ASTERISK,FOLLOW_ASTERISK_in_noprop2504);  
					stream_ASTERISK.add(ASTERISK247);

					// AST REWRITE
					// elements: ASTERISK
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (Object)adaptor.nil();
					// 1040:16: -> ASTERISK
					{
						adaptor.addChild(root_0, stream_ASTERISK.nextNode());
					}


					retval.tree = root_0;

					}
					break;
				case 13 :
					// cz/vutbr/web/csskit/antlr/CSS.g:1041:7: DASHMATCH
					{
					DASHMATCH248=(Token)match(input,DASHMATCH,FOLLOW_DASHMATCH_in_noprop2519);  
					stream_DASHMATCH.add(DASHMATCH248);

					// AST REWRITE
					// elements: DASHMATCH
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (Object)adaptor.nil();
					// 1041:17: -> DASHMATCH
					{
						adaptor.addChild(root_0, stream_DASHMATCH.nextNode());
					}


					retval.tree = root_0;

					}
					break;
				case 14 :
					// cz/vutbr/web/csskit/antlr/CSS.g:1042:7: INCLUDES
					{
					INCLUDES249=(Token)match(input,INCLUDES,FOLLOW_INCLUDES_in_noprop2531);  
					stream_INCLUDES.add(INCLUDES249);

					// AST REWRITE
					// elements: INCLUDES
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (Object)adaptor.nil();
					// 1042:16: -> INCLUDES
					{
						adaptor.addChild(root_0, stream_INCLUDES.nextNode());
					}


					retval.tree = root_0;

					}
					break;
				case 15 :
					// cz/vutbr/web/csskit/antlr/CSS.g:1043:7: COLON
					{
					COLON250=(Token)match(input,COLON,FOLLOW_COLON_in_noprop2543);  
					stream_COLON.add(COLON250);

					// AST REWRITE
					// elements: COLON
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (Object)adaptor.nil();
					// 1043:13: -> COLON
					{
						adaptor.addChild(root_0, stream_COLON.nextNode());
					}


					retval.tree = root_0;

					}
					break;
				case 16 :
					// cz/vutbr/web/csskit/antlr/CSS.g:1044:7: STRING_CHAR
					{
					STRING_CHAR251=(Token)match(input,STRING_CHAR,FOLLOW_STRING_CHAR_in_noprop2555);  
					stream_STRING_CHAR.add(STRING_CHAR251);

					// AST REWRITE
					// elements: STRING_CHAR
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (Object)adaptor.nil();
					// 1044:19: -> STRING_CHAR
					{
						adaptor.addChild(root_0, stream_STRING_CHAR.nextNode());
					}


					retval.tree = root_0;

					}
					break;
				case 17 :
					// cz/vutbr/web/csskit/antlr/CSS.g:1045:8: CTRL
					{
					CTRL252=(Token)match(input,CTRL,FOLLOW_CTRL_in_noprop2568);  
					stream_CTRL.add(CTRL252);

					// AST REWRITE
					// elements: CTRL
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (Object)adaptor.nil();
					// 1045:13: -> CTRL
					{
						adaptor.addChild(root_0, stream_CTRL.nextNode());
					}


					retval.tree = root_0;

					}
					break;
				case 18 :
					// cz/vutbr/web/csskit/antlr/CSS.g:1046:7: INVALID_TOKEN
					{
					INVALID_TOKEN253=(Token)match(input,INVALID_TOKEN,FOLLOW_INVALID_TOKEN_in_noprop2580);  
					stream_INVALID_TOKEN.add(INVALID_TOKEN253);

					// AST REWRITE
					// elements: INVALID_TOKEN
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (Object)adaptor.nil();
					// 1046:21: -> INVALID_TOKEN
					{
						adaptor.addChild(root_0, stream_INVALID_TOKEN.nextNode());
					}


					retval.tree = root_0;

					}
					break;

			}

			// cz/vutbr/web/csskit/antlr/CSS.g:1047:8: ( S )*
			loop104:
			while (true) {
				int alt104=2;
				int LA104_0 = input.LA(1);
				if ( (LA104_0==S) ) {
					alt104=1;
				}

				switch (alt104) {
				case 1 :
					// cz/vutbr/web/csskit/antlr/CSS.g:1047:8: S
					{
					S254=(Token)match(input,S,FOLLOW_S_in_noprop2593);  
					stream_S.add(S254);

					}
					break;

				default :
					break loop104;
				}
			}

			}

			retval.stop = input.LT(-1);

			retval.tree = (Object)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "noprop"


	public static class norule_return extends ParserRuleReturnScope {
		Object tree;
		@Override
		public Object getTree() { return tree; }
	};


	// $ANTLR start "norule"
	// cz/vutbr/web/csskit/antlr/CSS.g:1050:1: norule : ( NUMBER -> NUMBER | PERCENTAGE -> PERCENTAGE | DIMENSION -> DIMENSION | string -> string | URI -> URI | UNIRANGE -> UNIRANGE | INCLUDES -> INCLUDES | COMMA -> COMMA | GREATER -> GREATER | LESS -> LESS | QUESTION -> QUESTION | PERCENT -> PERCENT | EQUALS -> EQUALS | SLASH -> SLASH | EXCLAMATION -> EXCLAMATION | MINUS -> MINUS | PLUS -> PLUS | DASHMATCH -> DASHMATCH | RPAREN -> RPAREN | CTRL -> CTRL | '#' | '^' ) ;
	public final CSSParser.norule_return norule() throws RecognitionException {
		CSSParser.norule_return retval = new CSSParser.norule_return();
		retval.start = input.LT(1);

		Object root_0 = null;

		Token NUMBER255=null;
		Token PERCENTAGE256=null;
		Token DIMENSION257=null;
		Token URI259=null;
		Token UNIRANGE260=null;
		Token INCLUDES261=null;
		Token COMMA262=null;
		Token GREATER263=null;
		Token LESS264=null;
		Token QUESTION265=null;
		Token PERCENT266=null;
		Token EQUALS267=null;
		Token SLASH268=null;
		Token EXCLAMATION269=null;
		Token MINUS270=null;
		Token PLUS271=null;
		Token DASHMATCH272=null;
		Token RPAREN273=null;
		Token CTRL274=null;
		Token char_literal275=null;
		Token char_literal276=null;
		ParserRuleReturnScope string258 =null;

		Object NUMBER255_tree=null;
		Object PERCENTAGE256_tree=null;
		Object DIMENSION257_tree=null;
		Object URI259_tree=null;
		Object UNIRANGE260_tree=null;
		Object INCLUDES261_tree=null;
		Object COMMA262_tree=null;
		Object GREATER263_tree=null;
		Object LESS264_tree=null;
		Object QUESTION265_tree=null;
		Object PERCENT266_tree=null;
		Object EQUALS267_tree=null;
		Object SLASH268_tree=null;
		Object EXCLAMATION269_tree=null;
		Object MINUS270_tree=null;
		Object PLUS271_tree=null;
		Object DASHMATCH272_tree=null;
		Object RPAREN273_tree=null;
		Object CTRL274_tree=null;
		Object char_literal275_tree=null;
		Object char_literal276_tree=null;
		RewriteRuleTokenStream stream_INCLUDES=new RewriteRuleTokenStream(adaptor,"token INCLUDES");
		RewriteRuleTokenStream stream_RPAREN=new RewriteRuleTokenStream(adaptor,"token RPAREN");
		RewriteRuleTokenStream stream_SLASH=new RewriteRuleTokenStream(adaptor,"token SLASH");
		RewriteRuleTokenStream stream_GREATER=new RewriteRuleTokenStream(adaptor,"token GREATER");
		RewriteRuleTokenStream stream_DASHMATCH=new RewriteRuleTokenStream(adaptor,"token DASHMATCH");
		RewriteRuleTokenStream stream_EXCLAMATION=new RewriteRuleTokenStream(adaptor,"token EXCLAMATION");
		RewriteRuleTokenStream stream_QUESTION=new RewriteRuleTokenStream(adaptor,"token QUESTION");
		RewriteRuleTokenStream stream_PERCENT=new RewriteRuleTokenStream(adaptor,"token PERCENT");
		RewriteRuleTokenStream stream_COMMA=new RewriteRuleTokenStream(adaptor,"token COMMA");
		RewriteRuleTokenStream stream_NUMBER=new RewriteRuleTokenStream(adaptor,"token NUMBER");
		RewriteRuleTokenStream stream_LESS=new RewriteRuleTokenStream(adaptor,"token LESS");
		RewriteRuleTokenStream stream_UNIRANGE=new RewriteRuleTokenStream(adaptor,"token UNIRANGE");
		RewriteRuleTokenStream stream_DIMENSION=new RewriteRuleTokenStream(adaptor,"token DIMENSION");
		RewriteRuleTokenStream stream_PLUS=new RewriteRuleTokenStream(adaptor,"token PLUS");
		RewriteRuleTokenStream stream_EQUALS=new RewriteRuleTokenStream(adaptor,"token EQUALS");
		RewriteRuleTokenStream stream_MINUS=new RewriteRuleTokenStream(adaptor,"token MINUS");
		RewriteRuleTokenStream stream_102=new RewriteRuleTokenStream(adaptor,"token 102");
		RewriteRuleTokenStream stream_PERCENTAGE=new RewriteRuleTokenStream(adaptor,"token PERCENTAGE");
		RewriteRuleTokenStream stream_101=new RewriteRuleTokenStream(adaptor,"token 101");
		RewriteRuleTokenStream stream_URI=new RewriteRuleTokenStream(adaptor,"token URI");
		RewriteRuleTokenStream stream_CTRL=new RewriteRuleTokenStream(adaptor,"token CTRL");
		RewriteRuleSubtreeStream stream_string=new RewriteRuleSubtreeStream(adaptor,"rule string");

		try {
			// cz/vutbr/web/csskit/antlr/CSS.g:1051:3: ( ( NUMBER -> NUMBER | PERCENTAGE -> PERCENTAGE | DIMENSION -> DIMENSION | string -> string | URI -> URI | UNIRANGE -> UNIRANGE | INCLUDES -> INCLUDES | COMMA -> COMMA | GREATER -> GREATER | LESS -> LESS | QUESTION -> QUESTION | PERCENT -> PERCENT | EQUALS -> EQUALS | SLASH -> SLASH | EXCLAMATION -> EXCLAMATION | MINUS -> MINUS | PLUS -> PLUS | DASHMATCH -> DASHMATCH | RPAREN -> RPAREN | CTRL -> CTRL | '#' | '^' ) )
			// cz/vutbr/web/csskit/antlr/CSS.g:1051:5: ( NUMBER -> NUMBER | PERCENTAGE -> PERCENTAGE | DIMENSION -> DIMENSION | string -> string | URI -> URI | UNIRANGE -> UNIRANGE | INCLUDES -> INCLUDES | COMMA -> COMMA | GREATER -> GREATER | LESS -> LESS | QUESTION -> QUESTION | PERCENT -> PERCENT | EQUALS -> EQUALS | SLASH -> SLASH | EXCLAMATION -> EXCLAMATION | MINUS -> MINUS | PLUS -> PLUS | DASHMATCH -> DASHMATCH | RPAREN -> RPAREN | CTRL -> CTRL | '#' | '^' )
			{
			// cz/vutbr/web/csskit/antlr/CSS.g:1051:5: ( NUMBER -> NUMBER | PERCENTAGE -> PERCENTAGE | DIMENSION -> DIMENSION | string -> string | URI -> URI | UNIRANGE -> UNIRANGE | INCLUDES -> INCLUDES | COMMA -> COMMA | GREATER -> GREATER | LESS -> LESS | QUESTION -> QUESTION | PERCENT -> PERCENT | EQUALS -> EQUALS | SLASH -> SLASH | EXCLAMATION -> EXCLAMATION | MINUS -> MINUS | PLUS -> PLUS | DASHMATCH -> DASHMATCH | RPAREN -> RPAREN | CTRL -> CTRL | '#' | '^' )
			int alt105=22;
			switch ( input.LA(1) ) {
			case NUMBER:
				{
				alt105=1;
				}
				break;
			case PERCENTAGE:
				{
				alt105=2;
				}
				break;
			case DIMENSION:
				{
				alt105=3;
				}
				break;
			case INVALID_STRING:
			case STRING:
				{
				alt105=4;
				}
				break;
			case URI:
				{
				alt105=5;
				}
				break;
			case UNIRANGE:
				{
				alt105=6;
				}
				break;
			case INCLUDES:
				{
				alt105=7;
				}
				break;
			case COMMA:
				{
				alt105=8;
				}
				break;
			case GREATER:
				{
				alt105=9;
				}
				break;
			case LESS:
				{
				alt105=10;
				}
				break;
			case QUESTION:
				{
				alt105=11;
				}
				break;
			case PERCENT:
				{
				alt105=12;
				}
				break;
			case EQUALS:
				{
				alt105=13;
				}
				break;
			case SLASH:
				{
				alt105=14;
				}
				break;
			case EXCLAMATION:
				{
				alt105=15;
				}
				break;
			case MINUS:
				{
				alt105=16;
				}
				break;
			case PLUS:
				{
				alt105=17;
				}
				break;
			case DASHMATCH:
				{
				alt105=18;
				}
				break;
			case RPAREN:
				{
				alt105=19;
				}
				break;
			case CTRL:
				{
				alt105=20;
				}
				break;
			case 101:
				{
				alt105=21;
				}
				break;
			case 102:
				{
				alt105=22;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 105, 0, input);
				throw nvae;
			}
			switch (alt105) {
				case 1 :
					// cz/vutbr/web/csskit/antlr/CSS.g:1051:7: NUMBER
					{
					NUMBER255=(Token)match(input,NUMBER,FOLLOW_NUMBER_in_norule2608);  
					stream_NUMBER.add(NUMBER255);

					// AST REWRITE
					// elements: NUMBER
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (Object)adaptor.nil();
					// 1051:14: -> NUMBER
					{
						adaptor.addChild(root_0, stream_NUMBER.nextNode());
					}


					retval.tree = root_0;

					}
					break;
				case 2 :
					// cz/vutbr/web/csskit/antlr/CSS.g:1052:8: PERCENTAGE
					{
					PERCENTAGE256=(Token)match(input,PERCENTAGE,FOLLOW_PERCENTAGE_in_norule2621);  
					stream_PERCENTAGE.add(PERCENTAGE256);

					// AST REWRITE
					// elements: PERCENTAGE
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (Object)adaptor.nil();
					// 1052:19: -> PERCENTAGE
					{
						adaptor.addChild(root_0, stream_PERCENTAGE.nextNode());
					}


					retval.tree = root_0;

					}
					break;
				case 3 :
					// cz/vutbr/web/csskit/antlr/CSS.g:1053:8: DIMENSION
					{
					DIMENSION257=(Token)match(input,DIMENSION,FOLLOW_DIMENSION_in_norule2633);  
					stream_DIMENSION.add(DIMENSION257);

					// AST REWRITE
					// elements: DIMENSION
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (Object)adaptor.nil();
					// 1053:18: -> DIMENSION
					{
						adaptor.addChild(root_0, stream_DIMENSION.nextNode());
					}


					retval.tree = root_0;

					}
					break;
				case 4 :
					// cz/vutbr/web/csskit/antlr/CSS.g:1054:8: string
					{
					pushFollow(FOLLOW_string_in_norule2646);
					string258=string();
					state._fsp--;

					stream_string.add(string258.getTree());
					// AST REWRITE
					// elements: string
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (Object)adaptor.nil();
					// 1054:15: -> string
					{
						adaptor.addChild(root_0, stream_string.nextTree());
					}


					retval.tree = root_0;

					}
					break;
				case 5 :
					// cz/vutbr/web/csskit/antlr/CSS.g:1055:9: URI
					{
					URI259=(Token)match(input,URI,FOLLOW_URI_in_norule2660);  
					stream_URI.add(URI259);

					// AST REWRITE
					// elements: URI
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (Object)adaptor.nil();
					// 1055:16: -> URI
					{
						adaptor.addChild(root_0, stream_URI.nextNode());
					}


					retval.tree = root_0;

					}
					break;
				case 6 :
					// cz/vutbr/web/csskit/antlr/CSS.g:1056:9: UNIRANGE
					{
					UNIRANGE260=(Token)match(input,UNIRANGE,FOLLOW_UNIRANGE_in_norule2677);  
					stream_UNIRANGE.add(UNIRANGE260);

					// AST REWRITE
					// elements: UNIRANGE
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (Object)adaptor.nil();
					// 1056:18: -> UNIRANGE
					{
						adaptor.addChild(root_0, stream_UNIRANGE.nextNode());
					}


					retval.tree = root_0;

					}
					break;
				case 7 :
					// cz/vutbr/web/csskit/antlr/CSS.g:1057:9: INCLUDES
					{
					INCLUDES261=(Token)match(input,INCLUDES,FOLLOW_INCLUDES_in_norule2691);  
					stream_INCLUDES.add(INCLUDES261);

					// AST REWRITE
					// elements: INCLUDES
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (Object)adaptor.nil();
					// 1057:18: -> INCLUDES
					{
						adaptor.addChild(root_0, stream_INCLUDES.nextNode());
					}


					retval.tree = root_0;

					}
					break;
				case 8 :
					// cz/vutbr/web/csskit/antlr/CSS.g:1058:9: COMMA
					{
					COMMA262=(Token)match(input,COMMA,FOLLOW_COMMA_in_norule2705);  
					stream_COMMA.add(COMMA262);

					// AST REWRITE
					// elements: COMMA
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (Object)adaptor.nil();
					// 1058:15: -> COMMA
					{
						adaptor.addChild(root_0, stream_COMMA.nextNode());
					}


					retval.tree = root_0;

					}
					break;
				case 9 :
					// cz/vutbr/web/csskit/antlr/CSS.g:1059:9: GREATER
					{
					GREATER263=(Token)match(input,GREATER,FOLLOW_GREATER_in_norule2719);  
					stream_GREATER.add(GREATER263);

					// AST REWRITE
					// elements: GREATER
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (Object)adaptor.nil();
					// 1059:17: -> GREATER
					{
						adaptor.addChild(root_0, stream_GREATER.nextNode());
					}


					retval.tree = root_0;

					}
					break;
				case 10 :
					// cz/vutbr/web/csskit/antlr/CSS.g:1060:9: LESS
					{
					LESS264=(Token)match(input,LESS,FOLLOW_LESS_in_norule2733);  
					stream_LESS.add(LESS264);

					// AST REWRITE
					// elements: LESS
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (Object)adaptor.nil();
					// 1060:14: -> LESS
					{
						adaptor.addChild(root_0, stream_LESS.nextNode());
					}


					retval.tree = root_0;

					}
					break;
				case 11 :
					// cz/vutbr/web/csskit/antlr/CSS.g:1061:9: QUESTION
					{
					QUESTION265=(Token)match(input,QUESTION,FOLLOW_QUESTION_in_norule2747);  
					stream_QUESTION.add(QUESTION265);

					// AST REWRITE
					// elements: QUESTION
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (Object)adaptor.nil();
					// 1061:18: -> QUESTION
					{
						adaptor.addChild(root_0, stream_QUESTION.nextNode());
					}


					retval.tree = root_0;

					}
					break;
				case 12 :
					// cz/vutbr/web/csskit/antlr/CSS.g:1062:9: PERCENT
					{
					PERCENT266=(Token)match(input,PERCENT,FOLLOW_PERCENT_in_norule2761);  
					stream_PERCENT.add(PERCENT266);

					// AST REWRITE
					// elements: PERCENT
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (Object)adaptor.nil();
					// 1062:17: -> PERCENT
					{
						adaptor.addChild(root_0, stream_PERCENT.nextNode());
					}


					retval.tree = root_0;

					}
					break;
				case 13 :
					// cz/vutbr/web/csskit/antlr/CSS.g:1063:9: EQUALS
					{
					EQUALS267=(Token)match(input,EQUALS,FOLLOW_EQUALS_in_norule2775);  
					stream_EQUALS.add(EQUALS267);

					// AST REWRITE
					// elements: EQUALS
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (Object)adaptor.nil();
					// 1063:16: -> EQUALS
					{
						adaptor.addChild(root_0, stream_EQUALS.nextNode());
					}


					retval.tree = root_0;

					}
					break;
				case 14 :
					// cz/vutbr/web/csskit/antlr/CSS.g:1064:9: SLASH
					{
					SLASH268=(Token)match(input,SLASH,FOLLOW_SLASH_in_norule2789);  
					stream_SLASH.add(SLASH268);

					// AST REWRITE
					// elements: SLASH
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (Object)adaptor.nil();
					// 1064:15: -> SLASH
					{
						adaptor.addChild(root_0, stream_SLASH.nextNode());
					}


					retval.tree = root_0;

					}
					break;
				case 15 :
					// cz/vutbr/web/csskit/antlr/CSS.g:1065:9: EXCLAMATION
					{
					EXCLAMATION269=(Token)match(input,EXCLAMATION,FOLLOW_EXCLAMATION_in_norule2803);  
					stream_EXCLAMATION.add(EXCLAMATION269);

					// AST REWRITE
					// elements: EXCLAMATION
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (Object)adaptor.nil();
					// 1065:21: -> EXCLAMATION
					{
						adaptor.addChild(root_0, stream_EXCLAMATION.nextNode());
					}


					retval.tree = root_0;

					}
					break;
				case 16 :
					// cz/vutbr/web/csskit/antlr/CSS.g:1066:8: MINUS
					{
					MINUS270=(Token)match(input,MINUS,FOLLOW_MINUS_in_norule2816);  
					stream_MINUS.add(MINUS270);

					// AST REWRITE
					// elements: MINUS
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (Object)adaptor.nil();
					// 1066:14: -> MINUS
					{
						adaptor.addChild(root_0, stream_MINUS.nextNode());
					}


					retval.tree = root_0;

					}
					break;
				case 17 :
					// cz/vutbr/web/csskit/antlr/CSS.g:1067:8: PLUS
					{
					PLUS271=(Token)match(input,PLUS,FOLLOW_PLUS_in_norule2829);  
					stream_PLUS.add(PLUS271);

					// AST REWRITE
					// elements: PLUS
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (Object)adaptor.nil();
					// 1067:13: -> PLUS
					{
						adaptor.addChild(root_0, stream_PLUS.nextNode());
					}


					retval.tree = root_0;

					}
					break;
				case 18 :
					// cz/vutbr/web/csskit/antlr/CSS.g:1068:9: DASHMATCH
					{
					DASHMATCH272=(Token)match(input,DASHMATCH,FOLLOW_DASHMATCH_in_norule2843);  
					stream_DASHMATCH.add(DASHMATCH272);

					// AST REWRITE
					// elements: DASHMATCH
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (Object)adaptor.nil();
					// 1068:19: -> DASHMATCH
					{
						adaptor.addChild(root_0, stream_DASHMATCH.nextNode());
					}


					retval.tree = root_0;

					}
					break;
				case 19 :
					// cz/vutbr/web/csskit/antlr/CSS.g:1069:9: RPAREN
					{
					RPAREN273=(Token)match(input,RPAREN,FOLLOW_RPAREN_in_norule2857);  
					stream_RPAREN.add(RPAREN273);

					// AST REWRITE
					// elements: RPAREN
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (Object)adaptor.nil();
					// 1069:16: -> RPAREN
					{
						adaptor.addChild(root_0, stream_RPAREN.nextNode());
					}


					retval.tree = root_0;

					}
					break;
				case 20 :
					// cz/vutbr/web/csskit/antlr/CSS.g:1070:9: CTRL
					{
					CTRL274=(Token)match(input,CTRL,FOLLOW_CTRL_in_norule2871);  
					stream_CTRL.add(CTRL274);

					// AST REWRITE
					// elements: CTRL
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (Object)adaptor.nil();
					// 1070:14: -> CTRL
					{
						adaptor.addChild(root_0, stream_CTRL.nextNode());
					}


					retval.tree = root_0;

					}
					break;
				case 21 :
					// cz/vutbr/web/csskit/antlr/CSS.g:1071:9: '#'
					{
					char_literal275=(Token)match(input,101,FOLLOW_101_in_norule2885);  
					stream_101.add(char_literal275);

					}
					break;
				case 22 :
					// cz/vutbr/web/csskit/antlr/CSS.g:1072:9: '^'
					{
					char_literal276=(Token)match(input,102,FOLLOW_102_in_norule2896);  
					stream_102.add(char_literal276);

					}
					break;

			}

			}

			retval.stop = input.LT(-1);

			retval.tree = (Object)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "norule"

	// Delegated rules



	public static final BitSet FOLLOW_S_in_inlinestyle205 = new BitSet(new long[]{0x11A00428A0938040L,0x00000000022A0944L});
	public static final BitSet FOLLOW_declarations_in_inlinestyle210 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_inlineset_in_inlinestyle230 = new BitSet(new long[]{0x0080000000010002L});
	public static final BitSet FOLLOW_CDO_in_stylesheet258 = new BitSet(new long[]{0x195506BAA493B962L,0x00000064612AD9D4L});
	public static final BitSet FOLLOW_CDC_in_stylesheet262 = new BitSet(new long[]{0x195506BAA493B962L,0x00000064612AD9D4L});
	public static final BitSet FOLLOW_S_in_stylesheet266 = new BitSet(new long[]{0x195506BAA493B962L,0x00000064612AD9D4L});
	public static final BitSet FOLLOW_nostatement_in_stylesheet270 = new BitSet(new long[]{0x195506BAA493B962L,0x00000064612AD9D4L});
	public static final BitSet FOLLOW_statement_in_stylesheet274 = new BitSet(new long[]{0x195506BAA493B962L,0x00000064612AD9D4L});
	public static final BitSet FOLLOW_ruleset_in_statement304 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_atstatement_in_statement308 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_CHARSET_in_atstatement319 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_IMPORT_in_atstatement324 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_INVALID_IMPORT_in_atstatement329 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_IMPORT_END_in_atstatement334 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_page_in_atstatement339 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_VIEWPORT_in_atstatement345 = new BitSet(new long[]{0x0080000000000000L,0x0000000000020000L});
	public static final BitSet FOLLOW_S_in_atstatement347 = new BitSet(new long[]{0x0080000000000000L,0x0000000000020000L});
	public static final BitSet FOLLOW_LCURLY_in_atstatement354 = new BitSet(new long[]{0x11200428A0938040L,0x00000000022A4944L});
	public static final BitSet FOLLOW_S_in_atstatement356 = new BitSet(new long[]{0x11200428A0938040L,0x00000000022A4944L});
	public static final BitSet FOLLOW_declarations_in_atstatement359 = new BitSet(new long[]{0x0000000000000000L,0x0000000000004000L});
	public static final BitSet FOLLOW_RCURLY_in_atstatement365 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_FONTFACE_in_atstatement378 = new BitSet(new long[]{0x0080000000000000L,0x0000000000020000L});
	public static final BitSet FOLLOW_S_in_atstatement380 = new BitSet(new long[]{0x0080000000000000L,0x0000000000020000L});
	public static final BitSet FOLLOW_LCURLY_in_atstatement386 = new BitSet(new long[]{0x11200428A0938040L,0x00000000022A4944L});
	public static final BitSet FOLLOW_S_in_atstatement388 = new BitSet(new long[]{0x11200428A0938040L,0x00000000022A4944L});
	public static final BitSet FOLLOW_declarations_in_atstatement391 = new BitSet(new long[]{0x0000000000000000L,0x0000000000004000L});
	public static final BitSet FOLLOW_RCURLY_in_atstatement396 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_MEDIA_in_atstatement409 = new BitSet(new long[]{0x0080002000000000L,0x0000000000020000L});
	public static final BitSet FOLLOW_S_in_atstatement411 = new BitSet(new long[]{0x0080002000000000L,0x0000000000020000L});
	public static final BitSet FOLLOW_media_in_atstatement414 = new BitSet(new long[]{0x0080000000000000L});
	public static final BitSet FOLLOW_LCURLY_in_atstatement420 = new BitSet(new long[]{0x11540438A4938040L,0x000000606122C9C4L});
	public static final BitSet FOLLOW_S_in_atstatement422 = new BitSet(new long[]{0x11540438A4938040L,0x000000606122C9C4L});
	public static final BitSet FOLLOW_ruleset_in_atstatement426 = new BitSet(new long[]{0x11540438A4938040L,0x000000606122C9C4L});
	public static final BitSet FOLLOW_S_in_atstatement428 = new BitSet(new long[]{0x11540438A4938040L,0x000000606122C9C4L});
	public static final BitSet FOLLOW_RCURLY_in_atstatement433 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ATKEYWORD_in_atstatement451 = new BitSet(new long[]{0x0080000000000000L,0x0000000000020000L});
	public static final BitSet FOLLOW_S_in_atstatement453 = new BitSet(new long[]{0x0080000000000000L,0x0000000000020000L});
	public static final BitSet FOLLOW_LCURLY_in_atstatement456 = new BitSet(new long[]{0x1350043CA4838040L,0x00000000612049C4L});
	public static final BitSet FOLLOW_any_in_atstatement458 = new BitSet(new long[]{0x1350043CA4838040L,0x00000000612049C4L});
	public static final BitSet FOLLOW_RCURLY_in_atstatement461 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_PAGE_in_page483 = new BitSet(new long[]{0x0080002000010000L,0x0000000000020000L});
	public static final BitSet FOLLOW_S_in_page485 = new BitSet(new long[]{0x0080002000010000L,0x0000000000020000L});
	public static final BitSet FOLLOW_IDENT_in_page491 = new BitSet(new long[]{0x0080000000000000L,0x0000000000020000L});
	public static final BitSet FOLLOW_IDENT_in_page495 = new BitSet(new long[]{0x0000000000010000L});
	public static final BitSet FOLLOW_page_pseudo_in_page497 = new BitSet(new long[]{0x0080000000000000L,0x0000000000020000L});
	public static final BitSet FOLLOW_page_pseudo_in_page501 = new BitSet(new long[]{0x0080000000000000L,0x0000000000020000L});
	public static final BitSet FOLLOW_S_in_page504 = new BitSet(new long[]{0x0080000000000000L,0x0000000000020000L});
	public static final BitSet FOLLOW_LCURLY_in_page512 = new BitSet(new long[]{0x15200428A0938040L,0x00000000022A4944L});
	public static final BitSet FOLLOW_S_in_page514 = new BitSet(new long[]{0x15200428A0938040L,0x00000000022A4944L});
	public static final BitSet FOLLOW_declarations_in_page519 = new BitSet(new long[]{0x0400000000000000L,0x0000000000004000L});
	public static final BitSet FOLLOW_margin_rule_in_page521 = new BitSet(new long[]{0x0400000000000000L,0x0000000000004000L});
	public static final BitSet FOLLOW_RCURLY_in_page526 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_pseudocolon_in_page_pseudo560 = new BitSet(new long[]{0x0000002000000000L});
	public static final BitSet FOLLOW_IDENT_in_page_pseudo563 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_MARGIN_AREA_in_margin_rule574 = new BitSet(new long[]{0x0080000000000000L,0x0000000000020000L});
	public static final BitSet FOLLOW_S_in_margin_rule576 = new BitSet(new long[]{0x0080000000000000L,0x0000000000020000L});
	public static final BitSet FOLLOW_LCURLY_in_margin_rule579 = new BitSet(new long[]{0x11200428A0938040L,0x00000000022A4944L});
	public static final BitSet FOLLOW_S_in_margin_rule581 = new BitSet(new long[]{0x11200428A0938040L,0x00000000022A4944L});
	public static final BitSet FOLLOW_declarations_in_margin_rule584 = new BitSet(new long[]{0x0000000000000000L,0x0000000000004000L});
	public static final BitSet FOLLOW_RCURLY_in_margin_rule586 = new BitSet(new long[]{0x0000000000000002L,0x0000000000020000L});
	public static final BitSet FOLLOW_S_in_margin_rule588 = new BitSet(new long[]{0x0000000000000002L,0x0000000000020000L});
	public static final BitSet FOLLOW_pseudo_in_inlineset611 = new BitSet(new long[]{0x0080000000020000L,0x0000000000020000L});
	public static final BitSet FOLLOW_S_in_inlineset613 = new BitSet(new long[]{0x0080000000020000L,0x0000000000020000L});
	public static final BitSet FOLLOW_COMMA_in_inlineset617 = new BitSet(new long[]{0x0000000000010000L,0x0000000000020000L});
	public static final BitSet FOLLOW_S_in_inlineset619 = new BitSet(new long[]{0x0000000000010000L,0x0000000000020000L});
	public static final BitSet FOLLOW_pseudo_in_inlineset622 = new BitSet(new long[]{0x0080000000020000L,0x0000000000020000L});
	public static final BitSet FOLLOW_S_in_inlineset624 = new BitSet(new long[]{0x0080000000020000L,0x0000000000020000L});
	public static final BitSet FOLLOW_LCURLY_in_inlineset637 = new BitSet(new long[]{0x11200428A0938040L,0x0000000002284944L});
	public static final BitSet FOLLOW_declarations_in_inlineset643 = new BitSet(new long[]{0x0000000000000000L,0x0000000000004000L});
	public static final BitSet FOLLOW_RCURLY_in_inlineset648 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_IDENT_in_media675 = new BitSet(new long[]{0x0000000000020002L,0x0000000000020000L});
	public static final BitSet FOLLOW_S_in_media677 = new BitSet(new long[]{0x0000000000020002L,0x0000000000020000L});
	public static final BitSet FOLLOW_COMMA_in_media681 = new BitSet(new long[]{0x0000002000000000L,0x0000000000020000L});
	public static final BitSet FOLLOW_S_in_media683 = new BitSet(new long[]{0x0000002000000000L,0x0000000000020000L});
	public static final BitSet FOLLOW_IDENT_in_media686 = new BitSet(new long[]{0x0000000000020002L,0x0000000000020000L});
	public static final BitSet FOLLOW_S_in_media688 = new BitSet(new long[]{0x0000000000020002L,0x0000000000020000L});
	public static final BitSet FOLLOW_combined_selector_in_ruleset713 = new BitSet(new long[]{0x0080000000020000L});
	public static final BitSet FOLLOW_COMMA_in_ruleset716 = new BitSet(new long[]{0x0044003000018040L,0x0000000000020000L});
	public static final BitSet FOLLOW_S_in_ruleset718 = new BitSet(new long[]{0x0044003000018040L,0x0000000000020000L});
	public static final BitSet FOLLOW_combined_selector_in_ruleset721 = new BitSet(new long[]{0x0080000000020000L});
	public static final BitSet FOLLOW_LCURLY_in_ruleset729 = new BitSet(new long[]{0x11200428A0938040L,0x00000000022A4944L});
	public static final BitSet FOLLOW_S_in_ruleset731 = new BitSet(new long[]{0x11200428A0938040L,0x00000000022A4944L});
	public static final BitSet FOLLOW_declarations_in_ruleset739 = new BitSet(new long[]{0x0000000000000000L,0x0000000000004000L});
	public static final BitSet FOLLOW_RCURLY_in_ruleset744 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_norule_in_ruleset763 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_declaration_in_declarations785 = new BitSet(new long[]{0x0000000000000002L,0x0000000000080000L});
	public static final BitSet FOLLOW_SEMICOLON_in_declarations789 = new BitSet(new long[]{0x11200428A0938042L,0x00000000022A0944L});
	public static final BitSet FOLLOW_S_in_declarations791 = new BitSet(new long[]{0x11200428A0938042L,0x00000000022A0944L});
	public static final BitSet FOLLOW_declaration_in_declarations794 = new BitSet(new long[]{0x0000000000000002L,0x0000000000080000L});
	public static final BitSet FOLLOW_property_in_declaration826 = new BitSet(new long[]{0x0000000000010000L});
	public static final BitSet FOLLOW_COLON_in_declaration828 = new BitSet(new long[]{0x13D0043DA4838142L,0x00000000612209C4L});
	public static final BitSet FOLLOW_S_in_declaration830 = new BitSet(new long[]{0x13D0043DA4838142L,0x00000000612209C4L});
	public static final BitSet FOLLOW_terms_in_declaration833 = new BitSet(new long[]{0x0000000080000002L});
	public static final BitSet FOLLOW_important_in_declaration836 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_noprop_in_declaration856 = new BitSet(new long[]{0x1350043CA4838042L,0x00000000612009C4L});
	public static final BitSet FOLLOW_any_in_declaration858 = new BitSet(new long[]{0x1350043CA4838042L,0x00000000612009C4L});
	public static final BitSet FOLLOW_EXCLAMATION_in_important884 = new BitSet(new long[]{0x0000000000000000L,0x0000008000020000L});
	public static final BitSet FOLLOW_S_in_important886 = new BitSet(new long[]{0x0000000000000000L,0x0000008000020000L});
	public static final BitSet FOLLOW_103_in_important889 = new BitSet(new long[]{0x0000000000000002L,0x0000000000020000L});
	public static final BitSet FOLLOW_S_in_important891 = new BitSet(new long[]{0x0000000000000002L,0x0000000000020000L});
	public static final BitSet FOLLOW_MINUS_in_property920 = new BitSet(new long[]{0x0000002000000000L});
	public static final BitSet FOLLOW_IDENT_in_property923 = new BitSet(new long[]{0x0000000000000002L,0x0000000000020000L});
	public static final BitSet FOLLOW_S_in_property925 = new BitSet(new long[]{0x0000000000000002L,0x0000000000020000L});
	public static final BitSet FOLLOW_term_in_terms953 = new BitSet(new long[]{0x13D0043D24838142L,0x00000000612009C4L});
	public static final BitSet FOLLOW_valuepart_in_term986 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_LCURLY_in_term998 = new BitSet(new long[]{0x1350043CA4838040L,0x00000000612A49C4L});
	public static final BitSet FOLLOW_S_in_term1000 = new BitSet(new long[]{0x1350043CA4838040L,0x00000000612A49C4L});
	public static final BitSet FOLLOW_any_in_term1004 = new BitSet(new long[]{0x1350043CA4838040L,0x00000000612849C4L});
	public static final BitSet FOLLOW_SEMICOLON_in_term1008 = new BitSet(new long[]{0x1350043CA4838040L,0x00000000612A49C4L});
	public static final BitSet FOLLOW_S_in_term1010 = new BitSet(new long[]{0x1350043CA4838040L,0x00000000612A49C4L});
	public static final BitSet FOLLOW_RCURLY_in_term1015 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ATKEYWORD_in_term1027 = new BitSet(new long[]{0x0000000000000002L,0x0000000000020000L});
	public static final BitSet FOLLOW_S_in_term1029 = new BitSet(new long[]{0x0000000000000002L,0x0000000000020000L});
	public static final BitSet FOLLOW_EXPRESSION_in_funct1062 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_FUNCTION_in_funct1071 = new BitSet(new long[]{0x13D0043D24838140L,0x00000000612289C4L});
	public static final BitSet FOLLOW_S_in_funct1073 = new BitSet(new long[]{0x13D0043D24838140L,0x00000000612289C4L});
	public static final BitSet FOLLOW_terms_in_funct1076 = new BitSet(new long[]{0x0000000000000000L,0x0000000000008000L});
	public static final BitSet FOLLOW_RPAREN_in_funct1079 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_MINUS_in_valuepart1106 = new BitSet(new long[]{0x0000002000000000L});
	public static final BitSet FOLLOW_IDENT_in_valuepart1109 = new BitSet(new long[]{0x0000000000000002L,0x0000000000020000L});
	public static final BitSet FOLLOW_CLASSKEYWORD_in_valuepart1126 = new BitSet(new long[]{0x0000000000000002L,0x0000000000020000L});
	public static final BitSet FOLLOW_MINUS_in_valuepart1140 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000004L});
	public static final BitSet FOLLOW_NUMBER_in_valuepart1143 = new BitSet(new long[]{0x0000000000000002L,0x0000000000020000L});
	public static final BitSet FOLLOW_MINUS_in_valuepart1160 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000080L});
	public static final BitSet FOLLOW_PERCENTAGE_in_valuepart1163 = new BitSet(new long[]{0x0000000000000002L,0x0000000000020000L});
	public static final BitSet FOLLOW_MINUS_in_valuepart1180 = new BitSet(new long[]{0x0000000004000000L});
	public static final BitSet FOLLOW_DIMENSION_in_valuepart1183 = new BitSet(new long[]{0x0000000000000002L,0x0000000000020000L});
	public static final BitSet FOLLOW_string_in_valuepart1200 = new BitSet(new long[]{0x0000000000000002L,0x0000000000020000L});
	public static final BitSet FOLLOW_URI_in_valuepart1214 = new BitSet(new long[]{0x0000000000000002L,0x0000000000020000L});
	public static final BitSet FOLLOW_HASH_in_valuepart1231 = new BitSet(new long[]{0x0000000000000002L,0x0000000000020000L});
	public static final BitSet FOLLOW_UNIRANGE_in_valuepart1245 = new BitSet(new long[]{0x0000000000000002L,0x0000000000020000L});
	public static final BitSet FOLLOW_INCLUDES_in_valuepart1259 = new BitSet(new long[]{0x0000000000000002L,0x0000000000020000L});
	public static final BitSet FOLLOW_COLON_in_valuepart1273 = new BitSet(new long[]{0x0000000000000002L,0x0000000000020000L});
	public static final BitSet FOLLOW_COMMA_in_valuepart1287 = new BitSet(new long[]{0x0000000000000002L,0x0000000000020000L});
	public static final BitSet FOLLOW_GREATER_in_valuepart1301 = new BitSet(new long[]{0x0000000000000002L,0x0000000000020000L});
	public static final BitSet FOLLOW_LESS_in_valuepart1315 = new BitSet(new long[]{0x0000000000000002L,0x0000000000020000L});
	public static final BitSet FOLLOW_QUESTION_in_valuepart1329 = new BitSet(new long[]{0x0000000000000002L,0x0000000000020000L});
	public static final BitSet FOLLOW_PERCENT_in_valuepart1343 = new BitSet(new long[]{0x0000000000000002L,0x0000000000020000L});
	public static final BitSet FOLLOW_EQUALS_in_valuepart1357 = new BitSet(new long[]{0x0000000000000002L,0x0000000000020000L});
	public static final BitSet FOLLOW_SLASH_in_valuepart1371 = new BitSet(new long[]{0x0000000000000002L,0x0000000000020000L});
	public static final BitSet FOLLOW_PLUS_in_valuepart1384 = new BitSet(new long[]{0x0000000000000002L,0x0000000000020000L});
	public static final BitSet FOLLOW_ASTERISK_in_valuepart1397 = new BitSet(new long[]{0x0000000000000002L,0x0000000000020000L});
	public static final BitSet FOLLOW_MINUS_in_valuepart1414 = new BitSet(new long[]{0x0000000500000000L});
	public static final BitSet FOLLOW_funct_in_valuepart1417 = new BitSet(new long[]{0x0000000000000002L,0x0000000000020000L});
	public static final BitSet FOLLOW_DASHMATCH_in_valuepart1435 = new BitSet(new long[]{0x0000000000000002L,0x0000000000020000L});
	public static final BitSet FOLLOW_LPAREN_in_valuepart1449 = new BitSet(new long[]{0x1350043D24838040L,0x00000000612089C4L});
	public static final BitSet FOLLOW_valuepart_in_valuepart1451 = new BitSet(new long[]{0x1350043D24838040L,0x00000000612089C4L});
	public static final BitSet FOLLOW_RPAREN_in_valuepart1454 = new BitSet(new long[]{0x0000000000000002L,0x0000000000020000L});
	public static final BitSet FOLLOW_LBRACE_in_valuepart1473 = new BitSet(new long[]{0x1350043D24838040L,0x00000000612029C4L});
	public static final BitSet FOLLOW_valuepart_in_valuepart1475 = new BitSet(new long[]{0x1350043D24838040L,0x00000000612029C4L});
	public static final BitSet FOLLOW_RBRACE_in_valuepart1478 = new BitSet(new long[]{0x0000000000000002L,0x0000000000020000L});
	public static final BitSet FOLLOW_S_in_valuepart1496 = new BitSet(new long[]{0x0000000000000002L,0x0000000000020000L});
	public static final BitSet FOLLOW_selector_in_combined_selector1513 = new BitSet(new long[]{0x0000000800000002L,0x0000000010020100L});
	public static final BitSet FOLLOW_combinator_in_combined_selector1517 = new BitSet(new long[]{0x0044003000018040L});
	public static final BitSet FOLLOW_selector_in_combined_selector1520 = new BitSet(new long[]{0x0000000800000002L,0x0000000010020100L});
	public static final BitSet FOLLOW_GREATER_in_combinator1540 = new BitSet(new long[]{0x0000000000000002L,0x0000000000020000L});
	public static final BitSet FOLLOW_S_in_combinator1542 = new BitSet(new long[]{0x0000000000000002L,0x0000000000020000L});
	public static final BitSet FOLLOW_PLUS_in_combinator1552 = new BitSet(new long[]{0x0000000000000002L,0x0000000000020000L});
	public static final BitSet FOLLOW_S_in_combinator1554 = new BitSet(new long[]{0x0000000000000002L,0x0000000000020000L});
	public static final BitSet FOLLOW_TILDE_in_combinator1564 = new BitSet(new long[]{0x0000000000000002L,0x0000000000020000L});
	public static final BitSet FOLLOW_S_in_combinator1566 = new BitSet(new long[]{0x0000000000000002L,0x0000000000020000L});
	public static final BitSet FOLLOW_S_in_combinator1576 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_IDENT_in_selector1595 = new BitSet(new long[]{0x0044001000018002L,0x0000000000020000L});
	public static final BitSet FOLLOW_ASTERISK_in_selector1599 = new BitSet(new long[]{0x0044001000018002L,0x0000000000020000L});
	public static final BitSet FOLLOW_selpart_in_selector1603 = new BitSet(new long[]{0x0044001000018002L,0x0000000000020000L});
	public static final BitSet FOLLOW_S_in_selector1606 = new BitSet(new long[]{0x0000000000000002L,0x0000000000020000L});
	public static final BitSet FOLLOW_selpart_in_selector1636 = new BitSet(new long[]{0x0044001000018002L,0x0000000000020000L});
	public static final BitSet FOLLOW_S_in_selector1639 = new BitSet(new long[]{0x0000000000000002L,0x0000000000020000L});
	public static final BitSet FOLLOW_HASH_in_selpart1686 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_CLASSKEYWORD_in_selpart1694 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_LBRACE_in_selpart1701 = new BitSet(new long[]{0x0000002000000000L,0x0000000000020000L});
	public static final BitSet FOLLOW_S_in_selpart1703 = new BitSet(new long[]{0x0000002000000000L,0x0000000000020000L});
	public static final BitSet FOLLOW_attribute_in_selpart1706 = new BitSet(new long[]{0x0000000000000000L,0x0000000000002000L});
	public static final BitSet FOLLOW_RBRACE_in_selpart1708 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_pseudo_in_selpart1724 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_INVALID_SELPART_in_selpart1732 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_IDENT_in_attribute1756 = new BitSet(new long[]{0x0000040030880002L,0x0000000000820000L});
	public static final BitSet FOLLOW_S_in_attribute1758 = new BitSet(new long[]{0x0000040030880002L,0x0000000000820000L});
	public static final BitSet FOLLOW_set_in_attribute1766 = new BitSet(new long[]{0x0010002000000000L,0x0000000001020000L});
	public static final BitSet FOLLOW_S_in_attribute1790 = new BitSet(new long[]{0x0010002000000000L,0x0000000001020000L});
	public static final BitSet FOLLOW_IDENT_in_attribute1795 = new BitSet(new long[]{0x0000000000000002L,0x0000000000020000L});
	public static final BitSet FOLLOW_string_in_attribute1799 = new BitSet(new long[]{0x0000000000000002L,0x0000000000020000L});
	public static final BitSet FOLLOW_S_in_attribute1802 = new BitSet(new long[]{0x0000000000000002L,0x0000000000020000L});
	public static final BitSet FOLLOW_pseudocolon_in_pseudo1817 = new BitSet(new long[]{0x0000002400000000L});
	public static final BitSet FOLLOW_IDENT_in_pseudo1821 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_FUNCTION_in_pseudo1825 = new BitSet(new long[]{0x1000082000000000L,0x0000000000020004L});
	public static final BitSet FOLLOW_S_in_pseudo1827 = new BitSet(new long[]{0x1000082000000000L,0x0000000000020004L});
	public static final BitSet FOLLOW_IDENT_in_pseudo1832 = new BitSet(new long[]{0x0000000000000000L,0x0000000000028000L});
	public static final BitSet FOLLOW_MINUS_in_pseudo1836 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000004L});
	public static final BitSet FOLLOW_NUMBER_in_pseudo1839 = new BitSet(new long[]{0x0000000000000000L,0x0000000000028000L});
	public static final BitSet FOLLOW_MINUS_in_pseudo1843 = new BitSet(new long[]{0x0000080000000000L});
	public static final BitSet FOLLOW_INDEX_in_pseudo1846 = new BitSet(new long[]{0x0000000000000000L,0x0000000000028000L});
	public static final BitSet FOLLOW_S_in_pseudo1849 = new BitSet(new long[]{0x0000000000000000L,0x0000000000028000L});
	public static final BitSet FOLLOW_RPAREN_in_pseudo1853 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_COLON_in_pseudocolon1874 = new BitSet(new long[]{0x0000000000010002L});
	public static final BitSet FOLLOW_COLON_in_pseudocolon1876 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_IDENT_in_any1913 = new BitSet(new long[]{0x0000000000000002L,0x0000000000020000L});
	public static final BitSet FOLLOW_CLASSKEYWORD_in_any1924 = new BitSet(new long[]{0x0000000000000002L,0x0000000000020000L});
	public static final BitSet FOLLOW_NUMBER_in_any1935 = new BitSet(new long[]{0x0000000000000002L,0x0000000000020000L});
	public static final BitSet FOLLOW_PERCENTAGE_in_any1946 = new BitSet(new long[]{0x0000000000000002L,0x0000000000020000L});
	public static final BitSet FOLLOW_DIMENSION_in_any1956 = new BitSet(new long[]{0x0000000000000002L,0x0000000000020000L});
	public static final BitSet FOLLOW_string_in_any1967 = new BitSet(new long[]{0x0000000000000002L,0x0000000000020000L});
	public static final BitSet FOLLOW_URI_in_any1981 = new BitSet(new long[]{0x0000000000000002L,0x0000000000020000L});
	public static final BitSet FOLLOW_HASH_in_any1998 = new BitSet(new long[]{0x0000000000000002L,0x0000000000020000L});
	public static final BitSet FOLLOW_UNIRANGE_in_any2012 = new BitSet(new long[]{0x0000000000000002L,0x0000000000020000L});
	public static final BitSet FOLLOW_INCLUDES_in_any2026 = new BitSet(new long[]{0x0000000000000002L,0x0000000000020000L});
	public static final BitSet FOLLOW_COLON_in_any2040 = new BitSet(new long[]{0x0000000000000002L,0x0000000000020000L});
	public static final BitSet FOLLOW_COMMA_in_any2054 = new BitSet(new long[]{0x0000000000000002L,0x0000000000020000L});
	public static final BitSet FOLLOW_GREATER_in_any2068 = new BitSet(new long[]{0x0000000000000002L,0x0000000000020000L});
	public static final BitSet FOLLOW_LESS_in_any2082 = new BitSet(new long[]{0x0000000000000002L,0x0000000000020000L});
	public static final BitSet FOLLOW_QUESTION_in_any2096 = new BitSet(new long[]{0x0000000000000002L,0x0000000000020000L});
	public static final BitSet FOLLOW_PERCENT_in_any2110 = new BitSet(new long[]{0x0000000000000002L,0x0000000000020000L});
	public static final BitSet FOLLOW_EQUALS_in_any2124 = new BitSet(new long[]{0x0000000000000002L,0x0000000000020000L});
	public static final BitSet FOLLOW_SLASH_in_any2138 = new BitSet(new long[]{0x0000000000000002L,0x0000000000020000L});
	public static final BitSet FOLLOW_EXCLAMATION_in_any2152 = new BitSet(new long[]{0x0000000000000002L,0x0000000000020000L});
	public static final BitSet FOLLOW_MINUS_in_any2163 = new BitSet(new long[]{0x0000000000000002L,0x0000000000020000L});
	public static final BitSet FOLLOW_PLUS_in_any2174 = new BitSet(new long[]{0x0000000000000002L,0x0000000000020000L});
	public static final BitSet FOLLOW_ASTERISK_in_any2185 = new BitSet(new long[]{0x0000000000000002L,0x0000000000020000L});
	public static final BitSet FOLLOW_FUNCTION_in_any2202 = new BitSet(new long[]{0x1350043CA4838040L,0x00000000612289C4L});
	public static final BitSet FOLLOW_S_in_any2204 = new BitSet(new long[]{0x1350043CA4838040L,0x00000000612289C4L});
	public static final BitSet FOLLOW_any_in_any2207 = new BitSet(new long[]{0x1350043CA4838040L,0x00000000612089C4L});
	public static final BitSet FOLLOW_RPAREN_in_any2210 = new BitSet(new long[]{0x0000000000000002L,0x0000000000020000L});
	public static final BitSet FOLLOW_DASHMATCH_in_any2230 = new BitSet(new long[]{0x0000000000000002L,0x0000000000020000L});
	public static final BitSet FOLLOW_LPAREN_in_any2244 = new BitSet(new long[]{0x1350043CA4838040L,0x00000000612089C4L});
	public static final BitSet FOLLOW_any_in_any2246 = new BitSet(new long[]{0x1350043CA4838040L,0x00000000612089C4L});
	public static final BitSet FOLLOW_RPAREN_in_any2249 = new BitSet(new long[]{0x0000000000000002L,0x0000000000020000L});
	public static final BitSet FOLLOW_LBRACE_in_any2268 = new BitSet(new long[]{0x1350043CA4838040L,0x00000000612029C4L});
	public static final BitSet FOLLOW_any_in_any2270 = new BitSet(new long[]{0x1350043CA4838040L,0x00000000612029C4L});
	public static final BitSet FOLLOW_RBRACE_in_any2273 = new BitSet(new long[]{0x0000000000000002L,0x0000000000020000L});
	public static final BitSet FOLLOW_S_in_any2291 = new BitSet(new long[]{0x0000000000000002L,0x0000000000020000L});
	public static final BitSet FOLLOW_RCURLY_in_nostatement2306 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_SEMICOLON_in_nostatement2320 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_QUOT_in_nostatement2334 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_APOS_in_nostatement2348 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_CLASSKEYWORD_in_noprop2371 = new BitSet(new long[]{0x0000000000000002L,0x0000000000020000L});
	public static final BitSet FOLLOW_NUMBER_in_noprop2384 = new BitSet(new long[]{0x0000000000000002L,0x0000000000020000L});
	public static final BitSet FOLLOW_COMMA_in_noprop2396 = new BitSet(new long[]{0x0000000000000002L,0x0000000000020000L});
	public static final BitSet FOLLOW_GREATER_in_noprop2408 = new BitSet(new long[]{0x0000000000000002L,0x0000000000020000L});
	public static final BitSet FOLLOW_LESS_in_noprop2420 = new BitSet(new long[]{0x0000000000000002L,0x0000000000020000L});
	public static final BitSet FOLLOW_QUESTION_in_noprop2432 = new BitSet(new long[]{0x0000000000000002L,0x0000000000020000L});
	public static final BitSet FOLLOW_PERCENT_in_noprop2444 = new BitSet(new long[]{0x0000000000000002L,0x0000000000020000L});
	public static final BitSet FOLLOW_EQUALS_in_noprop2456 = new BitSet(new long[]{0x0000000000000002L,0x0000000000020000L});
	public static final BitSet FOLLOW_SLASH_in_noprop2468 = new BitSet(new long[]{0x0000000000000002L,0x0000000000020000L});
	public static final BitSet FOLLOW_EXCLAMATION_in_noprop2480 = new BitSet(new long[]{0x0000000000000002L,0x0000000000020000L});
	public static final BitSet FOLLOW_PLUS_in_noprop2492 = new BitSet(new long[]{0x0000000000000002L,0x0000000000020000L});
	public static final BitSet FOLLOW_ASTERISK_in_noprop2504 = new BitSet(new long[]{0x0000000000000002L,0x0000000000020000L});
	public static final BitSet FOLLOW_DASHMATCH_in_noprop2519 = new BitSet(new long[]{0x0000000000000002L,0x0000000000020000L});
	public static final BitSet FOLLOW_INCLUDES_in_noprop2531 = new BitSet(new long[]{0x0000000000000002L,0x0000000000020000L});
	public static final BitSet FOLLOW_COLON_in_noprop2543 = new BitSet(new long[]{0x0000000000000002L,0x0000000000020000L});
	public static final BitSet FOLLOW_STRING_CHAR_in_noprop2555 = new BitSet(new long[]{0x0000000000000002L,0x0000000000020000L});
	public static final BitSet FOLLOW_CTRL_in_noprop2568 = new BitSet(new long[]{0x0000000000000002L,0x0000000000020000L});
	public static final BitSet FOLLOW_INVALID_TOKEN_in_noprop2580 = new BitSet(new long[]{0x0000000000000002L,0x0000000000020000L});
	public static final BitSet FOLLOW_S_in_noprop2593 = new BitSet(new long[]{0x0000000000000002L,0x0000000000020000L});
	public static final BitSet FOLLOW_NUMBER_in_norule2608 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_PERCENTAGE_in_norule2621 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_DIMENSION_in_norule2633 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_string_in_norule2646 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_URI_in_norule2660 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_UNIRANGE_in_norule2677 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_INCLUDES_in_norule2691 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_COMMA_in_norule2705 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_GREATER_in_norule2719 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_LESS_in_norule2733 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_QUESTION_in_norule2747 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_PERCENT_in_norule2761 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_EQUALS_in_norule2775 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_SLASH_in_norule2789 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_EXCLAMATION_in_norule2803 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_MINUS_in_norule2816 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_PLUS_in_norule2829 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_DASHMATCH_in_norule2843 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_RPAREN_in_norule2857 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_CTRL_in_norule2871 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_101_in_norule2885 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_102_in_norule2896 = new BitSet(new long[]{0x0000000000000002L});
}
