<!doctype html>
<html>
    <head>
        <meta name="viewport" content="width=device-width">
        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
        <title>Serenity BDD Test Results - L1 Controls Navigator</title>
        <style media="all" type="text/css">/* -------------------------------------
        GLOBAL RESETS
    ------------------------------------- */
body {
    font-family: Helvetica, sans-serif;
    -webkit-font-smoothing: antialiased;
    font-size: 14px;
    line-height: 1.4;
    -ms-text-size-adjust: 100%;
    -webkit-text-size-adjust: 100%;
    background-color: #f6f6f6;
    margin: 0;
    padding: 0;
    width: 100%;
}

table {
    border-collapse: separate;
    mso-table-lspace: 0pt;
    mso-table-rspace: 0pt;
    width: 100%;
}

table td {
    font-family: Helvetica, sans-serif;
    font-size: 14px;
    vertical-align: top;
}

.container {
    margin: 0 auto !important;
    max-width: 600px;
    padding: 0;
    padding-top: 24px;
    width: 600px;
}

.content {
    box-sizing: border-box;
    display: block;
    margin: 0 auto;
    max-width: 600px;
    padding: 0;
}

.main {
    background: #fff;
    border-radius: 4px;
    width: 100%;
}

.wrapper {
    box-sizing: border-box;
    padding: 24px;
}

.compact-wrapper {
    box-sizing: border-box;
    padding-left: 24px;
    padding-top: 4px;
    padding-bottom: 4px;
}

.content-block {
    padding-top: 0;
    padding-bottom: 24px;
}

.flush-top {
    margin-top: 0;
    padding-top: 0;
}

.flush-bottom {
    margin-bottom: 0;
    padding-bottom: 0;
}

.header {
    margin-bottom: 24px;
    margin-top: 0;
    width: 100%;
}

.header > table {
    min-width: 100%;
}

.footer {
    clear: both;
    padding-top: 24px;
    text-align: center;
    width: 100%;
}

.footer td,
.footer p,
.footer span,
.footer a {
    color: #999999;
    font-size: 12px;
    text-align: center;
}

.section-callout {
    background-color: #1abc9c;
    color: #ffffff;
}

.section-callout h1,
.section-callout h2,
.section-callout h3,
.section-callout h4,
.section-callout p,
.section-callout li,
.section-callout td {
    color: #ffffff;
}

.section-callout-subtle {
    background-color: #f7f7f7;
    border-bottom: 1px solid #e9e9e9;
    border-top: 1px solid #e9e9e9;
}

.span-2,
.span-3 {
    display: inline-block;
    margin-bottom: 24px;
    vertical-align: top;
    width: 100%;
}

.span-2 > table,
.span-3 > table {
    padding-left: 24px;
    padding-right: 24px;
}

.span-3 {
    max-width: 298px;
}

.span-3 > table {
    max-width: 298px;
}

.span-2 {
    max-width: 197px;
}

.span-2 > table {
    max-width: 197px;
}

/* -------------------------------------
                RESPONSIVE AND MOBILE FRIENDLY STYLES
            ------------------------------------- */
@media only screen and (max-width: 640px) {
    .span-2,
    .span-3 {
        float: none !important;
        max-width: none !important;
        width: 100% !important;
    }

    .span-2 > table,
    .span-3 > table {
        max-width: 100% !important;
        width: 100% !important;
    }
}

/* -------------------------------------
                TYPOGRAPHY
            ------------------------------------- */
h1,
h2,
h3,
h4 {
    color: #222222;
    font-family: Helvetica, sans-serif;
    font-weight: 400;
    line-height: 1.4;
    margin: 0;
}

h1 {
    font-size: 36px;
    font-weight: 300;
    margin-bottom: 24px;
    text-align: center;
    text-transform: capitalize;
}

h2 {
    font-size: 28px;
    margin-bottom: 16px;
}

h3 {
    font-size: 22px;
    margin-bottom: 8px;
}

h4 {
    font-size: 14px;
    font-weight: 500;
    margin-bottom: 8px;
}

.alert {
    min-width: 100%;
}

.alert td {
    border-radius: 4px 4px 0 0;
    color: #ffffff;
    font-size: 14px;
    font-weight: 400;
    padding: 24px;
    text-align: center;
}

.alert a {
    color: #ffffff;
    font-size: 14px;
    font-weight: 400;
    text-decoration: none;
}

.alert.alert-warning td {
    background-color: #f39c12;
}

.alert.alert-danger td {
    background-color: #c0392b;
}

.alert.alert-success td {
    background-color: #1abc9c;
}

.last {
    margin-bottom: 0;
}

.first {
    margin-top: 0;
}

.align-center {
    text-align: center;
}

.align-right {
    text-align: right;
}

.align-left {
    text-align: left;
}

.text-link {
    color: #3498db !important;
    text-decoration: underline !important;
}

.clear {
    clear: both;
}

.mt0 {
    margin-top: 0;
}

.mb0 {
    margin-bottom: 0;
}

.preheader {
    color: transparent;
    display: none;
    height: 0;
    max-height: 0;
    max-width: 0;
    opacity: 0;
    overflow: hidden;
    mso-hide: all;
    visibility: hidden;
    width: 0;
}

.powered-by a {
    text-decoration: none;
}

.hr tr:first-of-type td,
.hr tr:last-of-type td {
    height: 24px;
    line-height: 24px;
}

.hr tr:nth-of-type(2) td {
    background-color: #f6f6f6;
    height: 1px;
    line-height: 1px;
    width: 100%;
}

/* -------------------------------------
                RESPONSIVE AND MOBILE FRIENDLY STYLES
            ------------------------------------- */
@media only screen and (max-width: 640px) {
    h1 {
        font-size: 36px !important;
        margin-bottom: 16px !important;
    }

    h2 {
        font-size: 28px !important;
        margin-bottom: 8px !important;
    }

    h3 {
        font-size: 22px !important;
        margin-bottom: 8px !important;
    }

    .main p,
    .main ul,
    .main ol,
    .main td,
    .main span {
        font-size: 16px !important;
    }

    .wrapper {
        padding: 8px !important;
    }

    .complact-wrapper {
        padding-left: 8px !important;
        padding-right: 8px !important;
        padding-top: 2px !important;
        padding-bottom: 2px !important;
    }

    .article {
        padding-left: 8px !important;
        padding-right: 8px !important;
    }

    .content {
        padding: 0 !important;
    }

    .container {
        padding: 0 !important;
        padding-top: 8px !important;
        width: 100% !important;
    }

    .header {
        margin-bottom: 8px !important;
        margin-top: 0 !important;
    }

    .main {
        border-left-width: 0 !important;
        border-radius: 0 !important;
        border-right-width: 0 !important;
    }

    .btn table {
        max-width: 100% !important;
        width: 100% !important;
    }

    .btn a {
        font-size: 16px !important;
        max-width: 100% !important;
        width: 100% !important;
    }

    .img-responsive {
        height: auto !important;
        max-width: 100% !important;
        width: auto !important;
    }

    .alert td {
        border-radius: 0 !important;
        font-size: 16px !important;
        padding-bottom: 16px !important;
        padding-left: 8px !important;
        padding-right: 8px !important;
        padding-top: 16px !important;
    }

    .receipt,
    .receipt-container {
        width: 100% !important;
    }

    .hr tr:first-of-type td,
    .hr tr:last-of-type td {
        height: 16px !important;
        line-height: 16px !important;
    }
}

/* -------------------------------------
                PRESERVE THESE STYLES IN THE HEAD
            ------------------------------------- */
@media all {
    .ExternalClass {
        width: 100%;
    }

    .ExternalClass,
    .ExternalClass p,
    .ExternalClass span,
    .ExternalClass font,
    .ExternalClass td,
    .ExternalClass div {
        line-height: 100%;
    }

    .apple-link a {
        color: inherit !important;
        font-family: inherit !important;
        font-size: inherit !important;
        font-weight: inherit !important;
        line-height: inherit !important;
        text-decoration: none !important;
    }
}

/* -------------------------------------
               CHART STYLES
            ------------------------------------- */
.block {
    margin: 0px 25px 0 0;
    border-radius: 5px;
    float: left;
    width: 300px;
    overflow: hidden;
}

.donut-chart-block {
    overflow: hidden;
}

.donut-chart {
    position: relative;
    background: white;
    width: 200px;
    height: 200px;
    margin: 2rem auto;
    border-radius: 100%;
}

.donut-chart .center {
    background: white;
    position: absolute;
    top: 35px;
    left: 35px;
    height: 130px;
    width: 130px;
    border-radius: 70px;
}

.clip {
    border-radius: 50%;
    clip: rect(0px, 200px, 200px, 100px);
    height: 100%;
    position: absolute;
    width: 100%;
}

.item {
    border-radius: 50%;
    clip: rect(0px, 100px, 200px, 0px);
    height: 100%;
    position: absolute;
    width: 100%;
    font-family: monospace;
    font-size: 1.5rem;
}

ul {
    list-style-type: none;
    margin: 0;
    padding: 0;
}

.test-suite-title {
    font-size: 1.3em;
    color: white;
    font-weight: bold;
}

/* -------------------------------------
        TEST RESULTS
    ------------------------------------- */
#passing_test {
    transform: rotate(${results.degreesByResult.SUCCESS.startDegrees}deg);
}

#passing_test .item {
    background-color: #61bd76;
    transform: rotate(${results.degreesByResult.SUCCESS.deltaDegrees}deg);
}

#pending_test {
    transform: rotate(${results.degreesByResult.PENDING.startDegrees}deg);
}

#pending_test .item {
    background-color: #92dcce;
    transform: rotate(${results.degreesByResult.PENDING.deltaDegrees}deg);
}

#ignored_tests {
    transform: rotate(${results.degreesByResult.IGNORED.startDegrees}deg);
}

#ignored_tests .item {
    background-color: #acb1b9;
    transform: rotate(${results.degreesByResult.IGNORED.deltaDegrees}deg);
}

#failing_tests {
    transform: rotate(${results.degreesByResult.FAILURE.startDegrees}deg);
}

#failing_tests .item {
    background-color: #f33446;
    transform: rotate(${results.degreesByResult.FAILURE.deltaDegrees}deg);
}

#error_tests {
    transform: rotate(${results.degreesByResult.ERROR.startDegrees}deg);
}

#error_tests .item {
    background-color: #FCB150;
    transform: rotate(${results.degreesByResult.ERROR.deltaDegrees}deg);
}

#compromised_tests {
    transform: rotate(${results.degreesByResult.COMPROMISED.startDegrees}deg);
}

#compromised_tests .item {
    background-color: #a4528b;
    transform: rotate(${results.degreesByResult.COMPROMISED.deltaDegrees}deg);
}

.legend {
    border-color: #acb1b9;
    border-style: solid;
    border-width: 1px;
    margin-top: 50px;
}

.legend .overview {
    font-weight: bold;
    font-size: 1.2em;
    color: white;
    background-color: #69727f;
    padding-bottom: 4px;
    padding-top: 4px;
    padding-left: 15px;
}

.passing {
    color: #61bd76;
}

.failing {
    color: #f44336;
}

.error {
    color: #FCB150;
}

.pending {
    color: #92dcce;
}

.ignored {
    color: #acb1b9;
}

.compromised {
    color: #7a306c;
}

.legend-key {
    font-weight: bold;
    padding-left: 4px;
}

.legend-value {
    color: #69727f;
    float: right;
    padding-right: 4px;
}

.environment {
    border-style: solid;
    border-width: 1px;
    border-color: #acb1b9;
}

.environment td {
    color: #69727f;
    font-size: 0.9em;
    text-align: center;
}

.result-bar {
    width: 150px;
}

.result-bar td {
    width: 150px;
    text-align: center;
    font-size: 0.9em;
}

.bar-passed {
    background-color: #61bd76;
    color: white;
}

.bar-failed {
    background-color: #f44336;
    color: white;
}

.bar-error {
    background-color: #FCB150;
    color: white;
}

.bar-pending {
    background-color: #92dcce;
    color: white;
}

.bar-ignored {
    background-color: #acb1b9;
    color: white;
}

.bar-compromised {
    height: 20px;
    background-color: #7a306c;
    color: white;
}

.frequent-failures {
    border-style: solid;
    border-width: 1px;
    border-color: #acb1b9;
}

.for-passed {
    background-color: #61bd76;
}

.for-failure {
    background-color: #f44336;
}

.for-error {
    background-color: #FCB150;
}

.for-pending {
    background-color: #92dcce;
}

.for-ignored {
    background-color: #acb1b9;
}

.for-compromised {
    background-color: #7a306c;
}

.count-badge {
    border-radius: 4px;
    padding: 2px;
    padding-left: 4px;
    padding-right: 4px;
    color: white;
    font-size: 0.9em;
    font-weight: bold;
}

h4 {
    font-size: 18px;
}</style>
        <!--[if gte mso 9]>
    <xml>
        <o:OfficeDocumentSettings>
            <o:AllowPNG/>
            <o:PixelsPerInch>96</o:PixelsPerInch>
        </o:OfficeDocumentSettings>
    </xml>
    <![endif]-->
    </head>
    <body>
        <table border="0" cellpadding="0" cellspacing="0" class="body">
            <tr>
                <td>&nbsp;</td>
                <td class="container">
                    <div class="content">
                        <!-- START CENTERED WHITE CONTAINER -->
                        <table border="0" cellpadding="0" cellspacing="0" class="main">
                            <!-- START NOTIFICATION BANNER -->
                            <tr>
                                <td>
                                    <table border="0" cellpadding="0" cellspacing="0" class="alert alert-success">
                                        <tr>
                                            <td align="center"><span class="test-suite-title"><span>Test Report - ${report.title}</span></span></td>
                                        </tr>
                                    </table>
                                </td>
                            </tr>
                            <!-- END NOTIFICATION BANNER -->
                            <!-- START MAIN CONTENT AREA -->
                            <tr>
                                <td class="wrapper">
                                    <table border="0" cellpadding="0" cellspacing="0">
                                        <tr>
                                            <td>
                                                <div class="donut-chart-block block">
                                                    <div class="donut-chart">
                                                        <div id="passing_test" class="clip">
                                                            <div class="item" data-rel="${results.countByResult.SUCCESS}"></div>
                                                        </div>
                                                        <div id="pending_test" class="clip">
                                                            <div class="item" data-rel="${results.countByResult.PENDING}"></div>
                                                        </div>
                                                        <div id="ignored_tests" class="clip">
                                                            <div class="item" data-rel="${results.countByResult.IGNORED}"></div>
                                                        </div>
                                                        <div id="failing_tests" class="clip">
                                                            <div class="item" data-rel="${results.countByResult.FAILURE}"></div>
                                                        </div>
                                                        <div id="error_tests" class="clip">
                                                            <div class="item" data-rel="${results.countByResult.ERROR}"></div>
                                                        </div>
                                                        <div id="compromised_tests" class="clip">
                                                            <div class="item" data-rel="${results.countByResult.COMPROMISED}"></div>
                                                        </div>
                                                        <div class="center"></div>
                                                    </div>
                                                </div>
                                            </td>
                                            <td>
                                                <table>
                                                    <tr>
                                                        <td>
                                                            <table class="legend" cellspacing="0" cellpadding="2">
                                                                <tr>
                                                                    <td class="overview" colspan="3">${results.totalCount} test<#if (results.totalCount != 1)>s</#if> executed</td>
                                                                </tr>
                                                                <tr class="passing">
                                                                    <td class="legend-key" style="width:67%">Passing</td>
                                                                    <td class> <span class="count-badge for-passed">${results.countByResult.SUCCESS}</span> </td>
                                                                    <td class="legend-value">(${results.percentageByResult.SUCCESS}%)</td>
                                                                </tr>
                                                                <tr class="pending">
                                                                    <td class="legend-key" style="width:67%">Pending</td>
                                                                    <td class> <span class="count-badge for-pending">${results.countByResult.PENDING}</span> </td>
                                                                    <td class="legend-value">(${results.percentageByResult.PENDING}%)</td>
                                                                </tr>
                                                                <tr class="ignored">
                                                                    <td class="legend-key" style="width:67%">Ignored</td>
                                                                    <td class> <span class="count-badge for-ignored">${results.countByResult.IGNORED}</span> </td>
                                                                    <td class="legend-value">(${results.percentageByResult.IGNORED}%)</td>
                                                                </tr>
                                                                <tr class="failing">
                                                                    <td class="legend-key" style="width:67%">Failing</td>
                                                                    <td class> <span class="count-badge for-failure">${results.countByResult.FAILURE}</span> </td>
                                                                    <td class="legend-value">(${results.percentageByResult.FAILURE}%)</td>
                                                                </tr>
                                                                <tr class="error">
                                                                    <td class="legend-key" style="width:67%">Broken</td>
                                                                    <td class> <span class="count-badge for-error">${results.countByResult.ERROR}</span> </td>
                                                                    <td class="legend-value">(${results.percentageByResult.ERROR}%)</td>
                                                                </tr>
                                                                <tr class="compromised">
                                                                    <td class="legend-key" style="width:67%">Compromised</td>
                                                                    <td class> <span class="count-badge for-compromised">${results.countByResult.COMPROMISED}</span> </td>
                                                                    <td class="legend-value">(${results.percentageByResult.COMPROMISED}%)</td>
                                                                </tr>
                                                            </table>
                                                        </td>
                                                    </tr>
                                                </table>
                                            </td>
                                        </tr>
                                    </table>
                                </td>
                            </tr>
                            <tr>
                                <td class="wrapper">
                                    <table class="environment">
                                        <tr>
                                            <th>Environment</th>
                                            <th>Version</th>
                                            <th>Host Name</th>
                                            <th>User</th>
                                            <th>Exeution Time</th>
                                        </tr>
                                        <tr>
                                            <td>NAV Automation INT6</td>
                                            <td>INT NAV 13.6.0</td>
                                            <td>INBOMVD123456</td>
                                            <td>madbpon</td>
                                            <td>3h 23m 33s</td>
                                        </tr>
                                    </table>
                                </td>
                            </tr>
                            <tr>
                                <td class="compact-wrapper"><h3>Functional Coverage</h3></td>
                            </tr>
                            <tr>
                                <td class="compact-wrapper">
                                    <h4>Control Creation</h4>
                                    <table class="compact-wrapper">
                                        <tr>
                                            <th></th>
                                            <th>Tests</th>
                                            <th>Pass</th>
                                            <th>Results</th>
                                        </tr>
                                        <tr>
                                            <td>ACO Acknowledgement - ICG Debt</td>
                                            <td>100</td>
                                            <td>10%</td>
                                            <td>
                                                <table cellspacing="0" cellpadding="0" class="result-bar">
                                                    <tr>
                                                        <td class="bar-passed" style="width:10%">10</td>
                                                        <td class="bar-failed" style="width:20%">20</td>
                                                        <td class="bar-error" style="width:5%">5</td>
                                                        <td class="bar-pending" style="width:10%">10</td>
                                                        <td class="bar-ignored" style="width:35%">35</td>
                                                        <td class="bar-compromised" style="width:15%">15</td>
                                                    </tr>
                                                </table>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td>Deal Not Logged Propertly - Breach Review</td>
                                            <td>100</td>
                                            <td>70%</td>
                                            <td>
                                                <table cellspacing="0" cellpadding="0" class="result-bar">
                                                    <tr>
                                                        <td class="bar-passed" style="width:70%">70</td>
                                                        <td class="bar-failed" style="width:20%">20</td>
                                                        <td class="bar-error" style="width:10%">10</td>
                                                    </tr>
                                                </table>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td>Dodd-Frank Control</td>
                                            <td>100</td>
                                            <td>30%</td>
                                            <td>
                                                <table cellspacing="0" cellpadding="0" class="result-bar">
                                                    <tr>
                                                        <td class="bar-passed" style="width:30%">30</td>
                                                        <td class="bar-failed" style="width:20%">20</td>
                                                        <td class="bar-error" style="width:5%">5</td>
                                                        <td class="bar-pending" style="width:10%">10</td>
                                                        <td class="bar-ignored" style="width:35%">35</td>
                                                        <td class="bar-compromised" style="width:0%"></td>
                                                    </tr>
                                                </table>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td>PA Dealing  - Breach Review</td>
                                            <td>100</td>
                                            <td>10%</td>
                                            <td>
                                                <table cellspacing="0" cellpadding="0" class="result-bar">
                                                    <tr>
                                                        <td class="bar-passed" style="width:10%">10</td>
                                                        <td class="bar-failed" style="width:20%">20</td>
                                                        <td class="bar-error" style="width:0%"></td>
                                                        <td class="bar-pending" style="width:15%">15</td>
                                                        <td class="bar-ignored" style="width:35%">35</td>
                                                        <td class="bar-compromised" style="width:15%">15</td>
                                                    </tr>
                                                </table>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td>Review of Team Licenses</td>
                                            <td>100</td>
                                            <td>70%</td>
                                            <td>
                                                <table cellspacing="0" cellpadding="0" class="result-bar">
                                                    <tr>
                                                        <td class="bar-passed" style="width:70%">10</td>
                                                        <td class="bar-failed" style="width:30%">20</td>
                                                        <td class="bar-error" style="width:0%"></td>
                                                        <td class="bar-pending" style="width:0%"></td>
                                                        <td class="bar-ignored" style="width:0%"></td>
                                                        <td class="bar-compromised" style="width:0%"></td>
                                                    </tr>
                                                </table>
                                            </td>
                                        </tr>
                                    </table>
                                </td>
                            </tr>
                            <tr>
                                <td class="compact-wrapper">
                                    <h4>Control Sumbission</h4>
                                    <table class="compact-wrapper">
                                        <tr>
                                            <th></th>
                                            <th>Tests</th>
                                            <th>Pass</th>
                                            <th>Results</th>
                                        </tr>
                                        <tr>
                                            <td>ACO Acknowledgement - ICG Debt</td>
                                            <td>100</td>
                                            <td>10%</td>
                                            <td>
                                                <table cellspacing="0" cellpadding="0" class="result-bar">
                                                    <tr>
                                                        <td class="bar-passed" style="width:10%">10</td>
                                                        <td class="bar-failed" style="width:20%">20</td>
                                                        <td class="bar-error" style="width:5%">5</td>
                                                        <td class="bar-pending" style="width:10%">10</td>
                                                        <td class="bar-ignored" style="width:35%">35</td>
                                                        <td class="bar-compromised" style="width:15%">15</td>
                                                    </tr>
                                                </table>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td>Deal Not Logged Propertly - Breach Review</td>
                                            <td>100</td>
                                            <td>70%</td>
                                            <td>
                                                <table cellspacing="0" cellpadding="0" class="result-bar">
                                                    <tr>
                                                        <td class="bar-passed" style="width:70%">70</td>
                                                        <td class="bar-failed" style="width:20%">20</td>
                                                        <td class="bar-error" style="width:10%">10</td>
                                                    </tr>
                                                </table>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td>Dodd-Frank Control</td>
                                            <td>100</td>
                                            <td>30%</td>
                                            <td>
                                                <table cellspacing="0" cellpadding="0" class="result-bar">
                                                    <tr>
                                                        <td class="bar-passed" style="width:30%">30</td>
                                                        <td class="bar-failed" style="width:20%">20</td>
                                                        <td class="bar-error" style="width:5%">5</td>
                                                        <td class="bar-pending" style="width:10%">10</td>
                                                        <td class="bar-ignored" style="width:35%">35</td>
                                                        <td class="bar-compromised" style="width:0%"></td>
                                                    </tr>
                                                </table>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td>PA Dealing  - Breach Review</td>
                                            <td>100</td>
                                            <td>10%</td>
                                            <td>
                                                <table cellspacing="0" cellpadding="0" class="result-bar">
                                                    <tr>
                                                        <td class="bar-passed" style="width:10%">10</td>
                                                        <td class="bar-failed" style="width:20%">20</td>
                                                        <td class="bar-error" style="width:0%"></td>
                                                        <td class="bar-pending" style="width:15%">15</td>
                                                        <td class="bar-ignored" style="width:35%">35</td>
                                                        <td class="bar-compromised" style="width:15%">15</td>
                                                    </tr>
                                                </table>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td>Review of Team Licenses</td>
                                            <td>100</td>
                                            <td>70%</td>
                                            <td>
                                                <table cellspacing="0" cellpadding="0" class="result-bar">
                                                    <tr>
                                                        <td class="bar-passed" style="width:70%">10</td>
                                                        <td class="bar-failed" style="width:30%">20</td>
                                                        <td class="bar-error" style="width:0%"></td>
                                                        <td class="bar-pending" style="width:0%"></td>
                                                        <td class="bar-ignored" style="width:0%"></td>
                                                        <td class="bar-compromised" style="width:0%"></td>
                                                    </tr>
                                                </table>
                                            </td>
                                        </tr>
                                    </table>
                                </td>
                            </tr>
                            <tr>
                                <td class="compact-wrapper"><h3>Test Failures</h3></td>
                            </tr>
                            <tr>
                                <td class="compact-wrapper">
                                    <table>
                                        <tr>
                                            <td>
                                                <table class="frequent-failures">
                                                    <tr>
                                                        <th colspan="2">Most Frequent Failures</th>
                                                    </tr>
                                                    <tr class="failing">
                                                        <td width="100%">Web Element Not Found</td>
                                                        <td><span class="count-badge for-failure">100</span></td>
                                                    </tr>
                                                    <tr class="error">
                                                        <td width="100%">Assertion Error</td>
                                                        <td><span class="count-badge for-error">50</span></td>
                                                    </tr>
                                                    <tr class="failing">
                                                        <td width="100%">Control Unavailable</td>
                                                        <td><span class="count-badge for-failure">30</span></td>
                                                    </tr>
                                                </table>
                                            </td>
                                            <td>
                                                <table class="frequent-failures">
                                                    <tr>
                                                        <th>Most Unstable Features</th>
                                                        <th>Failures</th>
                                                    </tr>
                                                    <tr class="failing">
                                                        <td width="100%">ACO Acknowledgement</td>
                                                        <td><span class="count-badge for-failure">100</span></td>
                                                    </tr>
                                                    <tr class="failing">
                                                        <td width="100%" class="failure">Submiting Evidence</td>
                                                        <td><span class="count-badge for-failure">50</span></td>
                                                    </tr>
                                                    <tr class="failing">
                                                        <td width="100%">Control Delegation</td>
                                                        <td><span class="count-badge for-failure">30</span></td>
                                                    </tr>
                                                </table>
                                            </td>
                                        </tr>
                                    </table>
                                </td>
                            </tr>
                            <tr class="footer">
                                <td>Report produced by Serenity BDD</td>
                            </tr>
                            <!-- END MAIN CONTENT AREA -->
                        </table>
                        <!-- END CENTERED WHITE CONTAINER -->
                    </div>
                </td>
                <td>&nbsp;</td>
            </tr>
        </table>
    </body>
</html>