/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.screenplay.conditions;

import com.google.common.collect.Maps;
import java.util.Map;
import net.serenitybdd.screenplay.Actor;
import net.serenitybdd.screenplay.Performable;
import net.serenitybdd.screenplay.conditions.SilentPerformable;

public abstract class ConditionalPerformable
implements Performable {
    protected final Map<Boolean, Performable> outcomeToPerform = Maps.newHashMap();

    public ConditionalPerformable() {
        this.outcomeToPerform.put(true, new SilentPerformable());
        this.outcomeToPerform.put(false, new SilentPerformable());
    }

    public ConditionalPerformable andIfSo(Performable taskToPerform) {
        this.outcomeToPerform.put(true, taskToPerform);
        return this;
    }

    public ConditionalPerformable otherwise(Performable taskToPerform) {
        this.outcomeToPerform.put(false, taskToPerform);
        return this;
    }

    @Override
    public <T extends Actor> void performAs(T actor) {
        actor.attemptsTo(this.outcomeToPerform.get(this.evaluatedConditionFor(actor)));
    }

    protected abstract Boolean evaluatedConditionFor(Actor var1);
}

