/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.screenplay.questions;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.serenitybdd.screenplay.Actor;
import net.serenitybdd.screenplay.EnumValues;
import net.serenitybdd.screenplay.Question;
import net.serenitybdd.screenplay.questions.TargetedUIState;
import net.serenitybdd.screenplay.targets.Target;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class UIStateReaderBuilder<T> {
    private final Target target;
    private final Class<T> type;
    private String subject;
    private final Optional<String> optionalParameter;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public UIStateReaderBuilder(Target target, Class<T> type) {
        this.target = target;
        this.type = type;
        this.subject = target.getName();
        this.optionalParameter = Optional.empty();
    }

    public UIStateReaderBuilder(Target target, Class<T> type, Optional<String> optionalParameter) {
        this.target = target;
        this.type = type;
        this.subject = target.getName();
        this.optionalParameter = optionalParameter;
    }

    public UIStateReaderBuilder<T> describedAs(String subject) {
        this.subject = subject;
        return this;
    }

    public <T> Question<T> map(Function<String, T> transformer) {
        return Question.about((String)this.subject).answeredBy(actor -> transformer.apply((String)this.asAString().answeredBy(actor)));
    }

    public Question<String> asAString() {
        return Question.about((String)this.subject).answeredBy(actor -> ((TargetedUIState)this.viewedBy(actor)).asString());
    }

    public Question<LocalDate> asADate() {
        return Question.about((String)this.subject).answeredBy(actor -> ((TargetedUIState)this.viewedBy(actor)).asLocalDate());
    }

    public Question<LocalDate> asADate(String format) {
        return Question.about((String)this.subject).answeredBy(actor -> ((TargetedUIState)this.viewedBy(actor)).asLocalDate(format));
    }

    public Question<BigDecimal> asABigDecimal() {
        return Question.about((String)this.subject).answeredBy(actor -> ((TargetedUIState)this.viewedBy(actor)).asBigDecimal());
    }

    public Question<Boolean> asABoolean() {
        return Question.about((String)this.subject).answeredBy(actor -> ((TargetedUIState)this.viewedBy(actor)).asBoolean());
    }

    public Question<Double> asDouble() {
        return Question.about((String)this.subject).answeredBy(actor -> ((TargetedUIState)this.viewedBy(actor)).asDouble());
    }

    public Question<Float> asFloat() {
        return Question.about((String)this.subject).answeredBy(actor -> ((TargetedUIState)this.viewedBy(actor)).asFloat());
    }

    public Question<Long> asLong() {
        return Question.about((String)this.subject).answeredBy(actor -> ((TargetedUIState)this.viewedBy(actor)).asLong());
    }

    public Question<Integer> asInteger() {
        return Question.about((String)this.subject).answeredBy(actor -> ((TargetedUIState)this.viewedBy(actor)).asInteger());
    }

    public <T> Question<T> asEnum(Class<T> enumType) {
        return Question.about((String)this.subject).answeredBy(actor -> EnumValues.forType((Class)enumType).getValueOf(((TargetedUIState)this.viewedBy(actor)).asString()));
    }

    public Question<Collection<String>> asACollection() {
        return Question.about((String)this.subject).answeredBy(actor -> ((TargetedUIState)this.viewedBy(actor)).asList());
    }

    public <E> Question<Collection<E>> asACollectionOf(Class<E> type) {
        return Question.about((String)this.subject).answeredBy(actor -> ((TargetedUIState)this.viewedBy(actor)).asListOf(type));
    }

    public Question<List<String>> asAList() {
        return Question.about((String)this.subject).answeredBy(actor -> ((TargetedUIState)this.viewedBy(actor)).asList());
    }

    public <E> Question<List<E>> asAListOf(Class<E> type) {
        return Question.about((String)this.subject).answeredBy(actor -> ((TargetedUIState)this.viewedBy(actor)).asListOf(type));
    }

    public T viewedBy(Actor actor) {
        try {
            if (this.optionalParameter.isPresent()) {
                return this.type.getConstructor(Target.class, Actor.class, String.class).newInstance(this.target, actor, this.optionalParameter.get());
            }
            return this.type.getConstructor(Target.class, Actor.class).newInstance(this.target, actor);
        }
        catch (Exception e) {
            this.logger.error("Failed to instantiate UIStateReader of type " + this.type, (Throwable)e);
            throw new IllegalStateException("Failed to instantiate UIStateReader of type " + this.type, e);
        }
    }
}

