/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.screenplay.questions;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.serenitybdd.core.pages.WebElementFacade;
import net.serenitybdd.screenplay.Question;
import net.serenitybdd.screenplay.abilities.BrowseTheWeb;
import net.serenitybdd.screenplay.questions.QuestionForName;
import net.serenitybdd.screenplay.questions.QuestionForNames;
import net.serenitybdd.screenplay.targets.Target;
import org.openqa.selenium.By;

public class Attribute {
    public static Question<String> of(Target target, String attributeName) {
        return Question.about((String)(attributeName + " attribute of " + target.getName())).answeredBy(actor -> Attribute.matches(target.resolveAllFor(actor), attributeName));
    }

    public static Question<String> of(By byLocator, String attributeName) {
        return Question.about((String)(attributeName + " attribute of " + attributeName)).answeredBy(actor -> Attribute.matches((List<WebElementFacade>)BrowseTheWeb.as(actor).findAll(byLocator), attributeName));
    }

    public static Question<String> of(String locator, String attributeName) {
        return Question.about((String)(attributeName + " attribute of " + locator)).answeredBy(actor -> Attribute.matches((List<WebElementFacade>)BrowseTheWeb.as(actor).findAll(locator, new Object[0]), attributeName));
    }

    public static Question<Collection<String>> ofEach(Target target, String attributeName) {
        return Question.about((String)(attributeName + " attribute of each " + target.getName())).answeredBy(actor -> target.resolveAllFor(actor).stream().map(element -> Attribute.matches(Collections.singletonList(element), attributeName)).collect(Collectors.toList()));
    }

    public static Question<Collection<String>> ofEach(By byLocator, String attributeName) {
        return Question.about((String)(attributeName + " attribute of each " + byLocator)).answeredBy(actor -> BrowseTheWeb.as(actor).findAll(byLocator).stream().map(element -> Attribute.matches(Collections.singletonList(element), attributeName)).collect(Collectors.toList()));
    }

    public static Question<Collection<String>> ofEach(String locator, String attributeName) {
        return Question.about((String)(attributeName + " attribute of each " + locator)).answeredBy(actor -> BrowseTheWeb.as(actor).findAll(locator, new Object[0]).stream().map(element -> Attribute.matches(Collections.singletonList(element), attributeName)).collect(Collectors.toList()));
    }

    public static QuestionForName of(Target target) {
        return name -> Attribute.of(target, name);
    }

    public static QuestionForName of(By byLocator) {
        return name -> Attribute.of(byLocator, name);
    }

    public static QuestionForName of(String locator) {
        return name -> Attribute.of(locator, name);
    }

    public static QuestionForNames ofEach(Target target) {
        return name -> Attribute.ofEach(target, name);
    }

    public static QuestionForNames ofEach(By byLocator) {
        return name -> Attribute.ofEach(byLocator, name);
    }

    public static QuestionForNames ofEach(String locator) {
        return name -> Attribute.ofEach(locator, name);
    }

    private static String matches(List<WebElementFacade> elements, String attributeName) {
        return elements.stream().findFirst().map(element -> element.getAttribute(attributeName)).orElse("");
    }
}

