/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.screenplay.matchers.statematchers;

import java.util.List;
import java.util.Optional;
import net.serenitybdd.core.pages.WebElementState;

public class MissingWebElement
implements WebElementState {
    private final String elementName;
    private String expectedErrorMessage;

    public MissingWebElement(String elementName) {
        this.elementName = elementName;
    }

    public boolean isVisible() {
        return false;
    }

    public boolean isCurrentlyVisible() {
        return false;
    }

    public boolean isCurrentlyEnabled() {
        return false;
    }

    public WebElementState shouldBeVisible() {
        this.failWithMessage("Element should be visible");
        return this;
    }

    public WebElementState shouldBeCurrentlyVisible() {
        this.failWithMessage("Element should be visible");
        return this;
    }

    public WebElementState shouldNotBeVisible() {
        return this;
    }

    public WebElementState shouldNotBeCurrentlyVisible() {
        return this;
    }

    public boolean hasFocus() {
        return false;
    }

    public boolean containsText(String value) {
        return false;
    }

    public boolean containsValue(String value) {
        return false;
    }

    public boolean containsOnlyText(String value) {
        return false;
    }

    public boolean containsSelectOption(String value) {
        return false;
    }

    public WebElementState shouldContainText(String textValue) {
        String errorMessage = String.format("The text '%s' was not found in the web element. Element text '%s'.", textValue, this.elementName);
        this.failWithMessage(errorMessage);
        return this;
    }

    public WebElementState shouldContainOnlyText(String textValue) {
        String errorMessage = String.format("The text '%s' does not match the elements text '%s'.", textValue, this.elementName);
        this.failWithMessage(errorMessage);
        return this;
    }

    public WebElementState shouldContainSelectedOption(String textValue) {
        this.failWithMessage(String.format("The list element '%s' was not found in the web element %s", textValue, this.elementName));
        return this;
    }

    public WebElementState shouldNotContainText(String textValue) {
        return this;
    }

    public WebElementState shouldBeEnabled() {
        this.failWithMessage(String.format("Field '%s' should be enabled", this.elementName));
        return this;
    }

    public boolean isEnabled() {
        return false;
    }

    public boolean isDisabled() {
        return false;
    }

    public WebElementState shouldNotBeEnabled() {
        return this;
    }

    public String getSelectedVisibleTextValue() {
        return null;
    }

    public List<String> getSelectedVisibleTexts() {
        return null;
    }

    public String getSelectedValue() {
        return null;
    }

    public List<String> getSelectedValues() {
        return null;
    }

    public List<String> getSelectOptions() {
        return null;
    }

    public boolean isPresent() {
        return false;
    }

    public WebElementState shouldBePresent() {
        this.failWithMessage(String.format("Field '%s' should be present", this.elementName));
        return this;
    }

    public WebElementState shouldNotBePresent() {
        return this;
    }

    public boolean isSelected() {
        return false;
    }

    public String getTextValue() {
        return null;
    }

    public String getValue() {
        return "";
    }

    public String getText() {
        return "";
    }

    public String getAttribute(String name) {
        return "";
    }

    public WebElementState expect(String errorMessage) {
        this.expectedErrorMessage = errorMessage;
        return this;
    }

    public boolean isClickable() {
        return false;
    }

    private void failWithMessage(String errorMessage) {
        throw new AssertionError((Object)this.getErrorMessage(errorMessage));
    }

    protected String getErrorMessage(String defaultErrorMessage) {
        return Optional.ofNullable(this.expectedErrorMessage).orElse(defaultErrorMessage);
    }
}

