/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.rest;

import com.google.common.base.Preconditions;
import io.restassured.RestAssured;
import io.restassured.authentication.AuthenticationScheme;
import io.restassured.authentication.CertificateAuthSettings;
import io.restassured.authentication.FormAuthConfig;
import io.restassured.authentication.OAuthSignature;
import io.restassured.authentication.PreemptiveAuthProvider;
import io.restassured.config.LogConfig;
import io.restassured.config.RestAssuredConfig;
import io.restassured.config.SSLConfig;
import io.restassured.filter.Filter;
import io.restassured.filter.log.LogDetail;
import io.restassured.internal.RequestSpecificationImpl;
import io.restassured.internal.ResponseSpecificationImpl;
import io.restassured.internal.TestSpecificationImpl;
import io.restassured.internal.UriValidator;
import io.restassured.mapper.ObjectMapper;
import io.restassured.parsing.Parser;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import io.restassured.specification.Argument;
import io.restassured.specification.ProxySpecification;
import io.restassured.specification.RequestSender;
import io.restassured.specification.RequestSpecification;
import io.restassured.specification.ResponseSpecification;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.KeyStore;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.serenitybdd.rest.decorators.ResponseSpecificationDecorated;
import net.serenitybdd.rest.decorators.request.RequestSpecificationDecorated;
import net.serenitybdd.rest.utils.RestDecorationHelper;
import net.serenitybdd.rest.utils.RestSpecificationFactory;

public class SerenityRest {
    private static ThreadLocal<RequestSpecificationDecorated> currentRequestSpecification = new ThreadLocal();

    public static RequestSpecification rest() {
        return SerenityRest.given();
    }

    public static ValidatableResponse and() {
        return SerenityRest.then();
    }

    public static ValidatableResponse then() {
        return (ValidatableResponse)SerenityRest.lastResponse().then();
    }

    public static Response lastResponse() {
        Preconditions.checkNotNull(currentRequestSpecification, (Object)"request specification should be initialized");
        Response lastResponse = currentRequestSpecification.get().getLastResponse();
        Preconditions.checkNotNull(currentRequestSpecification, (Object)"response should be created");
        return lastResponse;
    }

    public static String setDefaultBasePath(String basePath) {
        RestAssured.basePath = basePath;
        return RestAssured.basePath;
    }

    public static String getDefaultBasePath() {
        return RestAssured.basePath;
    }

    public static int getDefaultPort() {
        return RestAssured.port;
    }

    public static int setDefaultPort(int port) {
        RestAssured.port = port;
        return RestAssured.port;
    }

    public static boolean isUrlEncodingEnabled() {
        return RestAssured.urlEncodingEnabled;
    }

    public static boolean setUrlEncodingEnabled(boolean urlEncodingEnabled) {
        RestAssured.urlEncodingEnabled = urlEncodingEnabled;
        return RestAssured.urlEncodingEnabled;
    }

    public static String getDefaultRootPath() {
        return RestAssured.rootPath;
    }

    public static String setDefaultRootPath(String rootPath) {
        if (rootPath == null) {
            throw new IllegalArgumentException("RootPath can not be null");
        }
        RestAssured.rootPath = rootPath;
        return RestAssured.rootPath;
    }

    public static String getDefaultSessionId() {
        return RestAssured.sessionId;
    }

    public static String setDefaultSessionId(String sessionId) {
        if (sessionId == null) {
            throw new IllegalArgumentException("Session id can not be null");
        }
        RestAssured.sessionId = sessionId;
        return RestAssured.sessionId;
    }

    public static AuthenticationScheme getDefaultAuthentication() {
        return RestAssured.authentication;
    }

    public static AuthenticationScheme setDefaultAuthentication(AuthenticationScheme authentication) {
        if (authentication == null) {
            throw new IllegalArgumentException("AuthenticationScheme can not be null");
        }
        RestAssured.authentication = authentication;
        return RestAssured.authentication;
    }

    public static RequestSpecification getDefaultRequestSpecification() {
        return RestAssured.requestSpecification;
    }

    public static RequestSpecification setDefaultRequestSpecification(RequestSpecification requestSpecification) {
        RestAssured.requestSpecification = requestSpecification;
        return RestAssured.requestSpecification;
    }

    public static Parser getDefaultParser() {
        return RestAssured.defaultParser;
    }

    public static Parser setDefaultParser(Parser defaultParser) {
        RestAssured.defaultParser = defaultParser;
        return RestAssured.defaultParser;
    }

    public static ResponseSpecification getDefaultResponseSpecification() {
        return RestAssured.responseSpecification;
    }

    public static ResponseSpecification setDefaultResponseSpecification(ResponseSpecification responseSpecification) {
        RestAssured.responseSpecification = responseSpecification;
        return RestAssured.responseSpecification;
    }

    public static void reset() {
        RestAssured.reset();
    }

    public static List<Filter> filters(List<Filter> filters) {
        RestAssured.filters(filters);
        return SerenityRest.filters();
    }

    public static List<Filter> filters(Filter filter, Filter ... additionalFilters) {
        RestAssured.filters((Filter)filter, (Filter[])additionalFilters);
        return SerenityRest.filters();
    }

    public static List<Filter> replaceFiltersWith(List<Filter> filters) {
        RestAssured.replaceFiltersWith(filters);
        return SerenityRest.filters();
    }

    public static List<Filter> replaceFiltersWith(Filter filter, Filter ... additionalFilters) {
        RestAssured.replaceFiltersWith((Filter)filter, (Filter[])additionalFilters);
        return SerenityRest.filters();
    }

    public static List<Filter> filters() {
        return RestAssured.filters();
    }

    public static ObjectMapper objectMapper(ObjectMapper objectMapper) {
        RestAssured.objectMapper((ObjectMapper)objectMapper);
        return SerenityRest.config().getObjectMapperConfig().defaultObjectMapper();
    }

    public static ResponseSpecification expect() {
        return SerenityRest.given().response();
    }

    public static RequestSpecification with() {
        return SerenityRest.given();
    }

    public static List<Argument> withArguments(Object firstArgument, Object ... additionalArguments) {
        return RestAssured.withArguments((Object)firstArgument, (Object[])additionalArguments);
    }

    public static List<Argument> withNoArguments() {
        return RestAssured.withNoArguments();
    }

    public static List<Argument> withArgs(Object firstArgument, Object ... additionalArguments) {
        return SerenityRest.withArguments(firstArgument, additionalArguments);
    }

    public static List<Argument> withNoArgs() {
        return SerenityRest.withNoArguments();
    }

    public static RequestSpecification given() {
        RequestSpecificationImpl generated = (RequestSpecificationImpl)RestAssured.given();
        RequestSpecification request = RestDecorationHelper.decorate((RequestSpecification)generated);
        ResponseSpecificationDecorated response = RestSpecificationFactory.getInstrumentedResponseSpecification((ResponseSpecificationImpl)generated.response());
        return ((TestSpecificationImpl)SerenityRest.given(request, (ResponseSpecification)response)).getRequestSpecification();
    }

    public static RequestSender andGiven() {
        if (currentRequestSpecification.get() != null) {
            return (RequestSender)currentRequestSpecification.get();
        }
        return SerenityRest.given();
    }

    public static void clear() {
        currentRequestSpecification.remove();
    }

    public static RequestSender when() {
        if (currentRequestSpecification.get() != null) {
            return (RequestSender)currentRequestSpecification.get();
        }
        return SerenityRest.given();
    }

    public static RequestSender given(RequestSpecification request, ResponseSpecification response) {
        RequestSpecification requestDecorated = RestDecorationHelper.decorate(request);
        ResponseSpecification responseDecorated = RestDecorationHelper.decorate(response);
        RequestSender created = RestAssured.given((RequestSpecification)requestDecorated, (ResponseSpecification)responseDecorated);
        currentRequestSpecification.set((RequestSpecificationDecorated)((TestSpecificationImpl)created).getRequestSpecification());
        return created;
    }

    public static RequestSpecification given(RequestSpecification requestSpecification) {
        RequestSpecificationImpl generated = (RequestSpecificationImpl)RestAssured.given((RequestSpecification)requestSpecification);
        RequestSpecification request = RestDecorationHelper.decorate((RequestSpecification)generated);
        ResponseSpecificationDecorated response = RestSpecificationFactory.getInstrumentedResponseSpecification((ResponseSpecificationImpl)generated.response());
        return ((TestSpecificationImpl)SerenityRest.given(request, (ResponseSpecification)response)).getRequestSpecification();
    }

    public static SSLConfig useRelaxedHTTPSValidation() {
        return SerenityRest.useRelaxedHTTPSValidation("SSL");
    }

    public static SSLConfig useRelaxedHTTPSValidation(String protocol) {
        RestAssured.useRelaxedHTTPSValidation((String)protocol);
        return SerenityRest.config().getSSLConfig();
    }

    public static void registerParser(String contentType, Parser parser) {
        RestAssured.registerParser((String)contentType, (Parser)parser);
    }

    public static void unregisterParser(String contentType) {
        RestAssured.unregisterParser((String)contentType);
    }

    public static AuthenticationScheme oauth2(String accessToken) {
        return RestAssured.oauth2((String)accessToken);
    }

    public static SSLConfig trustStore(KeyStore truststore) {
        RestAssured.trustStore((KeyStore)truststore);
        return SerenityRest.config().getSSLConfig();
    }

    public static AuthenticationScheme certificate(String certURL, String password) {
        return RestAssured.certificate((String)certURL, (String)password);
    }

    public static LogConfig enableLoggingOfRequestAndResponseIfValidationFails() {
        return SerenityRest.enableLoggingOfRequestAndResponseIfValidationFails(LogDetail.ALL);
    }

    public static LogConfig enableLoggingOfRequestAndResponseIfValidationFails(LogDetail logDetail) {
        RestAssured.enableLoggingOfRequestAndResponseIfValidationFails((LogDetail)logDetail);
        return SerenityRest.config().getLogConfig();
    }

    public static AuthenticationScheme certificate(String certURL, String password, CertificateAuthSettings certificateAuthSettings) {
        return RestAssured.certificate((String)certURL, (String)password, (CertificateAuthSettings)certificateAuthSettings);
    }

    public static AuthenticationScheme form(String userName, String password) {
        return RestAssured.form((String)userName, (String)password);
    }

    public static PreemptiveAuthProvider preemptive() {
        return RestAssured.preemptive();
    }

    public static AuthenticationScheme form(String userName, String password, FormAuthConfig config) {
        return RestAssured.form((String)userName, (String)password, (FormAuthConfig)config);
    }

    public static AuthenticationScheme oauth2(String accessToken, OAuthSignature signature) {
        return RestAssured.oauth2((String)accessToken, (OAuthSignature)signature);
    }

    public static AuthenticationScheme basic(String userName, String password) {
        return RestAssured.basic((String)userName, (String)password);
    }

    public static ProxySpecification proxy(String host, int port, String scheme) {
        return SerenityRest.setDefaultProxy(host, port, scheme);
    }

    public static ProxySpecification proxy(String host, int port) {
        return SerenityRest.setDefaultProxy(host, port);
    }

    public static ProxySpecification proxy(int port) {
        return SerenityRest.setDefaultProxy(port);
    }

    public static ProxySpecification proxy(URI uri) {
        if (uri == null) {
            throw new IllegalArgumentException("Proxy URI cannot be null");
        }
        return SerenityRest.setDefaultProxy(new ProxySpecification(uri.getHost(), uri.getPort(), uri.getScheme()));
    }

    public static ProxySpecification proxy(String host) {
        if (UriValidator.isUri((String)host)) {
            try {
                return SerenityRest.setDefaultProxy(new URI(host));
            }
            catch (URISyntaxException e) {
                throw new RuntimeException("Internal error in REST Assured when constructing URI for Proxy.", e);
            }
        }
        return SerenityRest.setDefaultProxy(ProxySpecification.host((String)host));
    }

    public static ProxySpecification proxy(ProxySpecification proxySpecification) {
        return SerenityRest.setDefaultProxy(proxySpecification);
    }

    public static ProxySpecification setDefaultProxy(String host, int port, String scheme) {
        return SerenityRest.setDefaultProxy(new ProxySpecification(host, port, scheme));
    }

    public static ProxySpecification setDefaultProxy(ProxySpecification proxy) {
        if (proxy == null) {
            throw new IllegalArgumentException("ProxySpecification can not be null");
        }
        RestAssured.proxy = proxy;
        return RestAssured.proxy;
    }

    public static ProxySpecification setDefaultProxy(String host, int port) {
        return SerenityRest.setDefaultProxy(ProxySpecification.host((String)host).withPort(port));
    }

    public static ProxySpecification setDefaultProxy(int port) {
        return SerenityRest.setDefaultProxy(ProxySpecification.port((int)port));
    }

    public static ProxySpecification setDefaultProxy(URI uri) {
        if (uri == null) {
            throw new IllegalArgumentException("Proxy URI cannot be null");
        }
        return SerenityRest.setDefaultProxy(new ProxySpecification(uri.getHost(), uri.getPort(), uri.getScheme()));
    }

    public static ProxySpecification getDefaultProxy() {
        return RestAssured.proxy;
    }

    public static SSLConfig keystore(File pathToJks, String password) {
        RestAssured.keyStore((File)pathToJks, (String)password);
        return SerenityRest.config().getSSLConfig();
    }

    public static SSLConfig keystore(String password) {
        RestAssured.keyStore((String)password);
        return SerenityRest.config().getSSLConfig();
    }

    public static SSLConfig keystore(String pathToJks, String password) {
        RestAssured.keyStore((String)pathToJks, (String)password);
        return SerenityRest.config().getSSLConfig();
    }

    public static Response head(URI uri) {
        return (Response)SerenityRest.given().head(uri);
    }

    public static Response head() {
        return (Response)SerenityRest.given().head();
    }

    public static Response head(String path, Object ... pathParams) {
        return (Response)SerenityRest.given().head(path, pathParams);
    }

    public static Response head(String path, Map<String, ?> pathParams) {
        return (Response)SerenityRest.given().head(path, pathParams);
    }

    public static Response head(URL url) {
        return (Response)SerenityRest.given().head(url);
    }

    public static RestAssuredConfig config() {
        return RestAssured.config();
    }

    public static RestAssuredConfig getDefaultConfig() {
        return RestAssured.config;
    }

    public static RestAssuredConfig setDefaultConfig(RestAssuredConfig config) {
        if (config == null) {
            throw new IllegalArgumentException("RestAssuredConfig can not be null");
        }
        RestAssured.config = config;
        return RestAssured.config;
    }

    public static AuthenticationScheme oauth(String consumerKey, String consumerSecret, String accessToken, String secretToken, OAuthSignature signature) {
        return RestAssured.oauth((String)consumerKey, (String)consumerSecret, (String)accessToken, (String)secretToken, (OAuthSignature)signature);
    }

    public static AuthenticationScheme oauth(String consumerKey, String consumerSecret, String accessToken, String secretToken) {
        return RestAssured.oauth((String)consumerKey, (String)consumerSecret, (String)accessToken, (String)secretToken);
    }

    public static AuthenticationScheme digest(String userName, String password) {
        return RestAssured.digest((String)userName, (String)password);
    }

    public static Response options() {
        return (Response)SerenityRest.given().options();
    }

    public static Response options(URL url) {
        return (Response)SerenityRest.given().options(url);
    }

    public static Response options(URI uri) {
        return (Response)SerenityRest.given().options(uri);
    }

    public static Response options(String path, Object ... pathParams) {
        if (pathParams != null && pathParams.length == 1 && pathParams[0] instanceof Map) {
            return (Response)SerenityRest.given().options(path, new Object[]{pathParams[0]});
        }
        return (Response)SerenityRest.given().options(path, pathParams);
    }

    public static Response options(String path, Map<String, ?> pathParams) {
        return (Response)SerenityRest.given().options(path, pathParams);
    }

    public static Response patch(String path, Map<String, ?> pathParams) {
        return (Response)SerenityRest.given().patch(path, pathParams);
    }

    public static Response patch(URI uri) {
        return (Response)SerenityRest.given().patch(uri);
    }

    public static Response patch(URL url) {
        return (Response)SerenityRest.given().patch(url);
    }

    public static Response patch() {
        return (Response)SerenityRest.given().patch();
    }

    public static Response patch(String path, Object ... pathParams) {
        if (pathParams != null && pathParams.length == 1 && pathParams[0] instanceof Map) {
            return (Response)SerenityRest.given().patch(path, new Object[]{pathParams[0]});
        }
        return (Response)SerenityRest.given().patch(path, pathParams);
    }

    public static Response post(String path, Object ... pathParams) {
        if (pathParams != null && pathParams.length == 1 && pathParams[0] instanceof Map) {
            return (Response)SerenityRest.given().post(path, new Object[]{pathParams[0]});
        }
        return (Response)SerenityRest.given().post(path, pathParams);
    }

    public static Response post(String path, Map<String, ?> pathParams) {
        return (Response)SerenityRest.given().post(path, pathParams);
    }

    public static Response post(URL url) {
        return (Response)SerenityRest.given().post(url);
    }

    public static Response post() {
        return (Response)SerenityRest.given().post();
    }

    public static Response post(URI uri) {
        return (Response)SerenityRest.given().post(uri);
    }

    public static Response put(URI uri) {
        return (Response)SerenityRest.given().put(uri);
    }

    public static Response put(String path, Object ... pathParams) {
        if (pathParams != null && pathParams.length == 1 && pathParams[0] instanceof Map) {
            return (Response)SerenityRest.given().put(path, new Object[]{pathParams[0]});
        }
        return (Response)SerenityRest.given().put(path, pathParams);
    }

    public static Response put() {
        return (Response)SerenityRest.given().put();
    }

    public static Response put(URL url) {
        return (Response)SerenityRest.given().put(url);
    }

    public static Response delete(String path, Map<String, ?> pathParams) {
        return (Response)SerenityRest.given().delete(path, pathParams);
    }

    public static Response delete(URL url) {
        return (Response)SerenityRest.given().delete(url);
    }

    public static Response delete(URI uri) {
        return (Response)SerenityRest.given().delete(uri);
    }

    public static Response delete() {
        return (Response)SerenityRest.given().delete();
    }

    public static Response delete(String path, Object ... pathParams) {
        if (pathParams != null && pathParams.length == 1 && pathParams[0] instanceof Map) {
            return (Response)SerenityRest.given().delete(path, new Object[]{pathParams[0]});
        }
        return (Response)SerenityRest.given().delete(path, pathParams);
    }

    public static Response get(URI uri) {
        return (Response)SerenityRest.given().get(uri);
    }

    public static Response get(URL url) {
        return (Response)SerenityRest.given().get(url);
    }

    public static Response get(String path, Object ... pathParams) {
        if (pathParams != null && pathParams.length == 1 && pathParams[0] instanceof Map) {
            return (Response)SerenityRest.given().get(path, new Object[]{pathParams[0]});
        }
        return (Response)SerenityRest.given().get(path, pathParams);
    }

    public static Response get(String path, Map<String, ?> pathParams) {
        return (Response)SerenityRest.given().get(path, pathParams);
    }

    public static Response get() {
        return (Response)SerenityRest.given().get();
    }

    public static void restAssuredThat(Consumer<ValidatableResponse> expectedCondition) {
        expectedCondition.accept((ValidatableResponse)SerenityRest.lastResponse().then());
    }
}

