/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.rest.decorators.request;

import io.restassured.config.RestAssuredConfig;
import io.restassured.internal.RequestSpecificationImpl;
import io.restassured.internal.ResponseSpecificationImpl;
import io.restassured.response.Response;
import io.restassured.specification.FilterableRequestSpecification;
import io.restassured.specification.RequestSpecification;
import io.restassured.specification.ResponseSpecification;
import net.serenitybdd.rest.decorators.ResponseDecorated;
import net.serenitybdd.rest.decorators.ResponseSpecificationDecorated;
import net.serenitybdd.rest.utils.ReflectionHelper;
import net.serenitybdd.rest.utils.RestReportingHelper;
import net.serenitybdd.rest.utils.RestSpecificationFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class RequestSpecificationInitialisation
implements FilterableRequestSpecification {
    private static final Logger log = LoggerFactory.getLogger(RequestSpecificationInitialisation.class);
    protected final RequestSpecificationImpl core;
    protected final ReflectionHelper<RequestSpecificationImpl> helper;
    protected RestReportingHelper reporting;

    public RequestSpecificationInitialisation(RequestSpecificationImpl core) {
        this.core = core;
        this.helper = new ReflectionHelper<RequestSpecificationImpl>(core);
        this.reporting = new RestReportingHelper();
    }

    public void setRestReportingHelper(RestReportingHelper helper) {
        this.reporting = helper;
    }

    public ResponseSpecification response() {
        return this.check(this.core.response());
    }

    public RequestSpecification and() {
        return this;
    }

    public RequestSpecification with() {
        return this;
    }

    public ResponseSpecification then() {
        return this.check(this.core.then());
    }

    public ResponseSpecification expect() {
        return this.check(this.core.expect());
    }

    public RequestSpecification when() {
        return this;
    }

    public RequestSpecification given() {
        return this;
    }

    public RequestSpecification that() {
        return this;
    }

    public RequestSpecification request() {
        return this;
    }

    public int hashCode() {
        return this.core.hashCode();
    }

    public boolean equals(Object obj) {
        return this.core.equals(obj);
    }

    protected ResponseSpecification check(ResponseSpecification specification) {
        if (specification instanceof ResponseSpecificationDecorated) {
            return specification;
        }
        log.warn("returned not decorated response, SerenityRest can work incorrectly");
        return specification;
    }

    protected ResponseSpecification decorate(ResponseSpecification specification) {
        if (specification instanceof ResponseSpecificationDecorated) {
            return specification;
        }
        return RestSpecificationFactory.getInstrumentedResponseSpecification((ResponseSpecificationImpl)specification);
    }

    protected ResponseDecorated decorate(Response response) {
        if (response instanceof ResponseDecorated) {
            return (ResponseDecorated)response;
        }
        return new ResponseDecorated(response);
    }

    public RequestSpecificationImpl getCore() {
        return this.core;
    }

    protected void setResponseSpecification(ResponseSpecification specification) {
        this.getCore().setResponseSpecification(this.decorate(specification));
    }

    protected void setresponseSpecification(ResponseSpecification specification) {
        this.setResponseSpecification(specification);
    }

    protected RestAssuredConfig getRestAssuredConfig() {
        return this.getCore().getConfig();
    }

    protected RestAssuredConfig getrestAssuredConfig() {
        return this.getRestAssuredConfig();
    }
}

