/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.rest.decorators;

import com.jayway.restassured.authentication.CertificateAuthSettings;
import com.jayway.restassured.authentication.FormAuthConfig;
import com.jayway.restassured.authentication.OAuthSignature;
import com.jayway.restassured.specification.AuthenticationSpecification;
import com.jayway.restassured.specification.PreemptiveAuthSpec;
import com.jayway.restassured.specification.RequestSpecification;
import net.serenitybdd.rest.decorators.BaseWrapper;
import net.serenitybdd.rest.decorators.RestDecorator;

class AuthenticationSpecificationWrapper
extends BaseWrapper<AuthenticationSpecification>
implements AuthenticationSpecification {
    public AuthenticationSpecificationWrapper(AuthenticationSpecification auth, ThreadLocal<RequestSpecification> instrumented, RestDecorator decorator) {
        super(auth, instrumented, decorator);
    }

    public RequestSpecification basic(String userName, String password) {
        ((AuthenticationSpecification)this.core).basic(userName, password);
        return (RequestSpecification)this.specification.get();
    }

    public RequestSpecification digest(String userName, String password) {
        ((AuthenticationSpecification)this.core).digest(userName, password);
        return (RequestSpecification)this.specification.get();
    }

    public RequestSpecification certificate(String certURL, String password) {
        ((AuthenticationSpecification)this.core).certificate(certURL, password);
        return (RequestSpecification)this.specification.get();
    }

    public RequestSpecification certificate(String certURL, String password, CertificateAuthSettings settings) {
        ((AuthenticationSpecification)this.core).certificate(certURL, password, settings);
        return (RequestSpecification)this.specification.get();
    }

    @Deprecated
    public RequestSpecification certificate(String certURL, String password, String keystoreType, int port) {
        ((AuthenticationSpecification)this.core).certificate(certURL, password, keystoreType, port);
        return (RequestSpecification)this.specification.get();
    }

    public RequestSpecification oauth(String consumerKey, String consumerSecret, String accessToken, String secretToken) {
        ((AuthenticationSpecification)this.core).oauth(consumerKey, consumerSecret, accessToken, secretToken);
        return (RequestSpecification)this.specification.get();
    }

    public RequestSpecification oauth(String consumerKey, String consumerSecret, String accessToken, String secretToken, OAuthSignature signature) {
        ((AuthenticationSpecification)this.core).oauth(consumerKey, consumerSecret, accessToken, secretToken, signature);
        return (RequestSpecification)this.specification.get();
    }

    public RequestSpecification oauth2(String accessToken) {
        ((AuthenticationSpecification)this.core).oauth2(accessToken);
        return (RequestSpecification)this.specification.get();
    }

    public RequestSpecification oauth2(String accessToken, OAuthSignature signature) {
        ((AuthenticationSpecification)this.core).oauth2(accessToken, signature);
        return (RequestSpecification)this.specification.get();
    }

    public RequestSpecification none() {
        ((AuthenticationSpecification)this.core).none();
        return (RequestSpecification)this.specification.get();
    }

    public PreemptiveAuthSpec preemptive() {
        return this.decorator.decorate(((AuthenticationSpecification)this.core).preemptive());
    }

    public RequestSpecification form(String userName, String password) {
        ((AuthenticationSpecification)this.core).form(userName, password);
        return (RequestSpecification)this.specification.get();
    }

    public RequestSpecification form(String userName, String password, FormAuthConfig config) {
        ((AuthenticationSpecification)this.core).form(userName, password, config);
        return (RequestSpecification)this.specification.get();
    }
}

