/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.reports.html;

import java.time.Duration;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.serenitybdd.core.buildinfo.BuildInfoProvider;
import net.serenitybdd.core.buildinfo.BuildProperties;
import net.serenitybdd.core.environment.EnvironmentSpecificConfiguration;
import net.serenitybdd.core.reports.styling.TagStylist;
import net.serenitybdd.reports.model.BackgroundColor;
import net.serenitybdd.reports.model.CustomReportFields;
import net.serenitybdd.reports.model.DurationDistribution;
import net.serenitybdd.reports.model.DurationsKt;
import net.serenitybdd.reports.model.FrequentFailures;
import net.serenitybdd.reports.model.ReportTags;
import net.serenitybdd.reports.model.TagCoverage;
import net.serenitybdd.reports.model.TagResults;
import net.serenitybdd.reports.model.UnstableFeatures;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.issues.IssueTracking;
import net.thucydides.core.model.NumericalFormatter;
import net.thucydides.core.model.ReportType;
import net.thucydides.core.model.TestOutcome;
import net.thucydides.core.model.TestTag;
import net.thucydides.core.model.formatters.ReportFormatter;
import net.thucydides.core.reports.ReportOptions;
import net.thucydides.core.reports.TestOutcomes;
import net.thucydides.core.reports.html.EvidenceData;
import net.thucydides.core.reports.html.Formatter;
import net.thucydides.core.reports.html.ReportNameProvider;
import net.thucydides.core.reports.html.RequirementsFilter;
import net.thucydides.core.reports.html.ResultCounts;
import net.thucydides.core.reports.html.TagFilter;
import net.thucydides.core.reports.html.accessibility.ChartColorScheme;
import net.thucydides.core.requirements.ParentRequirementProvider;
import net.thucydides.core.requirements.RequirementsService;
import net.thucydides.core.requirements.model.Requirement;
import net.thucydides.core.requirements.reports.ScenarioOutcome;
import net.thucydides.core.requirements.reports.ScenarioOutcomes;
import net.thucydides.core.tags.OutcomeTagFilter;
import net.thucydides.core.util.EnvironmentVariables;
import net.thucydides.core.util.Inflector;
import net.thucydides.core.util.TagInflector;
import net.thucydides.core.util.VersionProvider;
import org.joda.time.DateTime;
import org.joda.time.ReadableDateTime;

public class FreemarkerContext {
    private final EnvironmentVariables environmentVariables;
    private final RequirementsService requirements;
    private final IssueTracking issueTracking;
    private final String relativeLink;
    private final BuildProperties buildProperties;
    private final TestTag parentTag;
    private final RequirementsService requirementsService;
    private final List<String> requirementTypes;
    private final String version;
    private final String buildNumber;
    private final List<String> tagTypes;
    private final ReportOptions reportOptions;
    private final CustomReportFields customReportFields;
    private final Collection<Requirement> requirementsWithTag;
    private final Collection<TestTag> tagsOfType;
    private final List<String> customFields;
    private final List<String> customFieldValues;

    public FreemarkerContext(EnvironmentVariables environmentVariables, RequirementsService requirements, IssueTracking issueTracking, String relativeLink, TestTag parentTag) {
        this.environmentVariables = environmentVariables;
        this.requirements = requirements;
        this.issueTracking = issueTracking;
        this.relativeLink = relativeLink;
        this.buildProperties = new BuildInfoProvider(environmentVariables).getBuildProperties();
        this.parentTag = parentTag;
        this.requirementsService = (RequirementsService)Injectors.getInjector().getInstance(RequirementsService.class);
        this.requirementTypes = requirements.getRequirementTypes();
        VersionProvider versionProvider = new VersionProvider(environmentVariables);
        this.version = versionProvider.getVersion();
        this.buildNumber = versionProvider.getBuildNumberText();
        this.tagTypes = new ReportTags(environmentVariables).getDisplayedTagTypes();
        this.reportOptions = new ReportOptions(environmentVariables);
        this.customReportFields = new CustomReportFields(environmentVariables);
        this.requirementsWithTag = requirements.getRequirementsWithTagsOfType(this.tagTypes);
        this.tagsOfType = requirements.getTagsOfType(this.tagTypes);
        this.customFields = this.customReportFields.getFieldNames();
        this.customFieldValues = this.customReportFields.getValues();
    }

    public FreemarkerContext(EnvironmentVariables environmentVariables, RequirementsService requirements, IssueTracking issueTracking, String relativeLink) {
        this(environmentVariables, requirements, issueTracking, relativeLink, TestTag.EMPTY_TAG);
    }

    public Map<String, Object> getBuildContext(TestOutcomes completeTestOutcomes, ReportNameProvider reportName, boolean useFiltering) {
        HashMap<String, Object> context = new HashMap<String, Object>();
        TagFilter tagFilter = new TagFilter(this.environmentVariables);
        OutcomeTagFilter outcomeFilter = new OutcomeTagFilter(this.environmentVariables);
        TestOutcomes testOutcomes = completeTestOutcomes.filteredByEnvironmentTags();
        context.put("colorScheme", new ChartColorScheme(this.environmentVariables));
        context.put("testOutcomes", testOutcomes);
        context.put("durations", new DurationDistribution(this.environmentVariables, testOutcomes));
        context.put("allTestOutcomes", testOutcomes.getRootOutcomes());
        if (useFiltering) {
            context.put("tagTypes", tagFilter.filteredTagTypes(testOutcomes.getTagTypes()));
        } else {
            context.put("tagTypes", testOutcomes.getTagTypes());
        }
        context.put("currentTag", TestTag.EMPTY_TAG);
        context.put("parentTag", this.parentTag);
        context.put("reportName", reportName);
        context.put("reportNameInContext", reportName);
        context.put("absoluteReportName", new ReportNameProvider(ReportNameProvider.NO_CONTEXT, ReportType.HTML, this.requirements));
        context.put("reportOptions", this.reportOptions);
        context.put("timestamp", this.timestampFrom((ReadableDateTime)new DateTime()));
        context.put("requirementTypes", this.requirementTypes);
        context.put("leafRequirementType", this.last(this.requirementTypes));
        this.addFormattersToContext(context);
        ZonedDateTime startTime = DurationsKt.startTimeOf((List)testOutcomes.getOutcomes());
        ZonedDateTime endTime = DurationsKt.endTimeOf((List)testOutcomes.getOutcomes());
        context.put("startTimestamp", this.readableTimestampFrom(startTime));
        context.put("endTimestamp", this.readableTimestampFrom(endTime));
        context.put("totalTestDuration", DurationsKt.formattedDuration((Duration)DurationsKt.totalDurationOf((List)testOutcomes.getOutcomes())));
        context.put("totalClockDuration", DurationsKt.formattedDuration((Duration)DurationsKt.clockDurationOf((List)testOutcomes.getOutcomes())));
        context.put("averageTestDuration", DurationsKt.formattedDuration((Duration)DurationsKt.averageDurationOf((List)testOutcomes.getOutcomes())));
        context.put("maxTestDuration", DurationsKt.formattedDuration((Duration)DurationsKt.maxDurationOf((List)testOutcomes.getOutcomes())));
        context.put("minTestDuration", DurationsKt.formattedDuration((Duration)DurationsKt.minDurationOf((List)testOutcomes.getOutcomes())));
        context.put("serenityVersionNumber", this.version);
        context.put("buildNumber", this.buildNumber);
        context.put("build", this.buildProperties);
        context.put("resultCounts", ResultCounts.forOutcomesIn((TestOutcomes)testOutcomes));
        List scenarios = outcomeFilter.scenariosFilteredByTagIn(ScenarioOutcomes.from((TestOutcomes)testOutcomes));
        List<ScenarioOutcome> executedScenarios = this.executedScenariosIn(scenarios);
        context.put("scenarios", scenarios);
        context.put("filteredScenarios", scenarios);
        context.put("testCases", executedScenarios);
        context.put("automatedTestCases", this.automated(executedScenarios));
        context.put("manualTestCases", this.manual(executedScenarios));
        context.put("evidence", EvidenceData.from(outcomeFilter.outcomesFilteredByTagIn(testOutcomes.getOutcomes())));
        context.put("frequentFailures", FrequentFailures.from((TestOutcomes)testOutcomes).withMaxOf(5));
        context.put("unstableFeatures", UnstableFeatures.from((TestOutcomes)testOutcomes).withRequirementsFrom((ParentRequirementProvider)this.requirementsService).withMaxOf(5));
        context.put("inflection", Inflector.getInstance());
        context.put("tagInflector", new TagInflector(this.environmentVariables));
        RequirementsFilter requirementsFilter = new RequirementsFilter(this.environmentVariables);
        Collection coveredTags = this.requirementsWithTag.stream().filter(requirement -> testOutcomes.containTestFor(requirement) || requirement.containsNoScenarios()).filter(arg_0 -> ((RequirementsFilter)requirementsFilter).inDisplayOnlyTags(arg_0)).map(Requirement::asTag).collect(Collectors.toSet());
        boolean hideEmptyRequirements = EnvironmentSpecificConfiguration.from((EnvironmentVariables)this.environmentVariables).getBooleanProperty(ThucydidesSystemProperty.SERENITY_REPORT_HIDE_EMPTY_REQUIREMENTS, true);
        ArrayList coverage = new ArrayList(TagCoverage.from((TestOutcomes)testOutcomes).showingTags(this.tagsOfType).showingTags(coveredTags).forTagTypes(this.tagTypes));
        context.put("hideEmptyRequirements", hideEmptyRequirements);
        context.put("coverage", coverage);
        context.put("backgroundColor", new BackgroundColor());
        testOutcomes.getOutcomes().forEach(testOutcome -> this.addTags((TestOutcome)testOutcome, (Map<String, Object>)context, null));
        context.put("tagResults", TagResults.from((TestOutcomes)testOutcomes).ignoringValues(new String[]{"ignore", "pending", "skip", "error", "compromised", "fail"}).ignoringTypes(new String[]{"Duration"}).groupedByType());
        context.put("customFields", this.customFields);
        context.put("customFieldValues", this.customFieldValues);
        return context;
    }

    private void addTags(TestOutcome testOutcome, Map<String, Object> context, String parentTitle) {
        TagFilter tagFilter = new TagFilter(this.environmentVariables);
        Set filteredTags = parentTitle != null ? tagFilter.removeTagsWithName(testOutcome.getTags(), parentTitle) : testOutcome.getTags();
        filteredTags = tagFilter.removeHiddenTagsFrom(filteredTags);
        context.put("filteredTags", filteredTags);
    }

    private String last(List<String> requirementTypes) {
        return requirementTypes.size() > 0 ? requirementTypes.get(requirementTypes.size() - 1) : "Feature";
    }

    private List<ScenarioOutcome> automated(List<ScenarioOutcome> executedScenariosIn) {
        return executedScenariosIn.stream().filter(scenarioOutcome -> scenarioOutcome.isManual() == false).collect(Collectors.toList());
    }

    private List<ScenarioOutcome> manual(List<ScenarioOutcome> executedScenariosIn) {
        return executedScenariosIn.stream().filter(scenarioOutcome -> scenarioOutcome.isManual()).collect(Collectors.toList());
    }

    private List<ScenarioOutcome> executedScenariosIn(List<ScenarioOutcome> scenarioOutcomes) {
        return scenarioOutcomes.stream().filter(scenarioOutcome -> !scenarioOutcome.getType().equalsIgnoreCase("background")).collect(Collectors.toList());
    }

    private void addFormattersToContext(Map<String, Object> context) {
        Formatter formatter = new Formatter();
        ReportFormatter reportFormatter = new ReportFormatter();
        context.put("formatter", formatter);
        context.put("reportFormatter", reportFormatter);
        context.put("formatted", new NumericalFormatter());
        context.put("inflection", Inflector.getInstance());
        context.put("tagInflector", new TagInflector(this.environmentVariables));
        context.put("styling", TagStylist.from(this.environmentVariables));
        context.put("relativeLink", this.relativeLink);
        context.put("reportOptions", new ReportOptions(this.environmentVariables));
        context.put("showDetailedStoryDescription", ThucydidesSystemProperty.SERENITY_SHOW_STORY_DETAILS_IN_TESTS.booleanFrom(this.environmentVariables, Boolean.valueOf(false)));
    }

    protected String readableTimestampFrom(ZonedDateTime time) {
        return time == null ? "" : time.format(DateTimeFormatter.ofPattern("MMM dd, yyyy HH:mm:ss"));
    }

    protected String timestampFrom(ReadableDateTime startTime) {
        return startTime == null ? "" : startTime.toString("dd-MM-YYYY HH:mm:ss");
    }

    public FreemarkerContext withParentTag(TestTag knownTag) {
        return new FreemarkerContext(this.environmentVariables, this.requirements, this.issueTracking, this.relativeLink, knownTag);
    }
}

